// <summary>ソースコード：モデルデータジェネレーター作成条件等格納クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モモデルデータジェネレーター作成条件等格納クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルプデータジェネレーターに必要な情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public class McModelDataGenerationInfo : McModelDataGenerationInfoIF, HySVersionManagement
    {

        /// <summary>生成するモデルのプロジェクト名称</summary>
        protected HySString m_csProjectName = new HySString("SampleSCF");

        /// <summary> モデル接続生成ライブラリ識別子 </summary>
        protected HySID m_csLibraryID;
        /// <summary> モデル接続生成クラス種別識別子</summary>
        protected HySObjectKind m_csModelKind;


        /// <summary>情報格納用ファイル名称管理テーブル</summary>
        protected HySDataHashTable m_csParameterFileTable = new HySDataHashTable();


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGenerationInfo csData = new McModelDataGenerationInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelDataGenerationInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelDataGenerationInfo()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetProjectname(csName) </para>
        /// </example>
        /// <param name="csName">プロジェクト名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本設定が　構造定義ファイル名を決定する</para>
        /// </remarks>
        public virtual void SetProjectName( HySString csName)
        {
            m_csProjectName.SetString(csName);
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetProjectname(sName) </para>
        /// </example>
        /// <param name="sName">プロジェクト名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本設定が　構造定義ファイル名を決定する</para>
        /// </remarks>
        public virtual void SetProjectname( string sName )
        {
            m_csProjectName.SetChar(sName);
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetProjectName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString プロジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>戻り値に従って構造定義ファイル名を決定する</para>
        /// </remarks>
        public virtual HySString GetProjectName()
        { return m_csProjectName; }

        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成ライブラリ識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLibraryID(csLibraryID) </para>
        /// </example>
        /// <param name="csLibraryID">モデル接続生成ライブラリ識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetLibraryID(HySID csLibraryID)
        {
            m_csLibraryID = csLibraryID;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成ライブラリ識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csLibraryID = LibraryID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID モデル接続生成ライブラリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetLibraryID()
        {
            return m_csLibraryID;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成クラス種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetGeneratorKind(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル接続生成クラス種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetGeneratorKind(HySObjectKind csModelKind)
        {
            m_csModelKind = csModelKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成クラス種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csModelKind = GetGeneratorKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind モデル接続生成クラス種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySObjectKind GetGeneratorKind()
        {
            return m_csModelKind;
        }

        // =================================
        // 情報格納用ファイル設定／取得メソッド
        // =================================
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddInfo(csKey, csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        protected virtual void AddInfo(HySString csKey, HySString csParameterFileName)
        {
            m_csParameterFileTable.AddObject(csKey, csParameterFileName);
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddInfo(csKey, csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        public virtual void AddInfo(string csKey, string csParameterFileName)
        {
            this.AddInfo(new HySString(csKey), new HySString(csParameterFileName));
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddInfo(csKey, csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddInfo(HySObjectKind csKey, HySString csParameterFileName)
        {
            m_csParameterFileTable.AddObject((HySString)csKey.GetString(), csParameterFileName);
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInfo(csKey, csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        protected virtual void SetInfo(HySString csKey, HySString csParameterFileName)
        {
            HySString csParameter= new HySString("");
            bool bLclRtn = GetInfo(csKey, ref csParameter);
            if (bLclRtn == true)
            {
                this.DeleteInfo(csKey);
            }
            this.AddInfo(csKey, csParameterFileName);
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInfo(sKey, sParameterFileName) </para>
        /// </example>
        /// <param name="sKey">情報引出し用キー</param>
        /// <param name="sParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        public virtual void SetInfo(string sKey, string sParameterFileName)
        {
            this.SetInfo(new HySString(sKey), new HySString(sParameterFileName));
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInfo(csKey, csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetInfo(HySObjectKind csKey, HySString csParameterFileName)
        {
            this.SetInfo((HySString)csKey.GetString(), csParameterFileName);
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名を削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteInfo(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        protected virtual void DeleteInfo(HySString csKey)
        {
            m_csParameterFileTable.DeleteData(csKey);
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名を削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteInfo(sKey) </para>
        /// </example>
        /// <param name="sKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        public virtual void DeleteInfo(string sKey)
        {
            this.DeleteInfo(new HySString(sKey));
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名を削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteInfo(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DeleteInfo(HySObjectKind csKey)
        {
            m_csParameterFileTable.DeleteData((HySString)csKey.GetString());
        }

        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetInfo(csKey, ref csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">情報格納ファイル名称</param>
        /// <returns>bool  =true:情報有り、=false:情報無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        public virtual bool GetInfo(HySString csKey, ref HySString csParameterFileName)
        {
            bool bRtn = false;
            HySString csFileName;
            csFileName = m_csParameterFileTable.GetObject(csKey) as HySString;
            if (null != (object)csFileName)
            {
                csParameterFileName.SetString(csFileName);
                bRtn = true;
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetInfo(sKey, ref sParameterFileName) </para>
        /// </example>
        /// <param name="sKey">情報引出し用キー</param>
        /// <param name="sParameterFileName">設定値</param>
        /// <returns>bool  =true:情報有り、=false:情報無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル開発者は使用禁止</para>
        /// </remarks>
        public virtual bool GetInfo(string sKey, ref string sParameterFileName)
        {
            HySString csParameterFileName= new HySString("");
            bool bRtn = this.GetInfo(new HySString(sKey), ref csParameterFileName);
            if( bRtn == true )
            {
                sParameterFileName = csParameterFileName.ToString();
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetInfo(csKey, ref csParameterFileName) </para>
        /// </example>
        /// <param name="csKey">情報引出し用キー</param>
        /// <param name="csParameterFileName">設定値</param>
        /// <returns>bool  =true:情報有り、=false:情報無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool GetInfo(HySObjectKind csKey, ref HySString csParameterFileName)
        {
            bool bRtn = false;
            HySString csFileName = m_csParameterFileTable.GetObject((HySString)csKey.GetString()) as HySString;
            if (null != (object)csFileName)
            {
                csParameterFileName.SetString(csFileName);
                bRtn = true;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部情報クリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Clear()
        {
            m_csParameterFileTable.ClearAllObject();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
