﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト管理フォームデータクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data.Tool;

namespace CommonMP.HYMCO.CoreImpl.Data.ProjectCtl
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクト情報（１レコード分）クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>プロジェクトの検索、登録時に名称等のデータを格納</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McProjectInfData : HySDataRoot, HySVersionManagement
    {
        /// <summary>シミュレーターID(McFigureUnityのID)</summary>
        protected HySID m_csSimPrjctID = new HySID("");
        
        /// <summary>表示プロジェクト名</summary>
        protected HySString m_csDispPrjName;
        
        //// <summary>【削除予定】キー1</summary>
        //protected HySString m_csKeyOneValue;
        //// <summary>【削除予定】キー2</summary>
        //protected HySString m_csKeyTwoValue;

        /// <summary>データベース名</summary>
        protected HySString m_csDbName;
        /// <summary>ファイルパス</summary>
        protected HySString m_csFileName;
        /// <summary>プロジェクトグループ名</summary>
        protected HySString m_csProjectGroupName = new HySString("DefaultGr");
        /// <summary>プロジェクト名</summary>
        protected HySString m_csProjectName;
        /// <summary>管理者名</summary>
        protected HySString m_csAdminName;
        /// <summary>作成日 </summary>
        protected HySTime m_csCreateDate;
        /// <summary>登録日 </summary>
        protected HySTime m_csRegistDate;
        /// <summary>更新日 </summary>
        protected HySTime m_csUpdateDate;
        /// <summary>計算開始時間 </summary>
        protected HySTime m_csStartSimuTime;
        /// <summary>計算終了時間</summary>
        protected HySTime m_csEndSimuTime;
        /// <summary>中断時刻</summary>
        protected HySTime m_csSuspendTime;

        ///// <summary>【削除予定】タイムステップ</summary>
        //protected HySTime m_csDeltaTime ;

        /// <summary>プロジェクトコメント</summary>
        protected HySString m_csComment;
        ///<summary>種別</summary>
        protected HySString m_csModelType;
        ///<summary>対象</summary>
        protected HySString m_csModelTarget;
        ///<summary>モデル</summary>
        protected HySString m_csModelCalcType;
        ///<summary>件名</summary>
        protected HySString m_csModelSubject;
        ///<summary>ケース名</summary>
        protected HySString m_csModelSituation;

        ///<summary>期間種別</summary>
        protected ModelPeriodType m_csModelPeriodType;
        ///<summary>期間</summary>
        protected McRange m_csModelPeriod;

        ///<summary>境界条件１</summary>
        protected HySString m_csThresholdCondition1;
        ///<summary>境界条件２</summary>
        protected HySString m_csThresholdCondition2;
        ///<summary>境界条件３</summary>
        protected HySString m_csThresholdCondition3;
        ///<summary>境界条件４</summary>
        protected HySString m_csThresholdCondition4;
        ///<summary>境界条件５</summary>
        protected HySString m_csThresholdCondition5;

        ///<summary>条件１</summary>
        protected HySString m_csCondition1;
        ///<summary>条件２</summary>
        protected HySString m_csCondition2;
        ///<summary>条件３</summary>
        protected HySString m_csCondition3;
        ///<summary>条件４</summary>
        protected HySString m_csCondition4;
        ///<summary>条件５</summary>
        protected HySString m_csCondition5;

        /// <summary>期間種別列挙体</summary>
        public enum ModelPeriodType
        {
            /// <summary>
            /// 設定無し
            /// </summary>
            NonType = 0,
            /// <summary>
            /// 期間
            /// </summary>
            PERIOD = 1,
            /// <summary>
            /// 定常
            /// </summary>
            REGULARITY = 2
        }

        ///// <summary>データ変更有り無しフラグ（=true:変更あり、=false:変更無し） ワーク用変数の為、シリアライズ対象ではない（保存しない）</summary>
        //[NonSerialized]
        //protected bool m_bChangedFlg = true;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McProjectInfData csProjectInfData = new McProjectInfData();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McProjectInfData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McProjectInfData()
        {
            m_csProjectName = new HySString("");

            // default 
            DateTime csDatatime = DateTime.Now;
            m_csStartSimuTime = HySCalendar.CreateTime(csDatatime.Year, csDatatime.Month, csDatatime.Day, csDatatime.Hour, 0, 0);
            //m_csDeltaTime = new HySTime(1, 0, 0);
            m_csEndSimuTime = m_csStartSimuTime + new HySTime(6.0D * 3600.0D);
            //m_csSuspendTime = m_csStartSimuTime + new HySTime(1.0 * 3600.0);
            m_csModelPeriodType = ModelPeriodType.NonType;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーターID(McFigureUnityのID)設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProjectID( csID );</para>
        /// </example>
        /// <param name="csID">シミュレーターID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetProjectID(HySID csID)
        {
            m_csSimPrjctID = csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーターID(McFigureUnityのID)取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csID = GetProjectID(　);</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーターID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetProjectID()
        {
            return m_csSimPrjctID;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySObjectKind csKind = csProjectInfData.GetSimulatorKind(　);</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーション種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetSimulatorKind()
        {
            return McDefine.SIMULATOR_KIND;
        }

        /// <summary><para>method outline:</para>
        /// <para>データベース名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetDbName( csString );</para>
        /// </example>
        /// <param name="csString">データベース名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDbName(HySString csString)
        {
            m_csDbName = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>データベース名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csDBName = csProjectInfData.GetDbName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>データベース名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetDbName()
        {
            return m_csDbName;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルパスのセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetFileName( csString );</para>
        /// </example>
        /// <param name="csString">ファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileName(HySString csString)
        {
            m_csFileName = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>ファイルパスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csFileName = csProjectInfData.GetFileName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファイルパス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetFileName()
        {
            return m_csFileName;
        }

// start of Ver1.1 追加
/*
         ﾒﾝﾊﾞｰ変数
         * /// <summary>プロジェクトグループ名</summary>
                protected HySString m_csProjectGroupName;
         * の追加が必要となるが、下位データ互換性を考慮し、m_sDecodedVersionは今回　Ｖｅｒ１．１として
         * シリアライズ・デシリアライズを考慮する事
         * Ｖｅｒ１．０で作成したデータが　Ｖｅｒ１．１で読み込めること　（Ｖｅｒ１．１→Ｖｅｒ１．０読み込みは不要）
*/
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetProjectGroupName( csString );</para>
        /// </example>
        /// <param name="csString">プロジェクトグループ名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetProjectGroupName(HySString csString)
        {
            m_csProjectGroupName = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csPrjGroupName = csProjectInfData.GetProjectGroupName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロジェクトグループ名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectGroupName()
        {
            return m_csProjectGroupName;
        }
// end of Ver1.1 追加

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetProjectName( csString );</para>
        /// </example>
        /// <param name="csString">プロジェクト名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetProjectName(HySString csString)
        {
            m_csProjectName = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csPrjName = csProjectInfData.GetProjectName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロジェクト名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectName()
        {
            return m_csProjectName;
        }

        /// <summary><para>method outline:</para>
        /// <para>管理者名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetAdminName( csString );</para>
        /// </example>
        /// <param name="csString">管理者名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAdminName(HySString csString)
        {
            m_csAdminName = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>管理者名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csAdminName = csProjectInfData.GetAdminName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>管理者名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetAdminName()
        {
            return m_csAdminName;
        }

        /// <summary><para>method outline:</para>
        /// <para>作成日のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetCreateDate( csTime );</para>
        /// </example>
        /// <param name="csTime">作成日</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCreateDate(HySTime csTime)
        {
            m_csCreateDate = csTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>作成日の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csCreateTime = csProjectInfData.GetCreateDate();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>作成日</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetCreateDate()
        {
            return m_csCreateDate;
        }

        /// <summary><para>method outline:</para>
        /// <para>登録日のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetRegistDate( csTime );</para>
        /// </example>
        /// <param name="csTime">登録日</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRegistDate(HySTime csTime)
        {
            m_csRegistDate = csTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>登録日の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HysTime csRegistTime = csProjectInfData.GetRegistDate();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>登録日</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetRegistDate()
        {
            return m_csRegistDate;
        }

        /// <summary><para>method outline:</para>
        /// <para>更新日のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetUpdateDate( csTime );</para>
        /// </example>
        /// <param name="csTime">更新日</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUpdateDate(HySTime csTime)
        {
            m_csUpdateDate = csTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>更新日の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HysTime csUpdateTime =csProjectInfData.GetUpdateDate();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>更新日</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetUpdateDate()
        {
            return m_csUpdateDate;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始時間のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetStartSimuTime( csTime );</para>
        /// </example>
        /// <param name="csTime">計算開始時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetStartSimuTime(HySTime csTime)
        {
            m_csStartSimuTime = csTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算開始時間の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HysTime csSimuStartTime =csProjectInfData.GetStartSimuTime();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>計算開始時間</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetStartSimuTime()
        {
            return m_csStartSimuTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算終了時間のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetEndSimuTime( csTime );</para>
        /// </example>
        /// <param name="csTime">計算終了時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEndSimuTime(HySTime csTime)
        {
            m_csEndSimuTime = csTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算終了時間の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HysTime csSimuEndTime =csProjectInfData.GetEndSimuTime();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>計算終了時間</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetEndSimuTime()
        {
            return m_csEndSimuTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>中断時刻のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetSuspendTime( csTime );</para>
        /// </example>
        /// <param name="csTime">中断時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSuspendTime(HySTime csTime)
        {
            m_csSuspendTime = csTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>中断時刻の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HysTime csSuspendTime =csProjectInfData.GetSuspendTime();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>中断時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetSuspendTime()
        {
            return m_csSuspendTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトコメントのセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetComment( csString );</para>
        /// </example>
        /// <param name="csString">プロジェクトコメント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetComment(HySString csString)
        {
            m_csComment = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトコメントの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csComment = csProjectInfData.GetComment();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロジェクトコメント</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetComment()
        {
            return m_csComment;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示プロジェクト名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetDispPrjectName(csString);</para>
        /// </example>
        /// <param name="csString">プロジェクトコメント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispProjectName(HySString csString)
        {
            m_csDispPrjName = csString;
        }
        /// <summary><para>method outline:</para>
        /// <para>表示プロジェクト名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csDispName = csProjectInfData.GetDispPrjectName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロジェクトコメント</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetDispProjectName()
        {
            return m_csDispPrjName;
        }

        /// <summary><para>method outline:</para>
        /// <para>種別のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelType( csModelType );</para>
        /// </example>
        /// <param name="csModelType">種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelType(HySString csModelType)
        {
            m_csModelType = csModelType;
        }
        /// <summary><para>method outline:</para>
        /// <para>種別の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csModelType = csProjectInfData.GetModelType();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetModelType()
        {
            return m_csModelType;
        }

        /// <summary><para>method outline:</para>
        /// <para>対象のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelTarget( csModelTarget );</para>
        /// </example>
        /// <param name="csModelTarget">対象</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelTarget(HySString csModelTarget)
        {
            m_csModelTarget = csModelTarget;
        }
        /// <summary><para>method outline:</para>
        /// <para>対象の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csModelTarget = csProjectInfData.GetModelTarget();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>対象</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetModelTarget()
        {
            return m_csModelTarget;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルのセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelCalcType( csModelCalcType );</para>
        /// </example>
        /// <param name="csModelCalcType">モデル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelCalcType(HySString csModelCalcType)
        {
            m_csModelCalcType = csModelCalcType;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csModelCalcType = csProjectInfData.GetModelCalcType();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetModelCalcType()
        {
            return m_csModelCalcType;
        }

        /// <summary><para>method outline:</para>
        /// <para>件名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelSubject( csModelSubject );</para>
        /// </example>
        /// <param name="csModelSubject">件名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelSubject(HySString csModelSubject)
        {
            m_csModelSubject = csModelSubject;
        }
        /// <summary><para>method outline:</para>
        /// <para>件名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csModelSubject = csProjectInfData.GetModelSubject();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>件名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetModelSubject()
        {
            return m_csModelSubject;
        }

        /// <summary><para>method outline:</para>
        /// <para>ケース名のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelSituation( csModelSituation );</para>
        /// </example>
        /// <param name="csModelSituation">ケース名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelSituation(HySString csModelSituation)
        {
            m_csModelSituation = csModelSituation;
        }
        /// <summary><para>method outline:</para>
        /// <para>ケース名の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csModelSituation = csProjectInfData.GetModelSituation();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ケース名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetModelSituation()
        {
            return m_csModelSituation;
        }

        /// <summary><para>method outline:</para>
        /// <para>期間種別のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelPeriodType( csModelPeriodType );</para>
        /// </example>
        /// <param name="csModelPeriodType">期間種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPeriodType(ModelPeriodType csModelPeriodType)
        {
            m_csModelPeriodType = csModelPeriodType;
        }
        /// <summary><para>method outline:</para>
        /// <para>期間種別の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ModelPeriodType csModelPeriodType = csProjectInfData.GetModelPeriodType();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>期間種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ModelPeriodType GetModelPeriodType()
        {
            return m_csModelPeriodType;
        }

        /// <summary><para>method outline:</para>
        /// <para>期間のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetModelPeriod( csModelPeriod );</para>
        /// </example>
        /// <param name="csModelPeriod">期間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelPeriod(McRange csModelPeriod)
        {
            m_csModelPeriod = csModelPeriod;
        }
        /// <summary><para>method outline:</para>
        /// <para>期間の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McRange csModelPeriod = csProjectInfData.GetModelPeriod();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>期間</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McRange GetModelPeriod()
        {
            return m_csModelPeriod;
        }

        /// <summary><para>method outline:</para>
        /// <para>境界条件１のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetThresholdCondition1( csThresholdCondition1 );</para>
        /// </example>
        /// <param name="csThresholdCondition1">境界条件１</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetThresholdCondition1(HySString csThresholdCondition1)
        {
            m_csThresholdCondition1 = csThresholdCondition1;
        }
        /// <summary><para>method outline:</para>
        /// <para>境界条件１の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csThresholdCondition1 = csProjectInfData.GetThresholdCondition1();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>境界条件１</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetThresholdCondition1()
        {
            return m_csThresholdCondition1;
        }

        /// <summary><para>method outline:</para>
        /// <para>境界条件２のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetThresholdCondition2( csThresholdCondition2 );</para>
        /// </example>
        /// <param name="csThresholdCondition2">境界条件２</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetThresholdCondition2(HySString csThresholdCondition2)
        {
            m_csThresholdCondition2 = csThresholdCondition2;
        }
        /// <summary><para>method outline:</para>
        /// <para>境界条件２の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csThresholdCondition2 = csProjectInfData.GetThresholdCondition2();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>境界条件２</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetThresholdCondition2()
        {
            return m_csThresholdCondition2;
        }

        /// <summary><para>method outline:</para>
        /// <para>境界条件３のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetThresholdCondition3( csThresholdCondition3 );</para>
        /// </example>
        /// <param name="csThresholdCondition3">境界条件３</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetThresholdCondition3(HySString csThresholdCondition3)
        {
            m_csThresholdCondition3 = csThresholdCondition3;
        }
        /// <summary><para>method outline:</para>
        /// <para>境界条件３の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csThresholdCondition3 = csProjectInfData.GetThresholdCondition3();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>境界条件３</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetThresholdCondition3()
        {
            return m_csThresholdCondition3;
        }

        /// <summary><para>method outline:</para>
        /// <para>境界条件４のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetThresholdCondition4( csThresholdCondition4 );</para>
        /// </example>
        /// <param name="csThresholdCondition4">境界条件４</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetThresholdCondition4(HySString csThresholdCondition4)
        {
            m_csThresholdCondition4 = csThresholdCondition4;
        }
        /// <summary><para>method outline:</para>
        /// <para>境界条件４の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csThresholdCondition4 = csProjectInfData.GetThresholdCondition4();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>境界条件４</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetThresholdCondition4()
        {
            return m_csThresholdCondition4;
        }

        /// <summary><para>method outline:</para>
        /// <para>境界条件５のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetThresholdCondition5( csThresholdCondition5 );</para>
        /// </example>
        /// <param name="csThresholdCondition5">境界条件５</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetThresholdCondition5(HySString csThresholdCondition5)
        {
            m_csThresholdCondition5 = csThresholdCondition5;
        }
        /// <summary><para>method outline:</para>
        /// <para>境界条件５の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csThresholdCondition5 = csProjectInfData.GetThresholdCondition5();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>境界条件５</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetThresholdCondition5()
        {
            return m_csThresholdCondition5;
        }

        /// <summary><para>method outline:</para>
        /// <para>条件１のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetCondition1( csCondition1 );</para>
        /// </example>
        /// <param name="csCondition1">条件１</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCondition1(HySString csCondition1)
        {
            m_csCondition1 = csCondition1;
        }
        /// <summary><para>method outline:</para>
        /// <para>条件１の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csCondition1 = csProjectInfData.GetCondition1();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>条件１</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetCondition1()
        {
            return m_csCondition1;
        }

        /// <summary><para>method outline:</para>
        /// <para>条件２のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetCondition2( csCondition2 );</para>
        /// </example>
        /// <param name="csCondition2">条件２</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCondition2(HySString csCondition2)
        {
            m_csCondition2 = csCondition2;
        }
        /// <summary><para>method outline:</para>
        /// <para>条件２の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csCondition2 = csProjectInfData.GetCondition2();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>条件２</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetCondition2()
        {
            return m_csCondition2;
        }

        /// <summary><para>method outline:</para>
        /// <para>条件３のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetCondition3( csCondition3 );</para>
        /// </example>
        /// <param name="csCondition3">条件３</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCondition3(HySString csCondition3)
        {
            m_csCondition3 = csCondition3;
        }
        /// <summary><para>method outline:</para>
        /// <para>条件３の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csCondition3 = csProjectInfData.GetCondition3();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>条件３</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetCondition3()
        {
            return m_csCondition3;
        }

        /// <summary><para>method outline:</para>
        /// <para>条件４のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetCondition4( csCondition4 );</para>
        /// </example>
        /// <param name="csCondition4">条件４</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCondition4(HySString csCondition4)
        {
            m_csCondition4 = csCondition4;
        }
        /// <summary><para>method outline:</para>
        /// <para>条件４の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csCondition4 = csProjectInfData.GetCondition4();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>条件４</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetCondition4()
        {
            return m_csCondition4;
        }

        /// <summary><para>method outline:</para>
        /// <para>条件５のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csProjectInfData.SetCondition5( csCondition5 );</para>
        /// </example>
        /// <param name="csCondition5">条件５</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCondition5(HySString csCondition5)
        {
            m_csCondition5 = csCondition5;
        }
        /// <summary><para>method outline:</para>
        /// <para>条件５の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csCondition5 = csProjectInfData.GetCondition5();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>条件５</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetCondition5()
        {
            return m_csCondition5;
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>データ変更フラグの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetChangeFlg( bChangeFlg );</para>
        /// </example>
        /// <param name="bChangeFlg">true:ﾃﾞｰﾀ変更あった、false:ﾃﾞｰﾀ変更なかった</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetChangeFlg( bool bChangeFlg )
        {
            m_bChangedFlg = bChangeFlg;
        }
        /// <summary><para>method outline:</para>
        /// <para>ﾃﾞｰﾀ変更あったか？</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = GetChangeFlg();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:ﾃﾞｰﾀ変更あった、false:ﾃﾞｰﾀ変更なかった</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetChangeFlg()
        {
            return m_bChangedFlg;
        }
        */

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.10";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        // プロジェクトグループ名をダミーセットする。
                        m_csProjectGroupName = new HySString("CmpProject.Ver1.0");
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
