﻿// <summary>ソースコード：接続構造チェック１レコード分クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>接続構造チェック１レコード分クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルチェックの結果および演算の情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McCheckInfRecord : HySDataRoot, HySVersionManagement
    {
        /// <summary>要素ID</summary>
        protected HySIdentifier m_csID;

        /// <summary>データ種別 ==true m_eDrawKind が有効、== false m_csModelKindが有効</summary>
        protected bool m_bViewData = false;
        /// <summary> 画面表示種別 </summary>
        protected McDefine.SymbolDrawKind m_eDrawKind;
        /// <summary> 演算側の種別 </summary>
        protected HySObjectKind m_csModelKind;

        /// <summary>メッセージレベル</summary>
        protected McDefine.MessageLevel m_eMessageLevel;

        /// <summary>メッセージ</summary>
        protected HySString m_csMessage;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCheckInfRecord csCheckInfRecord = new McCheckInfRecord()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McCheckInfRecord()
        {
            m_csID = null;
            m_eDrawKind = McDefine.SymbolDrawKind.HYM_NonSymbol;
            m_eMessageLevel = McDefine.MessageLevel.HYM_NON_LEVEL;
            m_csMessage = new HySString("");
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCheckInfRecord csMcCheckInfRecord = new McCheckInfRecord(csID, csModelKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="eMessageLevel">メッセージレベル</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCheckInfRecord(HySIdentifier csID, HySObjectKind csModelKind, McDefine.MessageLevel eMessageLevel, HySString csMessage)
        {
            m_csID = csID;
            m_csModelKind = csModelKind;
            m_bViewData = false;
            m_eMessageLevel = eMessageLevel;
            m_csMessage = csMessage;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCheckInfRecord csMcCheckInfRecord = new McCheckInfRecord(csID, eDrawKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="eDrawKind">シンボル描画種別</param>
        /// <param name="eMessageLevel">メッセージレベル</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCheckInfRecord(HySIdentifier csID, McDefine.SymbolDrawKind eDrawKind, McDefine.MessageLevel eMessageLevel, HySString csMessage)
        {
            m_csID = csID;
            m_eDrawKind = eDrawKind;
            m_bViewData = true;
            m_eMessageLevel = eMessageLevel;
            m_csMessage = csMessage;
            //バージョン情報設定
            SetNowVersion();
        }


        /// <summary><para>method outline:</para>
        /// <para>ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySIdentifier csID = GetID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier　要素ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySIdentifier GetID()
        {
            return m_csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部の情報は表示用オブジェクトからの情報か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bFlg = IsDrawObject()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:表示用オブジェクト、=false:計算用要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool IsDrawObject()
        {
            return m_bViewData;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部の情報は計算用要素からの情報か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bFlg = IsCalElementObject()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:計算用要素、=false:表示用オブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool IsCalElementObject()
        {
            return !(m_bViewData);
        }

        /// <summary><para>method outline:</para>
        /// <para>要素種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDefine.SymbolDrawKind eDrawKind = GetDrawKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDefine.SymbolDrawKind　要素種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>IsDrawObject()==true の時有効</para>
        /// </remarks>
        public McDefine.SymbolDrawKind GetDrawKind()
        {
            return m_eDrawKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySObjectKind csObjKind = GetObjectKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind　要素種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>IsCalElementObject()==true の時有効</para>
        /// </remarks>
        public HySObjectKind GetObjectKind() 
        {
            return m_csModelKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージレベル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDefine.MessageLevel eMessageLevel = GetMessageLevel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDefine.MessageLevel　メッセージレベル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDefine.MessageLevel GetMessageLevel()
        {
            return m_eMessageLevel;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csMessage = GetMessage()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString　メッセージ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetMessage()
        {
            return m_csMessage;
        }

        /// <summary><para>method outline:</para>
        /// <para>ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetID(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetID(HySIdentifier csID)
        {
            m_csID = csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDrawKind(eDrawKind)</para>
        /// </example>
        /// <param name="eDrawKind">要素種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDrawKind(McDefine.SymbolDrawKind eDrawKind)
        {
            m_eDrawKind = eDrawKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージレベル設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetMessageLevel(eMessageLevel)</para>
        /// </example>
        /// <param name="eMessageLevel">メッセージレベル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMessageLevel(McDefine.MessageLevel eMessageLevel)
        {
            m_eMessageLevel = eMessageLevel;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetMessage(csMessage)</para>
        /// </example>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMessage(HySString csMessage)
        {
            m_csMessage = csMessage;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
