﻿// <summary>ソースコード：接続構造チェック結果クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>接続構造チェック結果クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルチェックの結果および演算の情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McStructCheckData : McStructErrorInfo, HySVersionManagement
    {
        /// <summary>チェックデータリスト</summary>
        protected HySDataLinkedList m_csCheckDataList;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructCheckData csMcStructCheckData = new McStructCheckData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructCheckData()
        {
            m_csCheckDataList = new HySDataLinkedList();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>エラー情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddSimuErrorData(csID, csModelKind, sMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="sMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddSimuErrorData(HySIdentifier csID, HySKind csModelKind, string sMessage)
        {
            sMessage = "ERROR: " + sMessage;
            m_csCheckDataList.AddLast(new McCheckInfRecord(csID, (HySObjectKind)csModelKind, McDefine.MessageLevel.HYM_SIMULATION_ERROR, new HySString(sMessage)));
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>エラー情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddSimuErrorData(csID, csModelKind, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddSimuErrorData(HySIdentifier csID, HySKind csModelKind, HySString csMessage)
        {
            csMessage = new HySString("ERROR: ") + csMessage;
            m_csCheckDataList.AddLast(new McCheckInfRecord(csID, (HySObjectKind)csModelKind, McDefine.MessageLevel.HYM_SIMULATION_ERROR, csMessage));
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckData(csID, csModelKind, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddCheckErrorData(HySIdentifier csID, HySKind csModelKind, string csMessage)
        {
            AddCheckData(csID, csModelKind, McDefine.MessageLevel.HYM_MODELCHECK_ERROR, new HySString(csMessage));
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックワーニングデータ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckData(csID, csModelKind, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddCheckWarningData(HySIdentifier csID, HySKind csModelKind, string csMessage)
        {
            AddCheckData(csID, csModelKind, McDefine.MessageLevel.HYM_MODELCHECK_WARNING, new HySString(csMessage));
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェック一般情報データ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckInformationData(csID, csModelKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddCheckInformationData(HySIdentifier csID, HySKind csModelKind, string csMessage)
        {
            AddCheckData(csID, csModelKind, McDefine.MessageLevel.HYM_MODELCHECK_INFORMATION, new HySString(csMessage));
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckData(csID, csModelKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="eMessageLevel">メッセージレベル</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddCheckData(HySIdentifier csID, HySKind csModelKind, McDefine.MessageLevel eMessageLevel, HySString csMessage)
        {
            if (eMessageLevel == McDefine.MessageLevel.HYM_SIMULATION_ERROR)
            {
                csMessage = new HySString("ERROR: ") + csMessage;
            }
            else if (eMessageLevel == McDefine.MessageLevel.HYM_MODELCHECK_ERROR)
            {
                csMessage = new HySString("ERROR: ") + csMessage;
            }
            else if (eMessageLevel == McDefine.MessageLevel.HYM_MODELCHECK_WARNING)
            {
                csMessage = new HySString("WARNING: ") + csMessage;
            }
            else if (eMessageLevel == McDefine.MessageLevel.HYM_MODELCHECK_INFORMATION)
            {
                csMessage = new HySString("INFORMATION: ") + csMessage;
            }
            m_csCheckDataList.AddLast(new McCheckInfRecord(csID, (HySObjectKind)csModelKind, eMessageLevel, csMessage));
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckData(csID, eKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="eKind">シンボル描画種別</param>
        /// <param name="eMessageLevel">メッセージレベル</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddCheckData(HySIdentifier csID, McDefine.SymbolDrawKind eKind, McDefine.MessageLevel eMessageLevel, HySString csMessage)
        {
            m_csCheckDataList.AddLast(new McCheckInfRecord(csID, eKind, eMessageLevel, csMessage));
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ数取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = GetCheckDataCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>チェックデータ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCheckDataCount()
        {
            return m_csCheckDataList.GetCount();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータリンクリスト取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csDataLinkedList = GetCheckDataList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>チェックデータを保持するリンクリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetCheckDataList()
        {
            return m_csCheckDataList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCheckInfRecord csCheckInfRecord = GetCheckData(lPos)</para>
        /// </example>
        /// <param name="lPos">位置(0相対)</param>
        /// <returns>McStructCheckData チェックデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCheckInfRecord GetCheckData(long lPos)
        {
            return (McCheckInfRecord)m_csCheckDataList.GetData(lPos);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RemoveCheckData(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveCheckData(HySIdentifier csID)
        {
            long lLp = 0L;                      // ループカウンタ
            McCheckInfRecord csCheckData = null;

            if (csID == null)
            {// パラメータ異常
                return;
            }

            for (lLp = 0; lLp < m_csCheckDataList.GetCount(); lLp++)
            {// 要素を検索
                csCheckData = (McCheckInfRecord)m_csCheckDataList.GetData(lLp);
                if (csCheckData.GetID().Equals(csID) == true)
                {// IDが一致
                    m_csCheckDataList.RemoveData(lLp);
                    break;
                }
            }
            return;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータ削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RemoveCheckData(lPos)</para>
        /// </example>
        /// <param name="lPos">位置(0相対)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveCheckData(long lPos)
        {
            m_csCheckDataList.RemoveData(lPos);

            return;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>内部のチェック情報クリア</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ClearCheckData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearCheckData()
        {
            m_csCheckDataList.Clear();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
