﻿// <summary>ソースコード：接続構造接続線情報</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Model;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary><para>class outline:</para>
    /// <para>接続構造接続線情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/11/17][新規作成]
    /// [CommonMP][ver 1.2.0][2011/11/10][レコード数最適化処理追加]
    /// </para>
    /// </remarks>
    [Serializable]
    public class McStructConnection : HySDataRoot, HySVersionManagement
    {
        /// <summary> 接続データタ識別子 </summary>
        protected HySIdentifier m_csID = null;

        /// <summary> 接続元ポート識別子 </summary>
        protected HySIdentifier m_csFromPortID = null;
        /// <summary> 接続先ポート識別子 </summary>
        protected HySIdentifier m_csToPortID = null;
        /// <summary> 接続元要素識別子 </summary>
        protected HySIdentifier m_csFromElmID = null;
        /// <summary> 接続先要素識別子 </summary>
        protected HySIdentifier m_csToElmID = null;

        /// <summary>接続名称</summary>
        protected HySString m_sCnnctName = new HySString();

        //== starto fo XML化の対象にはならないメンバー　==//
        /// <summary>自身を所有するグループ要素</summary>
        protected McStructGroupElement m_csOwnerGrElm = null;
        //== end fo XML化の対象にはならないメンバー　==//

        // 一貫番号生成
        /// <summary>接続カウンタ</summary>
        static protected ulong m_ulPrimNo = 0UL;

        // ========================
        // 伝送データ生成に必要な情報
        // ========================
        /// <summary>伝送データ個別情報（必須）</summary>
        protected McModelInfo m_csTranDataInfo = new McModelInfo(new HySID(""), new HySObjectKind(""), new HySObjectKind(""), new HySString("")); // 仮設定 モデルを設定していなくても，構造定義ファイルを吐き出したときに死なない為;
        ///// <summary>モデルプロパティ表示／設定情報（必須）</summary>
        //McModelPropertyInfoRoot m_csModelProperty;  ← m_csTranDataInfo内にあるので此処では不用


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructConnection csStructConec = new McStructConnection( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McStructConnection()
        {
            m_ulPrimNo += 1;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructConnection csStructConec = new McStructConnection( csID )</para>
        /// </example>
        /// <param name="csID">データ識別子</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructConnection(HySIdentifier csID)
        {
            m_csID = csID;
            McStructConnection.m_ulPrimNo += 1;
            //string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString() + DateTime.Now.Second.ToString()
            //    + "." + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
            //m_csID = new HySID("C", m_ulPrimNo.ToString() + "-", sStr);
            string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString()
                + "-" + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
            //m_csID = new HySID("C" + m_ulPrimNo.ToString() + DateTime.Now.Second.ToString() + "-", ((long)McDefine.SymbolDrawKind.HYM_LINE).ToString(), sStr);
            m_csID = new HySID("C" + m_ulPrimNo.ToString() + DateTime.Now.Second.ToString() + "-"
                               + ((long)McDefine.SymbolDrawKind.HYM_LINE).ToString() + sStr);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>データ識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetID( csID )</para>
        /// </example>
        /// <param name="csID">データ識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySIdentifier csID)
        {
            m_csID = csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySIdentifier csID = GetID( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>データ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetID()
        {
            return m_csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>ID一致判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Equal( csID )</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>bool true:一致，false:不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySIdentifier csID)
        {
            if (csID == null || m_csID == null)
            {// パラメータ,メンバ変数異常
                return false;
            }

            return m_csID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>接続名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetConnectionName(csCnctName)</para>
        /// </example>
        /// <param name="csCnctName">接続名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnectionName(HySString csCnctName)
        {
            if ((object)csCnctName != null)
            {
                //m_sCnnctName = csCnctName;
                if ((object)m_sCnnctName != null)
                {
                    m_sCnnctName.SetString(csCnctName);
                }
                else
                {
                    m_sCnnctName = csCnctName;
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>接続名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csString = GetConnectionName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>接続名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetConnectionName()
        {
            HySString sRtnName = new HySString();
            if ((object)m_sCnnctName != null)
            {
                sRtnName = m_sCnnctName;
            }

            return sRtnName;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分を所有するグループ要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetOwnerElement(csOwnerGrElm)</para>
        /// </example>
        /// <param name="csOwnerGrElm">自分を所有するグループ要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetOwnerElement(McStructGroupElement csOwnerGrElm)
        {
            m_csOwnerGrElm = csOwnerGrElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>自分を所有するグループ要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructGroupElement csOwner = GetOwnerElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McStructGroupElement 自分を所有するグループ要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McStructGroupElement GetOwnerElement()
        {
            return m_csOwnerGrElm;
        }

        //======================================
        // 接続情報関連メソッド
        //======================================
        /// <summary><para>method outline:</para>
        /// <para>ポート接続情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetConnection( csFromID,csFromPortID,csToID,csToPortID )</para>
        /// </example>
        /// <param name="csFromID">接続元要素識別子</param>
        /// <param name="csFromPortID">接続元ポート識別子</param>
        /// <param name="csToID">接続先要素識別子</param>
        /// <param name="csToPortID">接続先ポート識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnection(HySIdentifier csFromID, HySIdentifier csFromPortID, HySIdentifier csToID, HySIdentifier csToPortID)
        {
            m_csFromElmID = csFromID;
            m_csFromPortID = csFromPortID;
            m_csToElmID = csToID;
            m_csToPortID = csToPortID;
        }
        /// <summary><para>method outline:</para>
        /// <para>ポート接続情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetConnection(ref csFromPortID, ref csToPortID )</para>
        /// </example>
        /// <param name="csFromPortID">接続元ポート識別子</param>
        /// <param name="csToPortID">接続先ポート識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetConnectionPort(ref HySIdentifier csFromPortID, ref HySIdentifier csToPortID)
        {
            csFromPortID = m_csFromPortID;
            csToPortID = m_csToPortID;
        }
        /// <summary><para>method outline:</para>
        /// <para>要素接続情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetConnectionElement(ref csFromID, ref csToID )</para>
        /// </example>
        /// <param name="csFromID">接続元要素識別子</param>
        /// <param name="csToID">接続先要素識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetConnectionElement(ref HySIdentifier csFromID, ref HySIdentifier csToID)
        {
            csFromID = m_csFromElmID;
            csToID = m_csToElmID;
        }

//------------
// start of レコード数自動調整の為の処理を追加
//  Ver1.2
//------------
        /// <summary><para>method outline:</para>
        /// <para>上位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csElm = GetUpperTerminalElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McStructElement 上位に接続されている要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetUpperTerminalElement()
        {
            McStructElement csElm = m_csOwnerGrElm.GetElement(m_csFromElmID); // 接続元要素を取得
            McStructGroupElement csGrElm = csElm as McStructGroupElement;
            if (csGrElm != null)
            {   // 接続元要素がGr要素ならば
                McStructPort csPort = csGrElm.GetPort(m_csFromPortID);
                if (csPort != null)
                {
                    McStructTranINPort csTrnINPort = csPort as McStructTranINPort;
                    McStructTranOUTPort csTrnOUTPort = csPort as McStructTranOUTPort;
                    if (csTrnINPort != null)
                    {   // グループの外に出て行く接続の場合
                        csElm = csGrElm.GetUpperTerminalElement(csTrnINPort);
                    }
                    else if (csTrnOUTPort != null)
                    {   // グループの内部に接続されている場合
                        csElm = csGrElm.GetUpperTerminalElement(csTrnOUTPort);
                    }
                }
            }
            if( csElm == null )
            {   // 前処理で要素が見つからない場合
                if (m_csFromElmID.Equals(m_csOwnerGrElm.GetID())==true)
                {   // Gr外からの接続
                    McStructPort csPort = m_csOwnerGrElm.GetPort(m_csFromPortID);
                    csElm = m_csOwnerGrElm.GetUpperTerminalElement(csPort);
                }
            }
            return csElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>下位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csElm = GetLowerTerminalElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McStructElement 下位に接続されている要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetLowerTerminalElement()
        {
            McStructElement csElm = m_csOwnerGrElm.GetElement(m_csToElmID); // 接続先要素を取得
            McStructGroupElement csGrElm = csElm as McStructGroupElement;
            if (csGrElm != null)
            {   // 接続先がGr要素ならば
                McStructPort csPort = csGrElm.GetPort(m_csToPortID);
                if (csPort != null)
                {
                    McStructTranINPort csTrnINPort = csPort as McStructTranINPort;
                    McStructTranOUTPort csTrnOUTPort = csPort as McStructTranOUTPort;
                    if (csTrnOUTPort != null)
                    {   // グループの外に出て行く接続の場合
                        csElm = csGrElm.GetLowerTerminalElement(csTrnOUTPort);
                    }
                    else if (csTrnINPort != null)
                    {   // グループの内部に接続されている場合
                        csElm = csGrElm.GetLowerTerminalElement(csTrnINPort);
                    }

                }
            }
            if (csElm == null)
            {   // 前処理で要素が見つからない場合
                if (m_csToElmID.Equals(m_csOwnerGrElm.GetID())==true)
                {   // Gr外へ出て行く接続
                    McStructPort csPort = m_csOwnerGrElm.GetPort(m_csToPortID);
                    csElm = m_csOwnerGrElm.GetLowerTerminalElement(csPort);
                }
            }
            return csElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続元要素ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySIdentifier csElmID = GetFromElmID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 接続元要素ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数値を返すのみ</para>
        /// </remarks>
        internal HySIdentifier GetFromElmID()
        { return m_csFromElmID; }
        /// <summary><para>method outline:</para>
        /// <para>接続先要素ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySIdentifier csElmID = GetToElmID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 接続先要素ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数値を返すのみ</para>
        /// </remarks>
        internal HySIdentifier GetToElmID()
        { return m_csToElmID; }
//------------
// end  of レコード数自動調整の為の処理を追加
//  Ver1.2
//------------

        /*
        /// <summary><para>method outline:</para>
        /// <para>接続インスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementAndPortInstance( csFromElm, csFromPort, csToElm, csToPort )</para>
        /// </example>
        /// <param name="csFromElm">接続元要素</param>
        /// <param name="csFromPort">接続元ポート</param>
        /// <param name="csToElm">接続先要素</param>
        /// <param name="csToPort">接続先ポート</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementAndPortInstance(McStructElement csFromElm, McStructPort csFromPort, McStructElement csToElm, McStructPort csToPort)
        {
            m_csFromElm = csFromElm;
            m_csToElm = csToElm;
            m_csFromPort = csFromPort;
            m_csToPort = csToPort;

            McConnectionPropertyIF csCnctPrpty = m_csTranDataInfo.GetPropertyInfo() as McConnectionPropertyIF;
            if (csCnctPrpty != null)
            {
                if( m_csFromElm != null )
                {
                    csCnctPrpty.SetUpperElementModelInfor(m_csFromElm.GetModelInfo());
                }
                if (m_csToElm != null)
                {
                    csCnctPrpty.SetLowerElementModelInfor(m_csToElm.GetModelInfo());
                }
            }
        }
        */

        //======================================
        // 伝送データ情報関連メソッド
        //======================================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送情報デフォルトパターン設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetDefaultPattern(pConnect)</para>
        /// </example>
        /// <param name="pConnect">再帰的コール時の引数：通常は null を設定</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDefaultPattern(McStructConnection pConnect)
        {
            McTranInfoPattern csRecvPatternWork = null;                         // 受信パターンワーク
            McTranInfoPattern csSendPatternWork = null;                         // 送信パターンワーク
            McTranInfoPattern csRecvPatternStock = null;                        // 受信パターン確保情報
            McTranInfoPattern csSendPatternStock = null;                        // 送信パターン確保情報
            McTranInfoPattern csRecvPattern = null;                             // 受信パターン
            McTranInfoPattern csSendPattern = null;                             // 送信パターン
            McCellModelPropertyInfo csUpperProperty = null;                     // 上位要素プロパティ
            McCellModelPropertyInfo csLowerProperty = null;                     // 下位要素プロパティ
            McDataMergePropertyInfo csDataMergePropertyInfo = null;             // マージモデルプロパティ
            int iRecvCnt = 0;                                                   // 受信パターン数
            int iSendCnt = 0;                                                   // 送信パターン数
            McCellArrayTranInfoPropertyInfo csTrnPrpty = m_csTranDataInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
            if (csTrnPrpty != null)
            {   // プロパティ情報有り
                csRecvPattern = (McTranInfoPattern)csTrnPrpty.GetReceiveTranInfoPattern();
                csSendPattern = (McTranInfoPattern)csTrnPrpty.GetSendTranInfoPattern();
                csUpperProperty = csTrnPrpty.GetUpperModelProperty() as McCellModelPropertyInfo;
                csLowerProperty = csTrnPrpty.GetLowerModelProperty() as McCellModelPropertyInfo;
                if (csUpperProperty != null)
                {   // 上流モデルプロパティ有り
                    csDataMergePropertyInfo = csUpperProperty as McDataMergePropertyInfo;
                    if (csDataMergePropertyInfo != null)
                    {   // マージモデルプロパティ
                        if (csDataMergePropertyInfo.GetMergeConnection() != null)
                        {   // 接続情報あり
                            for (int iLoop = 0; iLoop < csDataMergePropertyInfo.GetMergeConnection().GetIdxNum(); iLoop++)
                            {   // 接続情報数分処理
                                if (csDataMergePropertyInfo.GetMergeConnection().GetIdx()[iLoop] != -1)
                                {   // 接続情報設定有り
                                    for (int lLp = 0; lLp < csUpperProperty.GetSendPatternNumber(); lLp++)
                                    {// レコード数ループ
                                        csSendPatternWork = (McTranInfoPattern)csUpperProperty.GetSendPatternList().GetData(lLp);
                                        if (csSendPatternWork.GetTranDataKind().Equals(csTrnPrpty.GetModelKind()) == true)
                                        {// 種別が一致した場合
                                            csSendPatternStock = csSendPatternWork;
                                            iSendCnt++;
                                            break;
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    else
                    {
                        for (int lLp = 0; lLp < csUpperProperty.GetSendPatternNumber(); lLp++)
                        {// レコード数ループ
                            csSendPatternWork = (McTranInfoPattern)csUpperProperty.GetSendPatternList().GetData(lLp);
                            if (csSendPatternWork.GetTranDataKind().Equals(csTrnPrpty.GetModelKind()) == true)
                            {// 種別が一致した場合
                                csSendPatternStock = csSendPatternWork;
                                iSendCnt++;
                                break;
                            }
                        }
                    }
                }
                if (csLowerProperty != null)
                {   // 下流モデルプロパティ有り
                    for (int lLp = 0; lLp < csLowerProperty.GetReceivePatternNumber(); lLp++)
                    {// レコード数ループ
                        csRecvPatternWork = (McTranInfoPattern)csLowerProperty.GetReceivePatternList().GetData(lLp);
                        if (csRecvPatternWork.GetTranDataKind().Equals(csTrnPrpty.GetModelKind()) == true)
                        {// 種別が一致した場合
                            csRecvPatternStock = csRecvPatternWork;
                            iRecvCnt++;
                            break;
                        }
                    }
                }
                if (csRecvPattern == null)
                {   // パターン未設定
                    if (iRecvCnt == 1)
                    {   // パターン数が1個
                        csTrnPrpty.SetReceiveTranInfoPattern(csRecvPatternStock);
                        csTrnPrpty.SetLowerConnectionPatternID(csRecvPatternStock.GetPatternID());
                    }
                }
                if (csSendPattern == null)
                {   // パターン未設定
                    if (iSendCnt == 1)
                    {   // パターン数が1個
                        csTrnPrpty.SetSendTranInfoPattern(csSendPatternStock);
                        csTrnPrpty.SetUpperConnectionPatternID(csSendPatternStock.GetPatternID());
                    }
                }
            }

            McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);   // 上位から接続要素を探す
            if (csFromElm != null)
            {   // インスタンス有り
                if (csFromElm is McStructGroupElement)
                {   // 接続先がグループ要素ならば　中継端子に接続されている
                    McStructConnection csRlyTrn = ((McStructGroupElement)csFromElm).QueryConnectionByPortID(m_csFromPortID);    // 中継された接続を探す
                    if (csRlyTrn != null && csRlyTrn != pConnect)
                    {   // インスタンスが一意
                        csRlyTrn.SetDefaultPattern(this);
                    }
                    McStructElement csInnerFromElm = ((McStructGroupElement)csFromElm).QueryInternalElement(m_csFromPortID); // 真の要素を探す
                    if (csInnerFromElm != null)
                    {   // 真の要素があるならば
                        // Do Nothing
                    }
                }
                else
                {   // インスタンス無し
                    // Do Nothing
                }
            }
            else
            {   // インスタンス無し
                McStructPort csPort = m_csOwnerGrElm.GetPort(m_csFromPortID);
                if (csPort != null)
                {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                    if (m_csOwnerGrElm != null)
                    {   // インスタンス有り
                        McStructGroupElement csUpperOwnerGrElm = m_csOwnerGrElm.GetOwnerElement();
                        if (csUpperOwnerGrElm != null)
                        {   // インスタンス有り
                            McStructConnection csRlyTrn = csUpperOwnerGrElm.QueryConnectionByPortID(m_csFromPortID);    // 中継された接続を探す
                            if (csRlyTrn != null && csRlyTrn != pConnect)
                            {   // インスタンスが一意
                                csRlyTrn.SetDefaultPattern(this);
                            }
                        }
                        McStructElement csInnerFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID); // 真の要素を探す
                        if (csInnerFromElm != null)
                        {   // 真の要素があるならば
                            // Do Nothing
                        }
                    }
                }   // end of if(csPort !=null)
            }   // end of if (csFromElm != null)else()

            // 接続先
            McStructElement csToElm = m_csOwnerGrElm.GetElement(m_csToElmID);
            if (csToElm != null)
            {   // インスタンス有り
                if (csToElm is McStructGroupElement)
                {   // 接続先がグループ要素ならば　中継端子に接続されている
                    McStructConnection csRlyTrn = ((McStructGroupElement)csToElm).QueryConnectionByPortID(m_csToPortID);    // 中継された接続を探す
                    if (csRlyTrn != null && csRlyTrn != pConnect)
                    {   // インスタンスが一意
                        csRlyTrn.SetDefaultPattern(this);
                    }
                    McStructElement csInnerToElm = ((McStructGroupElement)csToElm).QueryInternalElement(m_csToPortID); // 真の要素を探す
                    if (csInnerToElm != null)
                    {   // 真の要素があるならば
                        // Do Nothing
                    }
                }
                else
                {   // グループ要素でない
                    // Do Nothing
                }
            }
            else
            {   // インスタンス無し
                McStructPort csPort = m_csOwnerGrElm.GetPort(m_csToPortID);
                if (csPort != null)
                {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                    if (m_csOwnerGrElm != null)
                    {   // インスタンス有り
                        McStructGroupElement csUpperOwnerGrElm = m_csOwnerGrElm.GetOwnerElement();
                        if (csUpperOwnerGrElm != null)
                        {   // インスタンス有り
                            McStructConnection csRlyTrn = csUpperOwnerGrElm.QueryConnectionByPortID(m_csToPortID);    // 中継された接続を探す
                            if (csRlyTrn != null && csRlyTrn != pConnect)
                            {   // インスタンスが一意
                                csRlyTrn.SetDefaultPattern(this);
                            }

                        }
                        McStructElement csInnerToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID); // 真の要素を探す
                        if (csInnerToElm != null)
                        {   // 真の要素があるならば
                            // Do Nothing
                        }
                    }
                }   // end of if(csPort !=null)
            }   // end of if (csToElm != null)else()
        }
  
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データプロパティ情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetTranInfoPropertyInfo(csPropertyInf, csCnnction)</para>
        /// </example>
        /// <param name="csPropertyInf">伝送データプロパティ情報</param>
        /// <param name="csCnnction">再帰的コール時の引数：通常は null を設定</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>伝送データ情報設定後、Gr内外の伝送データプロパティ情報が別インスタンスになるため、本メソッドにて同一インスタンスとする。</para>
        /// </remarks>
        public virtual void SetTranInfoPropertyInfo(McPropertyInfoRoot csPropertyInf, McStructConnection csCnnction)
        {
            m_csTranDataInfo.SetPropertyInfo(csPropertyInf);
            // 接続元
            McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);   // 上位から接続要素を探す
            if (csFromElm != null)
            {
                if (csFromElm is McStructGroupElement)
                {   // 接続先がグループ要素ならば　中継端子に接続されている
                    McStructConnection csRlyTrn = ((McStructGroupElement)csFromElm).QueryConnectionByPortID(m_csFromPortID);    // 中継された接続を探す
                    if (csRlyTrn != null && csRlyTrn != csCnnction)
                    {
                        csRlyTrn.SetTranInfoPropertyInfo(csPropertyInf, this);
                    }
                    McStructElement csInnerFromElm = ((McStructGroupElement)csFromElm).QueryInternalElement(m_csFromPortID); // 真の要素を探す
                    if (csInnerFromElm != null)
                    {   // 真の要素があるならば
                        // Do Nothing
                    }
                }
                else
                {
                    // Do Nothing
                }
            }
            else
            {
                McStructPort csPort = m_csOwnerGrElm.GetPort(m_csFromPortID);
                if (csPort != null)
                {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                    if (m_csOwnerGrElm != null)
                    {
                        McStructGroupElement csUpperOwnerGrElm = m_csOwnerGrElm.GetOwnerElement();
                        if (csUpperOwnerGrElm != null)
                        {
                            McStructConnection csRlyTrn = csUpperOwnerGrElm.QueryConnectionByPortID(m_csFromPortID);    // 中継された接続を探す
                            if (csRlyTrn != null && csRlyTrn != csCnnction)
                            {
                                csRlyTrn.SetTranInfoPropertyInfo(csPropertyInf, this);
                            }
                        }
                        McStructElement csInnerFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID); // 真の要素を探す
                        if (csInnerFromElm != null)
                        {   // 真の要素があるならば
                            // Do Nothing
                        }
                    }
                }   // end of if(csPort !=null)
            }   // end of if (csFromElm != null)else()

            // 接続先
            McStructElement csToElm = m_csOwnerGrElm.GetElement(m_csToElmID);
            if (csToElm != null)
            {
                if (csToElm is McStructGroupElement)
                {   // 接続先がグループ要素ならば　中継端子に接続されている
                    McStructConnection csRlyTrn = ((McStructGroupElement)csToElm).QueryConnectionByPortID(m_csToPortID);    // 中継された接続を探す
                    if (csRlyTrn != null && csRlyTrn != csCnnction)
                    {
                        csRlyTrn.SetTranInfoPropertyInfo(csPropertyInf, this);
                    }
                    McStructElement csInnerToElm = ((McStructGroupElement)csToElm).QueryInternalElement(m_csToPortID); // 真の要素を探す
                    if (csInnerToElm != null)
                    {   // 真の要素があるならば
                        // Do Nothing
                    }
                }
                else
                {
                    // Do Nothing
                }
            }
            else
            {
                McStructPort csPort = m_csOwnerGrElm.GetPort(m_csToPortID);
                if (csPort != null)
                {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                    if (m_csOwnerGrElm != null)
                    {
                        McStructGroupElement csUpperOwnerGrElm = m_csOwnerGrElm.GetOwnerElement();
                        if (csUpperOwnerGrElm != null)
                        {
                            McStructConnection csRlyTrn = csUpperOwnerGrElm.QueryConnectionByPortID(m_csToPortID);    // 中継された接続を探す
                            if (csRlyTrn != null && csRlyTrn != csCnnction)
                            {
                                csRlyTrn.SetTranInfoPropertyInfo(csPropertyInf, this);
                            }

                        }
                        McStructElement csInnerToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID); // 真の要素を探す
                        if (csInnerToElm != null)
                        {   // 真の要素があるならば
                            // Do Nothing
                        }
                    }
                }   // end of if(csPort !=null)
            }   // end of if (csToElm != null)else()
            McCellArrayTranInfoPropertyInfo csTrnPrpty = m_csTranDataInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
            if (csTrnPrpty != null)
            {
                csTrnPrpty.SetStructConnection(this);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetConnectionTranInfo(csTranInfo,csCnnction)</para>
        /// </example>
        /// <param name="csTranInfo">伝送データ個別情報</param>
        /// <param name="csCnnction">再帰的コール時の引数：通常は null を設定</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnectionTranInfo(McModelInfo csTranInfo, McStructConnection csCnnction)
        {
            if (csCnnction == null)
            {
                m_csTranDataInfo = csTranInfo;
            }
            else
            {
                m_csTranDataInfo = csTranInfo.Clone();
            }
            m_csTranDataInfo.SetElementID((HySID)this.m_csID);
            m_csTranDataInfo.SetUserName(m_sCnnctName);
            if (m_csTranDataInfo.GetPropertyInfo() != null)
            {
                m_csTranDataInfo.GetPropertyInfo().SetID((HySID)this.m_csID);    // プロパティ情報にも要素識別子を反映
                McConnectionPropertyIF csCnctPrpty = m_csTranDataInfo.GetPropertyInfo() as McConnectionPropertyIF;
                if (csCnctPrpty != null)
                {
                    // 接続元
                    McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);   // 上位から接続要素を探す
                    if (csFromElm != null)
                    {
                        if (csFromElm is McStructGroupElement)
                        {   // 接続先がグループ要素ならば　中継端子に接続されている
                            McStructConnection csRlyTrn = ((McStructGroupElement)csFromElm).QueryConnectionByPortID(m_csFromPortID);    // 中継された接続を探す
                            if (csRlyTrn != null && csRlyTrn != csCnnction)
                            {
                                csRlyTrn.SetConnectionTranInfo(csTranInfo, this);
                            }
                            McStructElement csInnerFromElm = ((McStructGroupElement)csFromElm).QueryInternalElement(m_csFromPortID); // 真の要素を探す
                            if (csInnerFromElm != null)
                            {   // 真の要素があるならば
                                csCnctPrpty.SetUpperElementModelInfor(csInnerFromElm.GetModelInfo());
                            }
                        }
                        else
                        {
                            csCnctPrpty.SetUpperElementModelInfor(csFromElm.GetModelInfo());
                        }
                    }
                    else
                    {
                        McStructPort csPort = m_csOwnerGrElm.GetPort(m_csFromPortID);
                        if (csPort != null)
                        {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                            if (m_csOwnerGrElm != null)
                            {
                                McStructGroupElement csUpperOwnerGrElm = m_csOwnerGrElm.GetOwnerElement();
                                if (csUpperOwnerGrElm != null)
                                {
                                    McStructConnection csRlyTrn = csUpperOwnerGrElm.QueryConnectionByPortID(m_csFromPortID);    // 中継された接続を探す
                                    if (csRlyTrn != null && csRlyTrn != csCnnction)
                                    {
                                        csRlyTrn.SetConnectionTranInfo(csTranInfo, this);
                                    }
                                }
                                McStructElement csInnerFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID); // 真の要素を探す
                                if (csInnerFromElm != null)
                                {   // 真の要素があるならば
                                    csCnctPrpty.SetUpperElementModelInfor(csInnerFromElm.GetModelInfo());
                                }
                            }
                        }   // end of if(csPort !=null)
                    }   // end of if (csFromElm != null)else()

                    // 接続先
                    McStructElement csToElm = m_csOwnerGrElm.GetElement(m_csToElmID);
                    if (csToElm != null)
                    {
                        if (csToElm is McStructGroupElement)
                        {   // 接続先がグループ要素ならば　中継端子に接続されている
                            McStructConnection csRlyTrn = ((McStructGroupElement)csToElm).QueryConnectionByPortID(m_csToPortID);    // 中継された接続を探す
                            if (csRlyTrn != null && csRlyTrn != csCnnction)
                            {
                                csRlyTrn.SetConnectionTranInfo(csTranInfo, this);
                            }
                            McStructElement csInnerToElm = ((McStructGroupElement)csToElm).QueryInternalElement(m_csToPortID); // 真の要素を探す
                            if (csInnerToElm != null)
                            {   // 真の要素があるならば
                                csCnctPrpty.SetLowerElementModelInfor(csInnerToElm.GetModelInfo());
                            }
                        }
                        else
                        {
                            csCnctPrpty.SetLowerElementModelInfor(csToElm.GetModelInfo());
                        }
                    }
                    else
                    {
                        McStructPort csPort = m_csOwnerGrElm.GetPort(m_csToPortID);
                        if (csPort != null)
                        {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                            if (m_csOwnerGrElm != null)
                            {
                                McStructGroupElement csUpperOwnerGrElm = m_csOwnerGrElm.GetOwnerElement();
                                if (csUpperOwnerGrElm != null)
                                {
                                    McStructConnection csRlyTrn = csUpperOwnerGrElm.QueryConnectionByPortID(m_csToPortID);    // 中継された接続を探す
                                    if (csRlyTrn != null && csRlyTrn != csCnnction)
                                    {
                                        csRlyTrn.SetConnectionTranInfo(csTranInfo, this);
                                    }

                                }
                                McStructElement csInnerToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID); // 真の要素を探す
                                if (csInnerToElm != null)
                                {   // 真の要素があるならば
                                    csCnctPrpty.SetLowerElementModelInfor(csInnerToElm.GetModelInfo());
                                }
                            }
                        }   // end of if(csPort !=null)
                    }   // end of if (csToElm != null)else()
                }   // end of if (csCnctPrpty != null)
                McCellArrayTranInfoPropertyInfo csTrnPrpty = m_csTranDataInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                if (csTrnPrpty != null)
                {
                    csTrnPrpty.SetStructConnection(this);
                }
            }   // end of if (m_csTranDataInfo.GetPropertyInfo() != null)
        }
 
        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ情報解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CancelTranInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CancelTranInfo()
        {
            m_csTranDataInfo = new McModelInfo(new HySID(""), new HySObjectKind(""), new HySObjectKind(""), new HySString(""));
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データ情報取得（接続要素情報付き）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McModelInfo csModelInfo = GetTranInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>伝送データ情報（接続要素情報付き）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelInfo GetTranInfo()
        {
            McCellArrayTranInfoPropertyInfo csCellTranInfoProperty = m_csTranDataInfo.GetPropertyInfo()  as McCellArrayTranInfoPropertyInfo;

            McMutualTranInfoProperty csMutalTrnInfoPrpty = m_csTranDataInfo.GetPropertyInfo() as McMutualTranInfoProperty;
            //if(csMutalTrnInfoPrpty != null )
            //{
            //}
            //else 
            if ( csCellTranInfoProperty != null )
            {
                McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);
                //csFromElm = m_csOwnerGrElm.QueryElementByPort(m_csFromPortID);
                if (csFromElm != null)
                {
                    if (csFromElm is McStructGroupElement)
                    {
                        if (csFromElm == this.m_csOwnerGrElm)
                        {   // Grの外から流れ込む場合
                            csFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID);
                        }
                        else
                        {   // m_csOwnerGrElm　内にある　グループ要素からの受信
                            csFromElm = ((McStructGroupElement)csFromElm).QueryInternalElement(m_csFromPortID);
                        }
                        if (csFromElm != null)
                        {
                            csCellTranInfoProperty.SetUpperElementModelInfor(csFromElm.GetModelInfo());
                        }
                    }
                    else
                    {
                        csCellTranInfoProperty.SetUpperElementModelInfor(csFromElm.GetModelInfo());
                    }
                }
                else
                {
                    McStructPort csPort = m_csOwnerGrElm.GetPort(m_csFromPortID);
                    if (csPort != null)
                    {   // 中継端子を経由して外部と接続している（Grの外から流れ込む場合）
                        csFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID);
                        if (csFromElm != null)
                        {
                            csCellTranInfoProperty.SetUpperElementModelInfor(csFromElm.GetModelInfo());
                        }
                    }
                }

                McStructElement csToElm = m_csOwnerGrElm.GetElement(m_csToElmID);
                if (csToElm != null)
                {
                    if (csToElm is McStructGroupElement)
                    {
                        if (csToElm == this.m_csOwnerGrElm)
                        {   // Grの外へ流れ出す場合
                            csToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID);
                        }
                        else
                        {   // m_csOwnerGrElm　内にある　グループ要素へ送信
                            csToElm = ((McStructGroupElement)csToElm).QueryInternalElement(m_csToPortID);
                        }
                        if (csToElm != null)
                        {
                            csCellTranInfoProperty.SetLowerElementModelInfor(csToElm.GetModelInfo());
                        }
                    }
                    else
                    {
                        csCellTranInfoProperty.SetLowerElementModelInfor(csToElm.GetModelInfo());
                    }
                }
                else
                {   // 中継端子を経由して外部と接続している（Grの外へ流れ出す場合）
                    csToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID);
                    if (csToElm != null)
                    {
                        csCellTranInfoProperty.SetLowerElementModelInfor(csToElm.GetModelInfo());
                    }
                }

                //// パターン情報再設定
                //if (csCellTranInfoProperty.GetUpperConnectionPatternID().ToString() != "")
                //{
                //    csCellTranInfoProperty.SetUpperConnectionPatternID(csCellTranInfoProperty.GetUpperConnectionPatternID());
                //}
                //if (csCellTranInfoProperty.GetLowerConnectionPatternID().ToString() != "")
                //{
                //    csCellTranInfoProperty.SetLowerConnectionPatternID(csCellTranInfoProperty.GetLowerConnectionPatternID());
                //}
            }
            m_csTranDataInfo.SetUserName(m_sCnnctName);

            /*
            if (m_csOwnerGrElm != null)
            {
                McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);
                if (csFromElm != null)
                {
                    if (csFromElm is McStructGroupElement)
                    {
                        csFromElm = ((McStructGroupElement)csFromElm).QueryInternalElement(m_csFromPortID);
                        if (csFromElm != null)
                        {                            
                        }
                    }
                    else
                    {
                    }
                }
                else
                {
                }
            }
            */
            return m_csTranDataInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ情報取得（接続要素情報付き）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McModelInfo csModelInfo = GetTranInfo()</para>
        /// </example>
        /// <param name="bSW">必ず false</param>
        /// <returns>伝送データ情報（接続要素情報付き）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual McModelInfo GetTranInfo(bool bSW)
        {
            McCellArrayTranInfoPropertyInfo csCellTranInfoProperty = m_csTranDataInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
            if (csCellTranInfoProperty != null)
            {
                McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);
                //csFromElm = m_csOwnerGrElm.QueryElementByPort(m_csFromPortID);
                if (csFromElm != null)
                {
                    if (csFromElm is McStructGroupElement)
                    {
                        if (csFromElm == this.m_csOwnerGrElm)
                        {   // Grの外から流れ込む場合
                            csFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID);
                        }
                        else
                        {   // m_csOwnerGrElm　内にある　グループ要素からの受信
                            csFromElm = ((McStructGroupElement)csFromElm).QueryInternalElement(m_csFromPortID);
                        }
                        if (csFromElm != null)
                        {
                            csCellTranInfoProperty.SetUpperElementModelInfor(csFromElm.GetModelInfo(false));
                        }
                    }
                    else
                    {
                        csCellTranInfoProperty.SetUpperElementModelInfor(csFromElm.GetModelInfo(false));
                    }
                }
                else
                {
                    McStructPort csPort = m_csOwnerGrElm.GetPort(m_csFromPortID);
                    if (csPort != null)
                    {   // 中継端子を経由して外部と接続している（Grの外から流れ込む場合）
                        csFromElm = m_csOwnerGrElm.QueryExternalElement(m_csFromPortID);
                        if (csFromElm != null)
                        {
                            csCellTranInfoProperty.SetUpperElementModelInfor(csFromElm.GetModelInfo(false));
                        }
                    }
                }

                McStructElement csToElm = m_csOwnerGrElm.GetElement(m_csToElmID);
                if (csToElm != null)
                {
                    if (csToElm is McStructGroupElement)
                    {
                        if (csToElm == this.m_csOwnerGrElm)
                        {   // Grの外へ流れ出す場合
                            csToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID);
                        }
                        else
                        {   // m_csOwnerGrElm　内にある　グループ要素へ送信
                            csToElm = ((McStructGroupElement)csToElm).QueryInternalElement(m_csToPortID);
                        }
                        if (csToElm != null)
                        {
                            csCellTranInfoProperty.SetLowerElementModelInfor(csToElm.GetModelInfo(false));
                        }
                    }
                    else
                    {
                        csCellTranInfoProperty.SetLowerElementModelInfor(csToElm.GetModelInfo(false));
                    }
                }
                else
                {   // 中継端子を経由して外部と接続している（Grの外へ流れ出す場合）
                    csToElm = m_csOwnerGrElm.QueryExternalElement(m_csToPortID);
                    if (csToElm != null)
                    {
                        csCellTranInfoProperty.SetLowerElementModelInfor(csToElm.GetModelInfo(false));
                    }
                }

                // パターン情報再設定
                if (csCellTranInfoProperty.GetUpperConnectionPatternID().ToString() != "")
                {
                    csCellTranInfoProperty.SetUpperConnectionPatternID(csCellTranInfoProperty.GetUpperConnectionPatternID());
                }
                if (csCellTranInfoProperty.GetLowerConnectionPatternID().ToString() != "")
                {
                    csCellTranInfoProperty.SetLowerConnectionPatternID(csCellTranInfoProperty.GetLowerConnectionPatternID());
                }
            }
            m_csTranDataInfo.SetUserName(m_sCnnctName);
            return m_csTranDataInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ情報取得(但し、接続要素情報等は無し)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McModelInfo csModelInfo = GetConnectionTranInfoOnly()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>伝送データ情報（接続要素情報無し）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelInfo GetConnectionTranInfoOnly()
        {
            m_csTranDataInfo.SetUserName(m_sCnnctName);
            return m_csTranDataInfo;
        }

        //======================================
        // 構造定義ファイル入出力関連メソッド
        //======================================

        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル本体部入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadStructureBody( csXml , csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬル</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadStructureBody(HySXmlNode csXml, McModelFactorySet csMdlFctry)
        {
            // Connection生成時,接続線IDが上書きされてしまうため再設定
            string sID = csXml.GetAttribute(McDefine.xml_ID);
            if (sID != "")
            {
                m_csID = new HySID(sID);
            }

            string sLibraryID = csXml.GetAttribute(McDefine.xml_FACTORYID);
            string sTranInfo = csXml.GetAttribute(McDefine.xml_TRANINFO);

            HySID csLibID = new HySID(sLibraryID);
            HySObjectKind csTranInfoID = new HySObjectKind(sTranInfo);

            if (sLibraryID != string.Empty && sTranInfo != string.Empty)
            {
                McModelInfo csModelInfo = null;
                HySObjectKind csClassification = new HySObjectKind("");
                HySString csModelName = new HySString("");
                HySObjectKind csModelType = new HySObjectKind("");
                // モデル情報をモデルファクトリクラスより取得する
                HySDataLinkedList csModelInfoList = csMdlFctry.GetCalModelInfoList();
                for (long lLoop = 0; lLoop < csModelInfoList.GetCount(); lLoop++)
                {
                    csModelInfo = (McModelInfo)csModelInfoList.GetData(lLoop);
                    if (csLibID.Equals(csModelInfo.GetLibraryID()) == true &&
                        csTranInfoID.Equals(csModelInfo.GetModelKind()) == true)
                    {
                        csClassification = (HySObjectKind)csModelInfo.GetClassification();
                        csModelName = (HySString)csModelInfo.GetModelName();
                        csModelType = (HySObjectKind)csModelInfo.GetModelType();
                        break;
                    }
                }
                // モデル個別情報生成
                //m_csTranDataInfo = new McModelInfo(
                //                        csLibID,
                //                        csClassification,
                //                        csTranInfoID,
                //                        csModelName);
                m_csTranDataInfo = new McModelInfo(
                                        csLibID,
                                        csClassification,
                                        csTranInfoID,
                                        csModelName,
                                        csModelType);

                McPropertyInfoRoot csPropertyInf = csMdlFctry.CreateTranInfoPropertyInfo(csLibID, csTranInfoID);
                if (csPropertyInf != null)
                {
                    csPropertyInf.SetID((HySID)this.m_csID);                        // プロパティ情報に要素ＩＤをセット
                    m_csTranDataInfo.SetPropertyInfo(csPropertyInf);
                }

                McPropertyInfoRoot csInitialInf = csMdlFctry.CreateTranInfoInitialInfo(csLibID, csTranInfoID);
                if (csInitialInf != null)
                {
                    csInitialInf.SetID((HySID)this.m_csID);                        // 初期情報に要素ＩＤをセット
                    m_csTranDataInfo.SetInitialInfo(csInitialInf);
                }
                m_csTranDataInfo.SetElementID((HySID)this.m_csID);
            }


            string sName = csXml.GetAttribute(McDefine.xml_NAME);
            if (sName != "")
            {
                m_sCnnctName = new HySString(sName);
            }

            this.GetTranInfo(false);  //
            // プロパティ解読
            HySXmlNode csXmlPropertyNode;
            HySXmlNodeList csXmlPropertyList = csXml.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
            long lPropertyNum = csXmlPropertyList.GetCount(); // 通常は１個
            for (long lLp = 0; lLp < lPropertyNum; lLp++)
            {
                csXmlPropertyNode = csXmlPropertyList.GetNode(lLp);
                // プロパティ情報ノード読み出し

                // プロパティタグ内容を読み出す
                McPropertyInfoRoot csPrpytInf = m_csTranDataInfo.GetPropertyInfo();
                if (csPrpytInf != null)
                {   // プロパティ情報有り
                    McCellArrayTranInfoPropertyInfo csTrnPrpty = csPrpytInf as McCellArrayTranInfoPropertyInfo;
                    if (csTrnPrpty != null)
                    {
                        csTrnPrpty.SetStructConnection(this);
                    }

                    if (csXmlPropertyNode != null)
                    {   // XML情報あり
                        csPrpytInf.XmlIN(csXmlPropertyNode);
                    }
                }
            }

            // Gr内外の接続線に対して、プロパティ情報の設定
            this.SetTranInfoPropertyInfo(m_csTranDataInfo.GetPropertyInfo(), null);

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル本体部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteStructureBody( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode WriteStructureBody(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            // Connectionタグ
            csRtnNode = HySXmlNode.CreateElement(McDefine.xml_CONNECTION, csXmlWriter);
            csRtnNode.SetAttribute(McDefine.xml_ID, m_csID.GetString().ToString());
            csRtnNode.SetAttribute(McDefine.xml_FROM, (m_csFromPortID.GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_TO, (m_csToPortID.GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_TRANINFO, ((m_csTranDataInfo.GetModelKind()).GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_FACTORYID, ((m_csTranDataInfo.GetLibraryID()).GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_NAME, this.GetConnectionName().ToString());

            //if (McPropertyInfoRoot.GetXmlOutFlg() == true)
            //if (McPropertyInfoBase.GetXmlOutFlg() == true)
            if (McPropertyInfoBase.GetXmlOutFlg() != McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART)
            {   // プロパティ情報出力必要ならば
                HySXmlNode csNode = null;
                // プロパティ情報ノード書き込み
                McPropertyInfoRoot csPrpytInf = m_csTranDataInfo.GetPropertyInfo();
                if (csPrpytInf != null)
                {   // プロパティ情報有り
                    csNode = csPrpytInf.XmlOUT(ref csXmlWriter);
                    if (csNode != null)
                    {
                        csRtnNode.AppendChild(csNode);
                    }
                }
            }
            return csRtnNode;
        }


        /// <summary><para>method outline:</para>
        /// <para>全削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Free()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void Free()
        {
            m_csID = null;
            m_csFromPortID = null;
            m_csToPortID = null;
            m_csFromElmID = null;
            m_csToElmID = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CopyInf(csOrgCnnct)</para>
        /// </example>
        /// <param name="csOrgCnnct">コピー元</param>
        /// <returns>=true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CopyInf(McStructConnection csOrgCnnct)
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>一貫番号取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ulong ulRtn = GetPrimNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>一貫番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public ulong GetPrimNo()
        {
            return m_ulPrimNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部に含まれる部品のIDを変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeID(csUpperCnnction) </para>
        /// </example>
        /// <param name="csUpperCnnction">Grの外からの接続：再帰的制御用</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ポートのID含む</para>
        /// </remarks>
        internal virtual HySID ChangeID(McStructConnection csUpperCnnction)
        {
            HySIdentifier csOrgFromElmID = m_csFromElmID;
            HySIdentifier csOrgToElmID = m_csToElmID;
            HySIdentifier csOrgFromPortID = m_csFromPortID;
            HySIdentifier csOrgToPortID = m_csToPortID;

            //HySIdentifier csNewFromElmID = m_csFromElmID;
            //HySIdentifier csNewToElmID = m_csToElmID;
            //HySIdentifier csNewFromPortID = m_csFromPortID;
            //HySIdentifier csNewToPortID = m_csToPortID;
            
            // 要素、ポートインスタンスの取得と各インスタンスのID変更
            McStructElement csFromElm = m_csOwnerGrElm.GetElement(m_csFromElmID);
            McStructElement csToElm = m_csOwnerGrElm.GetElement(m_csToElmID);
            McStructPort csFromPort =null;
            if( csFromElm != null )
            {
                csFromPort= csFromElm.GetPort(m_csFromPortID);
                if (csFromPort != null)
                {
                    m_csFromPortID = csFromPort.ChangeID();
                }
                //m_csFromElmID = csFromElm.ChangeID();
            }
            McStructPort csToPort =null;
            if( csToElm != null )
            {
                csToPort = csToElm.GetPort(m_csToPortID);
                if (csToPort != null)
                {
                    m_csToPortID = csToPort.ChangeID();
                }
                //m_csToElmID = csToElm.ChangeID();
            }

            // インスタンスの状態から　接続状態を知る
            // 受信側
            if (csFromElm != null)
            {
                if (csFromElm is McStructGroupElement)
                {
                    if (csFromElm == this.m_csOwnerGrElm)
                    {   // Grの外から流れ込む場合
                        // Do Nothing
                    }
                    else
                    {   // m_csOwnerGrElm内にある　グループ要素からの受信
                        McStructConnection csLowerCnnction = ((McStructGroupElement)csFromElm).QueryConnectionByPortID(csOrgFromPortID);
                        if (csLowerCnnction != null)
                        {
                            csLowerCnnction.ChangeID(this); // 下位のGr内流入接続に対するID変更指示
                        }
                    }
                }
                else
                {   // 通常要素接続
                    // Do Nothing
                }
            }
            else
            {   // Gr化要素のポートの場合
                //McStructPort csPort = m_csOwnerGrElm.GetPort(csOrgFromPortID);
                //if (csPort != null)
                //{   // 中継端子を経由して外部と接続している（Grの外から流れ込む場合）
                //    //　上位からの接続は　この処理プロック部分では考慮しない
                //}
            }          
            // 送信側
            if (csToElm != null)
            {
                if (csToElm is McStructGroupElement)
                {
                    if (csToElm == this.m_csOwnerGrElm)
                    {   // Grの外へ流れ出す場合
                        // Do Nothing
                    }
                    else
                    {   // m_csOwnerGrElm　内にある　グループ要素へ送信
                        McStructConnection csLowerCnnction = ((McStructGroupElement)csToElm).QueryConnectionByPortID(csOrgToPortID);
                        if (csLowerCnnction != null)
                        {
                            csLowerCnnction.ChangeID(this); // 下位のGr内流入接続に対するID変更指示
                        }
                    }
                }
                else
                {   // 通常要素接続
                    // Do Nothing
                }
            }
            else
            {   // 中継端子を経由して外部と接続している（Grの外へ流れ出す場合）
                //McStructPort csPort = m_csOwnerGrElm.GetPort(csOrgToPortID);
                //if (csPort != null)
                //{   // 中継端子を経由して外部と接続している（Grのへ流れ出す流れ込む場合）
                //    //　上位からの接続は　この処理プロック部分では考慮しない
                //}
            }

            if (csUpperCnnction != null)
            {   // Gr外の接続がある場合
                // Gr化要素のポートの場合
                //McStructPort csPort = m_csOwnerGrElm.GetPort(csOrgFromPortID);
                McStructPort csPort = m_csOwnerGrElm.GetPort(csUpperCnnction.m_csToPortID);
                if (csPort != null)
                {   // 中継端子を経由して外部と接続している（Grの外から流れ込む場合）
                    //csPort.SetID(csUpperCnnction.m_csToPortID);
                    m_csFromPortID = csUpperCnnction.m_csToPortID;
                }
                // 中継端子を経由して外部と接続している（Grの外へ流れ出す場合）
                csPort = m_csOwnerGrElm.GetPort(csUpperCnnction.m_csFromPortID);
                if (csPort != null)
                {   // 中継端子を経由して外部と接続している（Grのへ流れ出す流れ込む場合）
                    //csPort.SetID(csUpperCnnction.m_csToPortID);
                    m_csToPortID = csUpperCnnction.m_csFromPortID;
                }
                this.SetConnection(m_csFromElmID, m_csFromPortID, m_csToElmID, m_csToPortID);
            }

            //this.SetConnection(m_csFromElmID, m_csFromPortID, m_csToElmID, m_csToPortID); << 不用

            // 自身のID設定
            McStructConnection.m_ulPrimNo += 1;

            string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString()
                + "-" + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();

            //m_csID = new HySID("C" + m_ulPrimNo.ToString() + DateTime.Now.Second.ToString() + "-", ((long)McDefine.SymbolDrawKind.HYM_LINE).ToString(), sStr);
            m_csID = new HySID("C" + m_ulPrimNo.ToString() + DateTime.Now.Second.ToString() + "-" 
                               + ((long)McDefine.SymbolDrawKind.HYM_LINE).ToString() + sStr);

            return m_csID as HySID;
        }


        // ================================================
        //   Undo/Redo用処理
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructConnection csStructPort = CopyInfUsedByUndoRedoOnly(csCopyElement)</para>
        /// </example>
        /// <param name="csCopyElement">複製要素</param>
        /// <returns>McStructConnection 複製要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public virtual McStructConnection CopyInfUsedByUndoRedoOnly(McStructConnection csCopyElement)
        {
            if (csCopyElement == null)
            {
                csCopyElement = new McStructConnection();
            }

            McStructConnection.m_ulPrimNo -= 1;

            csCopyElement.m_csID = m_csID;
            csCopyElement.m_csFromPortID = m_csFromPortID;
            csCopyElement.m_csToPortID = m_csToPortID;
            csCopyElement.m_csFromElmID = m_csFromElmID;
            csCopyElement.m_csToElmID = m_csToElmID;
            csCopyElement.m_sCnnctName = m_sCnnctName;
            csCopyElement.m_csOwnerGrElm = m_csOwnerGrElm;
            csCopyElement.m_csTranDataInfo = m_csTranDataInfo.Clone();

            return csCopyElement;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            // ﾒﾝﾊﾞｰ：McCellArrayTranInfoPropertyInfo内のシリアライズ対象外のインスタンスを設定する
            if (m_csTranDataInfo != null)
            {
                McCellArrayTranInfoPropertyInfo csTrnPrpty = m_csTranDataInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                if (csTrnPrpty != null)
                {
                    csTrnPrpty.SetStructConnection(this);
                }
            }


            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();//復元後の整合性確保処理
        }
    }
}
