﻿// <summary>ソースコード：接続構造グループ要素</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Model;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary><para>class outline:</para>
    /// <para>接続構造グループ要素クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/11/17][新規作成]
    /// [CommonMP][ver 1.2.0][2011/11/10][レコード数最適化処理追加]
    /// </para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McStructGroupElement : McStructElement, HySVersionManagement //IDeserializationCallback
    {
        ///// <summary> 中継端子（送信）ＩＤ種別 </summary>
        //static protected readonly string RELAY_SEND = "Rly:Snd";
        ///// <summary> 中継端子（受信）ＩＤ種別 </summary>
        //static protected readonly string RELAY_RECEIVE = "Rly:Rcv";


        /// <summary>要素リスト</summary>
        protected HySDataLinkedList m_csElmList = new HySDataLinkedList();
        /// <summary>接続線リスト</summary>
        protected HySDataLinkedList m_csConnectionList = new HySDataLinkedList();
        ///// <summary> グループ外への中継接続端子リスト </summary>  <-- 親クラスの m_csPortList を使用する
        // protected HySDataLinkedList m_csExternalPortList = new HySDataLinkedList();

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructGroupElement csElm = new McStructGroupElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructGroupElement() : base(McDefine.SymbolDrawKind.HYM_GROUP)
        {
            string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString()
                            + "-" + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
            //m_csID = new HySID("G" + m_ulPrimElm.ToString() + DateTime.Now.Second.ToString() + "-",
            //                    ((long)(McDefine.SymbolDrawKind.HYM_GROUP)).ToString(), sStr);
            m_csID = new HySID("G" + m_ulPrimElm.ToString() + DateTime.Now.Second.ToString() + "-" +
                    ((long)(McDefine.SymbolDrawKind.HYM_GROUP)).ToString() + sStr);

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>シンボル描画種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSymbolDrawKind(eKind)</para>
        /// </example>
        /// <param name="eKind">シンボル描画種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSymbolDrawKind(McDefine.SymbolDrawKind eKind)
        {
            m_eDrawKind = eKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>要素識別子によって要素を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = GetElementByID(csElmID)</para>
        /// </example>
        /// <param name="csElmID">要素識別子</param>
        /// <returns>要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructElement GetElementByID(HySID csElmID)
        {
            McStructElement csRtn = null;
            McStructElement csElm = null;  // 要素
            long lNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lP = 0; lP < lNum; lP++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();
                if (csElm.Equal(csElmID) == true)
                {
                    csRtn = csElm;
                    break;
                }
                else
                {
                    if (csElm is McStructGroupElement)
                    {
                        csRtn = ((McStructGroupElement)csElm).GetElementByID(csElmID);
                        if (csRtn != null)
                        {
                            break;
                        }
                    }
                }

                m_csElmList.MoveCursorNext();
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ユーザー定義要素名称によって要素を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = GetElementByUserName(csUserElmName)</para>
        /// </example>
        /// <param name="csUserElmName">ユーザー定義要素名称</param>
        /// <returns>要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructElement GetElementByUserName(HySString csUserElmName)
        {
            McStructElement csRtn = null;
            if ((object)csUserElmName != null)
            {
                if (csUserElmName.ToString() != "")
                {
                    McStructElement csElm = null;  // 要素
                    McModelInfo csMdlInf = null;
                    HySString csUserName = null;
                    long lNum = m_csElmList.GetCount();
                    m_csElmList.SetCursorFirst();
                    for (long lP = 0; lP < lNum; lP++)
                    {
                        csElm = (McStructElement)m_csElmList.GetCursorData();
                        csMdlInf = csElm.GetModelInfo();
                        if (csMdlInf != null)
                        {
                            csUserName = csMdlInf.GetUserName();
                            if ((object)csUserName != null)
                            {
                                if (csUserElmName.Equal(csMdlInf.GetUserName()) == true)
                                {
                                    csRtn = csElm;
                                    break;
                                }
                            }
                        }
                        if (csElm is McStructGroupElement)
                        {
                            csRtn = ((McStructGroupElement)csElm).GetElementByUserName(csUserElmName);
                            if (csRtn != null)
                            {
                                break;
                            }
                        }

                        m_csElmList.MoveCursorNext();
                    }
                }
            }
            return csRtn;
        }
        //======================================
        // 内部エレメント関連メソッド
        //======================================
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = GetElmCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>グループ内の要素数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long GetElmCount()
        {
            return m_csElmList.GetCount();
        }

        /// <summary><para>method outline:</para>
        /// <para>要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = GetElement(lPos)</para>
        /// </example>
        /// <param name="lPos">位置(0相対)</param>
        /// <returns>要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructElement GetElement(long lPos)
        {
            return (McStructElement)m_csElmList.GetData(lPos);
        }
        /// <summary><para>method outline:</para>
        /// <para>要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = GetElement(csElmID)</para>
        /// </example>
        /// <param name="csElmID">要素識別子</param>
        /// <returns>要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructElement GetElement(HySIdentifier csElmID)
        {
            McStructElement csRtn=null;
            McStructElement csElm = null;  // 要素
            long lNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lP = 0; lP < lNum; lP++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();
                if (csElm.Equal(csElmID) == true)
                {
                    csRtn = csElm;
                    break;
                }
                /*
                else
                {
                    if (csElm is McStructGroupElement)
                    {
                        csRtn = ((McStructGroupElement)csElm).GetElement(csElmID);
                        if (csRtn != null)
                        {
                            break;
                        }
                    }
                }
                */
                m_csElmList.MoveCursorNext();
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定端子を持っている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = QueryElementByPort(csPortID)</para>
        /// </example>
        /// <param name="csPortID">端子識別子</param>
        /// <returns>要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McStructElement QueryElementByPort(HySIdentifier csPortID)
        {
            McStructElement csRtn = null;
            McStructElement csElm = null;  // 要素
            long lNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lP = 0; lP < lNum; lP++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();
                if (csElm.GetPort(csPortID) != null)
                {
                    csRtn = csElm;
                    break;
                }
                m_csElmList.MoveCursorNext();
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定接続端子を経由して接続されている自グループ外に存在する真の要素を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = QueryExternalElement(csPortID)</para>
        /// </example>
        /// <param name="csTranPortID">接続端子識別子</param>
        /// <returns>McStructElement 外部要素
        /// 中継端子が　外部と接続していなければ　null が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>外部要素がさらにグループ化要素ならばその内部も探索する</para>
        /// </remarks>
        virtual internal McStructElement QueryExternalElement(HySIdentifier csTranPortID)
        {
            McStructElement csRtn = null;

            McStructElement csFromElm = null;
            McStructElement csToElm = null;
            McStructTransPort csTranPort = this.GetPort(csTranPortID) as McStructTransPort;
            if( csTranPort == null ){  return csRtn;  }

            // 中継端子が接続している内向けのポートIDを取得する
            HySIdentifier csInnerFromPortID = new HySID("");
            HySIdentifier csInnerToPortID = new HySID("");
            csTranPort.GetInnerPortID(ref csInnerFromPortID, ref csInnerToPortID);
            // 中継端子が接続している外向けのポートIDを取得する
            HySIdentifier csOuterFromPortID = new HySID("");
            HySIdentifier csOuterToPortID = new HySID("");
            csTranPort.GetPortID(ref csOuterFromPortID, ref csOuterToPortID);

            McStructTranINPort csInTranPort = csTranPort as McStructTranINPort;
            McStructTranOUTPort csOutTranPort = csTranPort as McStructTranOUTPort;

            if (csInTranPort != null)
            {   // 外部からの流入の場合
                if( m_csOwnerGrElm == null){  return csRtn;  }
                csFromElm = m_csOwnerGrElm.QueryElementByPort(csOuterFromPortID);
                if (csFromElm == null)
                {
                    McStructPort csPort = m_csOwnerGrElm.GetPort(csOuterFromPortID);
                    if (csPort != null)
                    {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外から流れ込む場合）
                        csRtn = m_csOwnerGrElm.QueryExternalElement(csOuterFromPortID);
                    }
                }
                else
                {
                    if (csFromElm is McStructGroupElement)
                    {   // 上位グループ内に存在している　グループ化要素に接続
                        csRtn = ((McStructGroupElement)csFromElm).QueryInternalElement(csOuterFromPortID);
                    }
                    else
                    {   // 上位グループ内に存在している　通常の要素に接続
                        csRtn = csFromElm;
                    }
                }
            }
            if (csOutTranPort != null)
            {   // 外部への流出の場合
                if (m_csOwnerGrElm == null) { return csRtn; }
                csToElm = m_csOwnerGrElm.QueryElementByPort(csOuterToPortID);
                if (csToElm == null)
                {
                    McStructPort csPort = m_csOwnerGrElm.GetPort(csOuterToPortID);
                    if (csPort != null)
                    {   // 中継端子を経由して上位グループの更に外部と接続している（Grの外へ流れ出す場合）
                        csRtn = m_csOwnerGrElm.QueryExternalElement(csOuterToPortID);
                    }
                }
                else
                {
                    if (csToElm is McStructGroupElement)
                    {   // 上位グループ内に存在している　グループ化要素に接続
                        csRtn = ((McStructGroupElement)csToElm).QueryInternalElement(csOuterToPortID);
                    }
                    else
                    {   // 上位グループ内に存在している　通常の要素に接続
                        csRtn = csToElm;
                    }
                }
            }

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定接続端子を経由して接続されているグループの内部にある真の要素を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = QueryInternalElement(csPortID)</para>
        /// </example>
        /// <param name="csTranPortID">接続端子識別子</param>
        /// <returns>McStructElement 外部要素
        /// 中継端子が　内部で要素と接続していなければ　null が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>内部要素がさらにグループ化要素ならばその内部も探索する</para>
        /// </remarks>
        virtual internal McStructElement QueryInternalElement(HySIdentifier csTranPortID)
        {
            McStructElement csRtn = null;

            McStructElement csFromElm = null;
            McStructElement csToElm = null;
            McStructTransPort csTranPort = this.GetPort(csTranPortID) as McStructTransPort;
            if (csTranPort == null) { return csRtn; }

            // 中継端子が接続している内向けのポートIDを取得する
            HySIdentifier csInnerFromPortID = new HySID("");
            HySIdentifier csInnerToPortID = new HySID("");
            csTranPort.GetInnerPortID(ref csInnerFromPortID, ref csInnerToPortID);
            // 中継端子が接続している外向けのポートIDを取得する
            HySIdentifier csOuterFromPortID = new HySID("");
            HySIdentifier csOuterToPortID = new HySID("");
            csTranPort.GetPortID(ref csOuterFromPortID, ref csOuterToPortID);

            McStructTranINPort csInTranPort = csTranPort as McStructTranINPort;
            McStructTranOUTPort csOutTranPort = csTranPort as McStructTranOUTPort;

            if (csInTranPort != null)
            {   // 外部からの流入の場合
                csToElm = this.QueryElementByPort(csInnerToPortID);  // 自Gr内の要素検索
                if (csToElm == null)
                {   // 接続先がない
                }
                else
                {
                    if (csToElm is McStructGroupElement)
                    {   // 自グループ内に存在している　グループ化要素に接続
                        csRtn = ((McStructGroupElement)csToElm).QueryInternalElement(csInnerToPortID);
                    }
                    else
                    {   // 自グループ内に存在している　通常の要素に接続
                        csRtn = csToElm;
                    }
                }
            }
            if (csOutTranPort != null)
            {   // 外部への流出の場合
                csFromElm = this.QueryElementByPort(csInnerFromPortID);  // 自Gr内の要素検索
                if (csFromElm == null)
                {   // 接続先がない
                }
                else
                {
                    if (csFromElm is McStructGroupElement)
                    {   // 自グループ内に存在している　グループ化要素に接続
                        csRtn = ((McStructGroupElement)csFromElm).QueryInternalElement(csInnerFromPortID);
                    }
                    else
                    {   // 自グループ内に存在している　通常の要素に接続
                        csRtn = csFromElm;
                    }
                }
            }

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>要素追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = AddElement( csElm )</para>
        /// </example>
        /// <param name="csElm">グループ構成要素</param>
        /// <returns>long 0:成功，-1:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long AddElement(McStructElement csElm)
        {
            if (csElm == null)
            {// パラメータ異常
                return -1L;
            }

            csElm.SetOwnerElement(this);

            m_csElmList.AddLast(csElm);
            return 0L;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructElement csStructElement = AddElement(eKind, csElementKind)</para>
        /// </example>
        /// <param name="eKind">シンボル描画種別</param>
        /// <param name="csElementKind">描画オブジェクト区分</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructElement AddElement(McDefine.SymbolDrawKind eKind, HySObjectKind csElementKind)
        {
            McStructElement csNewElm = McStructElement.CreateNewElement(eKind, csElementKind,this);  // 要素生成
            this.AddElement(csNewElm);
            return csNewElm;
        }
        /*
        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructElement newObj = CreateNewElement(eKind,csElementKind)</para>
        /// </example>
        /// <param name="eKind">要素種別</param>
        /// <param name="csElementKind">オブジェクト区分</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McStructElement CreateNewElement(McDefine.SymbolDrawKind eKind, HySObjectKind csElementKind)
        {
                     
            McStructElement csNewElm = null;  // 画面表示要素

            if (eKind == McDefine.SymbolDrawKind.HYM_GROUP || eKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
            {// グループ
                csNewElm = new McStructGroupElement();
                ((McStructGroupElement)csNewElm).SetSymbolDrawKind(eKind);

                // グルー化要素のプロパティを仮設定
                McModelInfo　csGrModelInfo = null;
                if (eKind == McDefine.SymbolDrawKind.HYM_GROUP)
                {
                    csGrModelInfo = new McModelInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, new HySObjectKind(""),
                            McModelLibraryDefine.HYM_MODEL_SUBSYSTEM, McModelLibraryDefine.MODEL_NAME_SUBSYSTEM);
                    csNewElm.SetModelInfo(csGrModelInfo);
                }
                //else if (eKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
                //{
                //    csGrModelInfo = new McModelInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, new HySObjectKind(""),
                //            McModelLibraryDefine.HYM_MODEL_CONVERGENCE_ITERATION, McModelLibraryDefine.MODEL_NAME_CONVERGENCE_ITERATION);
                //}
            }
            else
            {// グループ以外
                csNewElm = new McStructElement(eKind);
            }
            csNewElm.SetDrawSubKind(csElementKind);
            return csNewElm;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>要素取り外し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csRemoveElement = RemoveGroup(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>McStructElement !=null:取り外した要素，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructElement RemoveElement(HySIdentifier csID)
        {
            McStructElement csRtnElm = null;      // 画面表示要素

            if (csID == null)
            {// パラメータ異常
                return csRtnElm;
            }

            McStructElement csElm = null;      // 画面表示要素
            long lElmNum = m_csElmList.GetCount();                      // ループカウンタ
            m_csElmList.SetCursorFirst();
            for (long lLp = 0; lLp < lElmNum; lLp++)
            {// 要素を検索
                csElm = (McStructElement)m_csElmList.GetCursorData();
                //csElm = (McViewerElement)m_csElmList.GetData(lLp);
                if (csElm.Equal(csID) != false)
                {// IDが一致
                    csRtnElm = (McStructElement)m_csElmList.RemoveData(lLp);
                    break;
                }
                m_csElmList.MoveCursorNext();
            }

            // 取り外した要素に関連する接続を　無くする
            if (csRtnElm != null)
            {   // 取り外しエレメントが存在するならば
                McStructConnection csCnnct = null;
                for (long lLp = 0; lLp < 9999999; lLp++)
                {
                    // 要素関連接続を検索
                    csCnnct = this.QueryConnectionByElmentID(csRtnElm.GetID());
                    if (csCnnct != null)
                    {   // 接続が存在すればそれを削除する
                        this.DeleteConnection(csCnnct.GetID());
                    }
                    else
                    {
                        break;
                    }
                }
            }

            return csRtnElm;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>指定要素に関連する端子接続情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csCnct = QueryConnectionByElmentID(csElmID)</para>
        /// </example>
        /// <param name="csElmID">要素ID</param>
        /// <returns>接続情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>特殊用途のみに使用するため、一般からは使用禁止
        /// 指定要素に関連する接続は複数あるが、本メソッドでは、最初にヒットしたもののみ返す
        /// RemoveElement() メソッド内でのみ使用する
        /// </para>
        /// </remarks>
        virtual protected McStructConnection QueryConnectionByElmentID(HySIdentifier csElmID)
        {
            McStructConnection csRtnConnection = null;  // 接続要素

            HySIdentifier csFromElmID = new HySID("");
            HySIdentifier csToElmID = new HySID("");

            McStructConnection csConnection = null;
            long lNum = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {// 要素を検索
                csConnection = (McStructConnection)m_csConnectionList.GetCursorData();
                csConnection.GetConnectionElement(ref csFromElmID, ref csToElmID);
                if (csElmID.Equals(csFromElmID) == true ||
                    csElmID.Equals(csToElmID) == true)
                {
                    csRtnConnection = csConnection;
                    break;
                }
                m_csConnectionList.MoveCursorNext();
            }
            return csRtnConnection;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素リストを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csElementList = GetElementList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal HySDataLinkedList GetElementList()
        {
            return m_csElmList;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素の持つ端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructPort csPort = GetInternalElmentsPort(csPortID)</para>
        /// </example>
        /// <param name="csPortID">端子ID</param>
        /// <returns>端子インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McStructPort GetInternalElmentsPort(HySIdentifier csPortID)
        {
            McStructPort csRtnPort = null;  // リターン端子
            McStructPort csPort = null; // 端子
            McStructElement csElm = null;  // 要素
            long lNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lP = 0; lP < lNum; lP++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();
                csPort = csElm.GetPort(csPortID);
                if (csPort !=null )
                {
                    csRtnPort = csPort;
                    break;
                }
                m_csElmList.MoveCursorNext();
            }
            return csRtnPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>グループ内要素のリスト順変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ElmentsListShuffle(csShuffleList)</para>
        /// </example>
        /// <param name="csShuffleList">変更順リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ElmentsListShuffle(HySDataLinkedList csShuffleList)
        {
            HySDataLinkedList csTempElmList = new HySDataLinkedList();
            McStructElement csElm = null;      // 画面表示要素
            for (long lLp1 = 0; lLp1 < csShuffleList.GetCount(); lLp1++)
            {
                HySString csTargetElmID = (HySString)csShuffleList.GetData(lLp1);
                for (long lLp2 = 0; lLp2 < m_csElmList.GetCount(); lLp2++)
                {// 要素を検索
                    csElm = (McStructElement)m_csElmList.GetData(lLp2);
                    if (csElm.GetID().ToString() == csTargetElmID.ToString())
                    {// IDが一致
                        csTempElmList.AddLast(m_csElmList.RemoveData(lLp2));
                        break;
                    }
                }
            }
            for (long lLp1 = csTempElmList.GetCount() - 1; lLp1 >= 0; lLp1--)
            {
                csElm = (McStructElement)csTempElmList.GetData(lLp1);
                m_csElmList.AddFirst(csElm);
            }
        }

        //======================================
        // 接続関連メソッド
        //======================================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グループ内要素接続生成（外部中継端子は除く）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csCnct = AddInternalConnection(csCnctID, csFromElmID, csFromPortID, csToElmID, csToPortID)</para>
        /// </example>
        /// <param name="csCnctID">ID</param>
        /// <param name="csFromElmID">接続元要素識別子</param>
        /// <param name="csFromPortID">接続元ポート識別子</param>
        /// <param name="csToElmID">接続先要素識別子</param>
        /// <param name="csToPortID">接続先ポート識別子</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>新規に接続生成する場合のみ使用可能
        /// 外部中継端子と接続するときは　AddExternalINConnection、AddExternalOUTConnectionを使用する
        /// </para>
        /// </remarks>
        virtual public McStructConnection AddInternalConnection(HySIdentifier csCnctID, HySIdentifier csFromElmID, HySIdentifier csFromPortID, HySIdentifier csToElmID, HySIdentifier csToPortID)
        {
            McStructConnection csNewCnct = null;

            McStructElement csFromElm = this.GetElement(csFromElmID);
            McStructElement csToElm = this.GetElement(csToElmID);

            if (csFromElm != null && csToElm != null)
            {   // 内部に接続する要素がいれば

                csNewCnct = this.CreateConnection(csCnctID, csFromElmID, csFromPortID, csToElmID, csToPortID);  // コネクションの作成
                this.m_csConnectionList.AddLast(csNewCnct);

                McStructPort csNewPort = null;
                McStructPort csFrmPort = null;
                McStructPort csToPort = null;

                // 接続元側端子設定
                csNewPort = csFromElm.GetPort(csFromPortID);
                McStructGroupElement csGrFromElm = csFromElm as McStructGroupElement;
                if (csGrFromElm == null)
                {   // 通常の要素ならば    
                    if (csNewPort == null)
                    {   // 未だ端子設定無し
                        csNewPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_SEND);
                        csFromElm.AddPort(csNewPort);
                    }
                }
                else
                {   // グループ要素ならば
                    if (csNewPort == null)
                    {   // 未だ端子設定無し
                        csNewPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_TRANS_OUT);
                        csFromElm.AddPort(csNewPort);
                    }
                }
                if (csFromPortID.ToString() != "")
                {
                    csNewPort.SetID(csFromPortID);
                }
                //csNewPort.SetPortID(csFromPortID, csToPortID);
                csNewPort.SetElmID(csFromElmID);
                csFrmPort = csNewPort;

                // 接続先側端子設定
                csNewPort = csToElm.GetPort(csToPortID);
                McStructGroupElement csGrToElm = csToElm as McStructGroupElement;
                if (csGrToElm == null)
                {   // 通常の要素ならば
                    if (csNewPort == null)
                    {   // 未だ端子設定無し
                        csNewPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_RECEIVE);
                        csToElm.AddPort(csNewPort);
                    }
                }
                else
                {   // グループ要素ならば
                    if (csNewPort == null)
                    {
                        csNewPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_TRANS_IN);
                        csToElm.AddPort(csNewPort);
                    }
                }
                if (csToPortID.ToString() != "")
                {
                    csNewPort.SetID(csToPortID);
                }
                //csNewPort.SetPortID(csFromPortID, csToPortID);
                csNewPort.SetElmID(csToElmID);
                csToPort = csNewPort;

                csFrmPort.SetPortID(csFrmPort.GetID(), csToPort.GetID());
                csToPort.SetPortID(csFrmPort.GetID(), csToPort.GetID());
                csNewCnct.SetConnection(csFromElmID, csFrmPort.GetID(), csToElmID, csToPort.GetID());


//                McStructElement csFrmStrElm = this.GetElement(csFromElmID);
//                McStructElement csToStrElm = this.GetElement(csToElmID);
//                csNewCnct.SetElementAndPortInstance(csFrmStrElm, csFrmPort, csToStrElm, csToPort);
            }
            return csNewCnct;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csNewCnnct = CreateConnection(csCnctID, csFromElmID, csFromPortID, csToElmID, csToPortID)</para>
        /// </example>
        /// <param name="csCnctID">ID</param>
        /// <param name="csFromElmID">接続元要素識別子</param>
        /// <param name="csFromPortID">接続元ポート識別子</param>
        /// <param name="csToElmID">接続先要素識別子</param>
        /// <param name="csToPortID">接続先ポート識別子</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>新規に接続生成するのみ、端子整合性等は、外部で設定</para>
        /// </remarks>
        virtual protected McStructConnection CreateConnection(HySIdentifier csCnctID, HySIdentifier csFromElmID, HySIdentifier csFromPortID, HySIdentifier csToElmID, HySIdentifier csToPortID)
        {
            McStructConnection csNewCnct = null;  // 接続情報
            if (csCnctID == null || csFromElmID == null || csToElmID == null)
            {// パラメータ異常
                return csNewCnct;
            }

            csNewCnct = new McStructConnection(csCnctID);
            //csNewCnct.SetID(csID);
            csNewCnct.SetConnection(csFromElmID, csFromPortID, csToElmID, csToPortID);

            //m_csConnectionList.AddLast(csNewCnct); <-- 外部で行う
            csNewCnct.SetOwnerElement(this);

            return csNewCnct;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示端子接続情報数取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = GetConnectionCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面表示端子接続情報数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long GetConnectionCount()
        {
            return m_csConnectionList.GetCount();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示端子接続情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csStructConnection = GetConnection(lPos)</para>
        /// </example>
        /// <param name="lPos">位置(0相対)</param>
        /// <returns>画面表示端子接続情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructConnection GetConnection(long lPos)
        {
            return (McStructConnection)m_csConnectionList.GetData(lPos);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>指定端子に関連する端子接続情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csCnct = QueryConnectionByPortID(csPortID)</para>
        /// </example>
        /// <param name="csPortID">端子ID</param>
        /// <returns>接続情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal McStructConnection QueryConnectionByPortID(HySIdentifier csPortID)
        {
            McStructConnection csRtnConnection = null;  // 接続要素

            HySIdentifier csFromPortID = new HySID("");
            HySIdentifier csToPortID = new HySID("");

            McStructConnection csConnection = null;
            long lNum = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {// 要素を検索
                csConnection = (McStructConnection)m_csConnectionList.GetCursorData();
                csConnection.GetConnectionPort(ref csFromPortID, ref csToPortID);
                if (csPortID.Equals(csFromPortID) == true ||
                    csPortID.Equals(csToPortID) == true)
                {
                    csRtnConnection = csConnection;
                    break;
                }
                m_csConnectionList.MoveCursorNext();
            }
            return csRtnConnection;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続線破棄</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csStructConnection = DeleteConnection(csCnntID)</para>
        /// </example>
        /// <param name="csCnntID">接続線ID</param>
        /// <returns>破棄した接続線</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructConnection DeleteConnection(HySIdentifier csCnntID)
        {
            McStructConnection csRtnConnection = null;  // 接続要素
            if (csCnntID == null)
            {// パラメータ異常
                return csRtnConnection;
            }
            McStructConnection csConnection = null; 
            long lNum = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp< lNum; lLp++)
            {// 要素を検索
                csConnection = (McStructConnection)m_csConnectionList.GetCursorData();
                if (csConnection.Equal(csCnntID) != false)
                {   // IDが一致
                    csRtnConnection = csConnection;
                    m_csConnectionList.RemoveData(lLp);
                    break;
                }
                m_csConnectionList.MoveCursorNext();
            }

            if (csRtnConnection != null)
            {
                // 削除する接続に関連する要素の端子を無くする
                HySIdentifier csFromElmID = new HySID("");
                HySIdentifier csToElmID = new HySID("");
                HySIdentifier csFromPortID = new HySID("");
                HySIdentifier csToPortID = new HySID("");
                HySIdentifier csNullID = new HySID("");
                McStructTransPort csRlyPort = null;
                McStructPort csPort = null;
                csRtnConnection.GetConnectionElement(ref csFromElmID, ref csToElmID);
                csRtnConnection.GetConnectionPort(ref csFromPortID, ref csToPortID);

                McStructElement csElm = this.GetElement(csFromElmID);
                if (csElm != null)
                {
                    csPort = csElm.GetPort(csFromPortID);
                    if (csPort as McStructTransPort == null)
                    {
                        // 通常端子であるならば
                        csElm.DelPort(csFromPortID);
                    }
                    else
                    {
                        // 中継端子であるならば
                        //csRlyPort = csPort as McStructTransPort;
                        //csRlyPort.SetInnerPortID(csNullID, csNullID);  // <-- 接続情報をリセットする
                        csPort.SetPortID(csNullID, csNullID);  // <-- 接続情報をリセットする
                    }
                }
                csElm = this.GetElement(csToElmID);
                if (csElm != null)
                {
                    csPort = csElm.GetPort(csToPortID);
                    if (csPort as McStructTransPort == null)
                    {
                        // 通常端子であるならば
                        csElm.DelPort(csToPortID);
                    }
                    else
                    {
                        // 中継端子であるならば
                        //csRlyPort = csPort as McStructTransPort;
                        //csRlyPort.SetInnerPortID(csNullID, csNullID);  // <-- 接続情報をリセットする
                        csPort.SetPortID(csNullID, csNullID);  // <-- 接続情報をリセットする
                    }
                }

                // 削除する接続に関連する外部接続端子の情報をリセットする
                //HySIdentifier csNullID = new HySID("", "", "");
                csRlyPort = this.GetPort(csFromPortID) as McStructTransPort;
                if (csRlyPort != null)
                {
                    csRlyPort.SetInnerPortID(csNullID, csNullID);  // <-- 接続情報をリセットする
                }
                csRlyPort = this.GetPort(csToPortID) as McStructTransPort;
                if (csRlyPort != null)
                {
                    csRlyPort.SetInnerPortID(csNullID, csNullID);  // <-- 接続情報をリセットする
                }
            }

            return csRtnConnection;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>接続線取り外し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RemoveConnection(csCnnct)</para>
        /// </example>
        /// <param name="csCnnct">取り外す接続線</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>接続線を取り外すのみで、内部の整合性をあわせる処理は行わない</para>
        /// </remarks>
        virtual protected void RemoveConnection(McStructConnection csCnnct )
        {
            if (csCnnct == null) { return; }
        
            McStructConnection csConnection = null;
            long lNum = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {// 要素を検索
                csConnection = (McStructConnection)m_csConnectionList.GetCursorData();
                if (csConnection.Equal(csCnnct.GetID()) != false)
                {   // IDが一致
                    m_csConnectionList.RemoveData(lLp);
                    break;
                }
                m_csConnectionList.MoveCursorNext();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>接続リストを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csDataLinkedList = GetConnectionList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>接続リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal HySDataLinkedList GetConnectionList()
        {
            return m_csConnectionList;
        }

        //======================================
        // 端子関連メソッド
        //======================================


        /// <summary>
        /// <para>method outline:</para>
        /// <para>端子追加(後ほど削除するため、本メソッドは使用禁止)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructPort csPort = AddPort(eKind,csElmID)</para>
        /// </example>
        /// <param name="eKind">端子種別</param>
        /// <param name="csElmID">端子を追加する要素ID</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        virtual public McStructPort AddPort(McDefine.SymbolDrawKind eKind, HySIdentifier csElmID)
        {
            McStructPort csNewPort = null;     // 画面表示端子
            long lRet = -1L;                    // 復帰情報
            long lLp = 0L;                      // ループカウンタ
            McStructElement csElm = null;      // 画面表示要素

            if (csElmID == null)
            {// パラメータ異常
                return csNewPort;
            }

            for (lLp = 0; lLp < m_csElmList.GetCount(); lLp++)
            {// 要素を検索
                csElm = (McStructElement)m_csElmList.GetData(lLp);
                if (csElm.Equal(csElmID) != false)
                {// IDが一致

                    csNewPort = CreateNewStructPort(eKind);
                    //csNewPort.SetElmID(csElmID);
                    lRet = csElm.AddPort(csNewPort);

                    if (lRet != 0L)
                    {// 失敗
                        csNewPort = null;
                    }
                    break;
                }
            }

            return csNewPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>描画要素端子削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructPort csPort = DelPort(csPortID)</para>
        /// </example>
        /// <param name="csPortID">描画要素端子ID</param>
        /// <returns>削除する端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McStructPort DelPort(HySIdentifier csPortID)
        {
            // グループ要素では、m_csPortList　に入っている端子は、全て中継端子である
            McStructTransPort csPort = this.GetPort(csPortID) as McStructTransPort; //IDで該当するポートを取得
            if (csPort != null)
            {
                // 端子を削除
                base.DelPort(csPortID);
   
                // 中継端子に関連した接続を削除する
                for (long lLp = 0; lLp < 9999999; lLp++)
                {
                    // 端子に関連する接続を検索
                    McStructConnection csConnection = this.QueryConnectionByPortID(csPortID);
                    if (csConnection != null)
                    {   // 端子に関連する端子があれば
                        this.DeleteConnection(csConnection.GetID());
                    }
                    else
                    {
                        break;
                    }
                }
            }
            return csPort;
        }

        //======================================
        // 中継端子関連メソッド
        //======================================

        /// <summary>
        /// <para>method outline:</para>
        /// <para>中継端子追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructTransPort csTransPort = AddRelayPort(eKind,csRelayPortID)</para>
        /// </example>
        /// <param name="eKind">端子種別</param>
        /// <param name="csRelayPortID">中継端子ID（ID自動生成時はnull）</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McStructTransPort AddRelayPort(McDefine.SymbolDrawKind eKind, HySIdentifier csRelayPortID)
        {
            McStructTransPort csRtnPort = this.CreateNewStructPort(eKind) as McStructTransPort;
            if (csRtnPort != null)
            {
                this.AddPort(csRtnPort);
                if (csRelayPortID != null)
                {
                    csRtnPort.SetID(csRelayPortID);
                }
            }
            return csRtnPort;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>外部からグループ内への入力接続生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csConnection = AddExternalINConnection(csID, csFromRelayPortID, csToElmID, csToPortID)</para>
        /// </example>
        /// <param name="csID">接続線ID</param>
        /// <param name="csFromRelayPortID">接続元中継ポート識別子</param>
        /// <param name="csToElmID">接続先要素識別子</param>
        /// <param name="csToPortID">接続先ポート識別子</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>先にAddRelayPort()で中継端子を生成しておく必要がある。</para>
        /// </remarks>
        virtual public McStructConnection AddExternalINConnection(HySIdentifier csID, HySIdentifier csFromRelayPortID, HySIdentifier csToElmID, HySIdentifier csToPortID)
        {
            McStructConnection csNewCnct = null;
            McStructTranINPort csInport = this.GetPort(csFromRelayPortID) as McStructTranINPort;
            if (csInport != null)
            {   // 中継端子有り

                McStructElement csElm = this.GetElement(csToElmID);      // 要素
                if (csElm != null)
                {   // 接続先要素有り
                    csInport.SetInnerPortID(csFromRelayPortID, csToPortID);
                    //// 接続のFrom側は　中継端子となる(要素では無い為、From側要素のIDはダミー）
                    //csNewCnct = this.CreateConnection(csID, McDefine.STRUCT_DMY_ELM, csFromRelayPortID, csToElmID, csToPortID);
                    csNewCnct = this.CreateConnection(csID, GetID(), csFromRelayPortID, csToElmID, csToPortID);
                    this.m_csConnectionList.AddLast(csNewCnct);
                    McStructPort csPort = csElm.GetPort(csToPortID);
                    if (csPort == null)
                    {   // 指定の端子が無ければ新しく作成する
                        McStructGroupElement csGrToElm = csElm as McStructGroupElement;
                        if (csGrToElm == null)
                        {   // 通常の要素ならば    
                            csPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_RECEIVE); //this.AddPort(McDefine.SymbolDrawKind.HYM_RECEIVE, csToElmID);
                        }
                        else
                        {   // グループ要素ならば
                            csPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_TRANS_IN);
                        }
                        if (csToPortID.ToString() != "")
                        {
                            csPort.SetID(csToPortID);
                        }
                        csElm.AddPort(csPort);
                        csInport.SetInnerPortID(csFromRelayPortID, csPort.GetID());
                        csNewCnct.SetConnection(GetID(), csFromRelayPortID, csToElmID, csPort.GetID());
                    }
                    csPort.SetPortID(csFromRelayPortID, csPort.GetID());
                }
            }
            return csNewCnct;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グループ内から外部への出力接続生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructConnection csConnection = AddExternalOUTConnection(csID, csFromElmID, csFromPortID, csToRelayPortID)</para>
        /// </example>
        /// <param name="csID">接続線ID</param>
        /// <param name="csFromElmID">接続元要素識別子</param>
        /// <param name="csFromPortID">接続元ポート識別子</param>
        /// <param name="csToRelayPortID">接続先中継ポート識別子</param>
        /// <returns>!=null:成功，==null:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>先にAddRelayPort()で中継端子を生成しておく必要がある。</para>
        /// </remarks>
        virtual public McStructConnection AddExternalOUTConnection(HySIdentifier csID, HySIdentifier csFromElmID, HySIdentifier csFromPortID, HySIdentifier csToRelayPortID)
        {
            McStructConnection csNewCnct = null;
            McStructTranOUTPort csOutPort = this.GetPort(csToRelayPortID) as McStructTranOUTPort;
            if (csOutPort != null)
            {   // 中継端子有り
                McStructElement csElm = this.GetElement(csFromElmID);      // 要素
                if (csElm != null)
                {   // 接続要素有り
                    csOutPort.SetInnerPortID(csFromPortID, csToRelayPortID);
                    //// 接続のTo側は　中継端子になる（要素は無い為、To側要素のIDはダミー）
                    //csNewCnct = this.CreateConnection(csID, csFromElmID, csFromPortID, McDefine.STRUCT_DMY_ELM, csToRelayPortID);
                    csNewCnct = this.CreateConnection(csID, csFromElmID, csFromPortID, GetID(), csToRelayPortID);
                    this.m_csConnectionList.AddLast(csNewCnct);

                    McStructPort csPort = csElm.GetPort(csFromPortID);
                    if (csPort == null)
                    {   // 指定の端子が無ければ新しく作成する
                        McStructGroupElement csGrFromElm = csElm as McStructGroupElement;
                        if (csGrFromElm == null)
                        {   // 通常の要素ならば    
                            csPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_SEND); //this.AddPort(McDefine.SymbolDrawKind.HYM_SEND, csFromElmID);
                        }
                        else
                        {   // グループ要素ならば
                            csPort = this.CreateNewStructPort(McDefine.SymbolDrawKind.HYM_TRANS_OUT);
                        }
                        if (csFromPortID.ToString() != "")
                        {
                            csPort.SetID(csFromPortID);
                        }
                        csElm.AddPort(csPort);
                        csOutPort.SetInnerPortID(csPort.GetID(), csToRelayPortID);
                        csNewCnct.SetConnection(csFromElmID, csPort.GetID(), GetID(), csToRelayPortID);
                    }
                    csPort.SetPortID(csPort.GetID(), csToRelayPortID);
                }
            }
            return csNewCnct;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>中継端子破棄</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DeleteRelayPort(csRelayPortID, csUpperGroupElement)</para>
        /// </example>
        /// <param name="csRelayPortID">中継端子識別子</param>
        /// <param name="csUpperGroupElement">上位（自分を持っている）のグループ要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void DeleteRelayPort(HySIdentifier csRelayPortID, McStructGroupElement csUpperGroupElement)
        {
            McStructConnection csCnnct = csUpperGroupElement.QueryConnectionByPortID(csRelayPortID);
            if (csCnnct != null)
            {   // 上位が指定中継端子に接続していれば
                csUpperGroupElement.DeleteConnection( csCnnct.GetID() );
                //以下の処理は不用(上位が自分に繋がっている接続を消せば、自ずと中継端子も消える為)
                //this.DelPort(csRelayPortID);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>外部と内部の端子を中継端子を使わずに直接接続する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DirectConnection(csRelayPortID, csUpperGroupElement)</para>
        /// </example>
        /// <param name="csRelayPortID">中継端子識別子</param>
        /// <param name="csUpperGroupElement">上位（自分を持っている）のグループ要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>グループを解除するときのみ使用する</para>
        /// </remarks>
        virtual protected void DirectConnection(HySIdentifier csRelayPortID, McStructGroupElement csUpperGroupElement)
        {
            McStructConnection csCnnct = csUpperGroupElement.QueryConnectionByPortID(csRelayPortID);  // 多くとも１本のみ
            McStructConnection csInnerCnnct = this.QueryConnectionByPortID(csRelayPortID);
            if (csCnnct != null)
            {   // 上位が指定中継端子に接続していれば
                McStructTranOUTPort csOutPort = this.GetPort(csRelayPortID) as McStructTranOUTPort;
                McStructTranINPort csInPort = this.GetPort(csRelayPortID) as McStructTranINPort;
                HySIdentifier csFromElmID = new HySID("");
                HySIdentifier csToElmID = new HySID("");
                HySIdentifier csFromPortID = new HySID("");
                HySIdentifier csToPortID = new HySID("");

                HySIdentifier csInnerFromElmID = new HySID("");
                HySIdentifier csInnerToElmID = new HySID("");
                HySIdentifier csInnerFromPortID = new HySID("");
                HySIdentifier csInnerToPortID = new HySID("");

                McStructPort csFromPort = null;
                McStructPort csToPort = null;

                csCnnct.GetConnectionElement(ref csFromElmID, ref csToElmID); // 外部要素
                csCnnct.GetConnectionPort(ref csFromPortID, ref csToPortID);

                if (csOutPort != null)
                {   // 外部出力用中継端子ならば
                    if (csInnerCnnct != null)
                    {   // 内部接続有りならば
                        csInnerCnnct.GetConnectionElement(ref csInnerFromElmID, ref csInnerToElmID); // 内部要素 
                        csInnerCnnct.GetConnectionPort(ref csInnerFromPortID, ref csInnerToPortID);

                        csCnnct.SetConnection(csInnerFromElmID, csInnerFromPortID, csToElmID, csToPortID);  // 外部からの接続端子のポートを設定し直す
                        //csOutPort.SetInnerPortID(csInnerFromPortID, csToPortID);
                        if (csUpperGroupElement.GetID().Equals(csToElmID) == true)
                        {
                            csToPort = csUpperGroupElement.GetPort(csToPortID);
                        }
                        else
                        {
                            McStructElement csToElm = csUpperGroupElement.GetElement(csToElmID);
                            if (csToElm != null)
                            {
                                csToPort = csToElm.GetPort(csToPortID);
                            }
                        }
                        if (csToPort != null)
                        {
                            if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
                            {
                                ((McStructTransPort)csToPort).SetInnerPortID(csInnerFromPortID, csToPortID);
                            }
                            else
                            {
                                csToPort.SetPortID(csInnerFromPortID, csToPortID);
                            }
                        }

                        McStructElement csInnerElm = this.GetElement(csInnerFromElmID);
                        if (csInnerElm != null)
                        {
                            csFromPort = csInnerElm.GetPort(csInnerFromPortID);
                        }
                        else
                        {
                            csFromPort = this.GetPort(csInnerFromPortID);
                        }
                        if (csFromPort != null)
                        {
                            csFromPort.SetPortID(csInnerFromPortID, csToPortID);
                        }
                        this.RemoveConnection(csInnerCnnct); // 内部接続分を外しておく
                    }
                    else
                    {   // 内部接続無しならば
                        csUpperGroupElement.DeleteConnection(csCnnct.GetID());
                    }

                }
                else if (csInPort != null)
                {   // 内部入力用中継端子ならば              
                    if (csInnerCnnct != null)
                    {   // 内部接続有りならば                  
                        csInnerCnnct.GetConnectionElement(ref csInnerFromElmID, ref csInnerToElmID); // 内部要素 
                        csInnerCnnct.GetConnectionPort(ref csInnerFromPortID, ref csInnerToPortID);

                        csCnnct.SetConnection(csFromElmID, csFromPortID, csInnerToElmID, csInnerToPortID);  // 外部からの接続端子のポートを設定し直す
                        //csInPort.SetInnerPortID(csFromPortID, csInnerToPortID);
                        if (csUpperGroupElement.GetID().Equals(csFromElmID) == true)
                        {
                            csFromPort = csUpperGroupElement.GetPort(csFromPortID);
                        }
                        else
                        {
                            McStructElement csFromElm = csUpperGroupElement.GetElement(csFromElmID);
                            if (csFromElm != null)
                            {
                                csFromPort = csFromElm.GetPort(csFromPortID);
                            }
                        }
                        if (csFromPort != null)
                        {
                            if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
                            {
                                ((McStructTransPort)csFromPort).SetInnerPortID(csFromPortID, csInnerToPortID);
                            }
                            else
                            {
                                csFromPort.SetPortID(csFromPortID, csInnerToPortID);
                            }
                        }

                        McStructElement csInnerElm = this.GetElement(csInnerToElmID);
                        if (csInnerElm != null)
                        {
                            csToPort = csInnerElm.GetPort(csInnerToPortID);
                        }
                        else
                        {
                            csToPort = this.GetPort(csInnerToPortID);
                        }
                        if (csToPort != null)
                        {
                            csToPort.SetPortID(csFromPortID, csInnerToPortID);
                        }
                        this.RemoveConnection(csInnerCnnct); // 内部接続分を外しておく
                    }
                    else
                    {   // 内部接続無しならば
                        csUpperGroupElement.DeleteConnection(csCnnct.GetID());
                    }
                }
            }
            else
            {   // 外部接続無しならば
                if (csInnerCnnct != null)
                {   // 内部接続有りならば                  
                    this.DeleteConnection(csInnerCnnct.GetID());
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>グループ化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructGroupElement csNewGroup = MakeGroup(csGrElementID,csGroupMemberElmList,eElmKind,csElementKind)</para>
        /// </example>
        /// <param name="csGrElementID">グループ化要素のID（この値がGr化した要素のIDとなる）</param>
        /// <param name="csGroupMemberElmList">グループ化されるメンバー要素のリスト</param>
        /// <param name="eElmKind">シンボル描画種別</param>
        /// <param name="csElementKind">描画オブジェクト区分</param>
        /// <returns>生成インスタンス（失敗の場合はnullが返る）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McStructGroupElement MakeGroup(HySIdentifier csGrElementID, HySDataLinkedList csGroupMemberElmList, McDefine.SymbolDrawKind eElmKind, HySObjectKind csElementKind)
        {
            McStructGroupElement newGrElm = McStructElement.CreateNewElement(eElmKind, csElementKind,this) as McStructGroupElement;// this.CreateNewElement(eElmKind, csElementKind) as McStructGroupElement;
            //newGrElm.SetID(csGrElementID);

            // １．要素のつみ直し
            McStructElement csElm = null;
            long lElmNum = csGroupMemberElmList.GetCount();
            csGroupMemberElmList.SetCursorFirst();
            for (long lLp = 0; lLp < lElmNum; lLp++)
            {
                csElm = (McStructElement)csGroupMemberElmList.GetCursorData();

                this.m_csElmList.RemoveData(csElm); // 自身のリストから外す
                newGrElm.m_csElmList.AddLast(csElm); // 新しいGr要素に追加
                csElm.SetOwnerElement(newGrElm);    // 新しい所有者を設定

                csGroupMemberElmList.MoveCursorNext();
            }
            // 最後に自身に新Gr要素を追加する
            this.m_csElmList.AddLast(newGrElm);

            // ２．必要な中継端子作成が必要な接続を洗い出す
            HySDataLinkedList csInnerCnnctionList = new HySDataLinkedList();  // 新Gr内接続の一時保管
            HySDataLinkedList csExternInCnnctionList = new HySDataLinkedList();  // 新Gr内へ流入接続の一時保管
            HySDataLinkedList csExternOutCnnctionList = new HySDataLinkedList();  // 新Gr外への流出接続の一時保管

            McStructElement csFromCnnctElm = null;
            McStructElement csToCnnctElm = null;
            McStructConnection csCnnct=null;
            HySIdentifier csFromElmID = new HySID("");
            HySIdentifier csToElmID = new HySID("");
            HySIdentifier csFromPortID = new HySID("");
            HySIdentifier csToPortID = new HySID("");
            bool bFromElmExistOUT = false;  // FromElement is not in the new Group
            bool bToElmExistOUT = false; // ToElement is not in the new Group

            long lCnctNum = this.m_csConnectionList.GetCount();
            this.m_csConnectionList.SetCursorFirst();
            for (long lCn = 0; lCn < lCnctNum; lCn++)
            {   // 接続数繰り返す
                csCnnct = (McStructConnection)this.m_csConnectionList.GetCursorData();
                csCnnct.GetConnectionElement(ref csFromElmID, ref csToElmID);
                csCnnct.GetConnectionPort(ref csFromPortID, ref csToPortID);
                csFromCnnctElm = newGrElm.GetElement(csFromElmID);  // csOutElm == null ならば内部にも外にも存在しない => 中継端子と接続中

                bFromElmExistOUT = false;
                if ((csFromCnnctElm = newGrElm.GetElement(csFromElmID)) == null)
                {   // From 側の要素が新Ｇｒ内に存在しない場合(From要素が何処に存在しようと、とにかくFromが新Ｇｒ内部に無い)
                    bFromElmExistOUT = true;
                }
                bToElmExistOUT = false;
                if ((csToCnnctElm = newGrElm.GetElement(csToElmID)) == null)
                {   // To 側の要素が新Ｇｒ内に存在しない場合(To要素が何処に存在しようと、とにかくToが新Ｇｒ内部に無い)
                    bToElmExistOUT = true;
                }


                if (bFromElmExistOUT == false && bToElmExistOUT == false)
                {   // From要素とTo要素が共に新Ｇｒ内にいる
                    csInnerCnnctionList.AddLast(csCnnct); // 一時保管リストへ追加
                }
                else if (bFromElmExistOUT == true && bToElmExistOUT == false)
                {   // Fromが外で、Toが内部にいる場合
                    csExternInCnnctionList.AddLast(csCnnct); // 新Gr内へ流入接続の一時保管リストへ追加
                }
                else if (bFromElmExistOUT == false && bToElmExistOUT == true)
                {   // Fromが内部で、Toが外にいる場合
                    csExternOutCnnctionList.AddLast(csCnnct); // 新Gr外への流出接続の一時保管リストへ追加
                }
                else if (bFromElmExistOUT == true && bToElmExistOUT == true)
                {   // Fromが外部で、Toも外にいる場合
                    // Do Nothing （何もしない）
                }

                m_csConnectionList.MoveCursorNext();
            }
            
            // ３．先の結果を基に接続を移動する           
            // ３．１　新Gr要素内接続
            lCnctNum = csInnerCnnctionList.GetCount();
            csInnerCnnctionList.SetCursorFirst();
            for (long lCn = 0; lCn < lCnctNum; lCn++)
            {   // 接続数繰り返す    
                csCnnct = (McStructConnection)csInnerCnnctionList.GetCursorData();
                this.m_csConnectionList.RemoveData(csCnnct);  // 自身のリストから外す
                newGrElm.m_csConnectionList.AddLast(csCnnct); // 新しいGr要素に追加
                csCnnct.SetOwnerElement(newGrElm); // 所有者の再設定
                csInnerCnnctionList.MoveCursorNext();
            }
            csInnerCnnctionList.Clear(); // 後始末

            HySID newPortID = null;
            // ３．２　自→新Grへの入力接続
            lCnctNum = csExternInCnnctionList.GetCount();
            csExternInCnnctionList.SetCursorFirst();
            for (long lCn = 0; lCn < lCnctNum; lCn++)
            {   // 接続数繰り返す    
                csCnnct = (McStructConnection)csExternInCnnctionList.GetCursorData();
                csCnnct.GetConnectionElement(ref csFromElmID, ref csToElmID);
                csCnnct.GetConnectionPort(ref csFromPortID, ref csToPortID);
                // 中継端子設定
                ////string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString() + DateTime.Now.Second.ToString()
                ////+ "." + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
                ////newPortID = new HySID(RELAY_RECEIVE, McStructTransPort.GetPrimNo().ToString() + "-", sStr);
                //string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString()
                //+ "-" + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
                ////newPortID = new HySID(RELAY_RECEIVE.ToString() + McStructTransPort.GetPrimNo().ToString() + DateTime.Now.Second.ToString() + "-", ((long)McDefine.SymbolDrawKind.HYM_TRANS_IN).ToString(), sStr);
                //newPortID = new HySID(RELAY_RECEIVE.ToString() + McStructTransPort.GetPrimNo().ToString() + DateTime.Now.Second.ToString() + "-" + ((long)McDefine.SymbolDrawKind.HYM_TRANS_IN).ToString() + sStr);
                //newGrElm.AddRelayPort(McDefine.SymbolDrawKind.HYM_TRANS_IN, newPortID);

                McStructTransPort csNewPort = newGrElm.AddRelayPort(McDefine.SymbolDrawKind.HYM_TRANS_IN, null);
                newPortID = (HySID)csNewPort.GetID();
                newGrElm.GetPort(newPortID).SetPortID(csFromPortID, newPortID);
                // 接続を中継端子へ
                csCnnct.SetConnection(csFromElmID, csFromPortID, newGrElm.GetID(), newPortID);
                // 相手端子の接続情報修正
                McStructPort csFromPort = null;
                if (GetID().Equals(csFromElmID) == true)
                {
                    csFromPort = GetPort(csFromPortID);
                }
                else
                {
                    csFromCnnctElm = GetElement(csFromElmID);
                    if (csFromCnnctElm != null)
                    {
                        csFromPort = csFromCnnctElm.GetPort(csFromPortID);
                    }
                }
                if (csFromPort != null)
                {
                    if (csFromPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_IN)
                    {
                        ((McStructTransPort)csFromPort).SetInnerPortID(csFromPortID, newPortID);
                    }
                    else
                    {
                        csFromPort.SetPortID(csFromPortID, newPortID);
                    }
                }

                McModelInfo csOldInfo = csCnnct.GetTranInfo(); // 元の伝送データ

                // 不要となった端子を削除しておく
                //csElm = newGrElm.GetElement(csToElmID);
                //McStructGroupElement csInnerGrElm = csElm as McStructGroupElement;
                //if (csInnerGrElm == null)
                //{
                //    csElm.DelPort(csToPortID);
                //}
                //else
                //{
                //}

                // 内部の配線を行う(接続のIDは仮)
                McStructConnection csInCnnct = newGrElm.AddExternalINConnection(
                                new HySID("IN"+ csGrElementID.GetString().ToString()+ McStructConnection.GetPrimNo().ToString()), //new HySID("IN", csGrElementID.GetString().ToString(), McStructConnection.GetPrimNo().ToString()),
                                newPortID,
                                csToElmID,
                                csToPortID);

                csInCnnct.SetConnectionName(csCnnct.GetConnectionName());

                if (csOldInfo != null)
                {
                    //McModelInfo csInnerModelInfo = new McModelInfo(
                    //                                        csOldInfo.GetLibraryID(),
                    //                                        csOldInfo.GetClassification(),
                    //                                        csOldInfo.GetModelKind(),
                    //                                        csOldInfo.GetModelName());
                    McModelInfo csInnerModelInfo = new McModelInfo(
                                                            csOldInfo.GetLibraryID(),
                                                            csOldInfo.GetClassification(),
                                                            csOldInfo.GetModelKind(),
                                                            csOldInfo.GetModelName(),
                                                            csOldInfo.GetModelType());
                    //McPropertyInfoRoot csOldPrptyInfo = csOldInfo.GetPropertyInfo();
                    //if (csOldPrptyInfo != null)
                    //{
                    //    csInnerModelInfo.SetPropertyInfo(csOldPrptyInfo.Clone());
                    //}
                    //McPropertyInfoRoot csOldInitInfo = csOldInfo.GetInitialInfo();
                    //if (csOldInitInfo != null)
                    //{
                    //    csInnerModelInfo.SetInitialInfo(csOldInitInfo.Clone());
                    //}

                    //csInnerModelInfo.SetPropertyInfo(csOldInfo.GetPropertyInfo());
                    //csInnerModelInfo.SetInitialInfo(csOldInfo.GetInitialInfo());

                    csInCnnct.SetConnectionTranInfo(csInnerModelInfo,null);

                    csInnerModelInfo.SetPropertyInfo(csOldInfo.GetPropertyInfo());
                    csInnerModelInfo.SetInitialInfo(csOldInfo.GetInitialInfo());
                }

                csExternInCnnctionList.MoveCursorNext();
            }
            csExternInCnnctionList.Clear(); // 後始末

            // ３．３　新Gr→自への出力接続
            lCnctNum = csExternOutCnnctionList.GetCount();
            csExternOutCnnctionList.SetCursorFirst();
            for (long lCn = 0; lCn < lCnctNum; lCn++)
            {   // 接続数繰り返す    
                csCnnct = (McStructConnection)csExternOutCnnctionList.GetCursorData();
                csCnnct.GetConnectionElement(ref csFromElmID, ref csToElmID);
                csCnnct.GetConnectionPort(ref csFromPortID, ref csToPortID);
                // 中継端子設定
                ////string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString() + DateTime.Now.Second.ToString()
                ////            + "." + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
                ////newPortID = new HySID(RELAY_SEND, McStructTransPort.GetPrimNo().ToString() + "-", sStr);
                //string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString()
                //+ "-" + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
                ////newPortID = new HySID(RELAY_SEND.ToString() + McStructTransPort.GetPrimNo().ToString() + DateTime.Now.Second.ToString() + "-", ((long)McDefine.SymbolDrawKind.HYM_TRANS_OUT).ToString(), sStr);
                //newPortID = new HySID(RELAY_SEND.ToString() + McStructTransPort.GetPrimNo().ToString() + DateTime.Now.Second.ToString() + "-" + ((long)McDefine.SymbolDrawKind.HYM_TRANS_OUT).ToString() + sStr);
                //newGrElm.AddRelayPort(McDefine.SymbolDrawKind.HYM_TRANS_OUT, newPortID);

                McStructTransPort csNewPort = newGrElm.AddRelayPort(McDefine.SymbolDrawKind.HYM_TRANS_OUT, null);
                newPortID = (HySID)csNewPort.GetID();
                newGrElm.GetPort(newPortID).SetPortID(newPortID, csToPortID);
                // 接続を中継端子へ
                csCnnct.SetConnection(newGrElm.GetID(), newPortID, csToElmID, csToPortID);
                // 相手端子の接続情報修正
                McStructPort csToPort = null;
                if (GetID().Equals(csToElmID) == true)
                {
                    csToPort = GetPort(csToPortID);
                }
                else
                {
                    csToCnnctElm = GetElement(csToElmID);
                    if (csToCnnctElm != null)
                    {
                        csToPort = csToCnnctElm.GetPort(csToPortID);
                    }
                }
                if (csToPort != null)
                {
                    if (csToPort.GetSymbolDrawKind() == McDefine.SymbolDrawKind.HYM_TRANS_OUT)
                    {
                        ((McStructTransPort)csToPort).SetInnerPortID(newPortID, csToPortID);
                    }
                    else
                    {
                        csToPort.SetPortID(newPortID, csToPortID);
                    }
                }

                McModelInfo csOldInfo = csCnnct.GetTranInfo(); // 元の伝送データ

                // 不要となった端子を削除しておく
                //csElm = newGrElm.GetElement(csFromElmID);
                //McStructGroupElement csInnerGrElm = csElm as McStructGroupElement;
                //if (csInnerGrElm == null)
                //{
                //    csElm.DelPort(csFromPortID);
                //}
                //else
                //{
                //}

                // 内部の配線を行う(接続のIDは仮)
                McStructConnection csInCnnct = newGrElm.AddExternalOUTConnection(
                                new HySID("OUT" + csGrElementID.GetString().ToString() + McStructConnection.GetPrimNo().ToString()),  //new HySID("OUT", csGrElementID.GetString().ToString(), McStructConnection.GetPrimNo().ToString()),
                                csFromElmID,
                                csFromPortID,
                                newPortID);
                csInCnnct.SetConnectionName(csCnnct.GetConnectionName());

                if (csOldInfo != null)
                {
                    //McModelInfo csInnerModelInfo = new McModelInfo(
                    //                                        csOldInfo.GetLibraryID(),
                    //                                        csOldInfo.GetClassification(),
                    //                                        csOldInfo.GetModelKind(),
                    //                                        csOldInfo.GetModelName());
                    McModelInfo csInnerModelInfo = new McModelInfo(
                                                            csOldInfo.GetLibraryID(),
                                                            csOldInfo.GetClassification(),
                                                            csOldInfo.GetModelKind(),
                                                            csOldInfo.GetModelName(),
                                                            csOldInfo.GetModelType());
                    //McPropertyInfoRoot csOldPrptyInfo = csOldInfo.GetPropertyInfo();
                    //if (csOldPrptyInfo != null)
                    //{
                    //    csInnerModelInfo.SetPropertyInfo(csOldPrptyInfo.Clone());
                    //}
                    //McPropertyInfoRoot csOldInitInfo = csOldInfo.GetInitialInfo();
                    //if (csOldInitInfo != null)
                    //{
                    //    csInnerModelInfo.SetInitialInfo(csOldInitInfo.Clone());
                    //}

                    //csInnerModelInfo.SetPropertyInfo(csOldInfo.GetPropertyInfo());
                    //csInnerModelInfo.SetInitialInfo(csOldInfo.GetInitialInfo());

                    csInCnnct.SetConnectionTranInfo(csInnerModelInfo,null);

                    csInnerModelInfo.SetPropertyInfo(csOldInfo.GetPropertyInfo());
                    csInnerModelInfo.SetInitialInfo(csOldInfo.GetInitialInfo());
                }

                csExternOutCnnctionList.MoveCursorNext();
            }
            csExternOutCnnctionList.Clear(); // 後始末


            csGroupMemberElmList.Clear(); // 後始末

            return newGrElm;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>指定したグループ要素（内部に存在）の解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = Disband(csGrElementID)</para>
        /// </example>
        /// <param name="csGrElementID">解体するグループ要素のID</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Disband(HySIdentifier csGrElementID)
        {
            bool bRtn = false;
            McStructGroupElement csGrElm = this.GetElement(csGrElementID) as McStructGroupElement;
            if (csGrElm != null)
            {
                bRtn = csGrElm.Disband(this);
            }
            return bRtn;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>グループ解除(自身を解体する)</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = Disband(csUpperGroupElement)</para>
        /// </example>
        /// <param name="csUpperGroupElement">上位（自分を持っている）のグループ要素</param>
        /// <returns>false</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual bool Disband(McStructGroupElement csUpperGroupElement)
        {
            // 最初に中継端子を全て外し、直接接続とする
            long lRlyPortNum = m_csPortList.GetCount();
            HySDataLinkedList csRlyList = new HySDataLinkedList();
            McStructTransPort csTrnPort=null;

            m_csPortList.SetCursorFirst();
            for (long lLp = 0; lLp < lRlyPortNum; lLp++)
            {   // 中継端子数繰り返し
                csTrnPort = m_csPortList.GetCursorData() as McStructTransPort;
                if (csRlyList != null)
                {
                    csRlyList.AddLast(csTrnPort);
                }
                m_csPortList.MoveCursorNext();
            }
            lRlyPortNum = csRlyList.GetCount();
            csRlyList.SetCursorFirst();
            for (long lLp = 0; lLp < lRlyPortNum; lLp++)
            {   // 中継端子数繰り返し
                csTrnPort = (McStructTransPort)csRlyList.GetCursorData();
                this.DirectConnection(csTrnPort.GetID(), csUpperGroupElement);
                csRlyList.MoveCursorNext();
            }

            // 内部のエレメントを全て外部に移す
            McStructElement csElm = null;
            long lElmNum=m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for( long lLp=0;lLp<lElmNum;lLp++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();   // 内部要素を取り外す
                csUpperGroupElement.m_csElmList.AddLast(csElm); // 取り外した内部要素を上位のGr化要素へ追加する
                csElm.SetOwnerElement(csUpperGroupElement); // 所有者を設定
                m_csElmList.MoveCursorNext();
            }
            m_csElmList.Clear();

            // 内部の接続を全て外部に移す
            McStructConnection csCnnect = null;
            long lCnnctNum = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lCnnctNum; lLp++)
            {
                csCnnect = (McStructConnection)m_csConnectionList.GetCursorData();
                csUpperGroupElement.m_csConnectionList.AddLast(csCnnect);
                csCnnect.SetOwnerElement(csUpperGroupElement); // 所有者の再設定
                m_csConnectionList.MoveCursorNext();
            }
            m_csConnectionList.Clear();

            // 自身を上位から外す
            csUpperGroupElement.RemoveElement(this.GetID());

            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>全削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = AllClear()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override bool AllClear()
        {
            McStructElement.m_ulTotalElmInstanceNum = 0;

            McStructElement csElm = null;
            long lElm = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for(long lLp=0;lLp<lElm;lLp++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();
                csElm.AllClear();
                m_csElmList.MoveCursorNext();
            }
            m_csElmList.Clear();

            McStructConnection csCnct = null;
            long lCnct = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lCnct; lLp++)
            {
                csCnct = (McStructConnection)m_csConnectionList.GetCursorData();
                csCnct.Free();
                m_csConnectionList.MoveCursorNext();
            }
            m_csConnectionList.Clear();

            base.AllClear();

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>グループのδTの奨励値を計算する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csDltT = RecommendDeltaTime()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>グループのδTの奨励値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>奨励値が計算できない場合には　負の値が返る</para>
        /// </remarks>
        public virtual HySTime RecommendDeltaTime()
        {
            HySTime csRtn = new HySTime(-1);
            bool bMinSetFlg = false;
            McStructElement csElm = null;
            McStructGroupElement csGrElm = null;
            HySTime csMinTm = new HySTime(365*10, 0, 0, 0);
            HySTime csWorkTm = new HySTime(csMinTm.GetTime());
            long lElmNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lLp = 0; lLp < lElmNum; lLp++)
            {
                csElm = (McStructElement)m_csElmList.GetCursorData();
                csGrElm = csElm as McStructGroupElement;
                if (csGrElm != null)
                {
                    csWorkTm = csGrElm.RecommendDeltaTime();
                    if (csWorkTm.GetTime() <= 0.0)
                    {
                        csWorkTm = csMinTm * 2.0;
                    }
                }
                else
                {
                    McModelInfo csMdlInfo = csElm.GetModelInfo();
                    McModelPropertyInfo csMdlPrptyInf = csMdlInfo.GetPropertyInfo() as McModelPropertyInfo;
                    if (csMdlPrptyInf != null)
                    {
                        csWorkTm = new HySTime(csMdlPrptyInf.GetStepTime());
                    }
                }
                if (csWorkTm.GetTime() > 0 &&
                    csWorkTm.GetTime() < csMinTm.GetTime() )
                {
                    csMinTm.SetTime(csWorkTm.GetTime());
                    bMinSetFlg = true;
                }
                
                m_csElmList.MoveCursorNext();
            }

            if (bMinSetFlg == true)
            {
                //csRtn = csRtn.SetTime(csMinTm.GetTime() * 0.5);
                csRtn = csRtn.SetTime(csMinTm.GetTime());
            }
            return csRtn;
        }

        //======================================
        // 構造定義ファイル入出力関連メソッド
        //======================================

        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadStructureConfiguration( csXml,csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬ</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool ReadStructureConfiguration(HySXmlNode csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = base.ReadStructureConfiguration(csXml, csMdlFctry);
            bool bLclRtn=false;
            // 構成する要素が先
            HySXmlNode csXmlCompNode;
            HySXmlNodeList csXmlComponentList = csXml.GetChildNodeListByTagName(McDefine.xml_COMPONENT);
            long lCompNum = csXmlComponentList.GetCount(); // 通常は１個
            for (long lLp = 0; lLp < lCompNum; lLp++)
            {
                csXmlCompNode = csXmlComponentList.GetNode(lLp);
                this.ReadElementConfiguration(csXmlCompNode.GetChildNodeList(), csMdlFctry);
            }

            // 次に接続
            HySXmlNodeList csXmlCnnctlList;
            HySXmlNode csXmlCnnctNode;
            long lCnnctNum = 0;
            HySXmlNode csWirringNode;
            HySXmlNodeList csXmlWiringList = csXml.GetChildNodeListByTagName(McDefine.xml_WIRRING);
            long lWirringNum = csXmlWiringList.GetCount();   // 通常は１個
            for (long lLp = 0; lLp < lWirringNum; lLp++)
            {
                csWirringNode = csXmlWiringList.GetNode(lLp);

                csXmlCnnctlList = csWirringNode.GetChildNodeList();
                lCnnctNum = csXmlCnnctlList.GetCount();
                for( long lCnt=0;lCnt<lCnnctNum;lCnt++)
                {
                    csXmlCnnctNode = csXmlCnnctlList.GetNode(lCnt);
                    if ( McDefine.xml_CONNECTION.Equals(csXmlCnnctNode.GetName()) == true)
                    {
                        bLclRtn = this.ReadConnectionConfiguration(csXmlCnnctNode, csMdlFctry);
                    }
                }
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素構造定義ＸＭＬ入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadElementConfiguration( csXmlList,csMdlFctry )</para>
        /// </example>
        /// <param name="csXmlList">入力ＸＭＬ</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual bool ReadElementConfiguration(HySXmlNodeList csXmlList, McModelFactorySet csMdlFctry)
        {
            bool bRtn = true;
            bool bLocalRtn = false;
            HySXmlNode csXml;
            HySObjectKind csSubKind ;
            McStructElement csStructElm;
            long lLstNum = csXmlList.GetCount();
            for (long lLp = 0; lLp < lLstNum; lLp++)
            {
                csXml = csXmlList.GetNode(lLp);

                if (McDefine.xml_SUBSYSTEM.Equals(csXml.GetName()) == true ||
                    McDefine.xml_CONVERGENCE.Equals(csXml.GetName()) == true ||
                    McDefine.xml_CALELEMENT.Equals(csXml.GetName()) == true)
                {

                    csSubKind = new HySObjectKind(csXml.GetAttribute(McDefine.xml_KIND));

                    csStructElm = null;
                    if (McDefine.xml_SUBSYSTEM.Equals(csXml.GetName()) == true)
                    {   // Ｇｒ要素ならば
                        csStructElm = this.AddElement(McDefine.SymbolDrawKind.HYM_GROUP, csSubKind);
                    }
                    else if (McDefine.xml_CONVERGENCE.Equals(csXml.GetName()) == true)
                    {   // 収束演算Ｇｒ要素ならば
                        csStructElm = this.AddElement(McDefine.SymbolDrawKind.HYM_CALC_GROUP, csSubKind);
                    }
                    else if (McDefine.xml_CALELEMENT.Equals(csXml.GetName()) == true)
                    {   // 計算要素ならば
                        csStructElm = this.AddElement(McDefine.SymbolDrawKind.HYM_STD_ELEMENT, csSubKind);
                    }
                    else
                    {
                        // Do Nothing
                    }
                    if (csStructElm != null)
                    {
                        bLocalRtn = csStructElm.ReadStructureConfiguration(csXml, csMdlFctry);
                    }
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>接続構造定義ＸＭＬ入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadConnectionConfiguration( csXml,csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬ</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual bool ReadConnectionConfiguration(HySXmlNode csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = false;
            string sID = csXml.GetAttribute(McDefine.xml_ID);
            HySID csCnctID = new HySID(sID); //new HySID(sID, "", "");

            string sFrom = csXml.GetAttribute(McDefine.xml_FROM);
            string sTo = csXml.GetAttribute(McDefine.xml_TO);

            HySID csFromPortID = new HySID(sFrom); // new HySID(sFrom, "", "");
            HySID csToPortID = new HySID(sTo); //new HySID(sTo, "", "");
            McStructElement csFromElm = this.QueryElementByPort(csFromPortID);
            McStructElement csToElm = this.QueryElementByPort(csToPortID);

            McStructConnection csStructCnct = null;
            if (csFromElm != null && csToElm != null)
            {   // Ｆｒｏｍ，Ｔｏ共に　要素がある（＝Ｇｒ内要素同士の接続）
                csStructCnct = this.AddInternalConnection(csCnctID, csFromElm.GetID(), csFromPortID, csToElm.GetID(), csToPortID);
            }
            else if (csFromElm == null && csToElm != null)
            {   // 内部入力中継端子への接続
                if (this.GetPort(csFromPortID) != null)
                {
                    csStructCnct = this.AddExternalINConnection(csCnctID, csFromPortID, csToElm.GetID(), csToPortID);
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McStructGroupElement", "ReadConnectionConfiguration", 
                        Properties.HymcoImplResources.STATEMENT_NO_REC_TERM );
                   // HySLog.LogOut(HySLog.ONLINE, "McStructGroupElement", "ReadConnectionConfiguration", "No ReceiveTerminal");
                }
            }
            else if (csFromElm != null && csToElm == null)
            {   // 外部出力中継端子への接続
                if (this.GetPort(csToPortID) != null)
                {
                    csStructCnct = this.AddExternalOUTConnection(csCnctID, csFromElm.GetID(), csFromPortID, csToPortID);
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McStructGroupElement", "ReadConnectionConfiguration",
                        Properties.HymcoImplResources.STATEMENT_NO_SND_TERM );
                   // HySLog.LogOut(HySLog.ONLINE, "McStructGroupElement", "ReadConnectionConfiguration", "No SendTerminal");
                }
            }
            else
            {   // 中継端子同士の接続
                if (this.GetPort(csFromPortID) != null && this.GetPort(csToPortID) != null)
                {
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McStructGroupElement", "ReadConnectionConfiguration",
                       Properties.HymcoImplResources.STATEMENT_NO_REC_TERM + Properties.HymcoImplResources.STATEMENT_AND
                       + Properties.HymcoImplResources.STATEMENT_NO_SND_TERM);
                   // HySLog.LogOut(HySLog.ONLINE, "McStructGroupElement", "ReadConnectionConfiguration", "No ReceiveTerminal and No SendTerminal");
                }
            }

            if (csStructCnct != null)
            {
                bRtn = csStructCnct.ReadStructureBody(csXml, csMdlFctry);
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイルヘッダー部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteStructureHeader( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteStructureHeader(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode=null;
            if(m_eDrawKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
            {
                // Convergenceタグ
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_CONVERGENCE, csXmlWriter);
            }
            else
            {
                // SunSystemタグ
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_SUBSYSTEM, csXmlWriter);
            }
            csRtnNode.SetAttribute(McDefine.xml_ID, (this.GetID().GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_MODEL, ((m_csModelInfo.GetModelKind()).GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_FACTORYID, ((m_csModelInfo.GetLibraryID()).GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_KIND, (m_csDrawSubKind.GetString()).ToString());
            csRtnNode.SetAttribute(McDefine.xml_X, m_lX.ToString());
            csRtnNode.SetAttribute(McDefine.xml_Y, m_lY.ToString());
            csRtnNode.SetAttribute(McDefine.xml_ROTATION, m_lRotate.ToString());
            csRtnNode.SetAttribute(McDefine.xml_Width, m_lWidth.ToString());
            csRtnNode.SetAttribute(McDefine.xml_Height, m_lHeight.ToString());
            if ((object)m_sElementName != null)
            {
                csRtnNode.SetAttribute(McDefine.xml_ElementName, m_sElementName.ToString());
            }
            else
            {
                csRtnNode.SetAttribute(McDefine.xml_ElementName, "");
            }
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル本体部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteStructureBody( csInNode, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csInNode">XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteStructureBody(HySXmlNode csInNode, ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            HySXmlNode csNode = null;
            McStructElement csElm = null;

            // Componentsタグ
            csRtnNode = HySXmlNode.CreateElement(McDefine.xml_COMPONENT, csXmlWriter);
            long lElmNum = this.m_csElmList.GetCount();
            if (lElmNum > 0)
            {
                m_csElmList.SetCursorFirst();
                for (long lLp = 0; lLp < lElmNum; lLp++)
                {
                    csElm = (McStructElement)m_csElmList.GetCursorData();
                    csNode = csElm.WriteStructureConfiguration(ref csXmlWriter);
                    csRtnNode.AppendChild(csNode);
                    m_csElmList.MoveCursorNext();
                }
                csInNode.AppendChild(csRtnNode);
            }

            // 中継端子
            csRtnNode = base.WriteStructureBody(csInNode, ref csXmlWriter);
            if (csRtnNode != null)
            {   // データ有効
                csInNode.AppendChild(csRtnNode);
            }

            // Wirringタグ
            csRtnNode = HySXmlNode.CreateElement(McDefine.xml_WIRRING, csXmlWriter);
            McStructConnection csCnnct;
            long lCnnctNum = this.m_csConnectionList.GetCount();
            if (lCnnctNum > 0)
            {
                m_csConnectionList.SetCursorFirst();
                for (long lLp = 0; lLp < lCnnctNum; lLp++)
                {
                    csCnnct = (McStructConnection)m_csConnectionList.GetCursorData();
                    csNode = csCnnct.WriteStructureBody(ref csXmlWriter);
                    csRtnNode.AppendChild(csNode);
                    m_csConnectionList.MoveCursorNext();
                }
            }
            return csRtnNode;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ定義ファイルヘッダー部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WritePropertyHeader( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WritePropertyHeader(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            if (m_eDrawKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
            {
                // Convergenceタグ
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_CONVERGENCE, csXmlWriter);
            }
            else
            {
                // SunSystemタグ
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_SUBSYSTEM, csXmlWriter);
            }
            csRtnNode.SetAttribute(McDefine.xml_ID, (this.GetID().GetString()).ToString());
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ定義ファイル本体部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WritePropertyBody( csInNode, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csInNode">XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WritePropertyBody(HySXmlNode csInNode, ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            HySXmlNode csNode = null;
            McStructElement csElm = null;

            // Conpornentsタグ
            long lElmNum = this.m_csElmList.GetCount();
            if (lElmNum > 0)
            {
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_COMPONENT, csXmlWriter);
                m_csElmList.SetCursorFirst();
                for (long lLp = 0; lLp < lElmNum; lLp++)
                {
                    csElm = (McStructElement)m_csElmList.GetCursorData();
                    csNode = csElm.WritePropertyConfiguration(ref csXmlWriter);
                    csRtnNode.AppendChild(csNode);
                    m_csElmList.MoveCursorNext();
                }
                csInNode.AppendChild(csRtnNode);
            }
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadPropertyConfiguration( csXml,  csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">Xmlノード</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool ReadPropertyConfiguration(HySXmlNode csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = base.ReadPropertyConfiguration(csXml, csMdlFctry);
            bool bLclRtn = true;
            // 構成する要素
            string sWorkAttr;
            HySID csElmID = null;
            McStructElement csElment = null;

            HySXmlNode csXmlCompNode = null;
            HySXmlNodeList csXmlComponentList = csXml.GetChildNodeListByTagName(McDefine.xml_COMPONENT);
            long lCompNum = csXmlComponentList.GetCount(); // 通常は１個
            if (lCompNum > 0)
            {
                HySXmlNodeList csXmlList = csXmlComponentList.GetNode(0).GetChildNodeList();
                long lLstNum = csXmlList.GetCount();
                for (long lLp = 0; lLp < lLstNum; lLp++)
                {
                    csXmlCompNode = csXmlList.GetNode(lLp);
                    
                    // 識別子
                    sWorkAttr = csXmlCompNode.GetAttribute(McDefine.xml_ID);
                    csElmID = new HySID(sWorkAttr); //new HySID(sWorkAttr, "", "");

                    csElment = this.GetElement(csElmID);
                    if (csElment != null)
                    {
                        csElment.ReadPropertyConfiguration(csXmlCompNode, csMdlFctry);
                    }
                    else
                    {
                        bLclRtn = false;
                    }
                    
                }
            }
            if (bLclRtn == false){ bRtn = false;  }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期情報定義ファイルヘッダー部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteInitialHeader( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteInitialHeader(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            if (m_eDrawKind == McDefine.SymbolDrawKind.HYM_CALC_GROUP)
            {
                // Convergenceタグ
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_CONVERGENCE, csXmlWriter);
            }
            else
            {
                // SunSystemタグ
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_SUBSYSTEM, csXmlWriter);
            }
            csRtnNode.SetAttribute(McDefine.xml_ID, (this.GetID().GetString()).ToString());
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>プ初期情報定義ファイル本体部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteInitialBody( csInNode, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csInNode">XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteInitialBody(HySXmlNode csInNode, ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            HySXmlNode csNode = null;
            McStructElement csElm = null;

            // Conpornentsタグ
            long lElmNum = this.m_csElmList.GetCount();
            if (lElmNum > 0)
            {
                csRtnNode = HySXmlNode.CreateElement(McDefine.xml_COMPONENT, csXmlWriter);
                m_csElmList.SetCursorFirst();
                for (long lLp = 0; lLp < lElmNum; lLp++)
                {
                    csElm = (McStructElement)m_csElmList.GetCursorData();
                    csNode = csElm.WriteInitialConfiguration(ref csXmlWriter);
                    csRtnNode.AppendChild(csNode);
                    m_csElmList.MoveCursorNext();
                }
                csInNode.AppendChild(csRtnNode);
            }
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期情報定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadInitialConfiguration( csXml,  csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">Xmlノード</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool ReadInitialConfiguration(HySXmlNode csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = base.ReadInitialConfiguration(csXml, csMdlFctry);
            bool bLclRtn = true;
            // 構成する要素
            string sWorkAttr;
            HySID csElmID = null;
            McStructElement csElment = null;

            HySXmlNode csXmlCompNode = null;
            HySXmlNodeList csXmlComponentList = csXml.GetChildNodeListByTagName(McDefine.xml_COMPONENT);
            long lCompNum = csXmlComponentList.GetCount(); // 通常は１個
            if (lCompNum > 0)
            {
                HySXmlNodeList csXmlList = csXmlComponentList.GetNode(0).GetChildNodeList();
                long lLstNum = csXmlList.GetCount();
                for (long lLp = 0; lLp < lLstNum; lLp++)
                {
                    csXmlCompNode = csXmlList.GetNode(lLp);

                    // 識別子
                    sWorkAttr = csXmlCompNode.GetAttribute(McDefine.xml_ID);
                    csElmID = new HySID(sWorkAttr); //new HySID(sWorkAttr, "", "");

                    csElment = this.GetElement(csElmID);
                    if (csElment != null)
                    {
                        csElment.ReadInitialConfiguration(csXmlCompNode, csMdlFctry);
                    }
                    else
                    {
                        bLclRtn = false;
                    }

                }
            }
            if (bLclRtn == false) { bRtn = false; }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CopyInf(csOrgElm)</para>
        /// </example>
        /// <param name="csOrgElm">コピー元</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyInf(McStructElement csOrgElm)
        {
            m_csElmList = ((McStructGroupElement)csOrgElm).m_csElmList;
            m_csConnectionList = ((McStructGroupElement)csOrgElm).m_csConnectionList;
            base.CopyInf(csOrgElm);
        }
        /// <summary><para>method outline:</para>
        /// <para>内部要素数</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HowManyElement() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 要素数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        public override long HowManyElement()
        {
            long lTtlElmNo = 0;
            McStructElement csElm = null; // 要素
            long lElmNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lLp = 0; lLp < lElmNum; lLp++)
            {   // 要素数繰り返す
                csElm = (McStructElement)m_csElmList.GetCursorData();
                if (csElm != null)
                {   // 要素数累積
                    lTtlElmNo +=  csElm.HowManyElement();
                }
                m_csElmList.MoveCursorNext();
            }
            return lTtlElmNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>全内部要素のIDを変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 自身のID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続線、ポートのID含む</para>
        /// </remarks>
        public override HySID ChangeID()
        {
            // =========================================
            // １．Gr内部の接続のID変更
            //      この中で、下位Grへの入力・出力のID変更は行わせる。
            //      必ず上位から　ID変更命令が来る
            // ２．Gr内の要素のID変更
            // ３．自身のID変更
            // =========================================

            // １．内部の接続について　IDを変更させる
            long lCnctNum = m_csConnectionList.GetCount();
            McStructConnection csCnnct = null;//接続
            //McStructElement csFromElm = null;  
            //McStructElement csToElm = null; 
            //McStructPort csFromPort = null;
            //McStructPort csToPort = null;
            HySIdentifier csFromElmID = new HySID("");
            HySIdentifier csToElmID = new HySID("");
            HySIdentifier csFromPortID = new HySID("");
            HySIdentifier csToPortID = new HySID("");

            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lCnctNum; lLp++)
            {
                csCnnct = m_csConnectionList.GetCursorData() as McStructConnection;

                //csCnnct.GetConnectionElemet(ref csFromElmID, ref csToElmID);
                //csCnnct.GetConnectionPort(ref csFromPortID, ref csToPortID);
                //csFromElm = this.QueryElementByPort(csFromPortID);
                //if (csFromElm != null)
                //{
                //    csFromPort = csFromElm.GetPort(csFromPortID);
                //}
                //csToElm = this.QueryElementByPort(csToPortID);
                //if (csToElm != null)
                //{
                //    csToPort = csToElm.GetPort(csToPortID);
                //}

                csCnnct.ChangeID(null); // Gr 内部の接続に対するID変更（Gr外からの接続は行わない）
                
                m_csConnectionList.MoveCursorNext();
            }


            // ２．Gr内部の要素のID変更
            long lElmNum = m_csElmList.GetCount();
            m_csElmList.SetCursorFirst();
            for (long lLp = 0; lLp < lElmNum; lLp++)
            {   // 要素数繰り返す
                McStructElement csElm = (McStructElement)m_csElmList.GetCursorData();
                
                if (csElm != null)
                {   // 
                    csElm.ChangeID();   // 内部要素にID振り直しを行わせる
                }

                m_csElmList.MoveCursorNext();
            }

            // ３．自身のID変更
            base.ChangeID(); // 自身のID振り直し処理を行う

            return m_csID as HySID;
        }

        // ================================================
        //   Undo/Redo用処理
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>接続線追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = AddConnectionUsedByUndoRedoOnly( csConnection )</para>
        /// </example>
        /// <param name="csConnection">グループ構成要素</param>
        /// <returns>long 0:成功，-1:失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public long AddConnectionUsedByUndoRedoOnly(McStructConnection csConnection)
        {
            if (csConnection == null)
            {// パラメータ異常
                return -1L;
            }

            csConnection.SetOwnerElement(this);
            m_csConnectionList.AddLast(csConnection);

            return 0L;
        }

        /// <summary><para>method outline:</para>
        /// <para>ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetIDUsedByUndoRedoOnly(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public void SetIDUsedByUndoRedoOnly(HySIdentifier csID)
        {
            HySIdentifier csTempID = m_csID;
            HySIdentifier csFromElmID = null;
            HySIdentifier csToElmID = null;
            HySIdentifier csFromPortID = null;
            HySIdentifier csToPortID = null;

            m_csID = csID;

            long lRlyPortNum = m_csPortList.GetCount();
            McStructTransPort csTrnPort = null;
            McStructConnection csExternalConnection = null;

            m_csPortList.SetCursorFirst();
            for (long lLp = 0; lLp < lRlyPortNum; lLp++)
            {   // 中継端子数繰り返し
                csTrnPort = m_csPortList.GetCursorData() as McStructTransPort;

                if (csTrnPort != null)
                {
                    csTrnPort.SetElmID(csID);

                    if (m_csOwnerGrElm != null)
                    {
                        csExternalConnection = m_csOwnerGrElm.QueryConnectionByPortID(csTrnPort.GetID());
                        if (csExternalConnection != null)
                        {
                            csExternalConnection.GetConnectionElement(ref csFromElmID, ref csToElmID);
                            csExternalConnection.GetConnectionPort(ref csFromPortID, ref csToPortID);
                            if (csFromElmID.Equals(csTempID) == true)
                            {
                                csFromElmID = csID;
                            }
                            if (csToElmID.Equals(csTempID) == true)
                            {
                                csToElmID = csID;
                            }
                            csExternalConnection.SetConnection(csFromElmID, csFromPortID, csToElmID, csToPortID);
                        }
                    }
                }

                m_csPortList.MoveCursorNext();
            }

            long lCnctNum = m_csConnectionList.GetCount();
            McStructConnection csCnnct = null;//接続

            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lCnctNum; lLp++)
            {   // 接続線数繰り返す
                csCnnct = m_csConnectionList.GetCursorData() as McStructConnection;

                if (csCnnct != null)
                {
                    csCnnct.SetOwnerElement(this);

                    csCnnct.GetConnectionElement(ref csFromElmID, ref csToElmID);
                    csCnnct.GetConnectionPort(ref csFromPortID, ref csToPortID);
                    if (csFromElmID.Equals(csTempID) == true)
                    {
                        csFromElmID = csID;
                    }
                    if (csToElmID.Equals(csTempID) == true)
                    {
                        csToElmID = csID;
                    }
                    csCnnct.SetConnection(csFromElmID, csFromPortID, csToElmID, csToPortID);
                }

                m_csConnectionList.MoveCursorNext();
            }

            long lElmNum = m_csElmList.GetCount();
            McStructElement csElm = null;

            m_csElmList.SetCursorFirst();
            for (long lLp = 0; lLp < lElmNum; lLp++)
            {   // 要素数繰り返す
                csElm = (McStructElement)m_csElmList.GetCursorData();

                if (csElm != null)
                {
                    csElm.SetOwnerElement(this);
                }

                m_csElmList.MoveCursorNext();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>中継端子ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPortIDUsedByUndoRedoOnly(csBeforeID, csAfterID)</para>
        /// </example>
        /// <param name="csBeforeID">現在のID</param>
        /// <param name="csAfterID">設定ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public void SetPortIDUsedByUndoRedoOnly(HySIdentifier csBeforeID, HySIdentifier csAfterID)
        {
            long lRlyPortNum = m_csPortList.GetCount();
            McStructTransPort csTrnPort = null;
            McStructPort csPort = null;
            McStructConnection csConnection = null;
            HySIdentifier csFromElmID = null;
            HySIdentifier csToElmID = null;
            HySIdentifier csFromPortID = null;
            HySIdentifier csToPortID = null;

            m_csPortList.SetCursorFirst();
            for (long lLp = 0; lLp < lRlyPortNum; lLp++)
            {   // 中継端子数繰り返し
                csTrnPort = m_csPortList.GetCursorData() as McStructTransPort;

                if (csTrnPort != null)
                {
                    if (csTrnPort.Equal(csBeforeID) == true)
                    {
                        csTrnPort.SetID(csAfterID);

                        // 内部変更
                        csConnection = QueryConnectionByPortID(csBeforeID);
                        if (csConnection != null)
                        {
                            csConnection.GetConnectionElement(ref csFromElmID, ref csToElmID);
                            csConnection.GetConnectionPort(ref csFromPortID, ref csToPortID);
                            if (csFromPortID.Equals(csBeforeID) == true)
                            {
                                csFromPortID = csAfterID;

                                QueryElementByPort(csToPortID).GetPort(csToPortID).SetPortID(csFromPortID, csToPortID);
                            }
                            if (csToPortID.Equals(csBeforeID) == true)
                            {
                                csToPortID = csAfterID;

                                QueryElementByPort(csFromPortID).GetPort(csFromPortID).SetPortID(csFromPortID, csToPortID);
                            }
                            csConnection.SetConnection(csFromElmID, csFromPortID, csToElmID, csToPortID);

                            csTrnPort.SetInnerPortID(csFromPortID, csToPortID);
                        }

                        // 外部変更
                        if (m_csOwnerGrElm != null)
                        {
                            csConnection = m_csOwnerGrElm.QueryConnectionByPortID(csBeforeID);
                            if (csConnection != null)
                            {
                                csConnection.GetConnectionElement(ref csFromElmID, ref csToElmID);
                                csConnection.GetConnectionPort(ref csFromPortID, ref csToPortID);
                                if (csFromPortID.Equals(csBeforeID) == true)
                                {
                                    csFromPortID = csAfterID;

                                    if (m_csOwnerGrElm.QueryElementByPort(csToPortID) != null)
                                    {
                                        csPort = m_csOwnerGrElm.QueryElementByPort(csToPortID).GetPort(csToPortID);
                                    }
                                    else
                                    {
                                        csPort = m_csOwnerGrElm.GetPort(csToPortID);
                                    }
                                    if (csPort is McStructTranOUTPort)
                                    {
                                        ((McStructTransPort)csPort).SetInnerPortID(csFromPortID, csToPortID);
                                    }
                                    else
                                    {
                                        csPort.SetPortID(csFromPortID, csToPortID);
                                    }
                                }
                                if (csToPortID.Equals(csBeforeID) == true)
                                {
                                    csToPortID = csAfterID;

                                    if (m_csOwnerGrElm.QueryElementByPort(csFromPortID) != null)
                                    {
                                        csPort = m_csOwnerGrElm.QueryElementByPort(csFromPortID).GetPort(csFromPortID);
                                    }
                                    else
                                    {
                                        csPort = m_csOwnerGrElm.GetPort(csFromPortID);
                                    }
                                    if (csPort is McStructTranINPort)
                                    {
                                        ((McStructTransPort)csPort).SetInnerPortID(csFromPortID, csToPortID);
                                    }
                                    else
                                    {
                                        csPort.SetPortID(csFromPortID, csToPortID);
                                    }
                                }
                                csConnection.SetConnection(csFromElmID, csFromPortID, csToElmID, csToPortID);

                                csTrnPort.SetPortID(csFromPortID, csToPortID);
                            }
                        }
                    }
                }

                m_csPortList.MoveCursorNext();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructElement csStructElement = CopyInfUsedByUndoRedoOnly(csCopyElement)</para>
        /// </example>
        /// <param name="csCopyElement">複製要素</param>
        /// <returns>McStructElement 複製要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public override McStructElement CopyInfUsedByUndoRedoOnly(McStructElement csCopyElement)
        {
            if (csCopyElement == null)
            {
                csCopyElement = new McStructGroupElement();
            }

            base.CopyInfUsedByUndoRedoOnly(csCopyElement);

            ((McStructGroupElement)csCopyElement).SetSymbolDrawKind(GetSymbolDrawKind());

            for (long lLp = 0; lLp < m_csElmList.GetCount(); lLp++)
            {
                ((McStructGroupElement)csCopyElement).m_csElmList.AddLast(((McStructElement)m_csElmList.GetData(lLp)).CopyInfUsedByUndoRedoOnly(null));
            }

            for (long lLp = 0; lLp < m_csConnectionList.GetCount(); lLp++)
            {
                ((McStructGroupElement)csCopyElement).m_csConnectionList.AddLast(((McStructConnection)m_csConnectionList.GetData(lLp)).CopyInfUsedByUndoRedoOnly(null));
            }

            return csCopyElement;
        }


//------------
// start of レコード数自動調整の為の処理を追加
//  Ver1.2
//------------

        /// <summary><para>method outline:</para>
        /// <para>最適化処理の可否判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CanOptimizeTranInfoRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=最適化処理可能, false:=最適化処理不可能</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal bool CanOptimizeTranInfoRecord()
        {
            bool bRtn = false;
            if (this.GetModelInfo().GetModelKind().Equals(McModelLibraryDefine.HYM_MODEL_SUBSYSTEM) == true ||
                this.GetModelInfo().GetModelKind().Equals(McModelLibraryDefine.HYM_MODEL_FIG_UNITY) == true)
            {   // サブシステム要素ならばOK
                bRtn = true;
            }
            else
            {
                bRtn = false;
                McStructErrorInfo csErrorInfo = HySCommonInfoHash.GetCorrespondData(McDefine.CALCULATION_ERROR_INF, this.GetOwnerProjectID()) as McStructErrorInfo;
                if (csErrorInfo != null)
                {
                   // ver1.5 エラートレース日本語対応
                    csErrorInfo.AddCheckErrorData(this.GetID(), this.GetModelInfo().GetModelKind(),
                        Properties.HymcoImplResources.STATEMENT_GRMODEL_OPTIMIZE_NO );
                   // csErrorInfo.AddCheckErrorData(this.GetID(), this.GetModelInfo().GetModelKind(), " This Gr-Model cannot optimize.");
                }
            }
            // 下位にあるGr化要素を調べる
            McStructGroupElement csGrElm = null;
            long lElmNo = m_csElmList.GetCount();
            for (long lLp = 0; lLp < lElmNo; lLp++)
            {
                csGrElm = m_csElmList.GetData(lLp) as McStructGroupElement;
                if (csGrElm != null)
                {   // 内部のGr化要素問い合わせ
                    if (csGrElm.CanOptimizeTranInfoRecord() == false)
                    {
                        bRtn = false;
                        break;
                    }
                }
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>
        /// 要素モデル間接続線の最大レコード数自動調整処理その１
        /// （システム系のΔと要素のδによる設定）
        /// （同期／非同期計算のどちらにも有効）
        /// </para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = OptimizeTranInfoRecordStep1()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> long
        /// 正常時：McDefine.CALCULATION_NORMAL_RETURN
        /// 異常時：McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// レコード数＝((系のΔ)／(接続線の前要素のδ))＋２
        /// </para>
        /// </remarks>
        virtual internal long OptimizeTranInfoRecordStep1()
        {
            long lRtn = McDefine.CALCULATION_NORMAL_RETURN;
            try
            {
                McStructConnection csStrCnct = null;
                McStructElement csStrctElm = null;
                McStructGroupElement csGrElm = null;

                HySIdentifier csFromID = new HySID(""); // 接続線前モデルID
                HySIdentifier csToID = new HySID("");   // 接続線後モデルID
                McModelInfo csMdlInfo = null;
                McPropertyInfo csTranInfo = null; // 接続線プロパティ情報
                McModelPropertyInfo csMdlPrpty = null;  // モデルプロパティ情報
                McGroupPropertyInfo csGrMdlPrpty = null; // Gr化モデルプロパティ情報
                long lNewRecordNum = 2; // 新レコード数
                long lCnctNo = m_csConnectionList.GetCount();   // コネクション数
                double dSysDlt = 0.0;   // システムのΔ
                double dFromElmDlt = 0.0;   // 接続前要素モデルのδ
                long lElmNo = m_csElmList.GetCount();   // 内部のエレメント数

                // １．処理開始（同期・非同期共通）
                //    （系⊿／前要素δ）＋２
                // １．１　系のΔを取得する
                csGrMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                //dSysDlt = csGrMdlPrpty.GetStepTime();
                dSysDlt = this.GetOwnerStepTime();
                {
                    // １．２　各コネクションに対して　レコード数を設定
                    for (long lLp = 0; lLp < lCnctNo; lLp++)
                    {   // コネクション数分繰り返し
                        csStrCnct = m_csConnectionList.GetData(lLp) as McStructConnection;
                        if (csStrCnct != null)
                        {
                            // 接続線の前モデルを取得し、そのδを取得する
                            csStrctElm = csStrCnct.GetUpperTerminalElement();

                            if (csStrctElm != null)
                            {   // Ｇｒ内要素の接続
                                csMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                if (csMdlPrpty != null)
                                {
                                    dFromElmDlt = csMdlPrpty.GetStepTime();
                                }
                            }
                            else
                            {   // Ｇｒの外からの接続
                                HySIdentifier csFromPortID = new HySID("");
                                HySIdentifier csToPortID=new HySID("");
                                csStrCnct.GetConnectionPort(ref  csFromPortID, ref  csToPortID);
                                McStructPort csPort = this.GetPort(csFromPortID);
                                McStructElement csStrctTermilanElm = this.GetUpperTerminalElement(csPort);
                                if (csStrctTermilanElm != null)
                                {
                                    csMdlPrpty = csStrctTermilanElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                    if (csMdlPrpty != null)
                                    {
                                        dFromElmDlt = csMdlPrpty.GetStepTime();
                                    }
                                }
                            }

                            if (dFromElmDlt == 0.0)
                            {   // このときを考える ?????
                                dFromElmDlt = dSysDlt / 96.0;
                            }
                            lNewRecordNum = (long)(dSysDlt / dFromElmDlt) + 2;
                            csMdlInfo = csStrCnct.GetTranInfo();
                            csTranInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                            csTranInfo.SetMaxRecordDataNum(lNewRecordNum);  // レコード数更新
                        }
                    }
                }

                // 次にもう一度エレメントをスキャンし
                //    Gr要素ならばGr要素に対して OptimizeTranInfoRecord()を行わせる
                //     但し、この場合には、既に設定されているレコード数と自分の計算したレコード数を比べて
                //     大きい方を採用する
                lElmNo = m_csElmList.GetCount();
                for (long lLp = 0; lLp < lElmNo; lLp++)
                {
                    csGrElm = m_csElmList.GetData(lLp) as McStructGroupElement;
                    if (csGrElm != null)
                    {
                        csGrElm.OptimizeTranInfoRecordStep1();
                    }
                }
            }
            catch
            {
                lRtn = McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>
        /// 要素モデル間接続線の最大レコード数自動調整処理その２
        /// （後要素δと前要素δによる設定）
        /// （非同期計算に有効）
        /// </para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = OptimizeTranInfoRecordStep1()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> long
        /// 正常時：McDefine.CALCULATION_NORMAL_RETURN
        /// 異常時：McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// すでに、処理その１が実施済みである事が前提
        /// レコード数＝（後線の要素δ）／（前線の要素δ）＋２　を求め
        /// 既に設定されているレコード数と比較し大きいほうを採用する。
        /// </para>
        /// </remarks>
        virtual internal long OptimizeTranInfoRecordStep2()
        {
            long lRtn = McDefine.CALCULATION_NORMAL_RETURN;
            try
            {
                // 非同期ならば
                //   ２. （後要素δ／前要素δ）＋２

                McStructConnection csStrCnct = null;
                McStructElement csStrctElm = null;
                McStructGroupElement csGrElm = null;

                HySIdentifier csFromID = new HySID(""); // 接続線前モデルID
                HySIdentifier csToID = new HySID("");   // 接続線後モデルID
                McModelInfo csMdlInfo = null;
                McPropertyInfo csTranInfo = null; // 接続線プロパティ情報
                McModelPropertyInfo csMdlPrpty = null;  // モデルプロパティ情報
                McGroupPropertyInfo csGrMdlPrpty = null; // Gr化モデルプロパティ情報
                long lRecordNum = 0;    // 設定済みレコード数
                long lNewRecordNum = 2; // 新レコード数
                long lCnctNo = m_csConnectionList.GetCount();   // コネクション数
                double dSysDlt = 0.0;   // システムのΔ
                double dFromElmDlt = 0.0;   // 接続前要素モデルのδ
                double dToElmDlt = 0.0; // 接続後要素モデルのδ
                long lElmNo = m_csElmList.GetCount();   // 内部のエレメント数


                csGrMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                dSysDlt = this.GetOwnerStepTime();

                // 同期・非同期判断
                McDefine.DataFusionTiming eDtFs = McDefine.DataFusionTiming.ASYNCHRONOUS;
                McGroupPropertyInfo csGrpMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                if (csGrpMdlPrpty != null)
                {
                    eDtFs = csGrpMdlPrpty.GetDataFusionTiming();
                }
                if (eDtFs == McDefine.DataFusionTiming.ASYNCHRONOUS)
                {
                    // 非同期ならば
                    //   ２. （後要素δ／前要素δ）＋２
                    {
                        for (long lLp = 0; lLp < lCnctNo; lLp++)
                        {   // コネクション数分繰り返し
                            csStrCnct = m_csConnectionList.GetData(lLp) as McStructConnection;
                            if (csStrCnct != null)
                            {
                                // 接続線の前モデルを取得し、そのδを取得する
                                csStrctElm = csStrCnct.GetUpperTerminalElement();
                                csMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                if (csMdlPrpty != null)
                                {
                                    dFromElmDlt = csMdlPrpty.GetStepTime();
                                }

                                if (dFromElmDlt == 0.0)
                                {
                                    // このときを考える：Gr化の場合
                                    dFromElmDlt = dSysDlt;
                                }

                                csStrctElm = csStrCnct.GetLowerTerminalElement();
                                csMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                if (csMdlPrpty != null)
                                {
                                    dToElmDlt = csMdlPrpty.GetStepTime();
                                }

                                lNewRecordNum = (long)(dToElmDlt / dFromElmDlt) + 2;
                                csMdlInfo = csStrCnct.GetTranInfo();
                                csTranInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                                lRecordNum = csTranInfo.GetMaxRecordDataNum();
                                if (lRecordNum < lNewRecordNum)
                                {   // 既設定レコード数が新レコード数よりも小さいならば
                                    csTranInfo.SetMaxRecordDataNum(lNewRecordNum);  // レコード数更新
                                }
                            }
                        }
                    }

                }   // end of 非同期の場合

                // 次にもう一度エレメントをスキャンし
                //    Gr要素ならばGr要素に対して OptimizeTranInfoRecord()を行わせる
                //     但し、この場合には、既に設定されているレコード数と自分の計算したレコード数を比べて
                //     大きい方を採用する
                lElmNo = m_csElmList.GetCount();
                for (long lLp = 0; lLp < lElmNo; lLp++)
                {
                    csGrElm = m_csElmList.GetData(lLp) as McStructGroupElement;
                    if (csGrElm != null)
                    {
                        csGrElm.OptimizeTranInfoRecordStep2();
                    }
                }
            }
            catch
            {
                lRtn = McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR;
            }
            return lRtn;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>
        /// 要素モデル間接続線の最大レコード数自動調整処理その３の準備（初期化）
        /// （非同期計算に有効）
        /// </para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>OptimizeTranInfoRecordStep3Initialize(csDltTSetTbl)</para>
        /// </example>
        /// <param name="csDltTSetTbl">初期化したハッシュテーブル</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 各接続線の最大δを格納するハッシュテーブル（各要素IDをキーとする）に
        /// 初期値としてシステムのΔを設定する
        /// </para>
        /// </remarks>
        virtual internal void OptimizeTranInfoRecordStep3Initialize(ref Hashtable csDltTSetTbl)
        {
            double dSysDlt = 0.0;   // システムのΔ
            McStructElement csStrctElm = null;
            long lElmNo = m_csElmList.GetCount();   // 内部のエレメント数

            dSysDlt = this.GetOwnerStepTime();
            for (long lLp = 0; lLp < lElmNo; lLp++)
            {
                csStrctElm = m_csElmList.GetData(lLp) as McStructElement;
                csDltTSetTbl[csStrctElm] = dSysDlt;
                if (csStrctElm is McStructGroupElement)
                {   // Gr化要素ならば、内部に対しても初期化設定が必要
                    ((McStructGroupElement)csStrctElm).OptimizeTranInfoRecordStep3Initialize(ref csDltTSetTbl);
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>
        /// 要素モデル間接続線の最大レコード数自動調整処理その３の準備（上流のCalState型モデルのδ値を設定）
        /// （非同期計算に有効）
        /// </para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>OptimizeTranInfoRecordStep3SetDlt(csDltTSetTbl,csModelFactory)</para>
        /// </example>
        /// <param name="csDltTSetTbl">ハッシュテーブル</param>
        /// <param name="csModelFactory">モデルファクトリ：内部で生成されるモデルがMcStateCalModelBaseか否かを調べる時に使用する</param>
        /// <returns>正常:=0 , 異常:=-1</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内部のモデルの型を　CalState型/non-CalState型　を調べ、　
        /// CalState型の時はそれより下に接続されている要素について
        /// ハッシュテーブル（各要素IDをキーとする）に　自モデルのδを設定する。
        /// 但し、既に設定されている値の方が大きい場合には、δの設定は行わない。
        /// </para>
        /// </remarks>

        virtual internal long OptimizeTranInfoRecordStep3SetDlt(ref Hashtable csDltTSetTbl, McModelFactorySet csModelFactory)
        {
            long lNoStateCalModel = 0;  // CalState型 エレメント数
            try
            {
                McStructElement csStrctElm = null;
                McStructGroupElement csGrElm = null;

                HySIdentifier csFromID = new HySID(""); // 接続線前モデルID
                HySIdentifier csToID = new HySID("");   // 接続線後モデルID
                McModelInfo csMdlInfo = null;
                McPropertyInfo csPrptyInfo = null;  // プロパティ情報
                long lCnctNo = m_csConnectionList.GetCount();   // コネクション数
                long lElmNo = m_csElmList.GetCount();   // 内部のエレメント数

                // 同期・非同期判断
                McDefine.DataFusionTiming eDtFs = McDefine.DataFusionTiming.ASYNCHRONOUS;
                McGroupPropertyInfo csGrpMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                if (csGrpMdlPrpty != null)
                {
                    eDtFs = csGrpMdlPrpty.GetDataFusionTiming();
                }
                if (eDtFs == McDefine.DataFusionTiming.ASYNCHRONOUS)
                {
                    // 非同期ならば
                    //   ３．（CalState型が存在するとき）

                    //      ３．１　上流に存在する CalState型で一番大きいδとシステム⊿*2 のうち大きい方を求める＝＞Δ
                    // 上流に存在する CalState型で一番大きいδとシステム⊿*2 のうち大きい方=>Δを設定するハッシュテーブル作成（各要素）
                    double dElmDlt = 0.0;   // 要素のδT
                    for (long lLp = 0; lLp < lElmNo; lLp++)
                    {
                        csStrctElm = m_csElmList.GetData(lLp) as McStructElement;
                        csGrElm = csStrctElm as McStructGroupElement;
                        csMdlInfo = csStrctElm.GetModelInfo();
                        if (csGrElm == null)
                        {   // Gr化要素ではない場合

                            // csStrctElm 内のモデルが　State型ならば　＜＜－－－StructGroup側では判断できない
                            // Factory からモデルを生成させてから判断する 引数でモデルファクトリークラスが必要となる
                            McStateCalModelBase csNewModel = csModelFactory.CreateCalModel(csMdlInfo.GetLibraryID(), csMdlInfo.GetModelKind(), new HySID("dmy")) as McStateCalModelBase; // 現状計算型モデルならば
                            if (csNewModel != null)
                            {   // 現状計算型モデルならば
                                lNoStateCalModel += 1;
                                csPrptyInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                                dElmDlt = csPrptyInfo.GetStepTime();
                                if (dElmDlt > (double)(csDltTSetTbl[csStrctElm]))
                                {   //DltTSetTbl[csStrctElm]　よりもδTが大きいならば
                                    this.SetLowerStructElmDltT(csStrctElm, csDltTSetTbl, dElmDlt);
                                }
                            }
                        }
                        else
                        {   // Gr化要素の場合
                            lNoStateCalModel += csGrElm.OptimizeTranInfoRecordStep3SetDlt(ref csDltTSetTbl, csModelFactory);
                        }
                    }
                }   // end of 非同期の場合
            }
            catch
            {
                lNoStateCalModel = -1;
            }
            return lNoStateCalModel;
        }
        /// <summary><para>method outline:</para>
        /// <para>
        /// 要素モデル間接続線の最大レコード数自動調整処理その３
        /// （後要素δと前要素δによる設定）
        /// （非同期計算に有効）
        /// </para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = OptimizeTranInfoRecordStep3(csDltTSetTbl)</para>
        /// </example>
        /// <param name="csDltTSetTbl">ハッシュテーブル</param>
        /// <returns> long
        /// 正常時：McDefine.CALCULATION_NORMAL_RETURN
        /// 異常時：McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 本処理前に、処理その１、処理その２が実施済みである事。
        /// また、ハッシュテーブルに処理３の準備設定が実施済みである事。
        /// レコード数＝（ハッシュテーブル内の設定Δδ）／（前線の要素δ）＋２　を求め
        /// 既に設定されているレコード数と比較し大きいほうを採用する。
        /// </para>
        /// </remarks>
        virtual internal long OptimizeTranInfoRecordStep3(ref Hashtable csDltTSetTbl)
        {
            long lRtn = McDefine.CALCULATION_NORMAL_RETURN;
            try
            {

                McStructConnection csStrCnct = null;
                McStructElement csStrctElm = null;
                McStructGroupElement csGrElm = null;

                HySIdentifier csFromID = new HySID(""); // 接続線前モデルID
                HySIdentifier csToID = new HySID("");   // 接続線後モデルID
                McModelInfo csMdlInfo = null;
                McPropertyInfo csTranInfo = null; // 接続線プロパティ情報
                McPropertyInfo csPrptyInfo = null;  // プロパティ情報
                long lRecordNum = 0;    // 設定済みレコード数
                long lNewRecordNum = 2; // 新レコード数
                long lCnctNo = m_csConnectionList.GetCount();   // コネクション数
                double dFromElmDlt = 0.0;   // 接続前要素モデルのδ
                long lElmNo = m_csElmList.GetCount();   // 内部のエレメント数


                // 同期・非同期判断
                McDefine.DataFusionTiming eDtFs = McDefine.DataFusionTiming.ASYNCHRONOUS;
                McGroupPropertyInfo csGrpMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                if (csGrpMdlPrpty != null)
                {
                    eDtFs = csGrpMdlPrpty.GetDataFusionTiming();
                }
                if (eDtFs == McDefine.DataFusionTiming.ASYNCHRONOUS)
                {
                    // 非同期ならば
                    //   ３．（CalState型が存在するとき）
                    //      ３．２　（３．１で求めたΔ/前要素δ） ＋２
                    for (long lLp = 0; lLp < lCnctNo; lLp++)
                    {   // コネクション数分繰り返し
                        csStrCnct = m_csConnectionList.GetData(lLp) as McStructConnection;
                        // 接続線の後モデルを取得し、そのδを取得する
                        csStrctElm = csStrCnct.GetUpperTerminalElement();
                        csPrptyInfo = csStrctElm.GetModelInfo().GetPropertyInfo() as McPropertyInfo;
                        if (csPrptyInfo != null)
                        {
                            dFromElmDlt = csPrptyInfo.GetStepTime();
                        }

                        // 新レコード数を求める
                        lNewRecordNum = (long)((double)csDltTSetTbl[csStrctElm] / dFromElmDlt) + 2;

                        csMdlInfo = csStrCnct.GetTranInfo();
                        csTranInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                        lRecordNum = csTranInfo.GetMaxRecordDataNum();
                        if (lRecordNum < lNewRecordNum)
                        {   // 既設定レコード数が新レコード数よりも小さいならば
                            csTranInfo.SetMaxRecordDataNum(lNewRecordNum);  // レコード数更新
                        }

                        // 接続元の要素がGr化要素ならば、内部に対しても本処理を行う。
                        csStrCnct.GetConnectionElement(ref csFromID, ref csToID);
                        csGrElm = this.GetElement(csFromID) as McStructGroupElement;
                        if (csGrElm != null)
                        {
                            csGrElm.OptimizeTranInfoRecordStep3(ref csDltTSetTbl);
                        }
                    }
                }   // end of 非同期の場合
            }
            catch
            {
                lRtn = McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR;
            }
            return lRtn;
        }


        /*        
        /// <summary><para>method outline:</para>
        /// <para>要素モデル間接続線の最大レコード数自動調整</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = OptimizeTranInfoRecord(bTopCallFlg,csModelFactory)</para>
        /// </example>
        /// <param name="bTopCallFlg">
        /// 呼び出し位置フラグ：最上位コールの場合は:true を設定する
        /// 本メソッド内でリカーシブルコールを行場合には:false を設定する</param>
        /// <param name="csModelFactory">モデルファクトリ：内部で生成されるモデルがMcStateCalModelBaseか否かを調べる時に使用する</param>
        /// <returns> long
        /// 正常時：McDefine.CALCULATION_NORMAL_RETURN
        /// 異常時：McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 同期演算、非同期演算に関わらず、要素モデル間の接続線上の最大レコード数を最適化する
        /// </para>
        /// </remarks>
        virtual public long OptimizeTranInfoRecord( McModelFactorySet csModelFactory)
        {
            long lRtn = McDefine.CALCULATION_NORMAL_RETURN;
            try
            {
                // 同期ならば
                //    (系の⊿／前要素δ)＋２
                // 非同期ならば
                //   １. （系⊿／前要素δ）＋２
                //   ２. （後要素δ／前要素δ）＋２
                //   ３．（CalState型が存在するとき）
                //      ３．０　順序整列
                //      ３．１　上流に存在する CalState型で一番大きいδとシステム⊿*2 のうち大きい方を求める＝＞Δ
                //      ３．２　（上記Δ/後要素δ） ＋２
                //   １～３までのうち一番大きい数をレコード数として採用

                McStructConnection csStrCnct = null;
                McStructElement csStrctElm = null;
                McStructGroupElement csGrElm = null;

                HySIdentifier csFromID = new HySID(""); // 接続線前モデルID
                HySIdentifier csToID = new HySID("");   // 接続線後モデルID
                McModelInfo csMdlInfo = null;
                McPropertyInfo csTranInfo = null; // 接続線プロパティ情報
                McModelPropertyInfo csMdlPrpty = null;  // モデルプロパティ情報
                McPropertyInfo csPrptyInfo = null;  // プロパティ情報
                McGroupPropertyInfo csGrMdlPrpty = null; // Gr化モデルプロパティ情報
                long lRecordNum = 0;    // 設定済みレコード数
                long lNewRecordNum = 2; // 新レコード数
                long lCnctNo = m_csConnectionList.GetCount();   // コネクション数
                double dSysDlt = 0.0;   // システムのΔ
                double dFromElmDlt = 0.0;   // 接続前要素モデルのδ
                double dToElmDlt = 0.0; // 接続後要素モデルのδ
                long lElmNo = m_csElmList.GetCount();   // 内部のエレメント数

                // １．処理開始（同期・非同期共通）
                //    （系⊿／前要素δ）＋２
                // １．１　系のΔを取得する
                csGrMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                //dSysDlt = csGrMdlPrpty.GetStepTime();
                dSysDlt = this.GetOwnerStepTime();
                {
                    // １．２　各コネクションに対して　レコード数を設定
                    for (long lLp = 0; lLp < lCnctNo; lLp++)
                    {   // コネクション数分繰り返し
                        csStrCnct = m_csConnectionList.GetData(lLp) as McStructConnection;
                        if (csStrCnct != null)
                        {
                            // 接続線の前モデルを取得し、そのδを取得する
                            csStrCnct.GetConnectionElement(ref csFromID, ref csToID);
                            csStrctElm = this.GetElement(csFromID);
//
                            csStrctElm = csStrCnct.GetUpperTerminalElement();

                            if (csStrctElm != null)
                            {   // Ｇｒ内要素の接続
                                csMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                if (csMdlPrpty != null)
                                {
                                    dFromElmDlt = csMdlPrpty.GetStepTime();
                                }
                                else
                                {
                                    csGrElm = csStrctElm as McStructGroupElement;
                                    if (csGrElm != null)
                                    {
                                        dFromElmDlt = csGrElm.GetOwnerStepTime();
                                    }
                                    //csGrMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                                    //if (csGrMdlPrpty != null)
                                    //{
                                    //    dFromElmDlt = ((McStructGroupElement)csStrctElm).GetOwnerStepTime();
                                    //}
                                    if (dFromElmDlt == 0.0)
                                    {
                                        // この部分用検討
                                        //McStructGroupElement csGrpElm = csStrctElm as McStructGroupElement;
                                        dFromElmDlt = dSysDlt;  // ????
                                    }
                                }
                            }
                            else
                            {   // Ｇｒの外からの接続
                                McStructElement csStrctTermilanElm = csStrCnct.GetUpperTerminalElement();
                                // ★このメソッドが出来るならば
                                if (csStrctTermilanElm != null)
                                {
                                    csMdlPrpty = csStrctTermilanElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                    if (csMdlPrpty != null)
                                    {
                                        dFromElmDlt = csMdlPrpty.GetStepTime();
                                    }
                                }
                            }

                            if (dFromElmDlt == 0.0)
                            {   // このときを考える ?????
                                dFromElmDlt = dSysDlt / 96.0;
                            }
                            lNewRecordNum = (long)(dSysDlt / dFromElmDlt) + 2;
                            ////////////////////////////////////////////////////////
                            csMdlInfo = csStrCnct.GetTranInfo();
                            csTranInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                            lRecordNum = csTranInfo.GetMaxRecordDataNum();
                            if (lRecordNum < lNewRecordNum)
                            {   // 既設定レコード数が新レコード数よりも小さいならば
                                csTranInfo.SetMaxRecordDataNum(lNewRecordNum);  // レコード数更新
                            }
                        }
                    }
                }
                // 同期・非同期判断
                McDefine.DataFusionTiming eDtFs = McDefine.DataFusionTiming.ASYNCHRONOUS;
                McGroupPropertyInfo csGrpMdlPrpty = this.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                if (csGrpMdlPrpty != null)
                {
                    eDtFs = csGrpMdlPrpty.GetDataFusionTiming();
                }
                if (eDtFs == McDefine.DataFusionTiming.ASYNCHRONOUS)
                {
                    // 部分系ならば、収束演算系ならば＜＝＝＝色々考えられる


                    // 非同期ならば
                    //   ２. （後要素δ／前要素δ）＋２
                    {
                        for (long lLp = 0; lLp < lCnctNo; lLp++)
                        {   // コネクション数分繰り返し
                            csStrCnct = m_csConnectionList.GetData(lLp) as McStructConnection;
                            if (csStrCnct != null)
                            {
                                // 接続線の前モデルを取得し、そのδを取得する
                                csStrCnct.GetConnectionElement(ref csFromID, ref csToID);
                                csStrctElm = this.GetElement(csFromID);
//
                                csStrctElm = csStrCnct.GetUpperTerminalElement();
                                csMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                //csGrMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                                if (csMdlPrpty != null)
                                {
                                    dFromElmDlt = csMdlPrpty.GetStepTime();
                                }
                                else
                                {
                                    csGrElm = csStrctElm as McStructGroupElement;
                                    if (csGrElm != null)
                                    {
                                        dFromElmDlt = csGrElm.GetOwnerStepTime();
                                    }
                                }
                                //if (csGrMdlPrpty != null)
                                //{
                                //    //dFromElmDlt = csPrptyInfo.GetStepTime();
                                //}
                                if (dFromElmDlt == 0.0)
                                {
                                    // このときを考える：Gr化の場合
                                    dFromElmDlt = dSysDlt;
                                }

                                csStrctElm = this.GetElement(csToID);
//
                                csStrctElm = csStrCnct.GetLowerTerminalElement();
                                csMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McModelPropertyInfo;
                                //csGrMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                                if (csMdlPrpty != null)
                                {
                                    dToElmDlt = csMdlPrpty.GetStepTime();
                                }
                                else
                                {
                                    csGrElm = csStrctElm as McStructGroupElement;
                                    if (csGrElm != null)
                                    {
                                        dToElmDlt = csGrElm.GetOwnerStepTime();
                                    }
                                }
                                //if (csGrMdlPrpty != null)
                                //{
                                //    //dToElmDlt = csPrptyInfo.GetStepTime();
                                //    // このときを考える：Gr化の場合
                                //}

                                lNewRecordNum = (long)(dToElmDlt / dFromElmDlt) + 2;
                                ////////////////////////////////////////////////////////
                                csMdlInfo = csStrCnct.GetTranInfo();
                                csTranInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                                lRecordNum = csTranInfo.GetMaxRecordDataNum();
                                if (lRecordNum < lNewRecordNum)
                                {   // 既設定レコード数が新レコード数よりも小さいならば
                                    csTranInfo.SetMaxRecordDataNum(lNewRecordNum);  // レコード数更新
                                }
                            }
                        }
                    }
                    //   ３．（CalState型が存在するとき）
                    {
                        long lNoStateCalModel = 0;
                        //      ３．１　上流に存在する CalState型で一番大きいδとシステム⊿*2 のうち大きい方を求める＝＞Δ
                        // 上流に存在する CalState型で一番大きいδとシステム⊿*2 のうち大きい方=>Δを設定するハッシュテーブル作成（各要素）
                        Hashtable DltTSetTbl = new Hashtable();
                        // ハッシュテーブル初期化
                        for (long lLp = 0; lLp < lElmNo; lLp++)
                        { 
                            csStrctElm = m_csElmList.GetData(lLp) as McStructElement;
                            DltTSetTbl[csStrctElm] = dSysDlt;
                        }
                        double dElmDlt = 0.0;   // 要素のδT
                        for (long lLp = 0; lLp < lElmNo; lLp++)
                        {
                            csStrctElm = m_csElmList.GetData(lLp) as McStructElement;
                            csMdlInfo = csStrctElm.GetModelInfo();

                            // csStrctElm 内のモデルが　State型ならば　＜＜－－－StructGroup側では判断できない
                            // Factory からモデルを生成させてから判断する 引数でモデルファクトリークラスが必要となる
                            McStateCalModelBase csNewModel = csModelFactory.CreateCalModel(csMdlInfo.GetLibraryID(), csMdlInfo.GetModelKind(), new HySID("dmy")) as McStateCalModelBase; // 現状計算型モデルならば
                            if (csNewModel != null)
                            {   // 現状計算型モデルならば
                                lNoStateCalModel += 1;
                                csPrptyInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                                dElmDlt = csPrptyInfo.GetStepTime();
                                if (dElmDlt > (double)(DltTSetTbl[csStrctElm]))
                                {   //DltTSetTbl[csStrctElm]　よりもδTが大きいならば
                                    this.SetLowerStructElmDltT( csStrctElm, DltTSetTbl, dElmDlt);
                                }
                            }
                        }
                        if( lNoStateCalModel > 0 )
                        {   // McStateCalModelBaseが存在すれば以下の処理を行う
                            //      ３．２　（３．１で求めたΔ/前要素δ） ＋２
                            for (long lLp = 0; lLp < lCnctNo; lLp++)
                            {   // コネクション数分繰り返し
                                csStrCnct = m_csConnectionList.GetData(lLp) as McStructConnection;
                                // 接続線の後モデルを取得し、そのδを取得する
                                csStrCnct.GetConnectionElement(ref csFromID, ref csToID);
                                csStrctElm = this.GetElement(csFromID);
                                csPrptyInfo = csStrctElm.GetModelInfo().GetPropertyInfo() as McPropertyInfo;
                                if (csPrptyInfo != null)
                                {
                                    dFromElmDlt = csPrptyInfo.GetStepTime();
                                }
                                else
                                {
                                    csGrMdlPrpty = csStrctElm.GetModelInfo().GetPropertyInfo() as McGroupPropertyInfo;
                                    if (csGrMdlPrpty != null)
                                    {
                                        // この部分を考える
                                        //dFromElmDlt = csPrptyInfo.GetStepTime();
                                        //dFromElmDlt = csPrptyInfo.GetStepTime();
                                    }
                                }


                                lNewRecordNum = (long)((double)DltTSetTbl[csStrctElm] / dFromElmDlt) + 2;

                                csMdlInfo = csStrCnct.GetTranInfo();
                                csTranInfo = csMdlInfo.GetPropertyInfo() as McPropertyInfo;
                                lRecordNum = csTranInfo.GetMaxRecordDataNum();
                                if (lRecordNum < lNewRecordNum)
                                {   // 既設定レコード数が新レコード数よりも小さいならば
                                    csTranInfo.SetMaxRecordDataNum(lNewRecordNum);  // レコード数更新
                                }
                            }
                        } // end of if( McStateCalModelBaseが存在すれば )
                    } // end of ３．
                }   // end of 非同期の場合

                // 次にもう一度エレメントをスキャンし
                //    Gr要素ならばGr要素に対して OptimizeTranInfoRecord()を行わせる
                //     但し、この場合には、既に設定されているレコード数と自分の計算したレコード数を比べて
                //     大きい方を採用する
                lElmNo = m_csElmList.GetCount();
                for (long lLp = 0; lLp < lElmNo; lLp++)
                {
                    csGrElm = m_csElmList.GetData(lLp) as McStructGroupElement;
                    if (csGrElm != null)
                    {
                        csGrElm.OptimizeTranInfoRecord(csModelFactory);
                    }
                }
            }
            catch
            {
                lRtn = McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR;
            }
            return lRtn;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>
        /// 指定したcsStructElm より下流に存在するすべて（直下のエレメントだけではなく、下流のGr化要素内部も含める）の
        /// エレメントのハッシュテーブル値を 与えた値：dltT に設定する
        /// </para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerStructElmDltT( csStrctElm,  csDltTSetTbl,  dltT)</para>
        /// </example>
        /// <param name="csStrctElm">指定エレメント</param>
        /// <param name="csDltTSetTbl">ハッシュテーブル</param>
        /// <param name="dltT">設定する値</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// リカーシブルコールとなる
        /// </para>
        /// </remarks>
        virtual protected void SetLowerStructElmDltT(McStructElement csStrctElm, Hashtable csDltTSetTbl, double dltT)
        {
            if ((double)csDltTSetTbl[csStrctElm] < dltT)
            {
                csDltTSetTbl[csStrctElm] = dltT;
            }

            HySDataLinkedList csLowerElmList = new HySDataLinkedList();

            csStrctElm.GetLowerElementList(ref  csLowerElmList);
            //csLowerElmList = this.GetLowerElmList(ref csLowerElmList, csStrctElm);
            long csLowerElmNo = csLowerElmList.GetCount();
            McStructElement csLowerStrctElm = null;
            csLowerElmList.SetCursorFirst();
            for (long lLp = 0; lLp < csLowerElmNo; lLp++)
            {
                csLowerStrctElm = csLowerElmList.GetCursorData() as McStructElement;
                if (csLowerStrctElm != null)
                {
                    if ((double)csDltTSetTbl[csLowerStrctElm] < dltT)
                    {
                        //DltTSetTbl[csLowerStrctElm] = dltT;
                        this.SetLowerStructElmDltT(csLowerStrctElm, csDltTSetTbl, dltT);
                    }
                }
                csLowerElmList.MoveCursorNext();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>最上位の要素インスタンスの取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetTopOwnerElement()</para>
        /// </example>
        /// <returns>McStructGroupElement 最上位要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McStructGroupElement GetTopOwnerElement()
        {
            McStructGroupElement csGrElm = this.GetOwnerElement() as McStructGroupElement;
            if (csGrElm != null)
            {   // Gr 化要素ならばさらに上位の要素を取得する
                csGrElm = csGrElm.GetTopOwnerElement();
            }
            else
            {
                csGrElm = this;
            }
            return csGrElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>最上位要素のタイムステップ取得処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetOwnerStepTime()</para>
        /// </example>
        /// <returns>double 最上位要素のタイムステップ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected double GetOwnerStepTime()
        {
            McPropertyInfo csPrptyInfo = this.GetModelInfo().GetPropertyInfo() as McPropertyInfo;
            double dRtn = csPrptyInfo.GetStepTime();
            if (dRtn == 0.0)
            {
                McStructGroupElement csGrElm = this.GetOwnerElement() as McStructGroupElement;
                if (csGrElm != null)
                {
                    //csGrElm = csGrElm.GetTopOwnerElement();
                    dRtn = csGrElm.GetOwnerStepTime();
                }
            }
            return dRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>上位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetUpperTerminalElement( csPort )</para>
        /// </example>
        /// <param name="csPort">端子</param>
        /// <returns>McStructElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetUpperTerminalElement(McStructPort csPort)
        {
            McStructElement csElm = null;
            if (csPort is McStructTranINPort)
            {
                csElm = this.GetUpperTerminalElement((McStructTranINPort)csPort);
            }
            else if (csPort is McStructTranOUTPort)
            {
                csElm = this.GetUpperTerminalElement((McStructTranOUTPort)csPort);
            }
            return csElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>上位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetUpperTerminalElement(csTranInPort)</para>
        /// </example>
        /// <param name="csTranInPort">中継端子：Grの外部からの接続中継端子</param>
        /// <returns>McStructElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetUpperTerminalElement(McStructTranINPort csTranInPort)
        {
            McStructElement csElm = null;
            if (m_csOwnerGrElm != null)
            {
                McStructConnection csCnction = m_csOwnerGrElm.QueryConnectionByPortID(csTranInPort.GetID());// ポートを所有している接続線を取得する
                //McStructConnection csCnction = this.QueryConnectionByPortID(csTranInPort.GetFromPortID());
                if (csCnction != null)
                {   // 接続線ありならば
                    csElm = m_csOwnerGrElm.GetElement(csCnction.GetFromElmID());// 接続元要素取得
                    McStructGroupElement csGrElm = csElm as McStructGroupElement;
                    if (csGrElm != null)
                    {   // 接続元がGr化要素ならば:内部に含まれているグループの中を探る
                        csElm = csCnction.GetUpperTerminalElement();
                    }
                    if (csElm == null)
                    {   // 前の処理で要素が見つからなかったとき：自Gr要素の外からの接続の場合
                        HySIdentifier csFromPortID = new HySID("");
                        HySIdentifier csToPortID = new HySID("");
                        csCnction.GetConnectionPort(ref  csFromPortID, ref  csToPortID);
                        McStructPort csPort = this.GetPort(csFromPortID);// 接続元の端子IDを取得する
                        if (csPort != null)
                        {
                            csElm = this.GetUpperTerminalElement(csPort);
                        }
                        else
                        {   // グループの外からの接続の場合
                            csPort = m_csOwnerGrElm.GetPort(csFromPortID);
                            csElm = m_csOwnerGrElm.GetUpperTerminalElement(csPort);
                        }
                    }
                }
            }
            return csElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>上位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetUpperTerminalElement(csTranOutPort)</para>
        /// </example>
        /// <param name="csTranOutPort">中継端子：内部に含まれるGr要素からの中継端子</param>
        /// <returns>McStructElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetUpperTerminalElement(McStructTranOUTPort csTranOutPort)
        {
            McStructElement csElm = null;
            McStructConnection csCnction = this.QueryConnectionByPortID(csTranOutPort.GetID());// ポートを所有している接続線を取得する
            //McStructConnection csCnction = this.QueryConnectionByPortID(csTranOutPort.GetFromPortID());
            if (csCnction != null)
            {   // 接続線ありならば
                csElm = this.GetElement(csCnction.GetFromElmID());// 接続元要素取得
                McStructGroupElement csGrElm = csElm as McStructGroupElement;
                if (csGrElm != null)
                {   // 接続元がGr化要素ならば:内部に含まれているグループの中を探る
                    csElm = csCnction.GetUpperTerminalElement();
                }
                if (csElm == null)
                {   // 前の処理で要素が見つからなかったとき：自Gr要素の外からの接続の場合
                    HySIdentifier csFromPortID = new HySID("");
                    HySIdentifier csToPortID = new HySID("");
                    csCnction.GetConnectionPort(ref  csFromPortID, ref  csToPortID);
                    McStructPort csPort = this.GetPort(csFromPortID);
                    if (csPort != null)
                    {
                        csElm = this.GetUpperTerminalElement(csPort);
                    }
                    else
                    {
                        csPort = m_csOwnerGrElm.GetPort(csFromPortID);
                        csElm = m_csOwnerGrElm.GetUpperTerminalElement(csPort);
                    }
                }
            }
            return csElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>下位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetLowerTerminalElement(csPort)</para>
        /// </example>
        /// <param name="csPort">端子</param>
        /// <returns>McStructElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetLowerTerminalElement(McStructPort csPort)
        {
            McStructElement csElm = null;
            if (csPort is McStructTranINPort)
            {
                csElm = this.GetLowerTerminalElement((McStructTranINPort)csPort);
            }
            else if (csPort is McStructTranOUTPort)
            {
                csElm = this.GetLowerTerminalElement((McStructTranOUTPort)csPort);
            }
            return csElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>下位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetLowerTerminalElement(csTranInPort)</para>
        /// </example>
        /// <param name="csTranInPort">中継端子</param>
        /// <returns>McStructElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetLowerTerminalElement(McStructTranINPort csTranInPort)
        {
            McStructElement csElm = null;
            McStructConnection csCnction = this.QueryConnectionByPortID(csTranInPort.GetID());// ポートを所有している接続線を取得する
            //McStructConnection csCnction = m_csOwnerGrElm.QueryConnectionByPortID(csTranInPort.GetToPortID());
            if (csCnction != null)
            {   // 接続線ありならば
                csElm = this.GetElement(csCnction.GetToElmID());// 接続先の要素を取得する
                McStructGroupElement csGrElm = csElm as McStructGroupElement;
                if (csGrElm != null)
                {   // 接続先がGr化要素ならば：内部に含まれているグループの中を探る
                    csElm = csCnction.GetLowerTerminalElement();
                }
                if (csElm == null)
                {   // 前の処理で要素が見つからなかったとき：自Gr要素の外への接続の場合
                    HySIdentifier csFromPortID = new HySID("");
                    HySIdentifier csToPortID = new HySID("");
                    csCnction.GetConnectionPort(ref  csFromPortID, ref  csToPortID);
                    McStructPort csPort = this.GetPort(csToPortID);
                    if (csPort != null)
                    {
                        csElm = this.GetLowerTerminalElement(csPort);
                    }
                    else
                    {
                        csPort = m_csOwnerGrElm.GetPort(csToPortID);
                        csElm = m_csOwnerGrElm.GetLowerTerminalElement(csPort);
                    }
                }
            }
            return csElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>下位に接続されている要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetLowerTerminalElement(csTranOUTPort)</para>
        /// </example>
        /// <param name="csTranOUTPort">中継端子</param>
        /// <returns>McStructElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先がGr化要素ならばその中まで探る</para>
        /// </remarks>
        internal virtual McStructElement GetLowerTerminalElement(McStructTranOUTPort csTranOUTPort)
        {
            McStructElement csElm = null;
            if (m_csOwnerGrElm != null)
            {
                McStructConnection csCnction = m_csOwnerGrElm.QueryConnectionByPortID(csTranOUTPort.GetID());// ポートを所有している接続線を取得する
                //McStructConnection csCnction = m_csOwnerGrElm.QueryConnectionByPortID(csTranOUTPort.GetToPortID());
                if (csCnction != null)
                {   // 接続線ありならば
                    csElm = m_csOwnerGrElm.GetElement(csCnction.GetToElmID());
                    McStructGroupElement csGrElm = csElm as McStructGroupElement;
                    if (csGrElm != null)
                    {   // 接続先がGr化要素ならば：内部に含まれているグループの中を探る
                        csElm = csCnction.GetLowerTerminalElement();
                    }
                    if (csElm == null)
                    {   // 前の処理で要素が見つからなかったとき：自Gr要素の外への接続の場合
                        HySIdentifier csFromPortID = new HySID("");
                        HySIdentifier csToPortID = new HySID("");
                        csCnction.GetConnectionPort(ref  csFromPortID, ref  csToPortID);
                        McStructPort csPort = this.GetPort(csToPortID);
                        if (csPort != null)
                        {
                            csElm = this.GetLowerTerminalElement(csPort);
                        }
                        else
                        {
                            csPort = m_csOwnerGrElm.GetPort(csToPortID);
                            csElm = m_csOwnerGrElm.GetLowerTerminalElement(csPort);
                        }
                    }
                }
            }
            return csElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素IDで指定した要素に接続されている接続線のリストを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetConnectionList(csElementID)</para>
        /// </example>
        /// <param name="csElementID">要素ID</param>
        /// <returns>HySDataLinkedList 接続線リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual HySDataLinkedList GetConnectionList(HySIdentifier csElementID)
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            HySIdentifier csFromElmID = new HySID("");
            HySIdentifier csToElmID = new HySID("");
            McStructConnection csConnection = null;

            long lNum = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {// 要素を検索
                csConnection = (McStructConnection)m_csConnectionList.GetCursorData();
                csConnection.GetConnectionElement(ref csFromElmID, ref csToElmID);
                if (csElementID.Equals(csFromElmID) == true ||
                    csElementID.Equals(csToElmID) == true)
                {
                    csRtnList.AddLast( csConnection );
                }
                m_csConnectionList.MoveCursorNext();
            }
            return csRtnList;
        }

//------------
// end  of レコード数自動調整の為の処理を追加
//  Ver1.2
//------------

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================

        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            // この中で、要素に対して関連コネクションの一覧を作成させる
            //
            // McStructElement.m_csUpperCnnctList <-- [NonSerialized]化する
            // McStructElement.m_csLowerCnnctList <-- [NonSerialized]化する

            PostDeserialize();
        }
        */
    }
}
