﻿// <summary>ソースコード：モデル構造クラス</summary>
// <author>CommonMP</author>


using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Model;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル構造クラス</para>
    /// </summary>
    /// <remarks
    /// ><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/11/17][新規作成]
    /// [CommonMP][ver 1.2.0][2011/11/10][レコード数最適化処理追加]
    /// </para>
    /// </remarks>
    [Serializable]
    public class McStructInfo : McStructGroupElement, HySVersionManagement //IDeserializationCallback
    {
        /// <summary>画面表示要素カウンタ</summary>
        protected static ulong m_ulElmCounter = 0UL;

        /// <summary>イニシャルファイル名（パス無し）</summary>
        protected HySString m_csInitialFileName=null;
        /// <summary>プロパティファイル名（パス無し）</summary>
        protected HySString m_csPrptyFileName=null;

        ///// <summary>画面表示拡大率</summary>
        //protected long m_lDispScale = 0L;

        ///// <summary>モデル編集領域（幅）拡大率100%時</summary>
        //private long m_lAreaWidth = 0L;

        ///// <summary>モデル編集領域（高さ）拡大率100%時</summary>
        //private long m_lAreaHeight = 0L;


        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McStructInfo csStructInfo = new McStructInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructInfo()
        {
            //m_csModelInfoに値を設定する
            m_csModelInfo = new McModelInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, new HySObjectKind(""),
                    McModelLibraryDefine.HYM_MODEL_FIG_UNITY, McModelLibraryDefine.MODEL_NAME_SUBSYSTEM,
                    McDefine.MODEL_TYPE_GROUP);
            //m_csModelInfo.SetPropertyInfo(
            //    new McGroupPropertyInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            //                             );
            m_csModelInfo.SetPropertyInfo(
                new McFigUnityPropertyInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.HYM_MODEL_SUBSYSTEM, new HySTime(0, 0, 60))
                                        );
             //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>要素新番号取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ulong ulRtn = GetNewElmNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素新番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ulong GetNewElmNo()
        {
            m_ulElmCounter++;
            return m_ulElmCounter;
        }

        //======================================
        // 表示情報関連メソッド
        //======================================

                
        /// <summary><para>method outline:</para>
        /// <para>δTの奨励値を計算する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csDltT = RecommendDeltaTime()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>グループのδTの奨励値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySTime RecommendDeltaTime()
        {
            HySTime csRtn = new HySTime(1);
            HySTime csGrDtlT = base.RecommendDeltaTime();
            if (csGrDtlT.GetTime() > 0.0)
            {
                McFigUnityPropertyInfo csPrptyInf = this.m_csModelInfo.GetPropertyInfo() as McFigUnityPropertyInfo;
                if (csPrptyInf.GetDataFusionTiming() == McDefine.DataFusionTiming.SYNCHRONOUS)
                {
                    csRtn.SetTime( csGrDtlT.GetTime() * 0.5 );
                }
                else
                {
                    csRtn.SetTime(csGrDtlT.GetTime());
                }
            }
            return csRtn;
        }
         
        /// <summary><para>method outline:</para>
        /// <para>イニシャルファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInitialXmlFileName( csInitialFileName ) </para>
        /// </example>
        /// <param name="csInitialFileName">イニシャルファイル名称(パス無し)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetInitialXmlFileName(HySString csInitialFileName)
        {
            m_csInitialFileName = csInitialFileName;
        }
        /// <summary><para>method outline:</para>
        /// <para>イニシャルファイル名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetInitialXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>イニシャルファイル名称(パス無し)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetInitialXmlFileName()
        {
            return m_csInitialFileName;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyXmlFileName( csPropertyFileName ) </para>
        /// </example>
        /// <param name="csPropertyFileName">プロパティファイル名称(パス無し)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPropertyXmlFileName(HySString csPropertyFileName)
        {
            m_csPrptyFileName = csPropertyFileName;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティファイル名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetPropertyXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロパティファイル名称(パス無し)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetPropertyXmlFileName()
        {
            return m_csPrptyFileName;
        }
 
        //======================================
        // 構造定義ファイル入出力関連メソッド
        //======================================

        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイルヘッダー部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteStructureHeader( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteStructureHeader(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode;
            // MainSystemタグ
            csRtnNode = csXmlWriter.CreateRoot(McDefine.xml_MAINSYSTEM);
            csRtnNode.SetAttribute(McDefine.xml_ID, (this.GetID().GetString()).ToString());
            /*
            McPropertyInfoRoot csPrpty = m_csModelInfo.GetPropertyInfo();
            if (csPrpty != null)
            {
                csRtnNode.SetAttribute(McDefine.xml_FACTORYID, csPrpty.GetFactoryID().ToString());
                csRtnNode.SetAttribute(McDefine.xml_MODEL, csPrpty.GetModelKind().ToString());
            }
            */

            if (McPropertyInfoBase.GetXmlOutFlg() == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE)
            {
                csRtnNode.SetAttribute(McDefine.xml_PROPERTY_FILE, m_csPrptyFileName.ToString());
                csRtnNode.SetAttribute(McDefine.xml_INITIAL_FILE, m_csInitialFileName.ToString());
            }
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadStructureConfiguration( csXml,csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬ</param>
        /// <param name="csMdlFctry">モデルファクトリ</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadStructureConfiguration(HySXmlReader csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = false;
            HySXmlReader csXmlReader = csXml as HySXmlReader;
            if (csXmlReader != null)
            {
                // 内部情報を此処でクリアする
                this.AllClear();

                HySXmlNode csRootNode = csXmlReader.GetRootNode();

                if (csRootNode != null)
                {
                    bRtn = base.ReadStructureConfiguration(csRootNode, csMdlFctry);
                    
                    m_csPrptyFileName=null;
                    string sPrptyFile = csXml.GetAttribute(McDefine.xml_PROPERTY_FILE);
                    if (sPrptyFile != "") { m_csPrptyFileName = new HySString(sPrptyFile); }
                    m_csInitialFileName=null;
                    string sInitFile = csXml.GetAttribute(McDefine.xml_INITIAL_FILE);
                    if (sInitFile != "") { m_csInitialFileName = new HySString(sInitFile); }
                }
                else
                {
                    // ＸＭＬファイル読込エラーの場合
                    bRtn = false;
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadStructureConfiguration( csXml,csMdlFctry,sProjectGroupName )</para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬ</param>
        /// <param name="csMdlFctry">モデルファクトリ</param>
        /// <param name="sProjectGroupName">プロジェクトグループ名</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadStructureConfiguration(HySXmlReader csXml, McModelFactorySet csMdlFctry, string sProjectGroupName)
        {
            HySXmlReader csXmlReader = csXml as HySXmlReader;
            if (csXmlReader != null)
            {
                HySXmlNode csRootNode = csXmlReader.GetRootNode();
                string sWorkAttr = csRootNode.GetAttribute(McDefine.xml_ID);
                m_csID = new HySID(sWorkAttr);

                HySCommonInfoHash.SetCorrespond(McDefine.PROJECT_GROUP_NAME, m_csID.ToString(), sProjectGroupName);
            }
            return ReadStructureConfiguration(csXml, csMdlFctry);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ定義ファイルヘッダー部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WritePropertyHeader( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WritePropertyHeader(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode=null;
            // MainSystemタグ
            csRtnNode = csXmlWriter.CreateRoot(McDefine.xml_PROPERTY_ROOT);
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadPropertyConfiguration( csXml,  csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">Xmlノード</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadPropertyConfiguration(HySXmlReader csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = false;
            HySXmlReader csXmlReader = csXml as HySXmlReader;
            if (csXmlReader != null)
            {
                // 内部情報を此処でクリアする
                //this.AllClear();  <-- クリアしてはならない

                HySXmlNode csRootNode = csXmlReader.GetRootNode();

                if (csRootNode != null)
                {
                    bRtn = base.ReadPropertyConfiguration(csRootNode, csMdlFctry);
                }
                else
                {
                    // ＸＭＬファイル読込エラーの場合
                    bRtn = false;
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期情報定義ファイルヘッダー部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteInitialHeader( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteInitialHeader(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            // MainSystemタグ
            csRtnNode = csXmlWriter.CreateRoot(McDefine.xml_INITIAL_ROOT);
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期情報定義ファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadInitialConfiguration( csXml,  csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">Xmlノード</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadInitialConfiguration(HySXmlReader csXml, McModelFactorySet csMdlFctry)
        {
            bool bRtn = false;
            HySXmlReader csXmlReader = csXml as HySXmlReader;
            if (csXmlReader != null)
            {
                // 内部情報を此処でクリアする
                // this.AllClear();  <-- クリアしてはならない 

                HySXmlNode csRootNode = csXmlReader.GetRootNode();

                if (csRootNode != null)
                {
                    bRtn = base.ReadInitialConfiguration(csRootNode, csMdlFctry);
                }
                else
                {
                    // ＸＭＬファイル読込エラーの場合
                    bRtn = false;
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>全削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = AllClear()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override bool AllClear()
        {
            base.AllClear();
            //m_csModelInfoに値を設定する
            //m_csModelInfo.SetPropertyInfo(
            //    new McGroupPropertyInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            //                                );

            m_csModelInfo = null;
            m_csModelInfo = new McModelInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, new HySObjectKind(""),
                   McModelLibraryDefine.HYM_MODEL_FIG_UNITY, McModelLibraryDefine.MODEL_NAME_SUBSYSTEM,
                   McDefine.MODEL_TYPE_GROUP);
            m_csModelInfo.SetPropertyInfo(
                new McFigUnityPropertyInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.HYM_MODEL_SUBSYSTEM, new HySTime(60))
                                         );
           
            
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CopyInf(csOrgElm)</para>
        /// </example>
        /// <param name="csOrgElm">コピー元</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyInf(McStructElement csOrgElm)
        {
            //m_lDispScale = ((McStructInfo)csOrgElm).m_lDispScale;
            //m_lAreaWidth = ((McStructInfo)csOrgElm).m_lAreaWidth;
            //m_lAreaHeight = ((McStructInfo)csOrgElm).m_lAreaHeight;

            base.CopyInf(csOrgElm);
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ化要素への変換（自身が新しいグループ化要素になる）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McStructGroupElement csGrElm = ChangeGroupElement(csModelFactory) </para>
        /// </example>
        /// <param name="csModelFactory">モデルファクトリー</param>
        /// <returns>生成されたグループ化要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在の演算系が部分系として取り込まれる場合に使用する</para>
        /// </remarks>
        public virtual McStructGroupElement ChangeGroupElement(McModelFactorySet csModelFactory)
        {
            McStructInfo csNewStructInfo = HySDataDuplicate.DupliCateData(this) as McStructInfo;
            HySString csTmpXML = HySEnvInf.GetHomeDirectory();
            csTmpXML += new HySString("\\temp\\tmpPrj.xml");

            csNewStructInfo.ChangeID(); // IDを振り直す処理


            // ID を振り直しただけでは、内部の構造を完全に修正できないので、
            // 一旦、構造定義ファイルに落としてから、再読込し　内部モデルを構築する
            //McPropertyInfoBase.SetXmlOutFlg(true); // 詳細もXML出力する
            McPropertyInfoBase.SetXmlOutFlg(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL); // 詳細もXML出力する

            // XML 詳細出力
            HySXmlWriter csOutFile = new HySXmlWriter(csTmpXML);
            HySXmlNode csNode = csNewStructInfo.WriteStructureConfiguration(ref csOutFile);
            csOutFile.Save();

            // XML を入力
            HySFile csFile = new HySFile(csTmpXML);
            if (csFile.Exist() == true)
            {
                HySXmlReader csReader = new HySXmlReader(csTmpXML);

                // McFigureUnity からコールされれば　m_csModelFactoryを知っている
                bool bRtn = csNewStructInfo.ReadStructureConfiguration(csReader, csModelFactory);
            }
            McStructGroupElement csGrElm = new McStructGroupElement();

            McModelInfo csGrModelInfo = csModelFactory.GetModelInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.HYM_MODEL_SUBSYSTEM);
            csGrElm.SetModelInfo(csGrModelInfo.Clone());
            //McModelInfo csGrModelInfo = new McModelInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, new HySObjectKind(""),
            //        McModelLibraryDefine.HYM_MODEL_SUBSYSTEM, McModelLibraryDefine.MODEL_NAME_SUBSYSTEM,
            //        McDefine.MODEL_TYPE_GROUP);
            //csGrModelInfo.SetPropertyInfo(
            //    new McGroupPropertyInfo(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            //                             );
            //csGrElm.SetModelInfo(csGrModelInfo);

            csGrElm.SetDrawSubKind(McDefine.HYM_DRAW_SUB_KIND_NONSYMBOL);

            csGrElm.CopyInf(csNewStructInfo); // 内部情報をコピーする
            return csGrElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>XML内に設定されたIDを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csID = GetXmlStructID( csXml,  csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">Xmlノード</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>HySID XML内のID値（不明の時は、""が設定される）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetXmlStructID(HySXmlReader csXml, McModelFactorySet csMdlFctry)
        {
            HySID csRtn = new HySID("");
            HySXmlReader csXmlReader = csXml as HySXmlReader;
            if (csXmlReader != null)
            {
                HySXmlNode csRootNode = csXmlReader.GetRootNode();
                if (csRootNode != null)
                {
                    string sWorkAttr;
                    // 識別子
                    sWorkAttr = csXml.GetAttribute(McDefine.xml_ID);
                    //m_csID = new HySID(sWorkAttr, "", "");
                    csRtn = new HySID(sWorkAttr);
                }
            }
            return csRtn;
        }
        // 構造定義ファイル名等操作用ツール
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル名称作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MakeCSFName(csSCFNameWithPath, ref csPath, ref csSCFileName, ref csPrptyFileName, ref csInitialFileName, ref csPrjctFileName)</para>
        /// </example>
        /// <param name="csSCFNameWithPath">パス付きファイル名称</param>
        /// <param name="csPath">ファイルへのパス</param>
        /// <param name="csSCFileName">パス無しファイル名</param>
        /// <param name="csPrptyFileName">プロパティファイル名</param>
        /// <param name="csInitialFileName">イニシャルファイル名</param>
        /// <param name="csPrjctFileName">プロジェクトファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MakeCSFName(HySString csSCFNameWithPath, ref HySString csPath, ref HySString csSCFileName, ref HySString csPrptyFileName, ref HySString csInitialFileName, ref HySString csPrjctFileName)
        {
            string sFileName = "";
            string sFileNameWithoutSfx = "";
            string sPath = "";
            this.GetFileNameString(csSCFNameWithPath, ref sFileName, ref sFileNameWithoutSfx, ref sPath);
            csPath.SetChar(sPath);
            csSCFileName.SetChar(sFileName);
            // プロジェクトファイル名
            csPrjctFileName.SetChar("" + sFileNameWithoutSfx + "ProjectFile.xml");
            // イニシャルファイル名
            csInitialFileName.SetChar("" + sFileNameWithoutSfx + "Initial.xml");
            // プロパティファイル名
            csPrptyFileName.SetChar("" + sFileNameWithoutSfx + "Property.xml");
        }
        /// <summary><para>method outline:</para>
        /// <para>ファイル名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = GetFileNameString(sSCFNameWithPath, ref sFileName, ref sFileNameWithoutSfx, ref sPath)</para>
        /// </example>
        /// <param name="sSCFNameWithPath">パス付きファイル名称</param>
        /// <param name="sFileName">パス無しファイル名</param>
        /// <param name="sFileNameWithoutSfx">X添え字無しファイル名</param>
        /// <param name="sPath">ファイルへのパス</param>
        /// <returns>bool =true:正常、=false:異常 </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetFileNameString(HySString sSCFNameWithPath, ref string sFileName, ref string sFileNameWithoutSfx, ref string sPath)
        {
            string sFileNamePath = sSCFNameWithPath.ToString();
            int lLstPathIdx = -1; int lTmpLstPathIdx = -1;
            for (long lStr = 0; lStr < sSCFNameWithPath.GetLength(); lStr++)
            {
                lTmpLstPathIdx = sFileNamePath.IndexOf("\\", lLstPathIdx + 1);
                if (lTmpLstPathIdx >= 0)
                { lLstPathIdx = lTmpLstPathIdx; }
                else
                { break; }
            }
            sFileName = sFileNamePath.Substring(lLstPathIdx + 1);
            sFileNameWithoutSfx = sFileName.Substring(0, sFileName.Length - 4);
            if (lLstPathIdx > -1)
            {
                sPath = sFileNamePath.Substring(0, lLstPathIdx);
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = ProjectXML( ref csXmlWriter,csSCFName )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <param name="csSCFName">構造定義ファイル名</param>
        /// <param name="csStartTime">開始時刻</param>
        /// <param name="csGoalTime">終了時刻</param>
        /// <param name="csDltTime">Δｔ</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode ProjectXML(ref HySXmlWriter csXmlWriter, HySString csSCFName, HySTime csStartTime, HySTime csGoalTime, HySTime csDltTime )
        {
            HySXmlNode csRtnNode;
            // プロジェクトルート
            csRtnNode = csXmlWriter.CreateRoot(McDefine.xml_PROJECT);

            string sPrjctGrName = "";
            HySCommonInfoHash.GetCorrespond(McDefine.PROJECT_GROUP_NAME, this.m_csID.ToString(), ref sPrjctGrName);
            if (sPrjctGrName != "")
            {
                csRtnNode.SetAttribute(McDefine.xml_PROJECT_GROUP, sPrjctGrName);
            }

            HySXmlNode csNode = csXmlWriter.CreateElement(McDefine.xml_PRJCT_SCF);
            csNode.SetAttribute(McDefine.xml_PRJCT_SCF_NAME, csSCFName.ToString());
            csRtnNode.AppendChild(csNode);

            csNode = csXmlWriter.CreateElement(McDefine.xml_PRJCT_SIMULATION);
            HySXmlNode csSubNode = csXmlWriter.CreateElement(McDefine.xml_PRJCT_TIME);
            csSubNode.SetAttribute(McDefine.xml_PRJCT_START_TIME, (HySCalendar.ToString(csStartTime, HySCalendar.FORMAT.lSW_YEAR)));
            //csNode.SetAttribute(McDefine.xml_PRJCT_PAUSE_TIME, HySCalendar.ToString(m_csDataContainer.GetStartTime(), HySCalendar.FORMAT.lSW_YEAR));
            csSubNode.SetAttribute(McDefine.xml_PRJCT_GOAL_TIME, HySCalendar.ToString(csGoalTime, HySCalendar.FORMAT.lSW_YEAR));
            csSubNode.SetAttribute(McDefine.xml_PRJCT_DELTA_TIME, csDltTime.GetTime().ToString());
            csSubNode.SetAttribute(McDefine.xml_PRJCT_TIME_UNIT, "sec");
            csNode.AppendChild(csSubNode);
            csRtnNode.AppendChild(csNode);
            return csRtnNode;
        }


        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfoRoot csInf = GetPropertyInfo(csElmID)</para>
        /// </example>
        /// <param name="csElmID">要素モデルのＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McPropertyInfoRoot GetPropertyInfo(HySID csElmID)
        {
            McPropertyInfoRoot csRtn = null;
            McStructElement csElm = this.GetElementByID(csElmID);
            if (csElm != null)
            {
                McModelInfo csMdlInf = csElm.GetModelInfo();
                if (csMdlInf != null)
                {
                    csRtn = csMdlInf.GetPropertyInfo();
                }
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfoRoot csInf = GetPropertyInfo(csUserElmName)</para>
        /// </example>
        /// <param name="csUserElmName">ユーザー定義要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McPropertyInfoRoot GetPropertyInfo(HySString csUserElmName)
        {
            McPropertyInfoRoot csRtn = null;
            McStructElement csElm = this.GetElementByUserName(csUserElmName);
            if (csElm != null)
            {
                McModelInfo csMdlInf = csElm.GetModelInfo();
                if (csMdlInf != null)
                {
                    csRtn = csMdlInf.GetPropertyInfo();
                }
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInf = GetInitialInfo(csElmID) </para>
        /// </example>
        /// <param name="csElmID">要素モデルのＩＤ</param>
        /// <returns>McPropertyInfoRoot  初期化情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McPropertyInfoRoot GetInitialInfo(HySID csElmID)
        {
            McPropertyInfoRoot csRtn = null;
            McStructElement csElm = this.GetElementByID(csElmID);
            if (csElm != null)
            {
                McModelInfo csMdlInf = csElm.GetModelInfo();
                if (csMdlInf != null)
                {
                    csRtn = csMdlInf.GetInitialInfo();
                }
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInf = GetInitialInfo(csUserElmName) </para>
        /// </example>
        /// <param name="csUserElmName">ユーザー定義要素名称</param>
        /// <returns>McPropertyInfoRoot  初期化情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McPropertyInfoRoot GetInitialInfo(HySString csUserElmName)
        {
            McPropertyInfoRoot csRtn = null;
            McStructElement csElm = this.GetElementByUserName(csUserElmName);
            if (csElm != null)
            {
                McModelInfo csMdlInf = csElm.GetModelInfo();
                if (csMdlInf != null)
                {
                    csRtn = csMdlInf.GetInitialInfo();
                }
            }
            return csRtn;
        }

//------------
// start of レコード数自動調整の為の処理を追加
//  Ver1.2
//------------

        /// <summary><para>method outline:</para>
        /// <para>要素モデル間接続線の最大レコード数自動調整</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = OptimizeTranInfoRecord(csModelFactory)</para>
        /// </example>
        /// <param name="csModelFactory">モデルファクトリ：内部で生成されるモデルがMcStateCalModelBaseか否かを調べる時に使用する</param>
        /// <returns> long
        /// 正常時：McDefine.CALCULATION_NORMAL_RETURN
        /// 自動調整不能時：McDefine.CALCULATION_CANNOT_OPTIMIZE_RETURN
        /// 異常時：McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 自動調整不能時：McDefine.CALCULATION_CANNOT_OPTIMIZE_RETURNが返るのは、
        /// 内部に部分系以外のグループ化要素（自作グループ化要素）を持っている場合。
        /// ＜アルゴリズム概要は下記＞
        /// 同期ならば
        ///    (系の⊿／前要素δ)＋２
        /// 非同期ならば
        ///   １. （系⊿／前要素δ）＋２
        ///   ２. （後要素δ／前要素δ）＋２
        ///   ３．（CalState型が存在するとき）
        ///      ３．１　上流に存在する CalState型で一番大きいδを求める＝＞Δ
        ///      ３．２　（上記Δ/後要素δ） ＋２
        ///   １～３までのうち一番大きい数をレコード数として採用
        /// </para>
        /// </remarks>
        virtual public long OptimizeTranInfoRecord(McModelFactorySet csModelFactory)
        {
            long lRtn = McDefine.CALCULATION_NORMAL_RETURN;
            try
            {
                // 最初に最適化処理可能かを調べる
                if (this.CanOptimizeTranInfoRecord() == true)
                {
                    // 同期ならば
                    //    (系の⊿／前要素δ)＋２
                    // 非同期ならば
                    //   １. （系⊿／前要素δ）＋２
                    lRtn = this.OptimizeTranInfoRecordStep1();

                    if (lRtn == McDefine.CALCULATION_NORMAL_RETURN)
                    {
                        //   ２. （後要素δ／前要素δ）＋２
                        lRtn = this.OptimizeTranInfoRecordStep2();
                    }

                    if (lRtn == McDefine.CALCULATION_NORMAL_RETURN)
                    {
                        //   ３．（CalState型が存在するとき）
                        //      ３．１　上流に存在する CalState型で一番大きいδとシステムΔ のうち大きい方を求める＝＞Δ
                        //      ３．２　（上記Δ/後要素δ） ＋２
                        //   １～３までのうち一番大きい数をレコード数として採用
                        Hashtable csDltTSetTbl = new Hashtable();
                        this.OptimizeTranInfoRecordStep3Initialize(ref csDltTSetTbl);  // ハッシュテーブル初期化
                        if (this.OptimizeTranInfoRecordStep3SetDlt(ref csDltTSetTbl, csModelFactory) > 0)
                        {   // 内部にCalState型が存在するならば
                            lRtn = this.OptimizeTranInfoRecordStep3(ref csDltTSetTbl);
                        }
                    }
                }
                else
                {
                    lRtn = McDefine.CALCULATION_CANNOT_OPTIMIZE_RETURN;
                }
            }
            catch(Exception ex)
            {   // 何らかの例外処理を発生したとき
                lRtn = McDefine.CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR;
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "McStructInfo", "OptimizeTranInfoRecord",
                    Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + "(" + ex.Message + "):" + ex.StackTrace);
               // HySLog.LogOut(HySLog.TRIAL_RUN, "McStructInfo", "OptimizeTranInfoRecord", "catch Exception:(" + ex.Message + "):" + ex.StackTrace);
            }
            return lRtn;
        }

//------------
// end  of レコード数自動調整の為の処理を追加
//  Ver1.2
//------------

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
