﻿// <summary>ソースコード：接続構造（グループ外へ出力する）中継端子</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Model;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary><para>class outline:</para>
    /// <para>接続構造（グループ外へ出力する）中継端子</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/27][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McStructTranOUTPort : McStructTransPort, HySVersionManagement
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructTranOUTPort csPort = new McStructTranOUTPort()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>後で本コンストラクタは消える</para>
        /// </remarks>
        public McStructTranOUTPort()
            : base(McDefine.SymbolDrawKind.HYM_TRANS_OUT)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>端子接続ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPortID( csFromID, csToID )</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetPortID(HySIdentifier csFromID, HySIdentifier csToID)
        {
            m_csFromPortID = csFromID;
            m_csToPortID = csToID; // 自身のID
        }
        /// <summary><para>method outline:</para>
        /// <para>端子接続ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetPortID( ref csFromID, ref csToID )</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void GetPortID(ref HySIdentifier csFromID, ref HySIdentifier csToID)
        {
            csFromID = m_csID; // 自身のID
            csToID = m_csToPortID;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部向け端子情報ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInnerPortID(csFromID,csToID)</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetInnerPortID(HySIdentifier csFromID, HySIdentifier csToID)
        {
            m_csInternalFromID = csFromID;
            m_csInternalToID = csToID;
        }
        /// <summary><para>method outline:</para>
        /// <para>内部向け端子情報ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetInnerPortID(ref csFromID, ref csToID)</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void GetInnerPortID(ref HySIdentifier csFromID, ref HySIdentifier csToID)
        {
            csFromID = m_csInternalFromID;
            csToID = m_csID;
        }

        //======================================
        // 構造定義ファイル入出力関連メソッド
        //======================================
        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル本体部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteStructureBody( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override HySXmlNode WriteStructureBody(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtnNode = null;
            // SendTerminalタグ
            csRtnNode = HySXmlNode.CreateElement(McDefine.xml_SEND_TERMINAL, csXmlWriter);
            csRtnNode.SetAttribute(McDefine.xml_ID, m_csID.GetString().ToString());
            csRtnNode.SetAttribute(McDefine.xml_DIRECTION, m_lRotate.ToString());
            csRtnNode.SetAttribute(McDefine.xml_InnerX, m_lInnerX.ToString());
            csRtnNode.SetAttribute(McDefine.xml_InnerY, m_lInnerY.ToString());
            csRtnNode.SetAttribute(McDefine.xml_X, m_lX.ToString());
            csRtnNode.SetAttribute(McDefine.xml_Y, m_lY.ToString());
            return csRtnNode;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部に含まれる部品のIDを変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続線、ポートのID含む</para>
        /// </remarks>
        internal override HySID ChangeID()
        {
            // 自身のID設定
            McStructPort.m_ulPrimNo += 1;
            string sStr = DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString()
                        + "-" + DateTime.Now.Day.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Year.ToString();
            //m_csID = new HySID("Rly:Snd" + McStructTransPort.GetPrimNo().ToString() + DateTime.Now.Second.ToString() + "-", ((long)McDefine.SymbolDrawKind.HYM_TRANS_OUT).ToString(), sStr);
            m_csID = new HySID(
                "Rly:Snd" + McStructTransPort.GetPrimNo().ToString() + DateTime.Now.Second.ToString() + "-"
                + ((long)McDefine.SymbolDrawKind.HYM_TRANS_OUT).ToString()
                + sStr);


            return m_csID as HySID;
        }


        // ================================================
        //   Undo/Redo用処理
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructPort csStructPort = CopyInfUsedByUndoRedoOnly(csCopyElement)</para>
        /// </example>
        /// <param name="csCopyElement">複製要素</param>
        /// <returns>McStructPort 複製要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public override McStructPort CopyInfUsedByUndoRedoOnly(McStructPort csCopyElement)
        {
            if (csCopyElement == null)
            {
                csCopyElement = new McStructTranOUTPort();
            }

            base.CopyInfUsedByUndoRedoOnly(csCopyElement);

            return csCopyElement;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
