﻿// <summary>ソースコード：接続構造中継端子</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.StructInfo
{
    /// <summary><para>class outline:</para>
    /// <para>接続構造中継端子クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/27][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McStructTransPort : McStructPort
    {

        /// <summary>内部への接続元端子ID</summary>
        protected HySIdentifier m_csInternalFromID;
        /// <summary>内部への接続先端子ID</summary>
        protected HySIdentifier m_csInternalToID;
        /// <summary>内部描画位置(X)</summary>
        protected long m_lInnerX;
        /// <summary>内部描画位置(Y)</summary>
        protected long m_lInnerY;

        /// <summary> 中継端子（送信）ＩＤ種別 </summary>
        static protected readonly string RELAY_SEND = "Rly:Snd";
        /// <summary> 中継端子（受信）ＩＤ種別 </summary>
        static protected readonly string RELAY_RECEIVE = "Rly:Rcv";

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructTransPort csPort = new McStructTransPort(eKind)</para>
        /// </example>
        /// <param name="eKind">シンボル描画種別</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructTransPort(McDefine.SymbolDrawKind eKind)
            : base(eKind)
        {
            m_csInternalFromID = new HySID("");
            m_csInternalToID = new HySID("");

            // IDを端子系から中継端子系へ変更
            if (m_csID.ToString().Substring(0, 1) == "P")
            {
                if (eKind == McDefine.SymbolDrawKind.HYM_TRANS_IN)
                {
                    m_csID = new HySID(RELAY_RECEIVE + m_csID.ToString().Substring(1, m_csID.ToString().Length - 1));
                }
                else
                {
                    m_csID = new HySID(RELAY_SEND + m_csID.ToString().Substring(1, m_csID.ToString().Length - 1));
                }
            }

            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>内部向け端子情報ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInnerPortID(csFromID,csToID)</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetInnerPortID(HySIdentifier csFromID, HySIdentifier csToID)
        {
            m_csInternalFromID = csFromID;
            m_csInternalToID = csToID;
        }
        /// <summary><para>method outline:</para>
        /// <para>内部向け端子情報ID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetInnerPortID(ref csFromID, ref csToID)</para>
        /// </example>
        /// <param name="csFromID">接続元ID</param>
        /// <param name="csToID">接続先ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetInnerPortID(ref HySIdentifier csFromID, ref HySIdentifier csToID)
        {
            csFromID = m_csInternalFromID;
            csToID = m_csInternalToID;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部描画位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInnerPosition(lInnerX,lInnerY)</para>
        /// </example>
        /// <param name="lInnerX">内部描画位置X</param>
        /// <param name="lInnerY">内部描画位置Y</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetInnerPosition(long lInnerX, long lInnerY)
        {
            m_lInnerX = lInnerX;
            m_lInnerY = lInnerY;
        }
        /// <summary><para>method outline:</para>
        /// <para>内部描画位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetInnerPosition(ref lInnerX, ref lInnerY)</para>
        /// </example>
        /// <param name="lInnerX">内部描画位置X</param>
        /// <param name="lInnerY">内部描画位置Y</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetInnerPosition(ref long lInnerX, ref long lInnerY)
        {
            lInnerX = m_lInnerX;
            lInnerY = m_lInnerY;
        }

        /// <summary><para>method outline:</para>
        /// <para>全削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Free()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override void Free()
        {
            m_csInternalFromID=null;
            base.Free();
        }

        /// <summary><para>method outline:</para>
        /// <para>構造定義ＸＭＬ入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadStructureBody( csXml, csMdlFctry )</para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬ</param>
        /// <param name="csMdlFctry">モデルファクトリクラス</param>
        /// <returns>true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool ReadStructureBody(CommonMP.HYSSOP.CoreImpl.HSTools.HySXmlNode csXml, CommonMP.HYMCO.CoreImpl.Model.McModelFactorySet csMdlFctry)
        {
            string sDirection = csXml.GetAttribute(McDefine.xml_DIRECTION);
            if (sDirection != "") { m_lRotate = long.Parse(sDirection); }
            string sInnerX = csXml.GetAttribute(McDefine.xml_InnerX);
            if (sInnerX != "") { m_lInnerX = long.Parse(sInnerX); }
            string sInnerY = csXml.GetAttribute(McDefine.xml_InnerY);
            if (sInnerY != "") { m_lInnerY = long.Parse(sInnerY); }
            string sX = csXml.GetAttribute(McDefine.xml_X);
            if (sX != "") { m_lX = long.Parse(sX); }
            string sY = csXml.GetAttribute(McDefine.xml_Y);
            if (sY != "") { m_lY = long.Parse(sY); }

            return true;
        }


        // ================================================
        //   Undo/Redo用処理
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>情報のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McStructPort csStructPort = CopyInfUsedByUndoRedoOnly(csCopyElement)</para>
        /// </example>
        /// <param name="csCopyElement">複製要素</param>
        /// <returns>McStructPort 複製要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GUIでのUndo/Redoのみ使用、その他は使用禁止</para>
        /// </remarks>
        public override McStructPort CopyInfUsedByUndoRedoOnly(McStructPort csCopyElement)
        {
            if (csCopyElement == null)
            {
                csCopyElement = new McStructTransPort(GetSymbolDrawKind());
            }

            base.CopyInfUsedByUndoRedoOnly(csCopyElement);

            ((McStructTransPort)csCopyElement).m_csInternalFromID = m_csInternalFromID;
            ((McStructTransPort)csCopyElement).m_csInternalToID = m_csInternalToID;
            ((McStructTransPort)csCopyElement).m_lInnerX = m_lInnerX;
            ((McStructTransPort)csCopyElement).m_lInnerY = m_lInnerY;

            return csCopyElement;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        //
    }
}
