﻿// <summary>ソースコード：>ＨＹＭＣＯ汎用 ２次元情報 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.TranInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>汎用２次元情報 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>２次元配列情報(double)を保持できる</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McD2CellArrayTranInfo : HySD2CellArrayData, McTimeRecordIF, McTranInfo, McTranInfoIFCellType, HySVersionManagement
    {
        /// <summary> 伝送データ共通情報　</summary>
        protected McTranInfoCommon m_csCommonInfo = new McTranInfoCommon();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McD2CellArrayTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        private McD2CellArrayTranInfo() : base(1, 1, 1)
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csMeshData = new McD2CellArrayTranInfo( csPropertyInfo ) </para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>McD2CellArrayTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McD2CellArrayTranInfo(McPropertyInfoRoot csPropertyInfo)
            : base( ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetDim1(),
                    ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetDim2(),
                    ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetDimInCell())
        {
            McTranInfoPattern csTranInfoPattern = ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetSendTranInfoPattern() as McTranInfoPattern;
            if (csTranInfoPattern != null)
            {
                //((McCellArrayTranInfoPropertyInfo)csPropertyInfo).SetDimInCell(csTranInfoPattern.GetCellDataCharacteristic().GetDataNumber());
            }

            this.SetCellIDMngData(((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetCellIDMngData() as HySCellIDManageData);

            m_csCommonInfo.CreateMcReceiveCellData((McCellArrayTranInfoPropertyInfo)csPropertyInfo);
            m_csCommonInfo.GetReceiveCellData().SetTranInfo(this);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csData = new McD2CellArrayTranInfo(lCellDim1, lCellDim2, lDataDimInCell) </para>
        /// </example>
        /// <param name="lCellDim1">セル配列数</param>
        /// <param name="lCellDim2">第２セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <returns>McD2CellArrayTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McD2CellArrayTranInfo(long lCellDim1, long lCellDim2, long lDataDimInCell)
            : base(lCellDim1, lCellDim2, lDataDimInCell)
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>内部処理用コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McD2CellArrayTranInfo csData = new McD2CellArrayTranInfo(lCellDim1, lCellDim2, lDataDimInCell, false); </para>
        /// </example>
        /// <param name="lCellDim1">第１セル配列数</param>
        /// <param name="lCellDim2">第２セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <param name="bSW">常にfalse</param>
        /// <returns> McD2CellArrayTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>内部処理用：
        ///   時系列情報として情報を設定するとき　各レコード間に共通な情報を
        /// 　内部に冗長な情報として持たないように、共通情報の生成を止めて生成する
        /// </para>
        /// </remarks>
        internal McD2CellArrayTranInfo(long lCellDim1, long lCellDim2, long lDataDimInCell, bool bSW)
            : base(lCellDim1, lCellDim2, lDataDimInCell)
        {
            this.NullClearCellDataKind();
            m_csCommonInfo = null;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        {
            base.SetCellDataCharacteristic(csCellChara);
            m_csCommonInfo.SetCellDataCharacteristic(csCellChara);
        }
        /// <summary><para>method outline:</para>
        /// <para>同一種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SameKind( csTranInfo ) </para>
        /// </example>
        /// <param name="csTranInfo">比較する伝送データ</param>
        /// <returns> bool true :同一種別 , false:異種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>入力情報が null の場合には　false で返す</para>
        /// </remarks>
        public virtual bool SameKind(McTranInfo csTranInfo)
        {
            bool bRtn = false;
            if (csTranInfo != null)
            {
                if (csTranInfo is McD2CellArrayTranInfo)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部蓄積データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ResetData()
        {
            m_csCellArray = new HySCellData[m_lDim1, m_lDim2];
            for (long lLp2 = 0; lLp2 < m_lDim2; lLp2++)
            {
                for (long lLp1 = 0; lLp1 < m_lDim1; lLp1++)
                {
                    m_csCellArray[lLp1, lLp2] = new HySCellData(m_lDataDimInCell);
                }
            }
        }
        /// <summary>
        /// S.H.　内部データクリア
        /// </summary>
        public override void ClearData()
        {
            for (long lLp2 = 0; lLp2 < m_lDim2; lLp2++)
            {
                for (long lLp1 = 0; lLp1 < m_lDim1; lLp1++)
                {
                    m_csCellArray[lLp1, lLp2].ClearData();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo Clone( )
        {
            McD2CellArrayTranInfo csRtnObj = null;
            if (this.m_csCellDataKind != null)
            {
                csRtnObj = new McD2CellArrayTranInfo(m_lDim1,m_lDim2, m_csCellDataKind.m_lDim);
            }
            else
            {
                csRtnObj = new McD2CellArrayTranInfo(m_lDim1,m_lDim2, m_lDataDimInCell, false);
            }
            csRtnObj.CopyInfo(this);
            return csRtnObj;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CopyInfo(McTranInfo csOrgInfo)
        {
            McD2CellArrayTranInfo csOrgTrnInfo = csOrgInfo as McD2CellArrayTranInfo;
            if (csOrgTrnInfo == null)
            {
                return false;
            }
            base.CopyData((HySD2CellArrayData)csOrgTrnInfo);
            if (m_csCommonInfo != null)
            {
                m_csCommonInfo.CopyInfo(csOrgTrnInfo.m_csCommonInfo);
            }

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public virtual bool LastDataCopy(McTranInfo csOrgInfo)
        {
            return LatestDataCopy((McTimeRecordIF)csOrgInfo);
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public virtual bool LatestDataCopy(McTimeRecordIF csOrgInfo)
        {
            bool bRtn = false;
            McD2CellArrayTranInfo csOrgTrnInfo = csOrgInfo as McD2CellArrayTranInfo;
            if (csOrgTrnInfo != null)
            {
                if (this.Before(csOrgTrnInfo.GetLastTime()) == true)
                {   // 与えられたデータが、自分よりも新しい（同一時刻も含む）
                    bRtn = true;
                    this.CopyInfo(csOrgTrnInfo);
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans(csOrgTran)</para>
        /// </example>
        /// <param name="csOrgTran">上流側の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void MakeRelayPortDataTransContinuity(McTranInfo csOrgTran)
        {
            // Do Nothing
        }
        // ================================================
        // プロパティ設定関連
        // ================================================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetProperty(McPropertyInfoRoot csPropertyInfo)
        {
            McCellArrayTranInfoPropertyInfo csCellPrpyt = csPropertyInfo as McCellArrayTranInfoPropertyInfo;
            if (csCellPrpyt == null) { return; }
            // 受信設定
            McTranInfoPattern csRsvPtn = csCellPrpyt.GetReceiveTranInfoPattern() as McTranInfoPattern;
            if (csRsvPtn == null)
            {   // 受信パターンが未設定とみてリコメンド設定を行う
                //csRsvPtn = csCellPrpyt.GetRecommendReceiveCellPattern();
            }
            // 改めて設定
            McReceiveCellData csRcvCellDt = m_csCommonInfo.GetReceiveCellData() as McReceiveCellData;
            if (csRsvPtn != null)
            {
                //m_csCellDataKind = csRsvPtn.GetCellDataCharacteristic();
                m_csCommonInfo.CreateMcReceiveCellData(csCellPrpyt);
                csRcvCellDt = m_csCommonInfo.GetReceiveCellData() as McReceiveCellData;

                csRcvCellDt.SetInterpolateType(csRsvPtn.GetInterpolateType());
                m_csCommonInfo.SetInterpolateType(csRsvPtn.GetInterpolateType());
            }
            csRcvCellDt.SetCellDataGetter(csCellPrpyt.GetCellDataGetter());   // <-- これは重要
            csRcvCellDt.SetTranInfo(this);

            // 送信設定
            McTranInfoPattern csSndPtn = csCellPrpyt.GetSendTranInfoPattern() as McTranInfoPattern;
            if (csSndPtn == null)
            {   // 受信パターンが未設定とみてリコメンド設定を行う
                //csSndPtn = csCellPrpyt.GetRecommendSendCellPattern();
            }
            // 改めて設定
            if (csSndPtn != null)
            {
                m_csCellDataKind = csSndPtn.GetCellDataCharacteristic();

                m_csCommonInfo.CreateSendCellData(csCellPrpyt);
                McSendCellData csCellDt = m_csCommonInfo.GetSendCellData() as McSendCellData;
                csCellDt.SetTranInfoPattern(csSndPtn);
                csCellDt.SetID(csSndPtn.GetPatternID());
                csCellDt.SetTranInfo(this);

                long lTD1 = 0; long lTD2 = 0; long lTD3 = 0; long lDataDimInCell = 0; // パターン側の配列
                long lCellDim = csSndPtn.GetDimension(ref lTD1, ref lTD2, ref lTD3, ref lDataDimInCell);

                lTD1 = csCellPrpyt.GetDim1();
                lTD2 = csCellPrpyt.GetDim2();
                this.Init(lTD1, lTD2, lDataDimInCell, true);
            }
            m_csCellIDMngData = csCellPrpyt.GetCellIDMngData() as HySCellIDManageData;

        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        public virtual void SetOnlineProperty(McPropertyInfoRoot csPropertyInfo)
        {
            // Do Nothing
        }
        // ================================================
        // 共通情報設定
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>接続線共通情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranCommonCellDataIF csCnnctInf = GetCommonInf( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranCommonCellDataIF 接続線共通情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の共通情報を取得する</para>
        /// </remarks>
        public virtual McTranCommonCellDataIF GetCommonInf()
        {
            return m_csCommonInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 接続線ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        public virtual HySID GetConnectionID()
        {
            return m_csCommonInfo.GetConnectionID();
        }
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        public virtual HySString GetConnectionName()
        {
            return m_csCommonInfo.GetConnectionName();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual HySID GetUpperElementID()
        {
            return m_csCommonInfo.GetUpperElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetLowerElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual HySID GetLowerElementID()
        {
            return m_csCommonInfo.GetLowerElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 上流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual McElement GetUpperElement()
        {
            return m_csCommonInfo.GetUpperElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 下流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual McElement GetLowerElement()
        {
            return m_csCommonInfo.GetLowerElement();
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellGetter); </para>
        /// </example>
        /// <param name="csCellGetter">セル内データ取得クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataGetter(HySCellDataGetter csCellGetter)
        {
            m_csCommonInfo.SetCellDataGetter(csCellGetter);
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellDataGetter GetCellDataGetter()
        {
            return m_csCommonInfo.GetCellDataGetter();
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McReceiveCellDataIF csRevDt = GetReceiveCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McReceiveCellDataIF 受信したセル型情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報本体をを取得する</para>
        /// </remarks>
        public virtual McReceiveCellDataIF GetReceiveCellData()
        {
            return m_csCommonInfo.GetReceiveCellData();
        }
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csSndDt = GetSendCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF 送信するセル型情報設定クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報を設定する</para>
        /// </remarks>
        public virtual McSendCellDataIF GetSendCellData()
        {
            return m_csCommonInfo.GetSendCellData();
        }
        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3)
        {
            lDim1 = base.GetDimension1();
            lDim2 = base.GetDimension2();
            lDim3 = 0;
            return 2;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終セルデータ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csCellArry = GetLastCellArrayData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellArray セル配列データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellArray GetLastCellArrayData()
        { return this; }

        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySObjectKind GetTranInfoKind()
        { return McTranInfoDefine.D2_CELL; }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
