// <summary>ソースコード：>ＨＹＭＣＯ１次元時系列情報 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.TranInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>セル１つの　時系列管理 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/06][修正]
    /// </para>
    /// <para>remarks:</para>
    /// <para>たった一つのセルの　時系列情報を保持できる</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McTimeSeriesSingleCellTranInfo : HySTimeSeriesD1CellArrayData, McTranInfo, McTranInfoIFCellType, McTranInfoIFTimeSeriesType, HySVersionManagement
    {
        /// <summary> 伝送データ共通情報　</summary>
        protected McTranInfoCommon m_csCommonInfo = new McTranInfoCommon();

        /// <summary>レコードプールを使用するためのレコード種別保管</summary>
        protected HySObjectKind m_csRecordKind;
        //★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(伝送情報の事前作成)
        //★★★★★★★★★★★★★★★★★
        /// <summary>プールに対するアクション実施有無フラグ</summary>
        protected bool m_bCallFlg = false;
        /// <summary>プロジェクトID</summary>
        protected string m_sPrjID = "";

        //// <summary> ワーク用セル配列 </summary>
        //protected HySCellData[] m_csCellArryWork = new HySCellData[1];
        
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csMeshData = new McTimeSeriesD1CellArrayTranInfo( csPropertyInfo ) </para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>McTimeSeriesD1CellArrayTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTimeSeriesSingleCellTranInfo(McPropertyInfoRoot csPropertyInfo)
            : base( 1,
                    ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetDimInCell()
                    )
        {


            //★★★★★★★
            // Ver1.4で追加
            //★★★★★★★
            long lDataDimInCell = 0;
            McTranInfoPattern csTranInfoPattern = ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetSendTranInfoPattern() as McTranInfoPattern;
            if (csTranInfoPattern != null)
            {
                //((McCellArrayTranInfoPropertyInfo)csPropertyInfo).SetDimInCell(csTranInfoPattern.GetCellDataCharacteristic().GetDataNumber());
                //★★★★★★★
                // Ver1.4で追加
                //★★★★★★★
                long lTD1 = 0; long lTD2 = 0; long lTD3 = 0; // パターン側の配列
                long lCellDim = csTranInfoPattern.GetDimension(ref lTD1, ref lTD2, ref lTD3, ref lDataDimInCell);
            }

            m_lMaxDataNum = ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetMaxRecordDataNum();

            this.SetCellIDMngData( ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetCellIDMngData() as HySCellIDManageData );

            m_csCommonInfo.CreateMcReceiveCellData((McCellArrayTranInfoPropertyInfo)csPropertyInfo);
            m_csCommonInfo.GetReceiveCellData().SetTranInfo(this);
// 此処で、McCellIDMngDataのセットを行う必要がある。
//            m_csCommonInfo.GetReceiveCellData().SetCellIDData( ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetCellIDMngData())

            //★★★★★★★
            // Ver1.4で削除
            //★★★★★★★
            //long lDataDimInCell = ((McCellArrayTranInfoPropertyInfo)csPropertyInfo).GetDimInCell();
            Init(lDataDimInCell);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = new McTimeSeriesD1CellArrayTranInfo() </para>
        /// </example>
        /// <returns>McTimeSeriesSingleCellTranInfo  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>保持できるレコード数はMax64まで</para>
        /// </remarks>
        protected McTimeSeriesSingleCellTranInfo()
            : base(1, 8)
        {
            Init(8);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = new McTimeSeriesD1CellArrayTranInfo(lDataDimInCell,lMaxDataNum) </para>
        /// </example>
        /// <param name="lDataDimInCell">セル内情報配列数</param>
        /// <param name="lMaxDataNum">最大レコード数（指定された数までレコードを保持できる）</param>
        /// <returns>McTimeSeriesSingleCellTranInfo  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McTimeSeriesSingleCellTranInfo(long lDataDimInCell, long lMaxDataNum)
            : base(1, lDataDimInCell)
        {
            Init(lDataDimInCell);
            m_lMaxDataNum = lMaxDataNum;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lDataDimInCell) </para>
        /// </example>
        /// <param name="lDataDimInCell">セル内情報配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected void Init(long lDataDimInCell)
        {
            // プールへの登録
            HySString csRecordKind = new HySString(typeof(McD1CellArrayTranInfo).FullName + "[1][" + lDataDimInCell.ToString() + "]");
            m_csRecordKind = new HySObjectKind(csRecordKind);
            //★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(伝送情報の事前作成)
            //★★★★★★★★★★★★★★★★★
            // 下記は一度だけ呼び出し
            if (m_bCallFlg == false && m_csCommonInfo.GetSendCellData() != null)
            {
                //★★★★★★★★★★★★★★
                // Ver1.4で追加(共有化の選択)
                //★★★★★★★★★★★★★★
                bool bChkFlg = false;// 設定ファイルから取得
                HySString csChkString = HySEnvInf.GetEnvInf("HYMCO_CELL_SERIAL_COMMON_USE");
                if ((object)csChkString != null)
                {
                    bChkFlg = Convert.ToBoolean(csChkString.ToString());
                }
                if (bChkFlg == true)
                {
                    McTranInfoDataPool.RegistData(m_sPrjID, m_csRecordKind, new McD1CellArrayTranInfo(1, lDataDimInCell, false));
                }
                else
                {
                    McTranInfoDataPool.RegistData("", m_csRecordKind, new McD1CellArrayTranInfo(1, lDataDimInCell, false));
                }
                m_bCallFlg = true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McD1CellArrayTranInfo csNewRecord = NewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McD1CellArrayTranInfo 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McD1CellArrayTranInfo NewRecord()
        {
            // プールから情報をGetしてくる
            //★★★★★★★★★★★★★★★★★★
            // Ver1.4で追加(インスタンスの共有化)
            //★★★★★★★★★★★★★★★★★★
            //★★★★★★★★★★★★★★
            // Ver1.4で追加(共有化の選択)
            //★★★★★★★★★★★★★★
            bool bChkFlg = false;// 設定ファイルから取得
            HySString csChkString = HySEnvInf.GetEnvInf("HYMCO_CELL_SERIAL_COMMON_USE");
            if ((object)csChkString != null)
            {
                bChkFlg = Convert.ToBoolean(csChkString.ToString());
            }
            if (bChkFlg == true)
            {
                return (McD1CellArrayTranInfo)McTranInfoDataPool.GetNewData(m_sPrjID, m_csRecordKind, this.m_csCommonInfo);
            }
            else
            {
                return (McD1CellArrayTranInfo)McTranInfoDataPool.GetNewData(m_csRecordKind);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GetNewRecord 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return this.NewRecord();
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(csAddRecord) </para>
        /// </example>
        /// <param name="csAddRecord">追加レコード</param>
        /// <returns> 無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddData(HySTimeRecordIF csAddRecord)
        {
            // 追加レコード時刻と同一又は未来のレコードがあればそれらを削除して最後に追加する
            HySTime csAddTime = csAddRecord.GetLastTime();
            if (this.Before(csAddTime) == false)
            {   // 同一または、未来情報有り
                this.RemoveAfterData(csAddTime);
                if (this.EqualTime(csAddTime) == true)
                {   // 同一情報有り
                    this.m_csDataList.RemoveLastData();
                }
            }
            McD1CellArrayTranInfo csRecord = csAddRecord as McD1CellArrayTranInfo;
            long lDataNum = base.GetCount();
            if (lDataNum >= m_lMaxDataNum)
            {   // データ数が、最大数を超えたならば
                // 覚えているデータの最初を忘れさせる 
                McD1CellArrayTranInfo csRmvRcd = (McD1CellArrayTranInfo)m_csDataList.RemoveData(0); // 最初のデータを取り外す
                //★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(インスタンスの共有化)
                //★★★★★★★★★★★★★★★★★★
                //★★★★★★★★★★★★★★
                // Ver1.4で追加(共有化の選択)
                //★★★★★★★★★★★★★★
                bool bChkFlg = false;// 設定ファイルから取得
                HySString csChkString = HySEnvInf.GetEnvInf("HYMCO_CELL_SERIAL_COMMON_USE");
                if ((object)csChkString != null)
                {
                    bChkFlg = Convert.ToBoolean(csChkString.ToString());
                }
                if (bChkFlg == true)
                {
                    //★★★修正 ここから★★★
                    McTranInfoDataPool.TrashData(m_sPrjID, m_csRecordKind, base.m_lMaxDataNum, csRmvRcd, this.m_csCommonInfo); // プールに戻す
                    //★★★修正 ここまで★★★
                }
                else
                {
                    McTranInfoDataPool.TrashData(m_csRecordKind, csRmvRcd); // プールに戻す
                }

            }
            m_csDataList.AddLast(csRecord); // レコード追加

            base.SetLastTime(csRecord.GetLastTime());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>新しいレコードを追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddRecord(csTime,csCellData) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="csCellData">追加するレコード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddRecord(HySTime csTime, HySCellData csCellData)
        {
            McD1CellArrayTranInfo csAddRcd = this.NewRecord();
            csAddRcd.SetTime(csTime);

            HySCellData[] csCellArryWork = csAddRcd.GetCellData();
            csCellArryWork[0] = csCellData;

            csAddRcd.SetCellData(csCellArryWork);
            
            this.AddData(csAddRcd);
        }

        /// <summary><para>method outline:</para>
        /// <para>時系列最後のデータを削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = RemoveLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new HySCellData RemoveLastData()
        {
            McD1CellArrayTranInfo csArr = (McD1CellArrayTranInfo)(base.RemoveLastData());
            if (csArr != null)
            {
                return (csArr.GetCellData())[0];
            }
            else
            {
                return null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>カーソル位置のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetCursorData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellData セル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new HySCellData GetCursorData()
        {
            McD1CellArrayTranInfo csArr = (McD1CellArrayTranInfo)(base.GetCursorData());
            if (csArr != null)
            {
                return (csArr.GetCellData())[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>最新のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellData セル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new HySCellData GetLastData()
        {
            McD1CellArrayTranInfo csArr = (base.GetLastData()) as McD1CellArrayTranInfo;
            if (csArr != null)
            {
                return (csArr.GetCellData())[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>データを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetData(lOrderNum) </para>
        /// </example>
        /// <param name="lOrderNum">リスト上の順番番号：０相対</param>
        /// <returns>HySCellData セル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new HySCellData GetData(long lOrderNum)
        {
            McD1CellArrayTranInfo csArr = (McD1CellArrayTranInfo)(base.GetData(lOrderNum));
            if (csArr != null)
            {
                return (csArr.GetCellData())[0];
            }
            else
            {
                return null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        {
            base.SetCellDataCharacteristic(csCellChara);
            m_csCommonInfo.SetCellDataCharacteristic(csCellChara);
        }


        /// <summary><para>method outline:</para>
        /// <para>同一種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SameKind( csTranInfo ) </para>
        /// </example>
        /// <param name="csTranInfo">比較する伝送データ</param>
        /// <returns>bool =true :同一種別、=false:異種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>入力情報が null の場合には　false で返す</para>
        /// </remarks>
        public virtual bool SameKind(McTranInfo csTranInfo)
        {
            bool bRtn = false;
            if (csTranInfo != null)
            {
                if (csTranInfo is McTimeSeriesSingleCellTranInfo)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部蓄積データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ResetData()
        {
            this.Clear();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo Clone()
        {
            McTimeSeriesSingleCellTranInfo csRtnObj = new McTimeSeriesSingleCellTranInfo();
            csRtnObj.CopyInfo(this);
            return csRtnObj;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CopyInfo(McTranInfo csOrgInfo)
        {
            McTimeSeriesSingleCellTranInfo csOrg1DTrnInfo = csOrgInfo as McTimeSeriesSingleCellTranInfo;
            if (csOrg1DTrnInfo == null)
            {
                return false;
            }

            m_csRecordKind = new HySObjectKind(csOrg1DTrnInfo.m_csRecordKind.GetString());
            m_lMaxDataNum = csOrg1DTrnInfo.m_lMaxDataNum;
            m_bCallFlg = csOrg1DTrnInfo.m_bCallFlg;
            m_sPrjID = csOrg1DTrnInfo.m_sPrjID;

            McD1CellArrayTranInfo csDt = null;
            McD1CellArrayTranInfo csNewDt = null;
            long lDataNum = csOrg1DTrnInfo.GetCount();
            HySDataLinkedList csDataList = csOrg1DTrnInfo.m_csDataList;
            for (long iLp = 0; iLp < lDataNum; iLp++)
            {
                csDt = (McD1CellArrayTranInfo)csDataList.GetData(iLp);
                csNewDt = this.NewRecord();
                csNewDt.CopyData((McD1CellArrayTranInfo)csDt);
                this.AddData(csNewDt);
            }
            m_csCommonInfo.CopyInfo(csOrg1DTrnInfo.m_csCommonInfo);

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public virtual bool LastDataCopy(McTranInfo csOrgInfo)
        {
            bool bRtn = false;
            McTimeSeriesSingleCellTranInfo csOrgTrnInfo = csOrgInfo as McTimeSeriesSingleCellTranInfo;
            if (csOrgTrnInfo == null)
            {
                return false;
            }

            bRtn = true;
            HySCellData csRecord = null;
            HySTime csTim = null;
            long lCnt = csOrgTrnInfo.SetCursorPlus(this.GetLastTime());    // カーソルを最後に取得した時刻に持ってくる
            for (long lLp = 0; lLp < lCnt; lLp++)
            {   // 未取得分繰り返す
                csRecord = csOrgTrnInfo.GetCursorData() as HySCellData;
                csTim = csOrgTrnInfo.GetCursorTime();
                this.AddRecord(csTim,csRecord);

                csOrgTrnInfo.MoveCursorNext();
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans(csOrgTran)</para>
        /// </example>
        /// <param name="csOrgTran">上流側の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void MakeRelayPortDataTransContinuity(McTranInfo csOrgTran)
        {
            McTimeSeriesSingleCellTranInfo csOrg = csOrgTran as McTimeSeriesSingleCellTranInfo;
            if (csOrgTran != null)
            {
                this.m_csCommonInfo = csOrg.GetCommonInf().Clone() as McTranInfoCommon;
            }
        }

        // ================================================
        // プロパティ設定関連
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetProperty(McPropertyInfoRoot csPropertyInfo)
        {
            McCellArrayTranInfoPropertyInfo csCellPrpyt = csPropertyInfo as McCellArrayTranInfoPropertyInfo;
            if (csCellPrpyt == null) { return; } 
            
            // 受信設定
            McTranInfoPattern csRsvPtn = csCellPrpyt.GetReceiveTranInfoPattern() as McTranInfoPattern;
            if (csRsvPtn == null)
            {   // 受信パターンが未設定とみてリコメンド設定を行う
                //csRsvPtn = csCellPrpyt.GetRecommendReceiveCellPattern();
            }
            // 改めて設定
            McReceiveCellData csRcvCellDt = m_csCommonInfo.GetReceiveCellData() as McReceiveCellData;
            if (csRsvPtn != null)
            {
                //m_csCellDataKind = csRsvPtn.GetCellDataCharacteristic();
                m_csCommonInfo.CreateMcReceiveCellData(csCellPrpyt);
                csRcvCellDt = m_csCommonInfo.GetReceiveCellData() as McReceiveCellData;

                csRcvCellDt.SetInterpolateType(csRsvPtn.GetInterpolateType());
                m_csCommonInfo.SetInterpolateType(csRsvPtn.GetInterpolateType());
            }
            csRcvCellDt.SetCellDataGetter(csCellPrpyt.GetCellDataGetter());   // <-- これは重要
            csRcvCellDt.SetTranInfo(this);

            // 送信設定
            McTranInfoPattern csSndPtn = csCellPrpyt.GetSendTranInfoPattern() as McTranInfoPattern;
            if (csSndPtn == null)
            {   // 受信パターンが未設定とみてリコメンド設定を行う
                //csSndPtn = csCellPrpyt.GetRecommendSendCellPattern();
            }
            // 改めて設定
            if (csSndPtn != null)
            {
                m_csCellDataKind = csSndPtn.GetCellDataCharacteristic();

                m_csCommonInfo.CreateSendCellData(csCellPrpyt);
                McSendCellData csCellDt = m_csCommonInfo.GetSendCellData() as McSendCellData;
                csCellDt.SetTranInfoPattern(csSndPtn);
                csCellDt.SetID(csSndPtn.GetPatternID());
                csCellDt.SetTranInfo(this);

                long lTD1 = 0; long lTD2 = 0; long lTD3 = 0; long lDataDimInCell = 0; // パターン側の配列
                long lCellDim = csSndPtn.GetDimension(ref lTD1, ref lTD2, ref lTD3, ref lDataDimInCell);
                this.Init(lDataDimInCell); // <-- 重要(真レコード生成時の型式を決定)
            }
            m_csCellIDMngData = csCellPrpyt.GetCellIDMngData() as HySCellIDManageData;

            this.SetMaxHoldDataNum(csCellPrpyt.GetMaxRecordDataNum());

        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        public virtual void SetOnlineProperty(McPropertyInfoRoot csPropertyInfo)
        {
            // Do Nothing
        }
        // ================================================
        // 共通情報設定
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>接続線共通情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranCommonCellDataIF csCnnctInf = GetCommonInf( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranCommonCellDataIF 接続線共通情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の共通情報を取得する</para>
        /// </remarks>
        public virtual McTranCommonCellDataIF GetCommonInf()
        {
            return m_csCommonInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 接続線ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        public virtual HySID GetConnectionID()
        {
            return m_csCommonInfo.GetConnectionID();
        }
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        public virtual HySString GetConnectionName()
        {
            return m_csCommonInfo.GetConnectionName();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual HySID GetUpperElementID()
        {
            return m_csCommonInfo.GetUpperElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetLowerElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual HySID GetLowerElementID()
        {
            return m_csCommonInfo.GetLowerElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 上流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual McElement GetUpperElement()
        {
            return m_csCommonInfo.GetUpperElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 下流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual McElement GetLowerElement()
        {
            return m_csCommonInfo.GetLowerElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetInterpolateType(HySDefine.InterpolateType eInterpolateType)
        {
            m_csCommonInfo.SetInterpolateType(eInterpolateType);
        }
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDefine.InterpolateType GetInterpolateType()
        {
            return m_csCommonInfo.GetInterpolateType();
        }

        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3)
        {
            lDim1 = 1;
            lDim2 = 0;
            lDim3 = 0;
            return 1;
        }

        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McReceiveCellDataIF csRevDt = GetReceiveCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McReceiveCellDataIF 受信したセル型情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報本体をを取得する</para>
        /// </remarks>
        public virtual McReceiveCellDataIF GetReceiveCellData()
        {
            return m_csCommonInfo.GetReceiveCellData();
        }
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csSndDt = GetSendCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF 送信するセル型情報設定クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報を設定する</para>
        /// </remarks>
        public virtual McSendCellDataIF GetSendCellData()
        {
            return m_csCommonInfo.GetSendCellData();
        }
        /// <summary><para>method outline:</para>
        /// <para>最終セルデータ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csCellArry = GetLastCellArrayData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellArray セル配列データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellArray GetLastCellArrayData()
        {
            McD1CellArrayTranInfo csArr = (base.GetLastData()) as McD1CellArrayTranInfo;
            if (csArr != null)
            {
                return csArr.GetLastCellArrayData();
            }
            else
            {
                return null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySObjectKind GetTranInfoKind()
        { return McTranInfoDefine.SINGLE_CELL_SERIAL; }

        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(伝送情報の事前作成、インスタンスの共有化)
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>上流側要素モデルタイムステップの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElmTimeStep( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUpperElmTimeStep()
        {
            // Gr要素内で中継端子に接している場合、このタイミングで導通設定が行われておらず
            // 取得できない為、明示的にNullとする
            HySTime csTimeStep = null;
            if (this.m_csCommonInfo.GetUpperElement() != null)
            {
                csTimeStep = this.m_csCommonInfo.GetUpperElement().GetCalModel().GetDeltaTime();
            }
            //★★★★★★★★★★★★★★
            // Ver1.4で追加(共有化の選択)
            //★★★★★★★★★★★★★★
            bool bChkFlg = false;// 設定ファイルから取得
            HySString csChkString = HySEnvInf.GetEnvInf("HYMCO_CELL_SERIAL_COMMON_USE");
            if ((object)csChkString != null)
            {
                bChkFlg = Convert.ToBoolean(csChkString.ToString());
            }
            if (bChkFlg == true)
            {
                // Do Nothing
            }
            else
            {
                McTranInfoDataPool.m_bCommonUseFlg = false;
            }
            // 此処でプールに自身の情報（伝送情報型、最大レコード数）を教える
            McTranInfoDataPool.SetUpperElmTimeStep(m_sPrjID, m_csRecordKind, csTimeStep, base.m_lMaxDataNum, this.m_csCommonInfo);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトIDの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPrjID( ) </para>
        /// </example>
        /// <param name="sPrjID">プロジェクトID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPrjID(string sPrjID)
        {
            m_sPrjID = sPrjID;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public new void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
