﻿// <summary>ソースコード：セル識別子とセルの配列管理データ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>セル識別子とセルの配列管理データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>
    /// セルを個別に区別する場合に、識別子をつけたセルの配列位置を保持する
    /// 　セルＩＤ→セルの配列位置取得(補足情報として HySObjectKindも使用可)
    /// 　セル配列位置→セルＩＤ取得
    /// </para>
    ///<para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McCellIDMngData : HySCellIDManageData, McCellIDMngIF, HySVersionManagement
    {
        /// <summary>読み書き用ファイル名称（相対パス付き）</summary>
        protected HySString m_csXmlFileNameWithPath=null;

        /// <summary> 読み書き用ファイルの基準パス（最後の文字列は"\"で終わる）</summary>
        [NonSerialized]
        protected HySString m_csBaseXmlFilePath = new HySString("");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McReceiveCellData csCellData = new McReceiveCellData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPattern 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCellIDMngData()
        {
            //バージョン情報設定
            SetNowVersion();
        } 

        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = HySXmlNode.CreateElement(McDefine.xml_TRAN_CELL_MANAGE_TABLE, csXmlWriter);

            csRtn.SetAttribute(McDefine.xml_MODELKIND, "McCellIDMngData");
            if (((object)m_csXmlFileNameWithPath) != null)
            {
                csRtn.SetAttribute(McDefine.xml_FILE_NAME, m_csXmlFileNameWithPath.ToString());
            }

            HySID     csWkID = null;
            HySXmlNode csXmlNode = null;
            long lDim1=0;
            long lDim2=-1;
            long lDim3=-1;
            HySObjectKind csKind = null;

            long lPosCnt = this.GetIDCount();
            m_csIDList.SetCursorFirst();
            for (long lLp = 0; lLp < lPosCnt; lLp++)
            {
                csWkID = m_csIDList.GetCursorData() as HySID;
                this.GetCellIdx(csWkID, ref lDim1, ref lDim2, ref lDim3, ref csKind);
                // XMLノード作成
                csXmlNode = HySXmlNode.CreateElement(McDefine.xml_TRAN_CELL, csXmlWriter);
                csXmlNode.SetAttribute(McDefine.xml_TRAN_CELL_ID, csWkID.ToString());
                csXmlNode.SetAttribute(McDefine.xml_CELL_DIM1, lDim1.ToString());
                if (lDim2 >= 0)
                {
                    csXmlNode.SetAttribute(McDefine.xml_CELL_DIM2, lDim2.ToString());
                }
                if (lDim3 >= 0)
                {
                    csXmlNode.SetAttribute(McDefine.xml_CELL_DIM3, lDim3.ToString());
                }
                csXmlNode.SetAttribute(McDefine.xml_TRAN_CELL_KIND, csKind.ToString());
                csRtn.AppendChild(csXmlNode);   // AppendChildは最後に行う

                m_csIDList.MoveCursorNext();
            }

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからセルと識別子の対応管理情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csXml) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlIN(HySXmlNode csXml)
        {
            bool bRtn = true;
            this.Clear();

            //string sFileNameWithPath = csXml.GetAttribute(McDefine.xml_CELL_ID_MNG_FILE);
            string sFileNameWithPath = csXml.GetAttribute(McDefine.xml_FILE_NAME);
            if (sFileNameWithPath != "")
            {
                m_csXmlFileNameWithPath = new HySString(sFileNameWithPath);
                //bRtn = this.XmlFileRead();
            }

            //else
            //{
                HySXmlNodeList csXmlComponentList = csXml.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL_MANAGE_TABLE);
                HySXmlNode csXmlCellTable = csXmlComponentList.GetNode(0);
                if (csXmlCellTable != null)
                {
                    HySID csWkID = null;
                    long lDim1 = 0;
                    long lDim2 = -1;
                    long lDim3 = -1;
                    HySObjectKind csKind = null;
                    HySXmlNode csXmlCellNode;
                    HySXmlNodeList csXmlCellList = csXmlCellTable.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL);
                    String sRdStr = "";
                    long lCompNum = csXmlCellList.GetCount(); 
                    for (long lLp = 0; lLp < lCompNum; lLp++)
                    {
                        lDim1 = 0;
                        lDim2 = -1;
                        lDim3 = -1;
                        csXmlCellNode = csXmlCellList.GetNode(lLp);
                        csWkID = new HySID(csXmlCellNode.GetAttribute(McDefine.xml_TRAN_CELL_ID));
                        sRdStr = csXmlCellNode.GetAttribute(McDefine.xml_CELL_DIM1);
                        if (sRdStr != "")
                        {
                            lDim1 = Convert.ToInt32(sRdStr);
                        }
                        else
                        {
                            lDim1 = lLp;
                        }
                        sRdStr = csXmlCellNode.GetAttribute(McDefine.xml_CELL_DIM2);
                        if (sRdStr != "")
                        {
                            lDim2 = Convert.ToInt32(sRdStr);
                        }
                        sRdStr = csXmlCellNode.GetAttribute(McDefine.xml_CELL_DIM3);
                        if (sRdStr != "")
                        {
                            lDim3 = Convert.ToInt32(sRdStr);
                        }
                        csKind = new HySObjectKind(csXmlCellNode.GetAttribute(McDefine.xml_TRAN_CELL_KIND));
                        this.SetID(csWkID, lDim1, lDim2, lDim3, csKind);
                    }
                }
            //}

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetXmlFileName(csFileNameWithPath) </para>
        /// </example>
        /// <param name="csFileNameWithPath">XMLファイル名（相対パス付き）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetXmlFileName(HySString csFileNameWithPath)
        {
            m_csXmlFileNameWithPath = csFileNameWithPath;
        }
        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  HySString csFileName = GetXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>XMLファイル名（相対パス付き）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetXmlFileName()
        {
            return m_csXmlFileNameWithPath;
        }
        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル用基準パス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetXmlFileBasePath(csBasePath) </para>
        /// </example>
        /// <param name="csBasePath">基準パス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetXmlFileBasePath(HySString csBasePath)
        {
            m_csBaseXmlFilePath = csBasePath;
        }
        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル用基準パス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csBasePath = GetXmlFileBasePath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>XMLファイル用基準パス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetXmlFileBasePath()
        {
            return m_csBaseXmlFilePath;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定したファイルにセルと識別子の対応管理情報を書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = XmlFileWrite();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlFileWrite()
        {
            bool bRtn = false;
            if ((object)m_csXmlFileNameWithPath != null)
            {
                //HySXmlWriter csXmlWriter = new HySXmlWriter(m_csXmlFileNameWithPath);
                HySXmlWriter csXmlWriter = new HySXmlWriter(m_csBaseXmlFilePath+m_csXmlFileNameWithPath);
                HySXmlNode csRootNode = csXmlWriter.CreateRoot(McDefine.xml_CELL_ID_MNG_FILE);
                HySXmlNode csNode = this.XmlOUT(ref csXmlWriter);
                csRootNode.AppendChild(csNode);

                csXmlWriter.Save();
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定したファイルからセルと識別子の対応管理情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = XmlFileRead();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlFileRead()
        {
            bool bRtn = false;
            if ((object)m_csXmlFileNameWithPath != null)
            {
                //HySXmlReader csReader = new HySXmlReader(m_csXmlFileNameWithPath);
                HySXmlReader csReader = new HySXmlReader(m_csBaseXmlFilePath+m_csXmlFileNameWithPath);
                HySXmlNode csRootNode = csReader.GetRootNode();
                if (csRootNode != null)
                {
                    HySXmlNode csXmlCellNode =null;
                    HySXmlNodeList csXmlCellList = csRootNode.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL_MANAGE_TABLE);
                    csXmlCellNode = csXmlCellList.GetNode(0);
                    if (csXmlCellNode != null)
                    {
                        bRtn = this.XmlIN(csXmlCellNode);
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McCellIDMngIF 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McCellIDMngIF Clone()
        {
            McCellIDMngData csRtn = new McCellIDMngData();
            csRtn.CopyData(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyData(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySCellIDManageData csOrgData)
        {
            base.CopyData(csOrgData);
            McCellIDMngData csMcOrgData = csOrgData as McCellIDMngData;
            if( csMcOrgData != null )
            {
                if ((object)csMcOrgData.m_csXmlFileNameWithPath != null)
                {
                    m_csXmlFileNameWithPath = csMcOrgData.m_csXmlFileNameWithPath.Clone();
                }
                if ((object)csMcOrgData.m_csBaseXmlFilePath != null)
                {
                    m_csBaseXmlFilePath = csMcOrgData.m_csBaseXmlFilePath.Clone();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>地点定義情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = ReadPointDefFile(csFileNameWithPath) </para>
        /// </example>
        /// <param name="csFileNameWithPath">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadPointDefFile(HySString csFileNameWithPath)
        {
            bool bRtn = false;
            HySXmlReader csXmlReader = new HySXmlReader(csFileNameWithPath);
            HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
            if (csXmlRootNode is HySXmlNode)
            {
                // 情報読み出し
                bRtn = this.XmlIN(csXmlRootNode);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>クラス名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>クラスファイル名（ネームスペース無し）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetClassName()
        {
            return new HySString("McCellIDMngData");
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
