// <summary>ソースコード：内挿ツール作成クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;


namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>内挿ツール作成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>時系列情報の内挿処理を行う為のツールクラス</para>
    /// </remarks>
    public class McCellIDMngrFactory : McRoot
    {
        /// <summary>種ｵﾌﾞｼﾞｪｸﾄ管理</summary>
        static protected HySDataHashTable g_csSeedTbl = new HySDataHashTable(); 
      
        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データの種オブジェクト初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDManageData(csSeedObj) </para>
        /// </example>
        /// <param name="csSeedObj">セル識別子とセルの配列管理データ種別</param>
        /// <returns> 無し　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>此処で設定した種を元に CreateCellIDManageData() でオブジェクトの生成を行う</para>
        /// </remarks>
        static public void SetCellIDManageData(McCellIDMngIF csSeedObj)
        {
            if( csSeedObj == null )
            {   return ;   }

            HySString sClassName = csSeedObj.GetClassName();
            g_csSeedTbl.AddObject(sClassName, csSeedObj);
        }

        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateInterpolator(csKind) </para>
        /// </example>
        /// <param name="csKind">セル識別子とセルの配列管理データ種別</param>
        /// <returns> HySCellIDManageData セル識別子とセルの配列管理データ　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public McCellIDMngIF CreateCellIDManageData(HySKind csKind)
        {
            McCellIDMngIF csRtnObj = null;
            McCellIDMngIF csSeedObj = g_csSeedTbl[((HySString)csKind.GetString())] as McCellIDMngIF;
            if (csSeedObj != null)
            {
                csRtnObj = csSeedObj.Clone();
            }
            return csRtnObj;
        }
    }
}
