﻿// <summary>ソースコード：セル識別子とセルの配列管理データ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>伝送データに接続された上下のモデル内セルの対応データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>
    /// 下記対応情報を送る（主にモデルジェネレーターが作成し、付与する）
    /// １．接続元モデル内のセル内容が　伝送データのどのセルに対応するか
    /// ２．伝送データ内のセルが、接続先モデルのどのセルに対応するか
    /// </para>
    ///<para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McModelCellCorrespondenceInf : McCellIDMngData, McCellIDMngIF, HySVersionManagement
    {
        /// <summary><para>class outline:</para>
        /// <para>配列位置管理データ</para>
        /// </summary>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
        /// </remarks>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class McCellIdxInf : HySDimIdx, HySVersionManagement
        {
            /// <summary>上流モデル内のセルインデックス（０相対）１，２，３次元配列時に有効 </summary>
            public long m_lUpperModelCellIndexDim1 = -1;
            /// <summary>上流モデル内のセルインデックス（０相対）２，３次元配列時に有効</summary>
            public long m_lUpperModelCellIndexDim2 = -1;
            /// <summary>上流モデル内のセルインデックス（０相対）３次元配列時に有効 </summary>
            public long m_lUpperModelCellIndexDim3 = -1;

            // === 親クラスのメンバーを使用する ===
            //// <summary>データ内のセルインデックス（０相対） １，２，３次元配列時に有効</summary>
            //public long m_lDataCellIndexDim1 = -1;
            //// <summary>データ内のセルインデックス（０相対）２，３次元配列時に有効</summary>
            //public long m_lDataCellIndexDim2 = -1;
            //// <summary>データ内のセルインデックス（０相対）３次元配列時に有効 </summary>
            //public long m_lDataCellIndexDim3 = -1;

            /// <summary>下流モデル内のセルインデックス（０相対）１，２，３次元配列時に有効 </summary>
            public long m_lLowerModelCellIndexDim1 = -1;
            /// <summary>下流モデル内のセルインデックス（０相対）２，３次元配列時に有効</summary>
            public long m_lLowerModelCellIndexDim2 = -1;
            /// <summary>下流モデル内のセルインデックス（０相対）３次元配列時に有効 </summary>
            public long m_lLowerModelCellIndexDim3 = -1;

            /// <summary>対応名称</summary>
            public String m_sName = "";

            /// <summary><para>method outline:</para>
            /// <para>デフォルトコンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McCellIdxInf csObj = new McCellIdxInf( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>McCellIdxInf  生成したインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McCellIdxInf()
                :base (-1, -1, -1, new HySObjectKind(""))
            {
                //バージョン情報設定
                SetNowVersion();
            }

            /// <summary><para>method outline:</para>
            /// <para>文字列化</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySString csKeyStr = GetString( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>HySString 文字列</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            override public HySString GetString()
            {
                return new HySString(
                    "From[" + m_lUpperModelCellIndexDim1.ToString() + "," + m_lUpperModelCellIndexDim2.ToString() + "," + m_lUpperModelCellIndexDim3.ToString() +
                    "]-Rly["+m_lDim1.ToString() + "," + m_lDim2.ToString() + "," + m_lDim3.ToString() +
                    "]-To[" + m_lLowerModelCellIndexDim1.ToString() + "," + m_lLowerModelCellIndexDim2.ToString() + "," + m_lLowerModelCellIndexDim3.ToString() +"]"
                    );
            }

            /// <summary><para>method outline:</para>
            /// <para>セルと識別子の対応管理情報をXMLへ書き出す</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
            /// </example>
            /// <param name="csXmlWriter">XML書き出しクラス</param>
            /// <returns>HySXmlNode  XMLノードクラス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
            {
                HySXmlNode csXmlNode = HySXmlNode.CreateElement(McDefine.xml_TRAN_CELL, csXmlWriter);
                csXmlNode.SetAttribute(McDefine.xml_CELL_DIM1, m_lDim1.ToString());
                if (m_lDim2 >= 0)
                {
                    csXmlNode.SetAttribute(McDefine.xml_CELL_DIM2, m_lDim2.ToString());
                }
                if (m_lDim3 >= 0)
                {
                    csXmlNode.SetAttribute(McDefine.xml_CELL_DIM3, m_lDim3.ToString());
                }
                HySXmlNode csModelXmlNode = HySXmlNode.CreateElement(McDefine.xml_UPPER_MODEL_CELL, csXmlWriter);
                csModelXmlNode.SetAttribute(McDefine.xml_CELL_DIM1, m_lUpperModelCellIndexDim1.ToString());
                if (m_lUpperModelCellIndexDim2 >= 0)
                {
                    csModelXmlNode.SetAttribute(McDefine.xml_CELL_DIM2, m_lUpperModelCellIndexDim2.ToString());
                }
                if (m_lUpperModelCellIndexDim3 >= 0)
                {
                    csModelXmlNode.SetAttribute(McDefine.xml_CELL_DIM3, m_lUpperModelCellIndexDim3.ToString());
                }
                csXmlNode.AppendChild(csModelXmlNode);
                csModelXmlNode = HySXmlNode.CreateElement(McDefine.xml_LOWER_MODEL_CELL, csXmlWriter);
                csModelXmlNode.SetAttribute(McDefine.xml_CELL_DIM1, m_lLowerModelCellIndexDim1.ToString());
                if (m_lLowerModelCellIndexDim2 >= 0)
                {
                    csModelXmlNode.SetAttribute(McDefine.xml_CELL_DIM2, m_lLowerModelCellIndexDim2.ToString());
                }
                if (m_lLowerModelCellIndexDim3 >= 0)
                {
                    csModelXmlNode.SetAttribute(McDefine.xml_CELL_DIM3, m_lLowerModelCellIndexDim3.ToString());
                }
                csXmlNode.AppendChild(csModelXmlNode);
                return csXmlNode;
            }
            /// <summary><para>method outline:</para>
            /// <para>XMLからセルと識別子の対応管理情報を読み出す</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> bool bRtn = XmlIN(csXmlCellNode) </para>
            /// </example>
            /// <param name="csXmlCellNode">入力XML</param>
            /// <returns>bool  =true:正常、=false:型式不適等</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual bool XmlIN(HySXmlNode csXmlCellNode)
            {
                bool bRtn = true;

                m_lDim1 = 0;
                m_lDim2 = -1;
                m_lDim3 = -1;
                m_lUpperModelCellIndexDim1 = 0;
                m_lUpperModelCellIndexDim2 = -1;
                m_lUpperModelCellIndexDim3 = -1;
                m_lLowerModelCellIndexDim1 = 0;
                m_lLowerModelCellIndexDim2 = -1;
                m_lLowerModelCellIndexDim3 = -1;
                String sRdStr = "";

                sRdStr = csXmlCellNode.GetAttribute(McDefine.xml_CELL_DIM1);
                if (sRdStr != "")
                {
                    m_lDim1 = Convert.ToInt32(sRdStr);
                }
                sRdStr = csXmlCellNode.GetAttribute(McDefine.xml_CELL_DIM2);
                if (sRdStr != "")
                {
                    m_lDim2 = Convert.ToInt32(sRdStr);
                }
                sRdStr = csXmlCellNode.GetAttribute(McDefine.xml_CELL_DIM3);
                if (sRdStr != "")
                {
                    m_lDim3 = Convert.ToInt32(sRdStr);
                }
                          
                HySXmlNode csXmlNode =null;
                HySXmlNodeList csXmlCellList = csXmlCellNode.GetChildNodeListByTagName(McDefine.xml_UPPER_MODEL_CELL);
                csXmlNode = csXmlCellList.GetNode(0);
                if( csXmlNode != null)
                {
                    sRdStr = csXmlNode.GetAttribute(McDefine.xml_CELL_DIM1);
                    if (sRdStr != "")
                    {
                        m_lUpperModelCellIndexDim1 = Convert.ToInt32(sRdStr);
                    }
                    sRdStr = csXmlNode.GetAttribute(McDefine.xml_CELL_DIM2);
                    if (sRdStr != "")
                    {
                        m_lUpperModelCellIndexDim2 = Convert.ToInt32(sRdStr);
                    }
                    sRdStr = csXmlNode.GetAttribute(McDefine.xml_CELL_DIM3);
                    if (sRdStr != "")
                    {
                        m_lUpperModelCellIndexDim3 = Convert.ToInt32(sRdStr);
                    }
                }
                
                csXmlCellList = csXmlCellNode.GetChildNodeListByTagName(McDefine.xml_LOWER_MODEL_CELL);
                csXmlNode = csXmlCellList.GetNode(0);
                if (csXmlNode != null)
                {
                    sRdStr = csXmlNode.GetAttribute(McDefine.xml_CELL_DIM1);
                    if (sRdStr != "")
                    {
                        m_lLowerModelCellIndexDim1 = Convert.ToInt32(sRdStr);
                    }
                    sRdStr = csXmlNode.GetAttribute(McDefine.xml_CELL_DIM2);
                    if (sRdStr != "")
                    {
                        m_lLowerModelCellIndexDim2 = Convert.ToInt32(sRdStr);
                    }
                    sRdStr = csXmlNode.GetAttribute(McDefine.xml_CELL_DIM3);
                    if (sRdStr != "")
                    {
                        m_lLowerModelCellIndexDim3 = Convert.ToInt32(sRdStr);
                    }
                }
                return bRtn;
            }

            // start of バージョン互換性のための処理
            /// <summary>保存バージョン情報</summary>
            private string m_sDecodedVersion;
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sDecodedVersion = GetDecodedVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 保存バージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>メンバー変数に設定されているバージョン情報を返す</para>
            /// </remarks>
            public new string GetDecodedVersion()
            {
                return m_sDecodedVersion;
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sVersion = GetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 現在のバージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public new string GetNowVersion()
            {
                return "1.00";
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>現在のバージョン情報をメンバー変数に設定する</para>
            /// </remarks>
            public new void SetNowVersion()
            {
                m_sDecodedVersion = GetNowVersion();
            }
            /// <summary><para>method outline:</para>
            /// <para>復元後の整合性確保処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> PostDeserialize( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
            /// バージョンによって変数等追加がない場合には、実装の必要がない
            /// </para>
            /// </remarks>
            public override void PostDeserialize()
            {
                base.PostDeserialize();

                if (GetDecodedVersion() != GetNowVersion())
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            break;
                    }
                    SetNowVersion();
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>逆シリアル化時追加処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
            /// </example>
            /// <param name="csObj">ダミー</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>予約処理</para>
            /// </remarks>
            void IDeserializationCallback.OnDeserialization(Object csObj)
            {
                PostDeserialize();
            }
            // end of バージョン互換性のための処理
        }
             
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelCellCorrespondenceInf csCellInf = new McModelCellCorrespondenceInf()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelCellCorrespondenceInf 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelCellCorrespondenceInf()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>インデックス管理情報追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddIndexInf( csIdxInf) </para>
        /// </example>
        /// <param name="csIdxInf">インデックス情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void AddIndexInf(McCellIdxInf csIdxInf)
        {
            long lIdxInfNumber = m_csIDList.GetCount();
            HySID csIdxID = new HySID(lIdxInfNumber.ToString());
            m_csKeyTbl.AddObject(csIdxInf.GetString(), csIdxID);
            m_csIndexTbl.AddObject((HySString)csIdxID.GetString(), csIdxInf);
            m_csIDList.AddLast(csIdxID);
        }
        /// <summary><para>method outline:</para>
        /// <para>インデックス管理情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetIndexInf( csIdxID, csIdxInf) </para>
        /// </example>
        /// <param name="csIdxID">各インデックスを識別する識別子</param> 
        /// <param name="csIdxInf">インデックス情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetIndexInf(HySID csIdxID, McCellIdxInf csIdxInf)
        {
            m_csKeyTbl.AddObject(csIdxInf.GetString(), csIdxID);
            m_csIndexTbl.AddObject((HySString)csIdxID.GetString(), csIdxInf);
            m_csIDList.AddLast(csIdxID);
        }
        /// <summary><para>method outline:</para>
        /// <para>インデックス管理情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIdxInf csIdxInf = GetCellIdxInf(csIdxID) </para>
        /// </example>
        /// <param name="csIdxID">各インデックスを識別する識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McCellIdxInf GetCellIdxInf(HySID csIdxID)
        {
            McCellIdxInf csRtn = null;
            if (csIdxID != null)
            {
                csRtn = m_csIndexTbl.GetObject((HySString)csIdxID.GetString()) as McCellIdxInf;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>インデックス管理情報一覧取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIdxInf[] csIdx = GetCellIdxInf(ref lIdxInfNumber) </para>
        /// </example>
        /// <param name="lIdxInfNumber">配列数</param>
        /// <returns>McCellIdxInf[]　インデックス情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McCellIdxInf[] GetCellIdxInf(ref long lIdxInfNumber)
        {
            McCellIdxInf[] csRtn=null;

            HySID csID = null;
            lIdxInfNumber = m_csIDList.GetCount();
            csRtn = new McCellIdxInf[lIdxInfNumber];
            m_csIDList.SetCursorFirst();
            for (long lLp = 0; lLp < lIdxInfNumber; lLp++)
            {
                csID = m_csIDList.GetCursorData() as HySID;

                csRtn[lLp] = m_csIndexTbl.GetObject((HySString)csID.GetString()) as McCellIdxInf;

                m_csIDList.MoveCursorNext();
            }

            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>各インデックスを識別する識別子の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetIndexID( csIdxInf) </para>
        /// </example>
        /// <param name="csIdxInf">インデックス情報</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySID GetIndexID(McCellIdxInf csIdxInf)
        {
            HySID csRtn = null;
            if (csIdxInf != null)
            {
                csRtn = m_csKeyTbl.GetObject(csIdxInf.GetString()) as HySID;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>各インデックスを識別する識別子一覧取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIdxInf[] csIdx = GetCellIdxInf(ref lIDNumber) </para>
        /// </example>
        /// <param name="lIDNumber">配列数</param>
        /// <returns>McCellIdxInf[]　配列位置管理情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySID[] GetIndexID(ref long lIDNumber)
        {
            HySID[] csRtn = null;
            lIDNumber = m_csIDList.GetCount();
            csRtn = new HySID[lIDNumber];

            m_csIDList.SetCursorFirst();
            for (long lLp = 0; lLp < lIDNumber; lLp++)
            {
                csRtn[lLp] = m_csIDList.GetCursorData() as HySID;
                m_csIDList.MoveCursorNext();
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = HySXmlNode.CreateElement(McDefine.xml_TRAN_CELL_MANAGE_TABLE, csXmlWriter);
            csRtn.SetAttribute(McDefine.xml_MODELKIND, "McModelCellCorrespondenceInf");
            if (((object)m_csXmlFileNameWithPath) != null)
            {
                csRtn.SetAttribute(McDefine.xml_FILE_NAME, m_csXmlFileNameWithPath.ToString());
            }

            HySXmlNode csLclXmlNode = null;
            long lIdxInfNumber=0;
            McCellIdxInf[] csIdxArray = this.GetCellIdxInf(ref lIdxInfNumber);
            for (long lLp = 0; lLp < lIdxInfNumber; lLp++)
            {
                csLclXmlNode = csIdxArray[lLp].XmlOUT(ref csXmlWriter);
                csRtn.AppendChild(csLclXmlNode); 
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからセルと識別子の対応管理情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csXml) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csXml)
        {
            bool bRtn = true;
            this.Clear();

            //string sFileNameWithPath = csXml.GetAttribute(McDefine.xml_CELL_ID_MNG_FILE);
            string sFileNameWithPath = csXml.GetAttribute(McDefine.xml_FILE_NAME);
            if (sFileNameWithPath != "")
            {
                m_csXmlFileNameWithPath = new HySString(sFileNameWithPath);
                //bRtn = this.XmlFileRead();
            }

            //else
            //{
                McCellIdxInf csCellIdxInf = null;
                //HySID csCellID = null;
                HySXmlNode csXmlCellNode =null;
                HySXmlNodeList csXmlCellList = csXml.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL);
                long lCompNum = csXmlCellList.GetCount();
                for (long lLp = 0; lLp < lCompNum; lLp++)
                {
                    csXmlCellNode = csXmlCellList.GetNode(lLp);
                    if (csXmlCellNode != null)
                    {
                        csCellIdxInf = new McCellIdxInf();
                        if (csCellIdxInf.XmlIN(csXmlCellNode) == true)
                        {
                            this.AddIndexInf(csCellIdxInf);
                            //csCellID = new HySID(lLp.ToString());
                            //m_csKeyTbl.AddObject(csCellIdxInf.GetString(), csCellID);
                            //m_csIndexTbl.AddObject((HySString)csCellID.GetString(), csCellIdxInf);
                            //m_csIDList.AddLast(csCellIdxInf);
                        }
                    }
                }
            //}

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McCellIDMngIF 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellIDMngIF Clone()
        {
            McModelCellCorrespondenceInf csRtn = new McModelCellCorrespondenceInf();
            csRtn.CopyData(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyData(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySCellIDManageData csOrgData)
        {
            base.CopyData(csOrgData);
        }

        /// <summary><para>method outline:</para>
        /// <para>クラス名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>クラスファイル名（ネームスペース無し）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySString GetClassName()
        {
            return new HySString("McModelCellCorrespondenceInf");
        }


        // start of バージョン互換性のための処理
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        // end of バージョン互換性のための処理
    }
}
