﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>相互結合型　伝送情報パターンプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para> S.H. [2022/01/21][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McMutualTranInfoPattern : McTranInfoPattern
    {
        /// <summary>上に遡るデータ</summary>
        protected McTranInfoPattern m_csUpTranInfoPttn = null;
        /// <summary>下に下るデータ</summary>
        protected McTranInfoPattern m_csDownTranInfoPttn = null;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTranInfoPattern csPtn = new McTranInfoPattern(csID,csTranInfoKind,sName) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <param name="csTranInfoKind">伝送データ種別</param>
        /// <param name="sName">パターン名称</param>
        /// <returns>McTranInfoPattern 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMutualTranInfoPattern(HySID csID, HySObjectKind csTranInfoKind, String sName)
            : base( csID, csTranInfoKind, sName)
        {
            this.m_csCellCharacteristic = new HySDataCharacteristicInCell(1);

            //バージョン情報設定
            SetNowVersion();
        }


        /// <summary><para>method outline:</para>
        /// <para>上に遡る伝送データのプロパティ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUpTranInfoPattern(csUpPttn) </para>
        /// </example>
        /// <param name="csUpPttn">上に遡る伝送データのプロパティ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        public void SetUpTranInfoPattern( McTranInfoPattern csUpPttn)
        {
            m_csUpTranInfoPttn = csUpPttn;
        }

        /// <summary><para>method outline:</para>
        /// <para>下に下る伝送データのプロパティ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDownTranInfoPattern(csDownPttn) </para>
        /// </example>
        /// <param name="csDownPttn">下に下る伝送データのプロパティ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        public void SetDownTranInfoPattern( McTranInfoPattern csDownPttn)
        {
            m_csDownTranInfoPttn = csDownPttn;
        }

        /// <summary><para>method outline:</para>
        /// <para>上下の伝送データのプロパティ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>(csDownPttn, csUpPttn) = GetDwnUpPattern() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns> (csDownTranInfoPttn, csUpTranInfoPttn)  下り、上りの各パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        public (McTranInfoPattern, McTranInfoPattern)  GetDwnUpPattern()
        { return (m_csDownTranInfoPttn, m_csUpTranInfoPttn);  }
        public  McTranInfoPattern GetDwnPattern()
        { return m_csDownTranInfoPttn; }
        public McTranInfoPattern GetUpPattern()
        { return m_csUpTranInfoPttn; }
    }
}
