// <summary>ソースコード：伝送情報共通情報管理</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル型伝送情報共通情報管理</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McTranInfoCommon : McTranCommonCellDataIF, HySVersionManagement
    {
        /// <summary> 接続識別子 </summary>
        protected HySID m_csConnectionID = new HySID("");
        /// <summary> 接続線名 </summary>
        protected HySString m_csConnectionName = new HySString("");

        /// <summary> 上流要素 </summary>
        [NonSerialized]
        protected McCmnElement m_csUpperElm = null;
        /// <summary> 下流要素 </summary>
        [NonSerialized]
        protected McCmnElement m_csLowerElm = null;
        /// <summary> 上流端子 </summary>
        [NonSerialized]
        protected McPort m_csUpperPort = null;
        /// <summary> 下流端子 </summary>
        [NonSerialized]
        protected McPort m_csLowerPort = null;

        /// <summary>内挿方法式 </summary>
        protected HySDefine.InterpolateType m_eInterpolateType = HySDefine.InterpolateType.NO_INTERPOLATE;
        //// <summary>セル内データを取得するクラスを管理するクラス </summary>
        //protected HySCellDataGetter m_csCellDataGetter = new HySCellDataGetter(0);
        /// <summary> 受信したセル型情報取得クラス(下流に接続された要素が使用することに注意)　</summary>
        protected McReceiveCellData m_csRevCellData = null;
        /// <summary>送信するセル型情報設定クラス(上流に接続された要素が使用する事に注意)</summary>
        protected McSendCellData m_csSendCellData = null;

        //// <summary>セル内データを取得するクラスを管理するクラス </summary>
        //protected HySCellDataGetter m_csCellDataGetter = new HySCellDataGetter(0);

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTranInfoCommon = csTranInfoCommon = new McTranInfoCommon()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoCommon 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTranInfoCommon()
        {
            //バージョン情報設定
            SetNowVersion();
        } 

        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnectionID( csCnnctID ) </para>
        /// </example>
        /// <param name="csCnnctID">接続線ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnectionID(HySID csCnnctID)
        {
            m_csConnectionID = csCnnctID;
        }
        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続線ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        public virtual HySID GetConnectionID()
        { return m_csConnectionID; }

        /// <summary><para>method outline:</para>
        /// <para>接続線名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnectionName( csCnnctName ) </para>
        /// </example>
        /// <param name="csCnnctName">接続線名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素複数の接続線で結ぶ場合等に使用</para>
        /// </remarks>
        public virtual void SetConnectionName(HySString csCnnctName)
        {
            m_csConnectionName = csCnnctName;
            //m_csConnectionName.SetChar(csCnnctName.ToString());
        }
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        public virtual HySString GetConnectionName()
        { return m_csConnectionName; }

        /// <summary><para>method outline:</para>
        /// <para>上流要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUpperElement( csElm ) </para>
        /// </example>
        /// <param name="csElm">要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された要素を設定する</para>
        /// </remarks>
        public virtual void SetUpperElement(McElement csElm)
        { m_csUpperElm = csElm as McCmnElement; }
        /// <summary><para>method outline:</para>
        /// <para>下流要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLowerElement( csElm ) </para>
        /// </example>
        /// <param name="csElm">要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された要素を設定する</para>
        /// </remarks>
        public virtual void SetLowerElement(McElement csElm)
        { m_csLowerElm = csElm as McCmnElement; }

        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された要素を取得する</para>
        /// </remarks>
        public virtual McElement GetUpperElement()
        {
            if (m_csUpperElm == null)
            {
                m_csUpperElm = FindUpperElement();
            }
            return m_csUpperElm;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された要素を取得する</para>
        /// </remarks>
        public virtual McElement GetLowerElement()
        {
            if (m_csLowerElm == null)
            {
                m_csLowerElm = FindLowerElement();
            }
            return m_csLowerElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csElmName = GetUpperElementName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 要素名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された要素名を取得する</para>
        /// </remarks>
        public virtual HySString GetUpperElementName()
        {
            HySString csRtn = null;
            if (m_csUpperElm == null) { m_csUpperElm = FindUpperElement(); }
            if (m_csUpperElm != null)
            {
                csRtn = m_csUpperElm.GetElementName();
            }
            else
            {
                csRtn = new HySString("");
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csElmName = GetLowerElementName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 要素名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に接続された要素名を取得する</para>
        /// </remarks>
        public virtual HySString GetLowerElementName()
        {
            HySString csRtn = null;
            if (m_csLowerElm == null) { m_csLowerElm = FindLowerElement(); }
            if (m_csLowerElm != null)
            {
                csRtn = m_csLowerElm.GetElementName();
            }
            else
            {
                csRtn = new HySString("");
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual HySID GetUpperElementID()
        {
            HySID csRtn = null;
            if (m_csUpperElm == null) { m_csUpperElm = FindUpperElement(); }
            if (m_csUpperElm != null)
            {
                csRtn = (HySID)m_csUpperElm.GetID();
            }
            else
            {
                csRtn = new HySID("");
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual HySID GetLowerElementID()
        {
            HySID csRtn = null;
            if (m_csLowerElm == null) { m_csLowerElm = FindLowerElement(); }
            if (m_csLowerElm != null)
            {
                csRtn = (HySID)m_csLowerElm.GetID();
            }
            else
            {
                csRtn = new HySID("");
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUpperPort( csElm ) </para>
        /// </example>
        /// <param name="csPort">端子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された端子を設定する</para>
        /// </remarks>
        public virtual void SetUpperPort(McPort csPort)
        { m_csUpperPort = csPort; }
        /// <summary><para>method outline:</para>
        /// <para>下流端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLowerPort( csPort ) </para>
        /// </example>
        /// <param name="csPort">端子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された端子を設定する</para>
        /// </remarks>
        public virtual void SetLowerPort(McPort csPort)
        { m_csLowerPort = csPort; }
        /// <summary><para>method outline:</para>
        /// <para>上流端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPort csPort = GetUpperPort( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPort 端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された端子を取得する</para>
        /// </remarks>
        public virtual McPort GetUpperPort()
        { return m_csUpperPort; }
        /// <summary><para>method outline:</para>
        /// <para>下流端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPort csPort = GetLowerPort( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPort 端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された端子を取得する</para>
        /// </remarks>
        public virtual McPort GetLowerPort()
        { return m_csLowerPort; }

        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetInterpolateType(HySDefine.InterpolateType eInterpolateType)
        {
            m_eInterpolateType = eInterpolateType;
        }
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDefine.InterpolateType GetInterpolateType()
        {
            return m_eInterpolateType;
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellGetter); </para>
        /// </example>
        /// <param name="csCellGetter">セル内データ取得クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataGetter(HySCellDataGetter csCellGetter)
        {
            m_csCellDataGetter = new HySCellDataGetter(csCellGetter);
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellDataGetter GetCellDataGetter()
        {
            return m_csCellDataGetter;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McReceiveCellDataIF csRevDt = GetReceiveCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McReceiveCellDataIF 受信したセル型情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報本体をを取得する</para>
        /// </remarks>
        public virtual McReceiveCellDataIF GetReceiveCellData()
        { return m_csRevCellData; }
        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateMcReceiveCellData(csPrptyInf); </para>
        /// </example>
        /// <param name="csPrptyInf">セル型伝送データプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>生成したインスタンスは自身のメンバー変数として保持</para>
        /// </remarks>
        public virtual void CreateMcReceiveCellData(McCellTranPropertyIF csPrptyInf)
        {
            m_csRevCellData = new McReceiveCellData();
            McTranInfoPattern csTranInfoPattern = ((McCellArrayTranInfoPropertyInfo)csPrptyInf).GetSendTranInfoPattern() as McTranInfoPattern;
            // 下流に接続された要素が使用するため、GetSendTranInfoPattern()で取得したパターンを使用する
            if (csTranInfoPattern != null)
            {
                this.SetCellDataCharacteristic(csTranInfoPattern.GetCellDataCharacteristic());
                m_csRevCellData.SetCellDataGetter(new HySCellDataGetter(csPrptyInf.GetCellDataGetter()));
            }
            m_csRevCellData.SetInterpolateType(csPrptyInf.GetInterpolateType());
            csTranInfoPattern = ((McCellArrayTranInfoPropertyInfo)csPrptyInf).GetReceiveTranInfoPattern() as McTranInfoPattern;
            // 上流からのパターンを取得する
            if (csTranInfoPattern != null)
            {
                m_csRevCellData.SetReceiveTranInfoPattern(csTranInfoPattern);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csSndDt = GetSendCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF 送信するセル型情報設定クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて送信情報を設定する</para>
        /// </remarks>
        public virtual McSendCellDataIF GetSendCellData()
        { return m_csSendCellData; }
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateSendCellData(csPrptyInf); </para>
        /// </example>
        /// <param name="csPrptyInf">セル型伝送データプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>生成したインスタンスは自身のメンバー変数として保持</para>
        /// </remarks>
        public virtual void CreateSendCellData(McCellTranPropertyIF csPrptyInf)
        {
            McCellArrayTranInfoPropertyInfo csCellPrpty = csPrptyInf as McCellArrayTranInfoPropertyInfo;
            if (csCellPrpty == null) { return; }

            m_csSendCellData = new McSendCellData();
            m_csSendCellData.SetCellIDMngData(csCellPrpty.GetCellIDMngData() as HySCellIDManageData);

            McTranInfoPattern csTranInfoPattern = csCellPrpty.GetReceiveTranInfoPattern() as McTranInfoPattern;
            // 上流に接続された要素が使用するため、GetReceiveTranInfoPattern()で取得したパターンを使用する
            if (csTranInfoPattern != null)
            {
                m_csSendCellData.SetTranInfoPattern(csTranInfoPattern);
                m_csSendCellData.SetID(csTranInfoPattern.GetPatternID());
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        {
            long lDim = csCellChara.GetDataNumber();
            //HySCellDataGetter csGetter = new HySCellDataGetter(lDim);
            //m_csRevCellData.SetCellDataGetter(csGetter);
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranCommonCellDataIF Clone()
        {
            McTranInfoCommon csRtn = new McTranInfoCommon();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CopyInfo(McTranCommonCellDataIF csOrgInfo)
        {
            McTranInfoCommon csOrg = csOrgInfo as McTranInfoCommon;
            if (csOrg != null)
            {
                this.m_csConnectionID = csOrg.m_csConnectionID.Clone();
                this.m_csConnectionName = csOrg.m_csConnectionName.Clone();
                this.m_csUpperElm = csOrg.m_csUpperElm;
                this.m_csLowerElm = csOrg.m_csLowerElm;
                this.m_eInterpolateType = csOrg.m_eInterpolateType;
                //this.m_csCellDataGetter = new HySCellDataGetter(csOrg.m_csCellDataGetter);
                if (csOrg.m_csRevCellData != null)
                {
                    this.m_csRevCellData = csOrg.m_csRevCellData.Clone();
                }
                else
                {
                    this.m_csRevCellData = null;
                }
                // 
                if (csOrg.m_csSendCellData != null)
                {
                    this.m_csSendCellData = csOrg.m_csSendCellData.Clone() as McSendCellData;
                }
                else
                {
                    this.m_csSendCellData = null;
                }
            }

            return true;
        }


        /// <summary><para>method outline:</para>
        /// <para>上流接続端子から上流に設定された要素を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = FindUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流要素が null の場合に使用する</para>
        /// </remarks>
        internal virtual McCmnElement FindUpperElement()
        {
            McCmnElement csRtn = m_csUpperElm;

            McReceiveTrnsPort csRvTrnPort = m_csUpperPort as McReceiveTrnsPort;
            if (csRvTrnPort != null)
            {
                csRtn = csRvTrnPort.GetElement() as McCmnElement;
            }
            else
            {
                McSendTrnsPort csSndTrnPort = m_csUpperPort as McSendTrnsPort;
                if (csSndTrnPort != null)
                {
                    csRtn = csSndTrnPort.GetElement() as McCmnElement;
                }
            }

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流接続端子から下流に設定された要素を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = FindLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流要素がnull の場合に使用する</para>
        /// </remarks>
        internal virtual McCmnElement FindLowerElement()
        {
            McCmnElement csRtn = m_csLowerElm;

            McReceiveTrnsPort csRvTrnPort = m_csLowerPort as McReceiveTrnsPort;
            if (csRvTrnPort != null)
            {
                csRtn = csRvTrnPort.GetElement() as McCmnElement;
            }
            else
            {
                McSendTrnsPort csSndTrnPort = m_csLowerPort as McSendTrnsPort;
                if (csSndTrnPort != null)
                {
                    csRtn = csSndTrnPort.GetElement() as McCmnElement;
                }
            }

            return csRtn;
        }

        public virtual HySID GetRcvPatternID()
        {
            return m_csRevCellData.GetReceiveTranInfoPattern().GetPatternID();
        }
        ///// <summary><para>method outline:</para>
        ///// <para>逆シリアル化時追加処理</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> OnDeserialization(csObj) </para>
        ///// </example>
        ///// <param name="csObj">コールバックを開始したオブジェクト。このパラメータの機能は、現在実装されていません。</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //void IDeserializationCallback.OnDeserialization(Object csObj)
        //{
        //}

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
