// <summary>ソースコード：ＨＹＭＣＯモデルプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>伝送情報パターンプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class McTranInfoPattern : McTranInfoPatternPropertyIF, HySVersionManagement
    {
        /// <summary>識別子 </summary>
        protected HySID m_csID;

        /// <summary>伝送データ種別 </summary>
        protected HySObjectKind m_csDataKind;
        /// <summary>セル内情報種別 </summary>
        protected HySDataCharacteristicInCell m_csCellCharacteristic;
        /// <summary>内挿方法式 </summary>
        protected HySDefine.InterpolateType m_eInterpolateType = HySDefine.InterpolateType.LINEAR;

        /// <summary>第１分割数</summary>
        protected long m_lDim1 = 1;
        /// <summary>第２分割数</summary>
        protected long m_lDim2 = 0;
        /// <summary>第３分割数</summary>
        protected long m_lDim3 = 0;
        /// <summary>セル内の変数の数</summary>
        protected long m_lDataDimInCell = 0;
        /// <summary> セル配列の次元 </summary>
        protected long m_lCellDim = 0;

        /// <summary>名称 </summary>
        protected HySString m_csName=new HySString("");
        /// <summary>ユーザー指定種別 </summary>
        protected HySObjectKind m_csKind=new HySObjectKind("");
             
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPattern 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McTranInfoPattern( )
        {
            //バージョン情報設定
            SetNowVersion();
        } 
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTranInfoPattern csPtn = new McTranInfoPattern(csID,csTranInfoKind,sName) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <param name="csTranInfoKind">伝送データ種別</param>
        /// <param name="sName">パターン名称</param>
        /// <returns>McTranInfoPattern 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTranInfoPattern(HySID csID, HySObjectKind csTranInfoKind, String sName)
        {
            this.SetPatternID(csID);
            this.SetTranDataKind(csTranInfoKind);
            this.SetName(new HySString(sName));

            if (csTranInfoKind == McTranInfoDefine.D1_CELL)
            {
                this.SetDim(16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D2_CELL)
            {
                this.SetDim(16,16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D3_CELL)
            {
                this.SetDim(16, 16,16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.SINGLE_CELL_SERIAL)
            {
                this.SetDim(1);
            }
            else if (csTranInfoKind == McTranInfoDefine.D1_CELL_SERIAL)
            {
                this.SetDim(16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D2_CELL_SERIAL)
            {
                this.SetDim(16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D3_CELL_SERIAL)
            {
                this.SetDim(16, 16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D2_GIS_MESH)
            {
                this.SetDim(16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D3_GIS_MESH)
            {
                this.SetDim(16, 16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D2_GIS_MESH_SERIAL)
            {
                this.SetDim(16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.D3_GIS_MESH_SERIAL)
            {
                this.SetDim(16, 16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL)
            {
                this.SetDim(1);
            }
            else if( csTranInfoKind == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL)
            {
                this.SetDim(16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL)
            {
                this.SetDim(16, 16);   // デフォルト値
            }
            else if (csTranInfoKind == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL)
            {
                this.SetDim(16, 16, 16);   // デフォルト値
            }
            //バージョン情報設定
            SetNowVersion();
        }

        //=== 必須情報 ====
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPatternID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetPatternID(HySID csID)
        {
            m_csID = csID.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetPatternID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySID GetPatternID()
        { return m_csID; }

        /// <summary><para>method outline:</para>
        /// <para>データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranDataKind(csDataKind) </para>
        /// </example>
        /// <param name="csDataKind">データ種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetTranDataKind(HySObjectKind csDataKind)
        {
            m_csDataKind = csDataKind.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtKind = GetTranDataKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySObjectKind GetTranDataKind()
        { return m_csDataKind; }

        /// <summary><para>method outline:</para>
        /// <para>１セル内の各データの種別を示すクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = CreateCellDataCharacteristic(3);
        ///    csKind.SetTranDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="lDim">セル内変数の数</param>
        /// <returns>HySDataCharacteristicInCell １セル内の各データの種別を示すクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySDataCharacteristicInCell CreateCellDataCharacteristic(long lDim)
        {
            return new HySDataCharacteristicInCell(lDim);
        }
        /// <summary><para>method outline:</para>
        /// <para>１セル内の各データの種別を示すクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChar); </para>
        /// </example>
        /// <param name="csCellChar">１セル内の各データの種別を示すクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChar)
        {
            m_csCellCharacteristic = csCellChar.Clone();
            m_lDataDimInCell = m_csCellCharacteristic.GetDataNumber();
        }
        /// <summary><para>method outline:</para>
        /// <para>１セル内の各データの種別を示すクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = CreateCellDataCharacteristic();
        ///    csKind.SetTranDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell １セル内の各データの種別を示すクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellCharacteristic; }

        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信側のみ使用する</para>
        /// </remarks>
        public virtual void SetInterpolateType(HySDefine.InterpolateType eInterpolateType)
        {
            m_eInterpolateType = eInterpolateType;
        }
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信側のみ使用する</para>
        /// </remarks>
        public virtual HySDefine.InterpolateType GetInterpolateType()
        {
            return m_eInterpolateType;
        }

        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDim(long lDim1)
        {
            m_lDim1 = lDim1;
            m_lCellDim = 1;
        }
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDim(long lDim1, long lDim2)
        {
            m_lDim1 = lDim1;
            m_lDim2 = lDim2;
            if (m_lDim2 == 0) { m_lCellDim = 1; }
            else { m_lCellDim = 2; }
        }
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDim(long lDim1, long lDim2, long lDim3)
        {
            m_lDim1 = lDim1;
            m_lDim2 = lDim2;
            if(m_lDim2 == 0) { m_lCellDim = 1; }
            else 
            {
                m_lDim3 = lDim3;
                if (m_lDim3 == 0) { m_lCellDim = 2; }
                else { m_lCellDim = 3; }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <param name="lDataDimInCell">セル内変数の数</param>
        /// <returns>long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3, ref long lDataDimInCell)
        {
            lDim1 = m_lDim1;
            lDim2 = m_lDim2;
            lDim3 = m_lDim3;
            lDataDimInCell = m_lDataDimInCell = m_csCellCharacteristic.GetDataNumber();
            return m_lCellDim;
        }

        //=== 補足情報 ====
        /// <summary><para>method outline:</para>
        /// <para>名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetName( csName ) </para>
        /// </example>
        /// <param name="csName">名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        virtual public void SetName(HySString csName)
        {
            m_csName = csName.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        virtual public HySString GetName()
        {
            return m_csName;
        }
        /// <summary><para>method outline:</para>
        /// <para>ユーザー定義種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetKind(csKind) </para>
        /// </example>
        /// <param name="csKind">ユーザー定義種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetKind(HySObjectKind csKind)
        {
            m_csKind = csKind.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>ユーザー定義種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtKind = GetKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind ユーザー定義種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySObjectKind GetKind()
        { return m_csKind; }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csDt = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfoPatternPropertyIF Clone()
        {
            McTranInfoPattern csRtn = new McTranInfoPattern();
            csRtn.m_csID = this.m_csID.Clone();
            csRtn.m_csDataKind = this.m_csDataKind.Clone();
            csRtn.m_csCellCharacteristic = this.m_csCellCharacteristic.Clone();
            csRtn.m_eInterpolateType = this.m_eInterpolateType;
            csRtn.SetDim(m_lDim1, m_lDim2, m_lDim3);
            csRtn.m_lDataDimInCell = this.m_lDataDimInCell;
            csRtn.m_csName = this.m_csName.Clone();
            csRtn.m_csKind = this.m_csKind.Clone();
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>パターン情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = HySXmlNode.CreateElement(McTranInfoPattern.xml_TrnInfoRoot, csXmlWriter);
                            
            csRtn.SetAttribute(McTranInfoPattern.xml_ID, m_csID.ToString());          
            csRtn.SetAttribute(McTranInfoPattern.xml_DataKIND, m_csDataKind.ToString());
            csRtn.SetAttribute(McTranInfoPattern.xml_InterpolateType, m_eInterpolateType.ToString());
            csRtn.SetAttribute(McTranInfoPattern.xml_Name, m_csName.ToString());
            csRtn.SetAttribute(McTranInfoPattern.xml_Kind, m_csKind.ToString());

            HySXmlNode csLclNode = HySXmlNode.CreateElement(McTranInfoPattern.xml_DimPara, csXmlWriter);
            csLclNode.SetAttribute(McTranInfoPattern.xml_Dim1, m_lDim1.ToString());
            csLclNode.SetAttribute(McTranInfoPattern.xml_Dim2, m_lDim2.ToString());
            csLclNode.SetAttribute(McTranInfoPattern.xml_Dim3, m_lDim3.ToString());
            csLclNode.SetAttribute(McTranInfoPattern.xml_DimInCell, m_lDataDimInCell.ToString());
            csLclNode.SetAttribute(McTranInfoPattern.xml_CellDim, m_lCellDim.ToString());
            csRtn.AppendChild(csLclNode);

            if (m_csCellCharacteristic != null)
            {
                csLclNode = m_csCellCharacteristic.XmlOUT(ref csXmlWriter);
                csRtn.AppendChild(csLclNode);
            }


            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>XMLからパターン情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlIN(HySXmlNode csXml)
        {
            bool bRtn = true;

            string sWork = csXml.GetAttribute(McTranInfoPattern.xml_ID);
            m_csID = new HySID(sWork);
            sWork = csXml.GetAttribute(McTranInfoPattern.xml_DataKIND);
            m_csDataKind = new HySObjectKind(sWork);

            m_eInterpolateType = HySDefine.InterpolateType.LINEAR;
            sWork = csXml.GetAttribute(McTranInfoPattern.xml_InterpolateType);
            if (sWork == "NO_INTERPOLATE")
            {
                m_eInterpolateType = HySDefine.InterpolateType.NO_INTERPOLATE;
            }
            else if (sWork == "GET_NEXT_DATA")
            {
                m_eInterpolateType = HySDefine.InterpolateType.GET_NEXT_DATA;
            }
            
            sWork = csXml.GetAttribute(McTranInfoPattern.xml_Name);
            m_csName = new HySString(sWork);
            
            sWork = csXml.GetAttribute(McTranInfoPattern.xml_Kind);
            m_csKind = new HySObjectKind(sWork);

            if (m_csCellCharacteristic == null)
            {
                m_csCellCharacteristic = new HySDataCharacteristicInCell(1);
            }
            HySXmlNode csXmlValNode;
            HySXmlNodeList csXmlValNodeList = csXml.GetChildNodeListByTagName(HySDefine.xml_DATA_CHARACTERISTIC_IN_CELL);
            if (csXmlValNodeList.GetCount() >= 1)
            {
                csXmlValNode = csXmlValNodeList.GetNode(0);
                m_csCellCharacteristic.XmlIN(csXmlValNode);
            }

            csXmlValNodeList = csXml.GetChildNodeListByTagName(McTranInfoPattern.xml_DimPara);
            csXmlValNode = csXmlValNodeList.GetNode(0);
            
            sWork = csXmlValNode.GetAttribute(McTranInfoPattern.xml_Dim1);
            m_lDim1 = Int32.Parse(sWork);
            
            sWork = csXmlValNode.GetAttribute(McTranInfoPattern.xml_Dim2);
            m_lDim2 = Int32.Parse(sWork);
            
            sWork = csXmlValNode.GetAttribute(McTranInfoPattern.xml_Dim3);
            m_lDim3 = Int32.Parse(sWork);
            
            sWork = csXmlValNode.GetAttribute(McTranInfoPattern.xml_DimInCell);
            m_lDataDimInCell = Int32.Parse(sWork);
            
            sWork = csXmlValNode.GetAttribute(McTranInfoPattern.xml_CellDim);
            m_lCellDim = Int32.Parse(sWork);

            return bRtn;
        }

        /// <summary>XMLタグ：ルート </summary>
        static public string xml_TrnInfoRoot = "TraninfoPattern";
        /// <summary>XMLタグ：ID </summary>
        static public string xml_ID = "ID";
        /// <summary>XMLタグ：DataKind </summary>
        static public string xml_DataKIND = "DataKind";
        /// <summary>XMLタグ：内挿 </summary>
        static public string xml_InterpolateType = "InterpolateType";
        /// <summary>XMLタグ：Name </summary>
        static public string xml_Name = "Name";
        /// <summary>XMLタグ：KIND </summary>
        static public string xml_Kind = "KIND";

        /// <summary>XMLタグ：配列 </summary>
        static public string xml_DimPara = "Dimention";

        /// <summary>XMLタグ：１次元 </summary>
        static public string xml_Dim1 = "Dim1";
        /// <summary>XMLタグ：２次元 </summary>
        static public string xml_Dim2 = "Dim2";
        /// <summary>XMLタグ：３次元 </summary>
        static public string xml_Dim3 = "Dim3";
        /// <summary>XMLタグ：セル内配列 </summary>
        static public string xml_DimInCell = "DimInCell";
        /// <summary>XMLタグ：セルの配列次元 </summary>
        static public string xml_CellDim = "CellDim";
        

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
