﻿// <summary>ソースコード：セル型伝送情報プロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル型伝送情報プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>セル型伝送情報プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McCellArrayTranInfoPropertyInfo : McPropertyInfo, McCellTranPropertyIF, HySVersionManagement //McModelPropertyInfo //McPropertyInfo
    {
        /// <summary>内挿方法式 </summary>
        protected HySDefine.InterpolateType m_eInterpolateType = HySDefine.InterpolateType.LINEAR;
        /// <summary>セル内データを取得するクラスを管理するクラス </summary>
        protected HySCellDataGetter m_csCellDataGetter = new HySCellDataGetter(8);
        /// <summary> セル内のデータの意味を示す </summary>
        protected HySDataCharacteristicInCell m_csCellDataKind = new HySDataCharacteristicInCell(0);


        /// <summary>受信側側伝送データパターン</summary>
        protected McTranInfoPattern m_csReceiveTranInfoPattern = null;
        /// <summary>送信側伝送データパターン</summary>
        protected McTranInfoPattern m_csSendTranInfoPattern = null;

        ///// <summary>セル識別子とセルの配列管理 </summary>
        //protected McCellIDMngData m_csCellIDMng = null;  親クラスの McPropertyInfoBase内にある。

        //== starto fo XML化の対象にはならないメンバー　==//
        /// <summary> 上流接続パターン識別子 </summary>
        protected HySID m_csUpperCnctPattern = new HySID("");
        /// <summary> 下流接続パターン識別子 </summary>
        protected HySID m_csLowerCnctPattern = new HySID(""); 
        /// <summary> 接続元要素情報 </summary>
        protected McModelInfo m_csUpperElmInf = null;
        /// <summary> 接続先要素情報 </summary>
        protected McModelInfo m_csLowerElmInf = null;

        /// <summary> 自プロパティ情報を保持しているMcStructConnection インスタンス</summary>
        [NonSerialized]
        protected McStructConnection m_csStructCnct = null;
        //== end fo XML化の対象にはならないメンバー　==//


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCellArrayTranInfoPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McCellArrayTranInfoPropertyInfo()
            : base(null,null)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new McCellArrayTranInfoPropertyInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCellArrayTranInfoPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void Init()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>自分を保持しているMcStructConnectionインスタンスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetStructConnection(csCnct) </para>
        /// </example>
        /// <param name="csCnct">自分を保持しているMcStructConnectionインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetStructConnection(McStructConnection csCnct)
        {
            m_csStructCnct = csCnct;
        }
        /// <summary><para>method outline:</para>
        /// <para>自インスタンスを保持しているプロジェクトのＩＤ値を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sID = GetOwnerProjectID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>自インスタンスを保持しているプロジェクトのＩＤ値</returns>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override string GetOwnerProjectID()
        {
            string sRtn = "";
            if (m_csStructCnct != null)
            {
                McStructGroupElement csOwnerGrElm = m_csStructCnct.GetOwnerElement();
                if (csOwnerGrElm != null)
                {
                    sRtn = csOwnerGrElm.GetOwnerProjectID();
                }
            }
            return sRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="csMcModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetUpperElementModelInfor(HySDataRoot csMcModelInfo)
        {
            m_csUpperElmInf = csMcModelInfo as McModelInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="csMcModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetLowerElementModelInfor(HySDataRoot csMcModelInfo)
        {
            m_csLowerElmInf = csMcModelInfo as McModelInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetUpperModelInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelInfo　モデル情報取得</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelInfo GetUpperModelInfo()
        {
            return m_csUpperElmInf;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetLowerModelInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelInfo　モデル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelInfo GetLowerModelInfo()
        {
            return m_csLowerElmInf;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデルプロパティ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetFromElementModelInfor()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelPropertyIF　モデルプロパティ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelPropertyIF GetUpperModelProperty()
        {
            McModelPropertyIF csRtn = null;
            if (m_csUpperElmInf != null)
            {
                csRtn = m_csUpperElmInf.GetPropertyInfo() as McModelPropertyIF;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデルプロパティ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetToElementModelInfor()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelPropertyIF　モデルプロパティ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelPropertyIF GetLowerModelProperty()
        {
            McModelPropertyIF csRtn = null;
            if (m_csLowerElmInf != null)
            {
                csRtn = m_csLowerElmInf.GetPropertyInfo() as McModelPropertyIF;
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperConnectionPatternID(csCnnctPtnID)</para>
        /// </example>
        /// <param name="csCnnctPtnID">接続パターンＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetUpperConnectionPatternID(HySID csCnnctPtnID)
        {
            m_csUpperCnctPattern = csCnnctPtnID.Clone();

            m_csSendTranInfoPattern = null;// 初期化
            // 受信する要素有りか？
            if (m_csUpperElmInf == null) { return; }
            // セル型か？
            McCellModelPropertyInfo csCellElmPrpty = m_csUpperElmInf.GetPropertyInfo() as McCellModelPropertyInfo;
            if (csCellElmPrpty == null) { return; }

            // 送信要素が　準備するパターンのリスト
            HySDataLinkedList csSndPtnList = csCellElmPrpty.GetSendPatternList();
            if (csSndPtnList != null)
            {
                long lNum = csSndPtnList.GetCount();
                csSndPtnList.SetCursorFirst();
                McTranInfoPattern csSndPtn = null;
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csSndPtn = csSndPtnList.GetCursorData() as McTranInfoPattern;
                    if (csSndPtn == null) { continue; }
                    //if (m_csLowerCnctPattern.Equals(csSndPtn.GetPatternID()) == true)
                    if (m_csUpperCnctPattern.Equals(csSndPtn.GetPatternID()) == true)
                    {   // IDが一致
                        this.SetSendTranInfoPattern(csSndPtn);
                        break;
                    }
                    csSndPtnList.MoveCursorNext();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csCnnctPtnID = GetUpperConnectionPatternID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続パターンＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetUpperConnectionPatternID()
        {
            return m_csUpperCnctPattern;
        }
        /// <summary><para>method outline:</para>
        /// <para>送信側セル型伝送パターンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSendTranInfoPattern(csTranInfoPattern); </para>
        /// </example>
        /// <param name="csTranInfoPattern">セル型伝送パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSendTranInfoPattern(McTranInfoPatternPropertyIF csTranInfoPattern)
        {
            m_csSendTranInfoPattern = csTranInfoPattern as McTranInfoPattern;
            //m_csCellDataGetter = new HySCellDataGetter(csTranInfoPattern.GetCellDataCharacteristic().GetDataNumber());
        }
        /// <summary><para>method outline:</para>
        /// <para>セル型伝送パターンの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csTranInfoPattern=GetSendTranInfoPattern(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPatternPropertyIF セル型伝送パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfoPatternPropertyIF GetSendTranInfoPattern()
        { return m_csSendTranInfoPattern; }

        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerConnectionPatternID(csCnnctPtnID)</para>
        /// </example>
        /// <param name="csCnnctPtnID">接続パターンＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetLowerConnectionPatternID(HySID csCnnctPtnID)
        {
            m_csLowerCnctPattern = csCnnctPtnID.Clone();

            m_csReceiveTranInfoPattern = null; // 初期化

            // 受信する要素有りか？
            if (m_csLowerElmInf == null) { return; }
            // セル型か？
            McCellModelPropertyInfo csCellElmPrpty = m_csLowerElmInf.GetPropertyInfo() as McCellModelPropertyInfo;
            if (csCellElmPrpty == null) { return; }

            // 受信要素が　準備するパターンのリスト
            //m_csUpperElmInf.GetPropertyInfo();
            HySDataLinkedList csRsvPtnList = csCellElmPrpty.GetReceivePatternList();
            if (csRsvPtnList != null)
            {
                long lNum = csRsvPtnList.GetCount();
                csRsvPtnList.SetCursorFirst();
                McTranInfoPattern csRvPtn = null;
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csRvPtn = csRsvPtnList.GetCursorData() as McTranInfoPattern;
                    if (csRvPtn == null) { continue; }
                    //if (m_csUpperCnctPattern.Equals(csRvPtn.GetPatternID()) == true)
                    if (m_csLowerCnctPattern.Equals(csRvPtn.GetPatternID()) == true)
                    {   // IDが一致
                        this.SetReceiveTranInfoPattern(csRvPtn);
                        break;
                    }
                    csRsvPtnList.MoveCursorNext();
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csCnnctPtnID = GetLowerConnectionPatternID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続パターンＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetLowerConnectionPatternID()
        {
            return m_csLowerCnctPattern;
        }
        /// <summary><para>method outline:</para>
        /// <para>受信側セル型伝送パターンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetReceiveTranInfoPattern(csTranInfoPattern); </para>
        /// </example>
        /// <param name="csTranInfoPattern">セル型伝送パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetReceiveTranInfoPattern(McTranInfoPatternPropertyIF csTranInfoPattern)
        {
            m_csReceiveTranInfoPattern = csTranInfoPattern as McTranInfoPattern;
            if (m_csReceiveTranInfoPattern != null)
            {
                m_csCellDataGetter = new HySCellDataGetter(csTranInfoPattern.GetCellDataCharacteristic().GetDataNumber());
                m_eInterpolateType = m_csReceiveTranInfoPattern.GetInterpolateType();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>受信側セル型伝送パターンの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csTranInfoPattern=GetReceiveTranInfoPattern(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPatternPropertyIF セル型伝送パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfoPatternPropertyIF GetReceiveTranInfoPattern()
        { return m_csReceiveTranInfoPattern; }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McCellArrayTranInfoPropertyInfo csRtn = new McCellArrayTranInfoPropertyInfo(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);
            McCellArrayTranInfoPropertyInfo csOrgPrpty = csOrgObj as McCellArrayTranInfoPropertyInfo;
            if (csOrgPrpty != null)
            {
                m_eInterpolateType = csOrgPrpty.m_eInterpolateType;
                m_csCellDataGetter = new HySCellDataGetter(csOrgPrpty.m_csCellDataGetter);
                m_csCellDataKind = csOrgPrpty.m_csCellDataKind.Clone();
                if (csOrgPrpty.m_csReceiveTranInfoPattern != null)
                {
                    m_csReceiveTranInfoPattern = csOrgPrpty.m_csReceiveTranInfoPattern.Clone() as McTranInfoPattern;
                }
                if (csOrgPrpty.m_csSendTranInfoPattern != null)
                {
                    m_csSendTranInfoPattern = csOrgPrpty.m_csSendTranInfoPattern.Clone() as McTranInfoPattern;
                }
                m_csUpperCnctPattern = csOrgPrpty.m_csUpperCnctPattern.Clone();
                m_csLowerCnctPattern = csOrgPrpty.m_csLowerCnctPattern.Clone();
                m_csUpperElmInf = csOrgPrpty.m_csUpperElmInf;
                m_csLowerElmInf = csOrgPrpty.m_csLowerElmInf;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDim(long lDim1)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);

            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIM1, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY, McDefine.ValKind.LONG); // "セル配列数"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIM1, lDim1);
        }
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDim(long lDim1,long lDim2)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM2);

            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIM1, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_DIM1, McDefine.ValKind.LONG);    //"セル配列数（第１配列）"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIM1, lDim1);
            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIM2, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_DIM2, McDefine.ValKind.LONG);    //"セル配列数（第２配列）"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIM2, lDim2);
        }
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDim(long lDim1, long lDim2, long lDim3)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM2);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM3);

            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIM1, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_DIM1, McDefine.ValKind.LONG);    //"セル配列数（第１配列）"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIM1, lDim1);
            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIM2, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_DIM2, McDefine.ValKind.LONG);    //"セル配列数（第２配列）"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIM2, lDim2);
            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIM3, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_DIM3, McDefine.ValKind.LONG);    //"セル配列数（第３配列）"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIM3, lDim3);
        }

        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim1 = GetDim1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第１配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDim1()
        {
            long  lRtn = 1;
            this.GetInfo(McCellArrayTranInfoPropertyInfo.DIM1, ref lRtn);
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim2 = GetDim2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第２配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDim2()
        {
            long lRtn = 0;
            this.GetInfo(DIM2, ref lRtn);
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim3 = GetDim3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第３配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDim3()
        {
            long lRtn = 0;
            this.GetInfo(DIM3, ref lRtn);
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内変数の数を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDimInCell(lDataNum) </para>
        /// </example>
        /// <param name="lDataNum">セル内変数の数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDimInCell(long lDataNum)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIMINCELL);

            this.AddInfoType(McCellArrayTranInfoPropertyInfo.DIMINCELL, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_DIMINCELL, McDefine.ValKind.LONG);  //"セル内変数の数"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.DIMINCELL, lDataNum);

            m_csCellDataGetter = new HySCellDataGetter(lDataNum);
            m_csCellDataKind = new HySDataCharacteristicInCell(lDataNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内変数の配列数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内変数の配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimInCell()
        {
            long lRtn = 0;
            this.GetInfo(DIMINCELL, ref lRtn);
            return lRtn;
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>保持できる最大レコード数を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMaxRecordDataNum(lMaxRecord) </para>
        /// </example>
        /// <param name="lMaxRecord">最大レコード数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列情報の場合に有効</para>
        /// </remarks>
        public virtual void SetMaxRecordDataNum(long lMaxRecord)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.MAX_RECORD_DATA_NUM);
            this.AddInfoType(McCellArrayTranInfoPropertyInfo.MAX_RECORD_DATA_NUM, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_CELL_ARRAY_MAX_RECORD, McDefine.ValKind.LONG);   //"最大レコード数"
            this.SetInfo(McCellArrayTranInfoPropertyInfo.MAX_RECORD_DATA_NUM, lMaxRecord);
        }
        /// <summary><para>method outline:</para>
        /// <para>保持できる最大レコード数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetMaxRecordDataNum() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 最大レコード数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列情報の場合に有効</para>
        /// </remarks>
        public virtual long GetMaxRecordDataNum()
        {
            long lRtn = 0;
            this.GetInfo(MAX_RECORD_DATA_NUM, ref lRtn);
            return lRtn;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列情報の場合に有効</para>
        /// </remarks>
        public virtual void SetInterpolateType(HySDefine.InterpolateType eInterpolateType)
        {
            m_eInterpolateType = eInterpolateType;
        }
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列情報の場合に有効</para>
        /// </remarks>
        public virtual HySDefine.InterpolateType GetInterpolateType()
        {
            return m_eInterpolateType;
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellGetter); </para>
        /// </example>
        /// <param name="csCellGetter">セル内データ取得クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataGetter(HySCellDataGetter csCellGetter)
        {
            m_csCellDataGetter = new HySCellDataGetter(csCellGetter);
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellDataGetter GetCellDataGetter()
        {
            return m_csCellDataGetter;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();
        ///    csKind.SetTranDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellDataKind; }

        /*       
        /// <summary><para>method outline:</para>
        /// <para>伝送情報に合った　受信設定パターンリコメンドパターンを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPattern = csPtn = GetRecommendReceiveCellPattern() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPattern 受信設定パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ｵﾍﾟﾚｰﾀが何も設定しない場合等に用いる</para>
        /// </remarks>
        public McTranInfoPattern GetRecommendReceiveCellPattern()
        {
            McTranInfoPattern csRtn = null; // リコメンド値

            // 受信する要素有りか？
            if (m_csLowerElmInf == null) { return csRtn; }
            // セル型か？
            McCellModelPropertyInfo csCellElmPrpty = m_csLowerElmInf.GetPropertyInfo() as McCellModelPropertyInfo;
            if (csCellElmPrpty == null) { return csRtn; }

            // 受信要素が　準備するパターンのリスト
            HySDataLinkedList csRsvPtnList = csCellElmPrpty.GetReceivePatternList();
            if (csRsvPtnList != null)
            {
                long lNum = csRsvPtnList.GetCount(); 
                csRsvPtnList.SetCursorFirst();
                McTranInfoPattern csRvPtn = null;
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csRvPtn = csRsvPtnList.GetCursorData() as McTranInfoPattern;
                    if (csRvPtn == null) { continue; }
                    if (csRvPtn.GetTranDataKind().Equals(this.m_csModelKind) == true)
                    {   // 型が一致
                        csRtn = csRvPtn;
                        break;
                    }
                    csRsvPtnList.MoveCursorNext();
                }
            }
            return csRtn;
        }
        */
        /*
        /// <summary><para>method outline:</para>
        /// <para>伝送情報に合った　送信設定パターンリコメンドパターンを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPattern = csPtn = GetRecommendSendCellPattern() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPattern 送信設定パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ｵﾍﾟﾚｰﾀが何も設定しない場合等に用いる</para>
        /// </remarks>
        public McTranInfoPattern GetRecommendSendCellPattern()
        {
            McTranInfoPattern csRtn = null; // リコメンド値

            // 受信する要素有りか？
            if (m_csUpperElmInf == null) { return csRtn; }
            // セル型か？
            McCellModelPropertyInfo csCellElmPrpty = m_csUpperElmInf.GetPropertyInfo() as McCellModelPropertyInfo;
            if (csCellElmPrpty == null) { return csRtn; }

            // 送信要素が　準備するパターンのリスト
            HySDataLinkedList csSndPtnList = csCellElmPrpty.GetSendPatternList();
            if (csSndPtnList != null)
            {
                long lNum = csSndPtnList.GetCount();
                csSndPtnList.SetCursorFirst();
                McTranInfoPattern csSndPtn = null;
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csSndPtn = csSndPtnList.GetCursorData() as McTranInfoPattern;
                    if (csSndPtn == null) { continue; }
                    if (csSndPtn.GetTranDataKind().Equals(this.m_csModelKind) == true)
                    {   // 型が一致
                        csRtn = csSndPtn;
                        break;
                    }
                    csSndPtnList.MoveCursorNext();
                }
            }
            return csRtn;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = base.XmlOUT(ref csXmlWriter);
            //if (g_bXmlOutFlg == true)
            {   // XML出力ONならば
                HySXmlNode csLclNode = null;
                if (m_csSendTranInfoPattern != null)
                {
                    csLclNode = HySXmlNode.CreateElement(McDefine.xml_SEND_ELM_PATTERN, csXmlWriter);
                    csLclNode.SetAttribute(McDefine.xml_PATTERN_ID, m_csSendTranInfoPattern.GetPatternID().ToString());
                    csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                } 
                if (m_csReceiveTranInfoPattern != null)
                {
                    csLclNode = HySXmlNode.CreateElement(McDefine.xml_RECV_ELM_PATTERN, csXmlWriter);
                    csLclNode.SetAttribute(McDefine.xml_PATTERN_ID, m_csReceiveTranInfoPattern.GetPatternID().ToString());
                    csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                }

                // 内挿方法種別を出力
                csLclNode = HySXmlNode.CreateElement(McDefine.xml_INTERPOLATETYPE, csXmlWriter);
                if (m_eInterpolateType == HySDefine.InterpolateType.LINEAR)
                {
                    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sLINEAR_INTERPOLATE);
                }
                else if (m_eInterpolateType == HySDefine.InterpolateType.GET_NEXT_DATA)
                {
                    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sGET_NEXT_DATA_INTERPOLATE);
                }
                //else if (m_eInterpolateType == HySDefine.InterpolateType.POLYNOMIAL)
                //{
                //    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sPOLYNOMIAL_INTERPOLATE);
                //}
                else
                {
                    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sNO_INTERPOLATE);
                }
                csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う

                //m_csCellDataGetter出力
                csLclNode = m_csCellDataGetter.XmlOUT(ref csXmlWriter);
                csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う

                //m_csCellDataKind出力  <-- これは不用
                //csLclNode = m_csCellDataKind.XmlOUT(ref csXmlWriter);
                //csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う

                /* 親クラス側で行っている為不用
                // セル対応表の出力が必要
                McCellIDMngIF csMngDt = this.GetCellIDMngData();
                if( csMngDt != null )
                {
                    if (g_bXmlOutFlg == true)
                    {   // XML出力ONならば
                        csLclNode = csMngDt.XmlOUT(ref csXmlWriter);
                        csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                    }
                    else
                    {
                        HySString csFileName = csMngDt.GetXmlFileName();
                        csLclNode = HySXmlNode.CreateElement(McDefine.xml_CELLID_MNG_FILE, csXmlWriter);
                        csLclNode.SetAttribute(McDefine.xml_NAME, csFileName.ToString());
                        csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う

                        csMngDt.XmlFileWrite(); // 別ﾌｧｲﾙとして　内容を出力する
                    }
                }
                */
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csPrptyXml)
        {
            bool bRtn = base.XmlIN(csPrptyXml);

            HySXmlNode csXml = null;
            HySXmlNodeList csXmlVariableList = null;
            // 送信パターン設定情報取得
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_SEND_ELM_PATTERN);
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null && this.m_csUpperElmInf != null)
                {
                    string sKeyAttr = csXml.GetAttribute(McDefine.xml_PATTERN_ID);
                    HySID csPtnID = new HySID(sKeyAttr);
                    m_csUpperCnctPattern = csPtnID;
                    McCellModelPropertyInfo csMdlPrpty = this.m_csUpperElmInf.GetPropertyInfo() as McCellModelPropertyInfo;
                    if (csMdlPrpty != null)
                    {
                        this.SetSendTranInfoPattern(csMdlPrpty.GetSendPattern(csPtnID));
                    }
                }
            }
            // 受信パターン設定情報取得
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_RECV_ELM_PATTERN);
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null && this.m_csLowerElmInf != null)
                {
                    string sKeyAttr = csXml.GetAttribute(McDefine.xml_PATTERN_ID);
                    HySID csPtnID = new HySID(sKeyAttr);
                    m_csLowerCnctPattern = csPtnID; 
                    McCellModelPropertyInfo csMdlPrpty = this.m_csLowerElmInf.GetPropertyInfo() as McCellModelPropertyInfo;
                    if (csMdlPrpty != null)
                    {
                        this.SetReceiveTranInfoPattern(csMdlPrpty.GetReceivePattern(csPtnID));
                    }
                }
            }
            // 内挿方法取得復元
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_INTERPOLATETYPE);
            //long lValCnt = csXmlVariableList.GetCount();  <-- 通常は１個
            //for (long lLoop = 0; lLoop < lValCnt; lLoop++)
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null)
                {
                    string sKeyAttr = csXml.GetAttribute(McDefine.xml_MODELKIND);
                    if (HySDefine.sLINEAR_INTERPOLATE.Equals(sKeyAttr) == true)
                    {   // 線形内挿補間ならば
                        m_eInterpolateType = HySDefine.InterpolateType.LINEAR;
                    }
                    else if (HySDefine.sGET_NEXT_DATA_INTERPOLATE.Equals(sKeyAttr) == true)
                    { // 直後値取得ならば
                        m_eInterpolateType = HySDefine.InterpolateType.GET_NEXT_DATA;
                    }
                    //else if (HySDefine.sPOLYNOMIAL_INTERPOLATE.Equals(sKeyAttr) == true)
                    //{ // 多項式補間ならば
                    //    m_eInterpolateType = HySDefine.InterpolateType.POLYNOMIAL;
                    //}
                    else
                    {
                        m_eInterpolateType = HySDefine.InterpolateType.NO_INTERPOLATE;
                    }
                }
            }

            // m_csCellDataGetter 復元
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(HySDefine.xml_CELL_DATA_GETTER);
            m_csCellDataGetter.XmlIN(csXmlVariableList.GetNode(0));

            // m_csCellDataKind復元  <-- これは不用
            //csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(HySDefine.xml_DATA_CHARACTERISTIC_IN_CELL);
            //m_csCellDataKind.XmlIN(csXmlVariableList.GetNode(0));

            /* 親クラス側で行っている為不用
            // セル対応表の復元が必要
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_CELLID_MNG_FILE);
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null)
                {
                    string sKeyAttr = csXml.GetAttribute(McDefine.xml_NAME);
                    HySString csFileName = new HySString(sKeyAttr);
                    McCellIDMngIF csMngDt = this.GetCellIDMngData();
                    csMngDt.SetXmlFileName(csFileName);
                    csMngDt.XmlFileRead();
                }
                //else
                //{
                //}
            }
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_MODEL_CELL_GIS_TABLE);
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null)
                {
                    McCellIDMngIF csMngDt = this.GetCellIDMngData();
                    csMngDt.XmlIN(csXml);
                }
            }
            */

            return bRtn;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

        /// <summary> 第１配列数 </summary>
        public static string DIM1 = "Dim1";
        /// <summary> 第２配列数 </summary>
        public static string DIM2 = "Dim2";
        /// <summary> 第２配列数 </summary>
        public static string DIM3 = "Dim3";
        /// <summary> セル内変数配列数 </summary>
        public static string DIMINCELL = "DimInCell";

        /// <summary>  最大レコード数（指定された数までレコードを保持できる）</summary>
        [Obsolete("旧バージョン互換用：使用を奨励しない(McPropertyInfo.MAX_RECORD_DATA_NUM を使用する事)")]
        static public new string MAX_RECORD_DATA_NUM = "MaxRecordDataNum";
    }
}
