﻿// <summary>ソースコード：ＧＩＳ型伝送情報プロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ＧＩＳ型プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>ＧＩＳ型プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McGeoMeshTranInfoPropertyInfo : McCellArrayTranInfoPropertyInfo, HySVersionManagement //McPropertyInfo, McCellTranPropertyIF //McModelPropertyInfo //McPropertyInfo
    {
        //// <summary>内挿方法式 </summary>
        //protected HySDefine.InterpolateType m_eInterpolateType = HySDefine.InterpolateType.LINEAR;
        //// <summary>セル内データを取得するクラスを管理するクラス </summary>
        //protected McCellDataGetterManager m_csCellDataGetterMng = new McCellDataGetterManager();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McGeoMeshTranInfoPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McGeoMeshTranInfoPropertyInfo()
            : base(null,null)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new McGeoMeshTranInfoPropertyInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGeoMeshTranInfoPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void Init()
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM2);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM3);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIMINCELL);
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McGeoMeshTranInfoPropertyInfo csRtn = new McGeoMeshTranInfoPropertyInfo(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>保持するデータの形を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetKind(eKind) </para>
        /// </example>
        /// <param name="eKind">保持するデータの形</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetKind(HySGeoMesh.MESH_DATA_KIND eKind)
        {
            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.KIND);

            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.KIND, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_KIND, McDefine.ValKind.ENUM); //"メッシュデータの種別"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.KIND, (long)eKind);
        }

        /// <summary><para>method outline:</para>
        /// <para>保持するデータの形を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lKind = GetKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoMesh.MESH_DATA_KIND 保持するデータの形</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoMesh.MESH_DATA_KIND GetKind()
        {
            long lRtn = 0;
            HySGeoMesh.MESH_DATA_KIND eRtn = HySGeoMesh.MESH_DATA_KIND.BOTH_DATA_HOLD;
            if (GetInfo(KIND, ref lRtn) == true)
            {
                eRtn = (HySGeoMesh.MESH_DATA_KIND)lRtn;
            }
            return eRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lLon">経度方向のメッシュ分割数</param>
        /// <param name="lLat">緯度方向のメッシュ分割数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDim(long lLon, long lLat)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM2);

            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.LONDIM);
            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.LATDIM);

            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.LONDIM, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_LONDIM, McDefine.ValKind.LONG); //"経度方向のメッシュ分割数"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.LONDIM, lLon);
            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.LATDIM, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_LATDIM, McDefine.ValKind.LONG); //"緯度方向のメッシュ分割数"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.LATDIM, lLat);
        }
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lLon">経度方向のメッシュ分割数</param>
        /// <param name="lLat">緯度方向のメッシュ分割数</param>
        /// <param name="lAlt">高度方向のメッシュ分割数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDim(long lLon, long lLat, long lAlt)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM2);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM3);

            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.LONDIM);
            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.LATDIM);
            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.ALTDIM);

            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.LONDIM, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_LONDIM, McDefine.ValKind.LONG); //"経度方向のメッシュ分割数"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.LONDIM, lLon);
            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.LATDIM, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_LATDIM, McDefine.ValKind.LONG); //"緯度方向のメッシュ分割数"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.LATDIM, lLat);
            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.ALTDIM, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_ALTDIM, McDefine.ValKind.LONG); //"高度方向のメッシュ分割数"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.ALTDIM, lAlt);
        }

        /// <summary><para>method outline:</para>
        /// <para>緯度方向のメッシュ分割数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lLatDim = GetLatDim() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 緯度方向のメッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetLatDim()
        {
            long lRtn = 0;
            this.GetInfo(LATDIM, ref lRtn);
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>経度方向のメッシュ分割数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lLonDim = GetLonDim() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 経度方向のメッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetLonDim()
        {
            long lRtn = 0;
            this.GetInfo(LONDIM, ref lRtn);
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>高度方向のメッシュ分割数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAltDim = GetAltDim() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 高度方向のメッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetAltDim()
        {
            long lRtn = 0;
            this.GetInfo(ALTDIM, ref lRtn);
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>１メッシュ内のデータ配列数を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDimInMesh(lDataNum) </para>
        /// </example>
        /// <param name="lDataNum">セル内変数の数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDimInMesh(long lDataNum)
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIMINCELL);
            this.RemoveInfoType(McGeoMeshTranInfoPropertyInfo.DIMINMESH);

            this.AddInfoType(McGeoMeshTranInfoPropertyInfo.DIMINMESH, Properties.HymcoImplResources.TRANINFO_PROPERTY_INFO_GEOMESH_DIMINMESH, McDefine.ValKind.LONG);   //"メッシュ内変数の数"
            this.SetInfo(McGeoMeshTranInfoPropertyInfo.DIMINMESH, lDataNum);

            m_csCellDataGetter = new HySCellDataGetter(lDataNum);
            m_csCellDataKind = new HySDataCharacteristicInCell(lDataNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>１メッシュ内のデータ配列数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDimInMesh = GetDimInMesh() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long １メッシュ内のデータ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDimInMesh()
        {
            long lRtn = 0;
            this.GetInfo(DIMINMESH, ref lRtn);
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim1 = GetDim1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第１配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long GetDim1()
        {
            return this.GetLonDim();
        }
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim2 = GetDim2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第２配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long GetDim2()
        {
            return this.GetLatDim();
        }
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim3 = GetDim3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 第３配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long GetDim3()
        {
            return this.GetAltDim();
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
       /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

        /// <summary> 保持するデータの形 </summary>
        public static string KIND = "Kind";
        /// <summary> 緯度方向のメッシュ分割数 </summary>
        public static string LATDIM = "LatDim";
        /// <summary> 経度方向のメッシュ分割数 </summary>
        public static string LONDIM = "LonDim";
        /// <summary> 高度方向のメッシュ分割数 </summary>
        public static string ALTDIM = "AltDim";
        /// <summary> １メッシュ内のデータ配列数 </summary>
        public static string DIMINMESH = "DimInMesh";
        //// <summary>  最大レコード数（指定された数までレコードを保持できる）</summary>
        //static public string MAX_RECORD_DATA_NUM = "MaxDataNum";
    }
}
