﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>相互送受信（セル型）伝送情報プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>相互送受信（セル型）伝送情報プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para> S.H [2021/01/21][新規作成] </para>
    /// </remarks>
    [Serializable]
    public  class McMutualTranInfoProperty : McCellArrayTranInfoPropertyInfo, HySVersionManagement
    {
        /// <summary> 上に遡るデータのプロパティ情報　</summary>
        protected McCellArrayTranInfoPropertyInfo m_csUpstreamTrnInfo = null;

        /// <summary> 下に下るデータのプロパティ情報　</summary>
        protected McCellArrayTranInfoPropertyInfo m_csDownstreamTrnInfo = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCellArrayTranInfoPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McMutualTranInfoProperty()
                      : base(null, null)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new McMutualTranInfoProperty(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMutualTranInfoProperty(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            if (csModelKind == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL)
            {
                m_csUpstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(csLibraryID, McTranInfoDefine.SINGLE_CELL_SERIAL);
                m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(csLibraryID, McTranInfoDefine.SINGLE_CELL_SERIAL);
            }
            else if ( csModelKind == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL )
            {
                m_csUpstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(csLibraryID, McTranInfoDefine.D1_CELL_SERIAL);
                m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(csLibraryID, McTranInfoDefine.D1_CELL_SERIAL);
                //m_csUpstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(new HySID("_Up"), McTranInfoDefine.D1_CELL_SERIAL);
                //m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(new HySID("_Dwn"), McTranInfoDefine.D1_CELL_SERIAL);
            }
            else if (csModelKind == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL)
            {
                m_csUpstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(new HySID("_Up"), McTranInfoDefine.D2_CELL_SERIAL);
                m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(new HySID("_Dwn"), McTranInfoDefine.D2_CELL_SERIAL);
            }
            else if (csModelKind == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL)
            {
                m_csUpstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(new HySID("_Up"), McTranInfoDefine.D3_CELL_SERIAL);
                m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(new HySID("_Dwn"), McTranInfoDefine.D3_CELL_SERIAL);
            }

            // ダミー値として入れておく（親クラスとの整合性から、エラー発生させないため）
            m_csCellDataGetter = new HySCellDataGetter(1);  

            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void Init()
        {
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM1);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM2);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIM3);
            this.RemoveInfoType(McCellArrayTranInfoPropertyInfo.DIMINCELL);
        }

        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>上流方向、下流方向への伝送データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranInfoProperty(csDownstreamPrpty, csUpstreamPrpty) </para>
        /// </example>
        /// <param name="csDownstreamPrpty">上流→下流伝送データ</param>
        /// <param name="csUpstreamPrpty">下流→上流伝送データ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTranInfoProperty(McCellArrayTranInfoPropertyInfo csDownstreamPrpty, McCellArrayTranInfoPropertyInfo csUpstreamPrpty)
        {
            m_csDownstreamTrnInfo = csDownstreamPrpty;
            m_csUpstreamTrnInfo = csUpstreamPrpty;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="csDownstreamPrpty"></param>
        public virtual void SetDownstreamTranInfoProperty(McCellArrayTranInfoPropertyInfo csDownstreamPrpty)
        {
            m_csDownstreamTrnInfo = csDownstreamPrpty;
            if( m_csDownstreamTrnInfo.GetID() == null )
            {
                m_csDownstreamTrnInfo.SetID(new HySID("") );
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="csUpstreamPrpty"></param>
        public virtual void SetUpstreamTranInfoProperty(McCellArrayTranInfoPropertyInfo csUpstreamPrpty)
        {
            m_csUpstreamTrnInfo = csUpstreamPrpty;
            if (m_csUpstreamTrnInfo.GetID() == null)
            {
                m_csUpstreamTrnInfo.SetID(new HySID(""));
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDim(long lDim1)
        {
            base.SetDim(lDim1);
            m_csDownstreamTrnInfo.SetDim(lDim1);
            m_csUpstreamTrnInfo.SetDim(lDim1);
        }
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDim(long lDim1, long lDim2)
        {
            base.SetDim(lDim1, lDim2);
            m_csDownstreamTrnInfo.SetDim(lDim1, lDim2);
            m_csUpstreamTrnInfo.SetDim(lDim1, lDim2);
        }
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDim(long lDim1, long lDim2, long lDim3)
        {
            base.SetDim(lDim1, lDim2, lDim3);
            m_csDownstreamTrnInfo.SetDim(lDim1, lDim2, lDim3);
            m_csUpstreamTrnInfo.SetDim(lDim1, lDim2, lDim3);
        }

        /// <summary><para>method outline:</para>
        /// <para>上流方向、下流方向の伝送データプロパティ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> (csDownstreamPrpty, csUpstreamPrpty) = GetTranInfoProperty() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>  (csDownstreamPrpty:上流→下流伝送データ, csUpstreamPrpty:下流→上流伝送データ)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual (McCellArrayTranInfoPropertyInfo, McCellArrayTranInfoPropertyInfo) GetTranInfoProperty()
        {
            return (m_csDownstreamTrnInfo, m_csUpstreamTrnInfo);
        }
        public virtual  McCellArrayTranInfoPropertyInfo GetDownstreamTranInfoProperty()
        {
            return m_csDownstreamTrnInfo;
        }
        public virtual  McCellArrayTranInfoPropertyInfo  GetUpstreamTranInfoProperty()
        {
            return m_csUpstreamTrnInfo;
        }

        // ================================================
        //  
        // ================================================

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="csMcModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetUpperElementModelInfor(HySDataRoot csMcModelInfo)
        {
            base.SetUpperElementModelInfor(csMcModelInfo);

            m_csDownstreamTrnInfo.SetUpperElementModelInfor(csMcModelInfo);
            m_csUpstreamTrnInfo.SetLowerElementModelInfor(csMcModelInfo);
        }
     
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="csMcModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetLowerElementModelInfor(HySDataRoot csMcModelInfo)
        {
            base.SetLowerElementModelInfor(csMcModelInfo);

            m_csDownstreamTrnInfo.SetLowerElementModelInfor(csMcModelInfo);
            m_csUpstreamTrnInfo.SetUpperElementModelInfor(csMcModelInfo);
        }

        /// <summary><para>method outline:</para>
        /// <para>送信側セル型伝送パターンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSendTranInfoPattern(csTranInfoPattern); </para>
        /// </example>
        /// <param name="csTranInfoPattern">セル型伝送パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetSendTranInfoPattern(McTranInfoPatternPropertyIF csTranInfoPattern)
        {
            base.SetSendTranInfoPattern(csTranInfoPattern);

            McMutualTranInfoPattern csMutualPttn = csTranInfoPattern as McMutualTranInfoPattern;
            if (csMutualPttn != null)
            {
                McTranInfoPattern csUpTranInfoPttn = null;
                McTranInfoPattern csDownTranInfoPttn = null;
                (csDownTranInfoPttn, csUpTranInfoPttn) = csMutualPttn.GetDwnUpPattern();

                m_csDownstreamTrnInfo.SetSendTranInfoPattern(csDownTranInfoPttn.Clone());
                //m_csDownstreamTrnInfo.SetReceiveTranInfoPattern(csDownTranInfoPttn.Clone());

                //m_csUpstreamTrnInfo.SetSendTranInfoPattern(csUpTranInfoPttn.Clone());
                m_csUpstreamTrnInfo.SetReceiveTranInfoPattern(csUpTranInfoPttn.Clone());
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperConnectionPatternID(csCnnctPtnID)</para>
        /// </example>
        /// <param name="csCnnctPtnID">接続パターンＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetUpperConnectionPatternID(HySID csCnnctPtnID)
        {
            //m_csDownstreamTrnInfo.SetLowerConnectionPatternID(csCnnctPtnID);
            //m_csDownstreamTrnInfo.SetUpperConnectionPatternID(csCnnctPtnID);
            //m_csUpstreamTrnInfo.SetLowerConnectionPatternID(csCnnctPtnID);
            //m_csUpstreamTrnInfo.SetUpperConnectionPatternID(csCnnctPtnID);

            base.SetUpperConnectionPatternID( csCnnctPtnID);
        }
        public virtual void SetUpperConnectionPattern(McMutualTranInfoPattern csPattern)
        {
            HySID csCnnctPtnID = csPattern.GetPatternID();
            base.SetUpperConnectionPatternID(csCnnctPtnID);

            var (csDwnPtn, csUpPtn) = csPattern.GetDwnUpPattern();

            m_csDownstreamTrnInfo.SetUpperConnectionPatternID(csDwnPtn.GetPatternID());
            m_csDownstreamTrnInfo.SetSendTranInfoPattern(csDwnPtn);
            m_csUpstreamTrnInfo.SetLowerConnectionPatternID(csUpPtn.GetPatternID());
            m_csUpstreamTrnInfo.SetReceiveTranInfoPattern(csUpPtn);
        }

        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerConnectionPatternID(csCnnctPtnID)</para>
        /// </example>
        /// <param name="csCnnctPtnID">接続パターンＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetLowerConnectionPatternID(HySID csCnnctPtnID)
        {
            //m_csDownstreamTrnInfo.SetLowerConnectionPatternID(csCnnctPtnID);
            //m_csUpstreamTrnInfo.SetUpperConnectionPatternID(csCnnctPtnID); 
            
            base.SetLowerConnectionPatternID(csCnnctPtnID);
        }
        public virtual void SetLowerConnectionPattern(McMutualTranInfoPattern csPattern)
        {
            HySID csCnnctPtnID = csPattern.GetPatternID();
            base.SetLowerConnectionPatternID(csCnnctPtnID);

            var (csDwnPtn, csUpPtn) = csPattern.GetDwnUpPattern();
            
            m_csDownstreamTrnInfo.SetLowerConnectionPatternID(csDwnPtn.GetPatternID());
            m_csDownstreamTrnInfo.SetReceiveTranInfoPattern(csDwnPtn);
            m_csUpstreamTrnInfo.SetUpperConnectionPatternID(csUpPtn.GetPatternID());
            m_csUpstreamTrnInfo.SetSendTranInfoPattern(csUpPtn);
        }

        /// <summary><para>method outline:</para>
        /// <para>受信側セル型伝送パターンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetReceiveTranInfoPattern(csTranInfoPattern); </para>
        /// </example>
        /// <param name="csTranInfoPattern">セル型伝送パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetReceiveTranInfoPattern(McTranInfoPatternPropertyIF csTranInfoPattern)
        {
            base.SetReceiveTranInfoPattern(csTranInfoPattern);

            McMutualTranInfoPattern csMutualPttn = csTranInfoPattern as McMutualTranInfoPattern;
            if( csMutualPttn != null)
            {
                McTranInfoPattern csUpTranInfoPttn = null;
                McTranInfoPattern csDownTranInfoPttn = null;
                (csDownTranInfoPttn, csUpTranInfoPttn) = csMutualPttn.GetDwnUpPattern();

                m_csDownstreamTrnInfo.SetReceiveTranInfoPattern(csDownTranInfoPttn.Clone());
                //m_csDownstreamTrnInfo.SetSendTranInfoPattern(csDownTranInfoPttn);

                //m_csUpstreamTrnInfo.SetReceiveTranInfoPattern(csUpTranInfoPttn);
                m_csUpstreamTrnInfo.SetSendTranInfoPattern(csUpTranInfoPttn.Clone());
            }
        }

        //--------------------------------------------------------------
        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McMutualTranInfoProperty csRtn = new McMutualTranInfoProperty(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);
            McMutualTranInfoProperty csOrgPrpty = csOrgObj as McMutualTranInfoProperty;
            if (csOrgPrpty != null)
            {
                m_csDownstreamTrnInfo = csOrgPrpty.m_csDownstreamTrnInfo.Clone() as McCellArrayTranInfoPropertyInfo;
                m_csUpstreamTrnInfo = csOrgPrpty.m_csUpstreamTrnInfo.Clone() as McCellArrayTranInfoPropertyInfo;
            }
        }
        public void CopyData(McMutualTranInfoProperty csOrgObj)
        {
            this.CopyInf(csOrgObj);
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = base.XmlOUT(ref csXmlWriter);

            //----------------------------
            // Upstream 
            HySXmlNode csLclNode = HySXmlNode.CreateElement(McDefine.xml_UPSTREAM, csXmlWriter);

            HySXmlNode csUppNode = m_csUpstreamTrnInfo.XmlOUT( ref csXmlWriter);
            csLclNode.AppendChild(csUppNode);
            csRtn.AppendChild(csLclNode);

            HySXmlNode csUpprElmNode = HySXmlNode.CreateElement(McDefine.xml_UP_ELEM, csXmlWriter);
            HySXmlNode csUppPrptyNode = null;
            McPropertyInfoRoot csUpperPrpytInf = this.GetUpperModelProperty() as McPropertyInfoRoot;
            if (csUpperPrpytInf != null)
            {   // プロパティ情報有り
                csUppPrptyNode = csUpperPrpytInf.XmlOUT(ref csXmlWriter);
                csUpprElmNode.AppendChild(csUppPrptyNode);
            }
            csRtn.AppendChild(csUpprElmNode); 
            
            //----------------------------
            // Downstream
            csLclNode = HySXmlNode.CreateElement(McDefine.xml_DOWNSTREAM, csXmlWriter);
            
            HySXmlNode csDwnNode = m_csDownstreamTrnInfo.XmlOUT(ref csXmlWriter);
            csLclNode.AppendChild(csDwnNode);
            csRtn.AppendChild(csLclNode);  

            HySXmlNode csLowerElmNode = HySXmlNode.CreateElement(McDefine.xml_DOWN_ELEM, csXmlWriter);
            HySXmlNode csDwnPrptyNode = null;
            McPropertyInfoRoot csDwnPrpytInf = this.GetLowerModelProperty() as McPropertyInfoRoot;
            if (csUpperPrpytInf != null)
            {   // プロパティ情報有り
                csDwnPrptyNode = csDwnPrpytInf.XmlOUT(ref csXmlWriter);
                csLowerElmNode.AppendChild(csDwnPrptyNode);
            }
            csRtn.AppendChild(csLowerElmNode);

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csPrptyXml)
        {
            this.Clear();
            bool bRtn = base.XmlIN(csPrptyXml);

            HySXmlNode csXml = null;
            HySXmlNodeList csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_UPSTREAM);
            long lValCnt = csXmlVariableList.GetCount();
            if(lValCnt > 0 )
            {
                m_csUpstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(this.m_csLibraryID,McTranInfoDefine.D1_CELL_SERIAL);
                m_csUpstreamTrnInfo.SetUpperElementModelInfor(this.m_csUpperElmInf);
                m_csUpstreamTrnInfo.SetLowerElementModelInfor(this.m_csLowerElmInf);
                csXml = csXmlVariableList.GetNode(0);
                // プロパティ解読
                HySXmlNode csXmlPropertyNode; 
                HySXmlNodeList csXmlPropertyList = csXml.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                long lPropertyNum = csXmlPropertyList.GetCount(); // 通常は１個
                for (long lLp = 0; lLp < lPropertyNum; lLp++)
                {
                    csXmlPropertyNode = csXmlPropertyList.GetNode(lLp);
                    // プロパティ情報ノード読み出し
                    //////// プロパティタグ内容を読み出す
                    //////McPropertyInfoRoot csPrpytInf = this.GetUpperModelProperty() as McPropertyInfoRoot;
                    ////McPropertyInfoRoot csUpperPrpytInf = m_csUpstreamTrnInfo.GetUpperModelProperty() as McPropertyInfoRoot;
                    ////if (csUpperPrpytInf != null)
                    ////{   // プロパティ情報有り
                    ////    if (csXmlPropertyNode != null)
                    ////    {   // XML情報あり
                    ////        csUpperPrpytInf.XmlIN(csXmlPropertyNode);
                    ////    }
                    ////}
                    //// McPropertyInfoRoot csDownPrpytInf = m_csUpstreamTrnInfo.GetUpperModelProperty() as McPropertyInfoRoot;
                    ////if (csDownPrpytInf != null)
                    ////{   // プロパティ情報有り
                    ////    if (csXmlPropertyNode != null)
                    ////    {   // XML情報あり
                    ////        csDownPrpytInf.XmlIN(csXmlPropertyNode);
                    ////    }
                    ////}
                    m_csUpstreamTrnInfo.XmlIN(csXmlPropertyNode);
                }
                //m_csUpstreamTrnInfo.XmlIN(csPrptyXml);
            }
            //-----------------------------------------
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_DOWNSTREAM);
            lValCnt = csXmlVariableList.GetCount();
            if (lValCnt > 0)
            {
                m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(this.m_csLibraryID, McTranInfoDefine.D1_CELL_SERIAL);
                m_csDownstreamTrnInfo.SetUpperElementModelInfor(this.m_csLowerElmInf);
                m_csDownstreamTrnInfo.SetLowerElementModelInfor(this.m_csUpperElmInf);

                csXml = csXmlVariableList.GetNode(0);
                // プロパティ解読
                HySXmlNode csXmlPropertyNode;
                HySXmlNodeList csXmlPropertyList = csXml.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                long lPropertyNum = csXmlPropertyList.GetCount(); // 通常は１個
                for (long lLp = 0; lLp < lPropertyNum; lLp++)
                {
                    csXmlPropertyNode = csXmlPropertyList.GetNode(lLp);
                    // プロパティ情報ノード読み出し

                    ////// プロパティタグ内容を読み出す
                    //McPropertyInfoRoot csPrpytInf = this.GetLowerModelProperty() as McPropertyInfoRoot;
                    //if (csPrpytInf != null)
                    //{   // プロパティ情報有り
                    //    if (csXmlPropertyNode != null)
                    //    {   // XML情報あり
                    //        csPrpytInf.XmlIN(csXmlPropertyNode);
                    //    }
                    //}
                    m_csDownstreamTrnInfo.XmlIN(csXmlPropertyNode);
                }
            }



            //csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_DOWNSTREAM);
            //lValCnt = csXmlVariableList.GetCount();
            //if (lValCnt > 0)
            //{
            //    m_csDownstreamTrnInfo = new McCellArrayTranInfoPropertyInfo(this.m_csLibraryID, McTranInfoDefine.D1_CELL_SERIAL);
            //    m_csDownstreamTrnInfo.XmlIN(csXmlVariableList.GetNode(0));
            //}

            return true;
        }
     

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

    }   //end of class
}
