﻿// <summary>ソースコード：>ＨＹＭＣＯ汎用 ２次元情報 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.TranInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>汎用２次元情報 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>２次元配列情報(double)を保持できる</para>
    /// <para>Remarks</para>
    /// <para>本クラスは、プロトタイプ開発リリース版と互換性を取る為に残す。
    /// 　　　使用を奨励しない。
    /// 　　　本クラスは、McD2CellArrayTranInfoクラスに変更する。
    ///       以後、本クラスのVerUpにおける改造は行わない。（サポート終了）
    /// </para>
    /// </remarks>
    [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
    [Serializable]
    public class McDim2DataTranInfo : McTimeRecordBase, McTimeRecordIF, McTranInfo
    {
        /// <summary>行数</summary>
        protected long m_lRow = 1;
        /// <summary>列数</summary>
        protected long m_lColumn = 1;

        /// <summary>保持データ</summary>
        protected double[,] m_dData = null;

        /// <summary> 伝送データ共通情報　</summary>
        protected McTranInfoCommon m_csCommonInfo = new McTranInfoCommon();


        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lColumn, lRow) </para>
        /// </example>
        /// <param name="lColumn">列数</param>
        /// <param name="lRow">行数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected void Init(long lColumn, long lRow)
        {
            m_lRow = lRow;
            m_lColumn = lColumn;
            m_dData = new double[lColumn, lRow];
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDim2DataTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        private McDim2DataTranInfo()
        {
            Init(1, 1);
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csMeshData = new McDim2DataTranInfo( csPropertyInfo ) </para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>McDim2DataTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDim2DataTranInfo(McPropertyInfoRoot csPropertyInfo)
        {
            McProtoTranInfoPropertyInfo csRtnDt = csPropertyInfo as McProtoTranInfoPropertyInfo;
            if (csRtnDt != null)
            {
                long lCellDim2 = 1;
                long lCellDim1 = 1;
                csRtnDt.GetInfo(McTimeSeries2DTranInfo.DATA_ROW_NUM, ref lCellDim1);
                csRtnDt.GetInfo(McTimeSeries2DTranInfo.DATA_COLUMN_NUM, ref lCellDim2);
                Init(lCellDim2, lCellDim1);
            }
            else
            {
                Init(1, 1);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csData = new McDim2DataTranInfo(lColumn, lRow) </para>
        /// </example>
        /// <param name="lColumn">列数</param>
        /// <param name="lRow">行数</param>
        /// <returns>McDim2DataTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDim2DataTranInfo(long lColumn, long lRow)
        {
            this.Init(lColumn,lRow);
        }

        /// <summary><para>method outline:</para>
        /// <para>行の配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetRow() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 行の配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetRow()
        {
            return m_lRow;
        }
        /// <summary><para>method outline:</para>
        /// <para>列の配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetColumn() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 列の配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetColumn()
        {
            return m_lColumn;
        }
        /// <summary><para>method outline:</para>
        /// <para>データインスタンス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[,] csData = GetDataMatrixInstance() 
        ///        csData[i,j] = x;
        ///        y = csData[a,b];
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[列,行] ２次元配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[,] GetDataMatrixInstance()
        {
            return m_dData;
        }

        /// <summary><para>method outline:</para>
        /// <para>同一種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SameKind( csTranInfo ) </para>
        /// </example>
        /// <param name="csTranInfo">比較する伝送データ</param>
        /// <returns> bool true :同一種別 , false:異種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>入力情報が null の場合には　false で返す</para>
        /// </remarks>
        public virtual bool SameKind(McTranInfo csTranInfo)
        {
            bool bRtn = false;
            if (csTranInfo != null)
            {
                if (csTranInfo is McDim2DataTranInfo)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McDim2DataTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo Clone()
        {
            McDim2DataTranInfo csRtnObj = new McDim2DataTranInfo(m_lRow, m_lColumn);
            csRtnObj.CopyInfo(this);
            return csRtnObj;
        }
        /// <summary>
        /// S.H.　内部データクリア
        /// </summary>
        public virtual void ClearData()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CopyInfo(McTranInfo csOrgInfo)
        {
            McDim2DataTranInfo csOrgTrnInfo = (McDim2DataTranInfo)csOrgInfo as McDim2DataTranInfo;
            if (csOrgTrnInfo == null)
            {
                return false;
            }

            this.Init(csOrgTrnInfo.m_lColumn, csOrgTrnInfo.m_lRow);
            m_lRow = csOrgTrnInfo.m_lRow;
            m_lColumn = csOrgTrnInfo.m_lColumn;

            // データの内容をコピーする
            for (long iColumn = 0; iColumn < m_lColumn; iColumn++)
            {
                for (long iRow = 0; iRow < m_lRow; iRow++)
                {
                    m_dData[iColumn, iRow] = csOrgTrnInfo.m_dData[iColumn, iRow];
                }
            }

            this.m_csTime = csOrgTrnInfo.m_csTime.Clone();
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public virtual bool LastDataCopy(McTranInfo csOrgInfo)
        {
            return LatestDataCopy((McTimeRecordIF)csOrgInfo);
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報が自分と同一時刻または、新しければ自分の情報をコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public virtual bool LatestDataCopy(McTimeRecordIF csOrgInfo)
        {
            bool bRtn = false;
            McDim2DataTranInfo csOrgTrnInfo = csOrgInfo as McDim2DataTranInfo;
            if (csOrgTrnInfo != null)
            {
                if (this.Before(csOrgTrnInfo.GetLastTime()) == true)
                {   // 与えられたデータが、自分よりも新しい（同一時刻も含む）
                    bRtn = true;
                    this.CopyInfo(csOrgTrnInfo);
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans(csOrgTran)</para>
        /// </example>
        /// <param name="csOrgTran">上流側の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void MakeRelayPortDataTransContinuity(McTranInfo csOrgTran)
        {
            // Do Nothing
        }

        // ================================================
        // プロパティ設定関連
        // ================================================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetProperty(McPropertyInfoRoot csPropertyInfo)
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        public virtual void SetOnlineProperty(McPropertyInfoRoot csPropertyInfo)
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreatePropertyInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot プロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfoRoot CreatePropertyInfo()
        {
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部蓄積データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ResetData()
        {
            m_dData = new double[m_lColumn, m_lRow];
        }
        // ================================================
        // 共通情報設定
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>接続線共通情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranCommonCellDataIF csCnnctInf = GetCommonInf( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranCommonCellDataIF 接続線共通情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の共通情報を取得する</para>
        /// </remarks>
        public virtual McTranCommonCellDataIF GetCommonInf()
        {
            return m_csCommonInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続線ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        public virtual HySID GetConnectionID()
        {
            return m_csCommonInfo.GetConnectionID();
        }
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        public virtual HySString GetConnectionName()
        {
            return m_csCommonInfo.GetConnectionName();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual HySID GetUpperElementID()
        {
            return m_csCommonInfo.GetUpperElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csElmID = GetLowerElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual HySID GetLowerElementID()
        {
            return m_csCommonInfo.GetLowerElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 上流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual McElement GetUpperElement()
        {
            return m_csCommonInfo.GetUpperElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 下流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual McElement GetLowerElement()
        {
            return m_csCommonInfo.GetLowerElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySObjectKind GetTranInfoKind()
        { return McTranInfoDefine.TRNINF_2DIM_SERIAL_PROTOTYPE; }

        /// <summary>行の配列数</summary>
        static public string DATA_ROW_NUM = "lRow";
        /// <summary>列の配列数</summary>
        static public string DATA_COLUMN_NUM = "lColumn";

    }
}
