﻿// <summary>ソースコード：>ＨＹＭＣＯ時系列情報 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data.TranInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para> 時系列情報 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスは、プロトタイプ開発リリース版と互換性を取る為に残す。
    /// 　　　使用を奨励しない。
    /// 　　　本クラスは、McD1CellArrayTranInfoクラスに変更する。
    ///       以後、本クラスのVerUpにおける改造は行わない。（サポート終了）
    /// </para>
    /// </remarks>
    [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
    [Serializable]
    public class McMultiSerialTranInfo : McTimeSeries1DTranInfo, HySVersionManagement // HySTimeSeriesBase, McTranInfo, IDeserializationCallback
    {
        /// <summary>時系列の数</summary>
        protected long m_lDataSeriesNum = MAX_SERIES;


        // Serialize 対象外
        /// <summary>作業用データ</summary>
        [NonSerialized]
        protected double[] m_dWorkData = null;
        /// <summary>最後に追加したデータ</summary>
        protected double[] m_dLastData = new double[MAX_SERIES];

        /// <summary>系列データの最大数</summary>
        protected static readonly int MAX_SERIES = 8;
        /// <summary>系列１データの種別を表す情報(時系列の　N番目は何を表しているのかを設定する)</summary>
        protected HySObjectKind[] m_csSeriesKind = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McMultiSerialTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McMultiSerialTranInfo()
        {
        }
                
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csMeshData = new McMultiSerialTranInfo( csPropertyInfo ) </para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>McMultiSerialTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMultiSerialTranInfo(McPropertyInfoRoot csPropertyInfo)
        {
            McProtoTranInfoPropertyInfo csRtnDt = csPropertyInfo as McProtoTranInfoPropertyInfo;

            if (csRtnDt != null)
            {
                //csTransData = new McMultiSerialTranInfo(csPropertyInfo);
                csRtnDt.GetInfo(McMultiSerialTranInfo.DATA_SERIES_NUM, ref m_lDataSeriesNum);
                csRtnDt.GetInfo(McTimeSeries1DTranInfo.MAX_DATA_NUM, ref m_lMaxDataNum);
                this.Init( m_lDataSeriesNum);
            }
            else
            {
                m_lDataSeriesNum=8;
                this.Init( m_lDataSeriesNum);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = new McMultiSerialTranInfo(lSeriesNum) </para>
        /// </example>
        /// <param name="lSeriesNum">時系列の数（１～８）</param>
        /// <returns>McMultiSerialTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMultiSerialTranInfo(long lSeriesNum)
            : base(lSeriesNum)
        {
            m_lMaxDataNum = 720;
            if (lSeriesNum > 0 && lSeriesNum <= MAX_SERIES)
            {
                m_lDataSeriesNum = lSeriesNum;
            }
            else
            {
                base.Init(m_lDataSeriesNum);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = new McMultiSerialTranInfo(lSeriesNum, lMaxDataNum) </para>
        /// </example>
        /// <param name="lSeriesNum">時系列の数（１～８）</param>
        /// <param name="lMaxDataNum">最大データ数</param>
        /// <returns>McMultiSerialTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMultiSerialTranInfo(long lSeriesNum, long lMaxDataNum)
            : base(lSeriesNum)
        {
            m_lMaxDataNum = lMaxDataNum;
            if (lSeriesNum > 0 && lSeriesNum <= MAX_SERIES)
            {
                m_lDataSeriesNum = lSeriesNum;
            }
            else
            {
                base.Init(m_lDataSeriesNum);
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>系列データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSeriesDataKind(lSeriesNum, csKind) </para>
        /// </example>
        /// <param name="lSeriesNum">系列番号（１～８）</param> 
        /// <param name="csKind">系列データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSeriesDataKind(long lSeriesNum, HySObjectKind csKind)
        {
            if (lSeriesNum >= 1 && lSeriesNum <= m_lDataSeriesNum)
            {
                int iItem = (int)lSeriesNum - 1;
                m_csSeriesKind[iItem] = csKind;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtKind = GetSeriesDataKind(lSeriesNum) </para>
        /// </example>
        /// <param name="lSeriesNum">系列番号（１～８）</param> 
        /// <returns>HySObjectKind 系列データの種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetSeriesDataKind(long lSeriesNum)
        {
            HySObjectKind csRtn = null;
            if (lSeriesNum >= 1 && lSeriesNum <= m_lDataSeriesNum)
            {
                int iItem = (int)lSeriesNum - 1;
                csRtn = m_csSeriesKind[iItem];
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>データの系列数を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDtNum = GetDataSeriesNum() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long データの系列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDataSeriesNum()
        {
            return m_lDataSeriesNum;
        }


        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2, dDt3) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <param name="dDt3">系列３データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2, double dDt3)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            if (m_lDataSeriesNum == 2) { return false; }
            m_dLastData[2] = m_dWorkData[2] = dDt3;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2, dDt3, dDt4) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <param name="dDt3">系列３データ</param>
        /// <param name="dDt4">系列４データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2, double dDt3, double dDt4)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            if (m_lDataSeriesNum == 2) { return false; }
            m_dLastData[2] = m_dWorkData[2] = dDt3;
            if (m_lDataSeriesNum == 3) { return false; }
            m_dLastData[3] = m_dWorkData[3] = dDt4;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2, dDt3, dDt4, dDt5) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <param name="dDt3">系列３データ</param>
        /// <param name="dDt4">系列４データ</param>
        /// <param name="dDt5">系列５データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2, double dDt3, double dDt4, double dDt5)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            if (m_lDataSeriesNum == 2) { return false; }
            m_dLastData[2] = m_dWorkData[2] = dDt3;
            if (m_lDataSeriesNum == 3) { return false; }
            m_dLastData[3] = m_dWorkData[3] = dDt4;
            if (m_lDataSeriesNum == 4) { return false; }
            m_dLastData[4] = m_dWorkData[4] = dDt5;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2, dDt3, dDt4, dDt5, dDt6) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <param name="dDt3">系列３データ</param>
        /// <param name="dDt4">系列４データ</param>
        /// <param name="dDt5">系列５データ</param>
        /// <param name="dDt6">系列６データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2, double dDt3, double dDt4, double dDt5, double dDt6)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            if (m_lDataSeriesNum == 2) { return false; }
            m_dLastData[2] = m_dWorkData[2] = dDt3;
            if (m_lDataSeriesNum == 3) { return false; }
            m_dLastData[3] = m_dWorkData[3] = dDt4;
            if (m_lDataSeriesNum == 4) { return false; }
            m_dLastData[4] = m_dWorkData[4] = dDt5;
            if (m_lDataSeriesNum == 5) { return false; }
            m_dLastData[5] = m_dWorkData[5] = dDt6;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2, dDt3, dDt4, dDt5, dDt6, dDt7) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <param name="dDt3">系列３データ</param>
        /// <param name="dDt4">系列４データ</param>
        /// <param name="dDt5">系列５データ</param>
        /// <param name="dDt6">系列６データ</param>
        /// <param name="dDt7">系列７データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2, double dDt3, double dDt4, double dDt5, double dDt6, double dDt7)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            if (m_lDataSeriesNum == 2) { return false; }
            m_dLastData[2] = m_dWorkData[2] = dDt3;
            if (m_lDataSeriesNum == 3) { return false; }
            m_dLastData[3] = m_dWorkData[3] = dDt4;
            if (m_lDataSeriesNum == 4) { return false; }
            m_dLastData[4] = m_dWorkData[4] = dDt5;
            if (m_lDataSeriesNum == 5) { return false; }
            m_dLastData[5] = m_dWorkData[5] = dDt6;
            if (m_lDataSeriesNum == 6) { return false; }
            m_dLastData[6] = m_dWorkData[6] = dDt7;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, dDt1, dDt2, dDt3, dDt4, dDt5, dDt6, dDt7, dDt8) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="dDt1">系列１データ</param>
        /// <param name="dDt2">系列２データ</param>
        /// <param name="dDt3">系列３データ</param>
        /// <param name="dDt4">系列４データ</param>
        /// <param name="dDt5">系列５データ</param>
        /// <param name="dDt6">系列６データ</param>
        /// <param name="dDt7">系列７データ</param>
        /// <param name="dDt8">系列８データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, double dDt1, double dDt2, double dDt3, double dDt4, double dDt5, double dDt6, double dDt7, double dDt8)
        {
            McDim1DataTranInfo csRecord = this.NewRecord();
            m_dWorkData = csRecord.GetDataDimensionInstance();
            csRecord.SetTime(csTime.Clone()); // クローンを作成しないと、インスタンスがそのまま保持される
            m_dLastData[0] = m_dWorkData[0] = dDt1;
            if (m_lDataSeriesNum == 1) { return false; }
            m_dLastData[1] = m_dWorkData[1] = dDt1;
            if (m_lDataSeriesNum == 2) { return false; }
            m_dLastData[2] = m_dWorkData[2] = dDt3;
            if (m_lDataSeriesNum == 3) { return false; }
            m_dLastData[3] = m_dWorkData[3] = dDt4;
            if (m_lDataSeriesNum == 4) { return false; }
            m_dLastData[4] = m_dWorkData[4] = dDt5;
            if (m_lDataSeriesNum == 5) { return false; }
            m_dLastData[5] = m_dWorkData[5] = dDt6;
            if (m_lDataSeriesNum == 6) { return false; }
            m_dLastData[6] = m_dWorkData[6] = dDt7;
            if (m_lDataSeriesNum == 7) { return false; }
            m_dLastData[7] = m_dWorkData[7] = dDt8;
            base.AddData(csRecord);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = AddData(csTime, lDtDim, dDt) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <param name="lDtDim">系列データ配列数</param>
        /// <param name="dDt">系列データ</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool AddData(HySTime csTime, long lDtDim, double[] dDt)
        {
            if (lDtDim == 1)
            {
                return this.AddData(csTime, dDt[0]);
            }
            else if (lDtDim == 2)
            {
                return this.AddData(csTime, dDt[0], dDt[1]);
            }
            else if (lDtDim == 3)
            {
                return this.AddData(csTime, dDt[0], dDt[1], dDt[2]);
            }
            else if (lDtDim == 4)
            {
                return this.AddData(csTime, dDt[0], dDt[1], dDt[2], dDt[3]);
            }
            else if (lDtDim == 5)
            {
                return this.AddData(csTime, dDt[0], dDt[1], dDt[2], dDt[3], dDt[4]);
            }
            else if (lDtDim == 6)
            {
                return this.AddData(csTime, dDt[0], dDt[1], dDt[2], dDt[3], dDt[4], dDt[5]);
            }
            else if (lDtDim == 7)
            {
                return this.AddData(csTime, dDt[0], dDt[1], dDt[2], dDt[3], dDt[4], dDt[5], dDt[6]);
            }
            else if (lDtDim == 8)
            {
                return this.AddData(csTime, dDt[0], dDt[1], dDt[2], dDt[3], dDt[4], dDt[5], dDt[6], dDt[7]);
            }
            else
            {
                return false;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(csAddRecord) </para>
        /// </example>
        /// <param name="csAddRecord">追加レコード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddData(HySTimeRecordIF csAddRecord)
        {
            McDim1DataTranInfo csRecord = csAddRecord as McDim1DataTranInfo;
            if (csRecord != null)
            {
                long lDtDim = csRecord.GetDimension();
                if( lDtDim < MAX_SERIES )
                {
                    m_dWorkData = csRecord.GetDataDimensionInstance();
                    for (long lLp = 0; lLp < lDtDim; lLp++)
                    {
                        m_dLastData[lLp] = m_dWorkData[lLp];
                    }
                    base.AddData(csRecord);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>時系列最後のデータを削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dDt = RemoveLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 新しいデータインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new double[] RemoveLastData()
        {
            McDim1DataTranInfo csRmvDt = base.RemoveLastData();
            if (csRmvDt != null)
            {
                m_dWorkData = csRmvDt.GetDataDimensionInstance();
                return m_dWorkData;
            }
            else
            {
                return null;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dDt = GetCursorData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[]
        /// リスト上の指定番目のデータ
        /// 例：系列１は　dDt[0]、 系列２は dDt[1] に格納されて返される
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new double[] GetCursorData()
        {
            McDim1DataTranInfo csCursDt = base.GetCursorData();
            m_dWorkData = csCursDt.GetDataDimensionInstance();
            return m_dWorkData;
        }
        /// <summary><para>method outline:</para>
        /// <para>最新のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dDt = GetLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[]
        /// 最新データ（各系列のデータが配列に入れられる）
        /// 例：系列１は　dDt[0]、 系列２は dDt[1] に格納されて返される
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new double[] GetLastData()
        {
            return m_dLastData;
        }
        /// <summary><para>method outline:</para>
        /// <para>データを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] dDt = GetData(lOrderNum) </para>
        /// </example>
        /// <param name="lOrderNum">リスト上の順番番号：０相対</param>
        /// <returns>double[]
        /// リスト上の指定番目のデータ（各系列のデータが配列に入れられる）
        /// 例：系列１は　dDt[0]、 系列２は dDt[1] に格納されて返される
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new double[] GetData(long lOrderNum)
        {
            McDim1DataTranInfo csCursDt = base.GetData(lOrderNum);
            m_dWorkData = csCursDt.GetDataDimensionInstance();
            return m_dWorkData;
        }

        /// <summary><para>method outline:</para>
        /// <para>同一種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SameKind( csTranInfo ) </para>
        /// </example>
        /// <param name="csTranInfo">比較する伝送データ</param>
        /// <returns>bool =true :同一種別、=false:異種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>入力情報が null の場合には　false で返す</para>
        /// </remarks>
        public override bool SameKind(McTranInfo csTranInfo)
        {  
            bool bRtn = false;
            if (csTranInfo != null)
            {
                if (csTranInfo is McMultiSerialTranInfo)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McTranInfo Clone()
        {
            McMultiSerialTranInfo csRtnObj = new McMultiSerialTranInfo();
            csRtnObj.CopyInfo(this);
            return csRtnObj;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McTranInfo csOrgInfo)
        {
            bool bRtn = false;
            McMultiSerialTranInfo csOrg1DTrnInfo = csOrgInfo as McMultiSerialTranInfo;
            if (csOrg1DTrnInfo == null)
            {
                return bRtn;
            }
            bRtn = base.CopyInfo(csOrgInfo);
            for (long lLp = 0; lLp < MAX_SERIES; lLp++)
            {
                this.m_dLastData[lLp] = csOrg1DTrnInfo.m_dLastData[lLp];
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public override bool LastDataCopy(McTranInfo csOrgInfo)
        {
            bool bRtn = false;
            McMultiSerialTranInfo csOrg1DTrnInfo = csOrgInfo as McMultiSerialTranInfo;
            if (csOrg1DTrnInfo == null)
            {
                return bRtn;
            }
            bRtn = base.LastDataCopy(csOrg1DTrnInfo);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> OnDeserialization(csObj) </para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            m_csBusy = new HySMutex();
            m_dWorkData = new double[MAX_SERIES];
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans(csOrgTran)</para>
        /// </example>
        /// <param name="csOrgTran">上流側の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //public virtual void MakeRelayPortDataTransContinuity(McTranInfo csOrgTran)
        //{
            // Do Nothing
        //}
        */
        // ================================================
        // プロパティ設定関連
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetProperty(ref csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void GetProperty(ref McPropertyInfoRoot csPropertyInfo)
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetProperty(McPropertyInfoRoot csPropertyInfo)
        {
            McProtoTranInfoPropertyInfo csRtnDt = csPropertyInfo as McProtoTranInfoPropertyInfo;

            if (csRtnDt != null)
            {
                //csTransData = new McMultiSerialTranInfo(csPropertyInfo);
                csRtnDt.GetInfo(McMultiSerialTranInfo.DATA_SERIES_NUM, ref m_lDataSeriesNum);
                csRtnDt.GetInfo(McMultiSerialTranInfo.MAX_DATA_NUM, ref m_lMaxDataNum);
                this.Init(m_lDataSeriesNum);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyInfoRoot csPropertyInf = CreatePropertyInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot プロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreatePropertyInfo()
        {
            return null;
        }


        /// <summary><para>method outline:</para>
        /// <para>内部蓄積データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ResetData()
        {
            m_csLastTime.SetTime(0.0);

            this.Clear();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加が発生した場合にオーバーライドして実装する。
        /// </para>
        /// </remarks>
        public new void PostDeserialize()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTimeRecordIF 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySObjectKind GetTranInfoKind()
        { return McTranInfoDefine.TRNINF_MULTI_SERIAL_PROTOTYPE; }

        /// <summary> プロパティ設定用キー情報 </summary>
        public static readonly string DATA_SERIES_NUM = "m_lDataSeriesNum";
        //// <summary>  最大レコード数（指定された数までレコードを保持できる）</summary>
        //static public string MAX_RECORD_DATA_NUM = "lMaxDataNum";

    }
}
