﻿// <summary>ソースコード：>時系列データのレコードとなるデータの基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.TranInfo
{
    /// <summary><para>class outline:</para>
    /// <para>時系列データのレコードとなるデータの基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>１次元の情報（McDim1DataTranInfo）を　時系列情報として保持できる</para>
    /// <para>remarks:</para>
    /// <para>本クラスは、プロトタイプ開発リリース版と互換性を取る為に残す。
    /// 　　　使用を奨励しない。
    /// 　　　本クラスは、McTimeSeriesD1CellArrayTranInfoクラスに変更する。
    ///       以後、本クラスのVerUpにおける改造は行わない。（サポート終了）
    /// </para>
    /// </remarks>

    [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
    [Serializable]
    public abstract class McTimeRecordBase : HySTimeRecordIF
    {
        /// <summary>時刻</summary>
        protected HySTime m_csTime = HySTime.DEFAULT_TIME.Clone();

        /// <summary><para>method outline:</para>
        /// <para>時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTime(HySTime csTime)
        {
            m_csTime.SetTime(csTime);
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime  時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetLastTime()
        {
            return m_csTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>日付時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date と同じ場合は true、そうでない場合は false
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool EqualTime(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Equals(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">
        /// 比較用日付管理クラスオブジェクト(HySTime)
        /// </param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool After(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.After(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻より前の場合は true、そうでない場合は false</para>
        /// </remarks>
        public bool Before(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Before(csTime);
            }
            return bRtn;
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>  true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CopyInfo(McTranInfo csOrgInfo)
        {
            McTimeRecordBase csOrgTimeRecd = csOrgInfo as McTimeRecordBase;
            if (csOrgTimeRecd == null)
            {
                return false;
            }
            m_csTime.SetTime(csOrgTimeRecd.m_csTime);
            return true;
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加が発生した場合にオーバーライドして実装する。
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
        }
    }
}
