﻿// <summary>ソースコード：>ＨＹＭＣＯ１次元時系列情報 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.TranInfo;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>１次元情報（McDim1DataTranInfo）の時系列管理 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>１次元の情報（McDim1DataTranInfo）を　時系列情報として保持できる</para>
    /// <para>remarks:</para>
    /// <para>本クラスは、プロトタイプ開発リリース版と互換性を取る為に残す。
    /// 　　　使用を奨励しない。
    /// 　　　本クラスは、McTimeSeriesD1CellArrayTranInfoクラスに変更する。
    ///       以後、本クラスのVerUpにおける改造は行わない。（サポート終了）
    /// </para>
    /// </remarks>
    [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
    [Serializable]
    public class McTimeSeries1DTranInfo : HySTimeSeriesBase, McTranInfo
    {
        /// <summary>配列数</summary>
        protected long m_lDim = 1;

        /// <summary>レコードプールを使用するためのレコード種別保管</summary>
        protected HySObjectKind m_csRecordKind;

        /// <summary> 伝送データ共通情報　</summary>
        protected McTranInfoCommon m_csCommonInfo = new McTranInfoCommon();


        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lDataDim) </para>
        /// </example>
        /// <param name="lDataDim">情報配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected void Init(long lDataDim )
        {
            m_lDim = lDataDim;
            // プールへの登録
            HySString csRecordKind = new HySString(typeof(McDim1DataTranInfo).FullName + "[" + lDataDim.ToString() + "]");
            m_csRecordKind = new HySObjectKind(csRecordKind);
            McTranInfoDataPool.RegisterDataType(m_csRecordKind, new McDim1DataTranInfo(lDataDim));
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTimeSeries1DTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McTimeSeries1DTranInfo()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csMeshData = new McTimeSeries1DTranInfo( csPropertyInfo ) </para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>McTimeSeries1DTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTimeSeries1DTranInfo(McPropertyInfoRoot csPropertyInfo)
        {
            McProtoTranInfoPropertyInfo csRtnDt = csPropertyInfo as McProtoTranInfoPropertyInfo;
            if (csRtnDt != null)
            {
                long lDataDimension = 1;
                csRtnDt.GetInfo(McTimeSeries1DTranInfo.DATA_DIMENTION_NUM, ref lDataDimension);
                this.Init(lDataDimension);
                csRtnDt.GetInfo(McTimeSeries1DTranInfo.MAX_DATA_NUM, ref m_lMaxDataNum);
            }
            else
            {
                m_lMaxDataNum = 64;
                this.Init(8);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = new McTimeSeries1DTranInfo(lDataDim) </para>
        /// </example>
        /// <param name="lDataDim">情報配列数</param>
        /// <returns>McTimeSeries1DTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>保持できるレコード数はMax64まで</para>
        /// </remarks>
        public McTimeSeries1DTranInfo(long lDataDim)
        {
            Init(lDataDim);
            m_lMaxDataNum = 64;
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = new McTimeSeries1DTranInfo(lDataDim, lMaxDataNum) </para>
        /// </example>
        /// <param name="lDataDim">情報配列数</param>
        /// <param name="lMaxDataNum">最大レコード数（指定された数までレコードを保持できる）</param>
        /// <returns>McTimeSeries1DTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTimeSeries1DTranInfo(long lDataDim, long lMaxDataNum)
        {
            Init(lDataDim);
            m_lMaxDataNum = lMaxDataNum;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDimension() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内の配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロトタイプ公開時のメソッド互換性のため残す
        ///       GetDimension1() と同じ処理
        ///       新規モデル作成者は GetDimension1() メソッド使用を奨励する
        /// </para>
        /// </remarks>
        public long GetDimension()
        {
            return m_lDim;
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDim1DataTranInfo csNewRecord = NewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDim1DataTranInfo 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDim1DataTranInfo NewRecord()
        {
            // プールから情報をGetしてくる
            return (McDim1DataTranInfo)McTranInfoDataPool.GetNewData(m_csRecordKind);
        }
        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>NewRecord 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return this.NewRecord();
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(csAddRecord) </para>
        /// </example>
        /// <param name="csAddRecord">追加レコード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddData(HySTimeRecordIF csAddRecord)
        {
            McDim1DataTranInfo csRecord = csAddRecord as McDim1DataTranInfo;
            long lDataNum = base.GetCount();
            if (lDataNum >= m_lMaxDataNum)
            {   // データ数が、最大数を超えたならば
                // 覚えているデータの最初を忘れさせる 
                McDim1DataTranInfo csRmvRcd = (McDim1DataTranInfo)m_csDataList.RemoveData(0); // 最初のデータを取り外す
                McTranInfoDataPool.TrashData(m_csRecordKind, csRmvRcd); // プールに戻す

            }
            m_csDataList.AddLast(csRecord); // レコード追加

            base.SetLastTime(csRecord.GetLastTime());
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>新しいレコードを追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddRecord(csRecord) </para>
        /// </example>
        /// <param name="csRecord">追加するレコード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddRecord(McDim1DataTranInfo csRecord)
        {
            this.AddData(csRecord);
        }

        /// <summary><para>method outline:</para>
        /// <para>時系列最後のデータを削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDim1DataTranInfo csDim1DataTranInfo = RemoveLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDim1DataTranInfo 新しいデータインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new McDim1DataTranInfo RemoveLastData()
        {
            return (McDim1DataTranInfo)(base.RemoveLastData());
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDim1DataTranInfo csDim1DataTranInfo = GetCursorData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDim1DataTranInfo
        /// リスト上の指定番目のデータ
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new McDim1DataTranInfo GetCursorData()
        {
            return (McDim1DataTranInfo)(base.GetCursorData());
        }
        /// <summary><para>method outline:</para>
        /// <para>最新のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDim1DataTranInfo csDim1DataTranInfo = GetLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// 最新データ
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new McDim1DataTranInfo GetLastData()
        {
            return (McDim1DataTranInfo)(base.GetLastData());
        }
        /// <summary><para>method outline:</para>
        /// <para>データを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDim1DataTranInfo csDim1DataTranInfo = GetData(lOrderNum) </para>
        /// </example>
        /// <param name="lOrderNum">リスト上の順番番号：０相対</param>
        /// <returns>
        /// リスト上の指定番目のデータ
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new McDim1DataTranInfo GetData(long lOrderNum)
        {
            return (McDim1DataTranInfo)(base.GetData(lOrderNum));
        }

        /// <summary><para>method outline:</para>
        /// <para>同一種別比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SameKind( csTranInfo ) </para>
        /// </example>
        /// <param name="csTranInfo">比較する伝送データ</param>
        /// <returns>bool =true :同一種別、=false:異種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>入力情報が null の場合には　false で返す</para>
        /// </remarks>
        public virtual bool SameKind(McTranInfo csTranInfo)
        {  
            bool bRtn = false;
            if (csTranInfo != null)
            {
                if (csTranInfo is McTimeSeries1DTranInfo)
                {
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>内部蓄積データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ResetData()
        {
            this.Clear();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTimeSeries1DTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo Clone( )
        {
            McTimeSeries1DTranInfo csRtnObj = new McTimeSeries1DTranInfo(this.m_lDim,this.m_lMaxDataNum); 
            csRtnObj.CopyInfo(this);
            return csRtnObj;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CopyInfo(McTranInfo csOrgInfo)
        {
            McTimeSeries1DTranInfo csOrg1DTrnInfo = csOrgInfo as McTimeSeries1DTranInfo;
            if (csOrg1DTrnInfo == null)
            {
                return false;
            }

            if (csOrg1DTrnInfo.m_csRecordKind != null)
            {
                m_csRecordKind = new HySObjectKind(csOrg1DTrnInfo.m_csRecordKind.GetString());
            }
            m_lMaxDataNum = csOrg1DTrnInfo.m_lMaxDataNum;

            McDim1DataTranInfo csDt = null;
            McDim1DataTranInfo csNewDt = null;
            long lDataNum = csOrg1DTrnInfo.GetCount();
            HySDataLinkedList csDataList = csOrg1DTrnInfo.m_csDataList;
            for (long iLp = 0; iLp < lDataNum; iLp++)
            {
                csDt = (McDim1DataTranInfo)csDataList.GetData(iLp);
                csNewDt = this.NewRecord(); // プールからデータを取得する
                csNewDt.CopyInfo((McDim1DataTranInfo)csDt);
                this.AddData(csNewDt);
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>bool =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        public virtual bool LastDataCopy(McTranInfo csOrgInfo)
        {
            bool bRtn = false;
            McTimeSeries1DTranInfo csOrgTrnInfo = csOrgInfo as McTimeSeries1DTranInfo;
            if (csOrgTrnInfo == null)
            {
                return false;
            }

            if (this.m_lDim != csOrgTrnInfo.m_lDim )
            {
                bRtn = this.CopyInfo(csOrgTrnInfo);
            }
            else
            {
                bRtn = true; 
                if (this.Before(csOrgTrnInfo.GetLastTime()) == true)
                {
                    McDim1DataTranInfo csRecord = csOrgTrnInfo.GetLastData() as McDim1DataTranInfo;
                    McDim1DataTranInfo csNewDt = this.NewRecord(); // プールからデータを取得する
                    csNewDt.CopyInfo((McDim1DataTranInfo)csRecord);
                    this.AddData(csNewDt);
                }
            } // end of else
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgTimeSeriesData) </para>
        /// </example>
        /// <param name="csOrgTimeSeriesData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySTimeSeriesBase csOrgTimeSeriesData)
        {
            McTimeSeries1DTranInfo csOrgData = csOrgTimeSeriesData as McTimeSeries1DTranInfo;
            if (csOrgData != null)
            {
                this.CopyInfo(csOrgData);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans(csOrgTran)</para>
        /// </example>
        /// <param name="csOrgTran">上流側の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void MakeRelayPortDataTransContinuity(McTranInfo csOrgTran)
        {
            // Do Nothing
        }
        // ================================================
        // プロパティ設定関連
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetProperty(ref csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetProperty(ref McPropertyInfoRoot csPropertyInfo)
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetProperty(McPropertyInfoRoot csPropertyInfo)
        {
            McProtoTranInfoPropertyInfo csRtnDt = csPropertyInfo as McProtoTranInfoPropertyInfo;
            if (csRtnDt != null)
            {
                long lDataDimension = 1;
                csRtnDt.GetInfo(McTimeSeries1DTranInfo.DATA_DIMENTION_NUM, ref lDataDimension);
                this.Init(lDataDimension);
                csRtnDt.GetInfo(McTimeSeries1DTranInfo.MAX_DATA_NUM, ref m_lMaxDataNum);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        public virtual void SetOnlineProperty(McPropertyInfoRoot csPropertyInfo)
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyInfoRoot csPropertyInf = CreatePropertyInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot プロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfoRoot CreatePropertyInfo()
        {
            return null;
        }

        // ================================================
        // 共通情報設定
        // ================================================
        /// <summary><para>method outline:</para>
        /// <para>接続線共通情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranCommonCellDataIF csCnnctInf = GetCommonInf( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranCommonCellDataIF 接続線共通情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の共通情報を取得する</para>
        /// </remarks>
        public virtual McTranCommonCellDataIF GetCommonInf()
        {
            return m_csCommonInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続線ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        public virtual HySID GetConnectionID()
        {
            return m_csCommonInfo.GetConnectionID();
        }
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        public virtual HySString GetConnectionName()
        {
            return m_csCommonInfo.GetConnectionName();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual HySID GetUpperElementID()
        {
            return m_csCommonInfo.GetUpperElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csElmID = GetLowerElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual HySID GetLowerElementID()
        {
            return m_csCommonInfo.GetLowerElementID();
        }
        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 上流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        public virtual McElement GetUpperElement()
        {
            return m_csCommonInfo.GetUpperElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 下流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        public virtual McElement GetLowerElement()
        {
            return m_csCommonInfo.GetLowerElement();
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySObjectKind GetTranInfoKind()
        { return McTranInfoDefine.TRNINF_1DIM_SERIAL_PROTOTYPE; }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加が発生した場合にオーバーライドして実装する。
        /// </para>
        /// </remarks>
        public new void PostDeserialize()
        {
        }


        /// <summary>配列数</summary>
        static public readonly string DATA_DIMENTION_NUM = "lDimension";
        /// <summary>  最大レコード数（指定された数までレコードを保持できる）</summary>
        static public readonly string MAX_DATA_NUM = "lMaxDataNum";
    }
}
