﻿// <summary>ソースコード：ＨＹＭＣＯシミュレーター（演算単位系）ファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Controller.DIContainer;

namespace CommonMP.HYMCO.CoreImpl.FigureUnity
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯシミュレーター（演算単位系）ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McFigureUnityFactory : HySFactoryMono, HySSimulatorFactory
    {
        /// <summary>シミュレーター種別識別子</summary>
        protected HySObjectKind m_csKindID = McDefine.SIMULATOR_KIND;

        /// <summary>モデルファクトリクラス集合体</summary>
        protected McModelFactorySet m_csMdlFactorySet = new McModelFactorySet();


        /// <summary>プロパティ画面ファクトリクラス集合体 </summary>
        protected McPropertyScreenFactorySet m_csPrptyScreenFactorySet = new McPropertyScreenFactorySet();

        /// <summary>モデルデバッグ用ログクラス</summary>
        protected McLog m_csModelLog = new McLog();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McFigureUnityFactory csFactory = new McFigureUnityFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McFigureUnityFactory()
        {
            SetFactoryID(McDefine.FACTORY_ID_SIMULATION);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Init(HySFactoryMng csFactoryMng)
        {
            base.Init(csFactoryMng);

            // ＤＩコンテナ生成
            McSystemDIContainer csSystemDIContainer = new McSystemDIContainer();
            csSystemDIContainer.SetFigureUnityFactory(this);
            // 定義データ管理取得
            HySConfigDataManager csDataManager = csSystemDIContainer.GetConfigDataManager((HySFactoryManager)csFactoryMng);
            // 定義データ読込
            csDataManager.ConfigDataLoad();
            // 全ファクトリクラス生成
            csDataManager.CreateFactoryClassAll();

            // モデルファクトリーセットを設定する
            McStructElement.SetModelFactorySet(this.GetModelFactorySet());

            HySCommonInfoHash.CreateTable(McDefine.PROJECT_GROUP_NAME);
            HySCommonInfoHash.CreateTable(McDefine.CALCULATION_LOT_NAME);
            HySCommonInfoHash.CreateTable(McDefine.CALCULATION_ERROR_INF);

            // ディバッグ用ログクラス立ち上がり
            m_csModelLog.WakeUp();

            // 初期常数設定
            HySString csString = HySEnvInf.GetEnvInf("HYMCO_MAX_CELL_NUMBER_IN_TRANINFO");
            if ((object)csString != null)
            {
                McTranInfoDefine.TRNINF_DIM_MAX = Convert.ToInt32(csString.ToString());
            }

            // スクリーンにイベント送付先を設定(モニター画面用)
            McScreenCtl.SetSimulationController(HySSimulationController.m_csInstance);
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Term() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Term()
        {
            m_csMdlFactorySet.Term();
            m_csModelLog.ShutDown();
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetSimKind()
        {
            return m_csKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bVar = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// true  : 同じ
        /// false : 異なる
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool EqualSimKind(HySKind csSimKindID)
        {
            return m_csKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター（演算単位系）クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulator csSimulator = CreateSimulator(csSimulatorKind, csID) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子（ダミー)</param>
        /// <param name="csID">インスタンス個別識別子</param>
        /// <returns>シミュレーター（演算単位系）クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySSimulatorRoot CreateSimulator(HySKind csSimulatorKind, HySIdentifier csID)
        {
            HySSimulatorRoot csSimulator = (HySSimulatorRoot)new McFigureUnity();

            // 各種設定
            csSimulator.SetSimKind(m_csKindID);
            csSimulator.SetID(csID);

            ((McFigureUnity)csSimulator).SetModelFactory(m_csMdlFactorySet);

            return csSimulator;
        }

        /// <summary><para>method outline:</para>
        /// <para>データコンテナクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySContainer csContainer = CreateDataContainer( csSimulatorKind, csKey ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csKey">コンテナ識別子</param>
        /// <returns>データコンテナクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySContainer CreateDataContainer(HySKind csSimulatorKind, HySIdentifier csKey)
        {
            HySSimulationDataContainer csContainer = null;
            csContainer = new HySSimulationDataContainer(csSimulatorKind, csKey);
            // シミュレーション時間の仮設定
            csContainer.SetSimuTime(HySCalendar.CreateNowTime());
            csContainer.SetStartTime(HySCalendar.CreateNowTime());
            csContainer.SetDeltaTime(new HySTime(1, 0, 0));
            csContainer.SetGoalTime(HySCalendar.CreateNowTime() + new HySTime(24, 0, 0));


            // 要素間接続情報生成
            McStructInfo csStructInfo = new McStructInfo();
            csStructInfo.SetID(csKey);
            // データコンテナに要素間接続情報をセットする。
            csContainer.SetData(McDefine.HYM_DATA_STRUCT_INFO, csStructInfo );
            
            // プロジェクト情報生成
            McProjectInfData csProjectInfData = new McProjectInfData();
            //csProjectInfData.SetID((HySID)csKey);
            // データコンテナにプロジェクト情報をセットする。
            csContainer.SetData(McDefine.HYM_DATA_PROJECT_INFO, csProjectInfData);

            // チェック情報
            McStructCheckData csCheckInf = new McStructCheckData();
            // データコンテナにチェック情報をセットする。
            csContainer.SetData(McDefine.HYM_DATA_CHECK_INFO, csCheckInf);

            // ログ出力情報
            McModelLogData csLogData = new McModelLogData();
            // データコンテナにログ出力情報をセットする。
            csContainer.SetData(McDefine.HYM_DATA_LOG_INFO, csLogData);

            // シミュレーション状態
            McSimulationStatus csSimuStatus = new McSimulationStatus();
            csContainer.SetData(McDefine.HYM_DATA_SIMULATION_INFO, csSimuStatus);

            // 計算ロット情報格納用データ積み込み
            HySCalcLotInfo csCalLot = new HySCalcLotInfo(csSimulatorKind, csKey);
            csContainer.SetData(HySCalcLotInfo.DATA_KEY_CALC_LOT, csCalLot);

            return csContainer;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用データ生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulationDataGenerator csDataGenerator = CreateSimulationDataGenerator( csSimulatorKind,csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>シミュレーション用データ生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySSimulationDataGenerator CreateSimulationDataGenerator(HySKind csSimulatorKind, HySIdentifier csID)
        {
            HySSimulationDataGenerator csRtnObj = null;
            csRtnObj = new McModelGeneratorController();
            ((McModelGeneratorController)csRtnObj).SetModelFactory(this);
            return csRtnObj;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルファクトリ集合体取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactorySet csFactorySet = GetModelFactorySet(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelFactorySet　モデルファクトリ集合体インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelFactorySet GetModelFactorySet()
        {
            return m_csMdlFactorySet;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルファクトリ集合体取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyScreenFactorySet csFactorySet = GetPropertyScreenFactorySet(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyScreenFactorySet　プロパティ画面ファクトリ集合体インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyScreenFactorySet GetPropertyScreenFactorySet()
        {
            return m_csPrptyScreenFactorySet;
        }

    }
}
