// <summary>ソースコード：演算モデル用パラメータ等情報生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;

using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Controller.DIContainer;
using CommonMP.HYMCO.CoreImpl.BusiProc;

namespace CommonMP.HYMCO.CoreImpl.FigureUnity
{
    /// <summary><para>class outline:</para>
    /// <para>演算モデル用パラメータ等情報生成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McModelGeneratorController : McModelGenerateControllerIF
    {
        /// <summary> HYMCO モデルファクトリー</summary>
        protected McFigureUnityFactory m_csModelFactory = null;
        /// <summary> HYMCO モデルファクトリーセット</summary>
        protected McModelFactorySet m_csMdlFactorySet = null;
        /// <summary>プロパティ画面ファクトリクラス集合体 </summary>
        protected McPropertyScreenFactorySet m_csPrptyScreenFactorySet = null;

        /// <summary>演算要素モデルネットワーク生成クラスの情報リスト</summary>
        protected HySDataLinkedList m_csMcModelNetworkGeneratorInfoLIst = null;
        /// <summary>演算要素モデルネットワーク生成のリスト</summary>
        protected List<McModelNetworkGenerator> m_csMcModelNetworkGeneratorList = new List<McModelNetworkGenerator>();


        /// <summary>自動モデルパラメーター作成可能なモデルのリスト</summary>
        protected HySDataLinkedList m_csAbleParamGenerationModelList = new HySDataLinkedList();
        /// <summary>モデルパラメータージェネレーターのリスト</summary>
        protected List<McModelParameterGenerator> m_csMdlParaGeneratorList = new List<McModelParameterGenerator>();

        /// <summary>モデルジェネレーター固有画面の情報リスト</summary>
        protected HySDataLinkedList m_csModelGeneratorScreenList = new HySDataLinkedList();

        /// <summary> 業務処理クラス </summary>
        protected McBusiProcedure m_csBusiProc = null;

        /// <summary>処理中断フラグ </summary>
        protected bool m_bBreakFlg = false;
        /// <summary>動作中のモデルネットワーク生成クラス </summary>
        McModelNetworkGenerator m_csModelNetworkGenerator = null;

        /// <summary><para>method outline:</para>
        /// <para>HYMCOファクトリクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelFactory(csFactory)</para>
        /// </example>
        /// <param name="csFactory">HYMCOファクトリ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内部で、自動パラメータ設定可能なモデルを抽出し、モデルデータジェネレータークラスを
        /// リスト化して管理する
        /// </para>
        /// </remarks>
        public virtual void SetModelFactory(McFigureUnityFactory csFactory)
        {
            m_csModelFactory = csFactory;
            m_csMdlFactorySet = csFactory.GetModelFactorySet();

            McModelInfo csModelInfo = null;
            HySID csLibID = null;
            HySObjectKind csMdlKind = null;
            
            //演算要素モデルネットワーク生成クラス情報のリストを取得する
            m_csMcModelNetworkGeneratorInfoLIst = m_csMdlFactorySet.GetModelNetworkGeneratorList();

            // 演算要素モデルネットワーク生成クラスのリストを作成する
            McModelNetworkGenerator csMdlNetGen = null;
            long lNetGenCnt = m_csMcModelNetworkGeneratorInfoLIst.GetCount();
            m_csMcModelNetworkGeneratorInfoLIst.SetCursorFirst();
            for (long lLp = 0; lLp < lNetGenCnt; lLp++)
            {
                csModelInfo = m_csMcModelNetworkGeneratorInfoLIst.GetCursorData() as McModelInfo;
                csLibID = csModelInfo.GetLibraryID();
                csMdlKind = csModelInfo.GetModelKind();

                csMdlNetGen = m_csMdlFactorySet.CreateModelNetworkGenerator(csLibID, csMdlKind, new HySID(lLp.ToString()));
                if (csMdlNetGen != null)
                {
                    m_csMcModelNetworkGeneratorList.Add(csMdlNetGen);
                }
                m_csMcModelNetworkGeneratorInfoLIst.MoveCursorNext();
            }


            // 自動モデルパラメーター作成可能なモデルのリストとモデルパラメータージェネレーターのリストを作成する
            HySDataLinkedList csCalMdlList = m_csMdlFactorySet.GetCalModelInfoList();

            McModelParameterGenerator csModelPrmGenerator = null;
            long lMdlCnt = csCalMdlList.GetCount();
            csCalMdlList.SetCursorFirst();
            for (long lLp = 0; lLp < lMdlCnt; lLp++)
            {
                csModelInfo = csCalMdlList.GetCursorData() as McModelInfo;
                csLibID = csModelInfo.GetLibraryID();
                csMdlKind = csModelInfo.GetModelKind();

                csModelPrmGenerator = m_csMdlFactorySet.CreateModelParameterGenerator(csLibID, csMdlKind, new HySID(lLp.ToString()));
                if (csModelPrmGenerator != null)
                {
                    m_csMdlParaGeneratorList.Add(csModelPrmGenerator);
                    m_csAbleParamGenerationModelList.AddLast(csModelInfo);
                }
                csCalMdlList.MoveCursorNext();
            }

            // モデルジェネレーター関連情報リストの作成
            m_csModelGeneratorScreenList.Clear();
            HySDataLinkedList csScrnList = null;

            m_csPrptyScreenFactorySet = csFactory.GetPropertyScreenFactorySet();
            LinkedList<HySFactory> csFctryList = m_csPrptyScreenFactorySet.GetScreenFactoryList();

            McPropertyScreenFactoryBase csScrnFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = csFctryList.First;
            for (long lLoop = 0; lLoop < csFctryList.Count; lLoop++)
            {
                csScrnFactory = csFactoryNode.Value as McPropertyScreenFactoryBase;
                if (csScrnFactory != null)
                {
                    csScrnList = csScrnFactory.GetModelGeneratorScreenList();
                    if (csScrnList != null)
                    {
                        long lLstCnt = csScrnList.GetCount();
                        csScrnList.SetCursorFirst();
                        for (long lLp = 0; lLp < lLstCnt; lLp++)
                        {
                            m_csModelGeneratorScreenList.AddLast(csScrnList.GetCursorData());
                            csScrnList.MoveCursorNext();
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの情報リストを返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList bRtn = GetModelNetworkGeneratorList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラスの情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelNetworkGeneratorList()
        {
            return m_csMcModelNetworkGeneratorInfoLIst;
        }

        /// <summary><para>method outline:</para>
        /// <para>自動パラメータ設定可能なモデルのリストを返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList bRtn = GetModelDataGenerationList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>自動パラメータ設定可能なモデルのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>このリストに無いモデルはパラメーター等の自動生成が出来ない</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelDataGenerationList()
        {
            return m_csAbleParamGenerationModelList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレーター固有画面の情報リストを返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList bRtn = GetModelGeneratorScreenList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデルジェネレーター固有画面の情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorScreenList()
        {
            return m_csModelGeneratorScreenList;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = CreateSimulationInfo(ref csEvent)</para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報を生成する
        /// （通常は、指定ファイルに出力する）</para>
        /// </remarks>
        public virtual Boolean CreateSimulationInfo(ref HySSysEvent csEvent)
        {
            bool bRtn = true;
            bool bLclRtn = true; // ローカル値：
            m_bBreakFlg = false;

            McModelDataGenerationInfo csMDGInfo = ((HySEventObject)csEvent).GetData() as McModelDataGenerationInfo; // モデルデータジェネレーション用情報クラス
            McModelDataGenerationInfoIF csMDGInfoIF = csMDGInfo;
            if (csMDGInfo == null)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "McModelGeneratorController", "CreateSimulationInfo", 
                    Properties.HymcoImplResources.STATEMENT_NOT_MCMODELDATAGENERATIONINFO );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "McModelGeneratorController", "CreateSimulationInfo", "Cannot Get McModelDataGenerationInfo");
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(false, new HySString("モデルジェネレーション情報が取得できません。"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_MODELGENERATORINFO")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);
                bRtn = false;
                return bRtn;
            }

            m_csModelNetworkGenerator
                = m_csMdlFactorySet.CreateModelNetworkGenerator(
                                        csMDGInfo.GetLibraryID(),
                                        csMDGInfo.GetGeneratorKind(),
                                        new HySID(""));

            if (m_csModelNetworkGenerator == null)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "McModelGeneratorController", "CreateSimulationInfo", 
                    Properties.HymcoImplResources.STATEMENT_NOT_CREATE_MCMODELNETWORKGENERATOR + csMDGInfo.GetLibraryID() 
                    + Properties.HymcoImplResources.STATEMENT_GEN_KIND + csMDGInfo.GetGeneratorKind() + ")");
               // HySLog.LogOut(HySLog.TRIAL_RUN, "McModelGeneratorController", "CreateSimulationInfo",
               //     " Cannot Create McModelNetworkGenerator. (LibID=" + csMDGInfo.GetLibraryID() + ", GeneKind=" + csMDGInfo.GetGeneratorKind() + ")");
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(false, new HySString("モデル生成クラスが見つかりません。"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_FIND_MAKINGCLASS")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);
                bRtn = false;
                return bRtn;
            }
            if (m_bBreakFlg == true)
            {
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(false, new HySString("モデル生成処理を中断しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_BREAK_MEKE_MODELEINFO")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);
                bRtn = false;
                return bRtn;
            }
            m_csModelNetworkGenerator.ResetBreakCreation();
            bLclRtn = m_csModelNetworkGenerator.CheckBefoModelGeneration(ref csMDGInfoIF);
            if (bLclRtn == false)
            {
                if (m_bBreakFlg == true)
                {
                    //McMdlDtGenAckInfo csSubDt =
                    //    new McMdlDtGenAckInfo(false, new HySString("モデル生成処理を中断しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                    McMdlDtGenAckInfo csSubDt =
                        new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_BREAK_MEKE_MODELEINFO")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                    ((HySEventObject)csEvent).SetSubData(csSubDt);
                }
                else
                {
                    //McMdlDtGenAckInfo csSubDt =
                    //    new McMdlDtGenAckInfo(false, new HySString("入力情報に誤りがあります。"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                    McMdlDtGenAckInfo csSubDt =
                        new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_INPUT_DATA")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                    ((HySEventObject)csEvent).SetSubData(csSubDt);
                }

                bRtn = false;
                return bRtn;
            }
            //McMdlDtGenAckInfo csAckDt =
            //      new McMdlDtGenAckInfo(true, new HySString("モデル生成開始しました"), McMdlDtGenAckInfo.MODEL_GENERATION_PROGRESS);
            McMdlDtGenAckInfo csAckDt =
                  new McMdlDtGenAckInfo(true, new HySString(McMessage.GetString("MC_MSG_INFO_MG_MODEL_MAKING_START")), McMdlDtGenAckInfo.MODEL_GENERATION_PROGRESS);
            this.PutAckEvent(csAckDt);

            //HySString csSCFNameWithPath =
            //    HySEnvInf.GetHomeDirectory() + new HySString("\\temp\\") +
            //    csMDGInfo.GetProjectName() + new HySString(".xml");
            HySString csSCFNameWithPath = csMDGInfo.GetProjectName();
            HySString csPath = new HySString("");
            HySString csSCFileName = new HySString("");
            HySString csPrptyFileName = new HySString("");
            HySString csInitialFileName = new HySString("");
            HySString csPrjctFileName = new HySString("");

            McStructInfo csStructInfo = new McStructInfo();
            csStructInfo.MakeCSFName( csSCFNameWithPath, ref  csPath, ref  csSCFileName, ref  csPrptyFileName, ref  csInitialFileName, ref  csPrjctFileName);
            csStructInfo.SetPropertyXmlFileName(csPrptyFileName);
            csStructInfo.SetInitialXmlFileName(csInitialFileName);
            try
            {
                // 構造定義ファイル本体　.XML
                HySXmlWriter csOutFileXml = new HySXmlWriter(csSCFNameWithPath);
                McPropertyInfoBase.SetXmlOutFlg(McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE);
                HySXmlNode csRootNode = csStructInfo.WriteStructureHeader(ref csOutFileXml);

                // 構造定義ファイルの内部を作成する
                bLclRtn = m_csModelNetworkGenerator.CreateModelNetworkData(ref csMDGInfoIF, ref csRootNode, ref csOutFileXml);

                if (bLclRtn == false)
                {
                    if (m_bBreakFlg == true)
                    {
                        //McMdlDtGenAckInfo csSubDt =
                        //    new McMdlDtGenAckInfo(false, new HySString("モデル生成処理を中断しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                        McMdlDtGenAckInfo csSubDt =
                            new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_BREAK_MEKE_MODELEINFO")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                        ((HySEventObject)csEvent).SetSubData(csSubDt);
                    }
                    else
                    {
                        //McMdlDtGenAckInfo csSubDt =
                        //    new McMdlDtGenAckInfo(false, new HySString("モデルの構造定義情報作成に失敗しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
						//((HySEventObject)csEvent).SetSubData(csSubDt);
						//****
                        //string strTaget = CommonMP.HYMCO.CoreImpl.Tool.Msg.McMessage.GetString("Z_MC_CREATESIMULATIONINFO_FAIL");
                        string strTaget = CommonMP.HYMCO.CoreImpl.Tool.Msg.McMessage.GetString("MC_MSG_ERROR_MG_MAKE_MODELINFO");
                        McMdlDtGenAckInfo csSubDt =
							new McMdlDtGenAckInfo(false, new HySString(strTaget), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
						((HySEventObject)csEvent).SetSubData(csSubDt);

                    }
                    bRtn = false;
                }
                else
                {
                    csOutFileXml.Save();
                }
            }
            catch (Exception ex)
            {
                // ログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo",
                    Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + ":(" + m_csModelNetworkGenerator.ToString() + ")" + ex.Message); //ex.StackTrace);
               // HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo",
               //     "Exception Catch ::(" + m_csModelNetworkGenerator.ToString() + ")" + ex.Message); //ex.StackTrace);
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(false, new HySString("異常終了：In　" + m_csModelNetworkGenerator.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_END_IN") + m_csModelNetworkGenerator.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);
                // 異常通知
                bRtn = false;
            }

            //csAckDt = new McMdlDtGenAckInfo(true, new HySString("プロパティ情報／初期化情報作成開始しました"), McMdlDtGenAckInfo.MODEL_GENERATION_PROGRESS);
            csAckDt = new McMdlDtGenAckInfo(true, new HySString(McMessage.GetString("MC_MSG_INFO_MG_MAKING_START")), McMdlDtGenAckInfo.MODEL_GENERATION_PROGRESS);
            this.PutAckEvent(csAckDt);

            try
            {
                // プロパティファイル用ＸＭＬ
                HySXmlWriter csPropertyXml = new HySXmlWriter( (csPath + new HySString("\\") + csPrptyFileName) );
                // プロパティルートを作成
                HySXmlNode csPrptyRootNode = csStructInfo.WritePropertyHeader(ref csPropertyXml);
                // 全体システムのプロパティを設定
                HySXmlNode csSysPrptyNode = m_csModelNetworkGenerator.CreateSystemPorperty(ref csMDGInfoIF, ref csPrptyRootNode, ref csPropertyXml);
                if (csSysPrptyNode != null)
                {
                    csPrptyRootNode.AppendChild(csSysPrptyNode);
                }
                // プロパティファイル用<Components>タグの作成
                HySXmlNode csPropertyComponentsNode = csPropertyXml.CreateElement(McDefine.xml_COMPONENT);

                // 初期化ファイル用ＸＭＬ
                HySXmlWriter csInitialXml = new HySXmlWriter((csPath + new HySString("\\") + csInitialFileName) );
                // 初期化ルートを作成
                HySXmlNode csInitRootNode = csStructInfo.WriteInitialHeader(ref csInitialXml);
                // 初期化ファイル用<Components>タグの作成
                HySXmlNode csInitialComponentsNode = csInitialXml.CreateElement(McDefine.xml_COMPONENT);
               
                // 生成された要素の情報を一つずつ読み出して　そのプロパティ情報／初期化情報を書き出す
                McModelNetworkGeneratorBase.McElementTagInf csElmInf=null;
                HySID csMdlLibID = null;
                HySObjectKind csMdlKnd = null;
                McModelParameterGenerator csMdlPrmGen = null;
                
                HySDataLinkedList csElmentList = m_csModelNetworkGenerator.GetElementList();
                long lMdlCnt = csElmentList.GetCount();
                csElmentList.SetCursorFirst();
                for (long lElm = 0; lElm < lMdlCnt; lElm++)
                {
                    if (m_bBreakFlg == true)
                    {
                        //McMdlDtGenAckInfo csSubDt =
                        //    new McMdlDtGenAckInfo(false, new HySString("モデル生成処理を中断しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                        McMdlDtGenAckInfo csSubDt =
                            new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_BREAK_MEKE_MODELEINFO")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                        ((HySEventObject)csEvent).SetSubData(csSubDt);
                        bRtn = false;
                        break;
                    }
                    csElmInf = csElmentList.GetCursorData() as McModelNetworkGeneratorBase.McElementTagInf;
                    if (csElmInf != null)
                    {
                        csMdlLibID = csElmInf.GetLibID();
                        csMdlKnd = csElmInf.GetMdlKind();
                        // 自ライブライ外のモデルに設定を行いたい場合の設定プログラムを生成
                        csMdlPrmGen = m_csModelNetworkGenerator.CreateExternalModelParameterGenerator(csMdlLibID, csMdlKnd, csElmInf.GetElmenetID());
                        if (csMdlPrmGen == null)
                        {   // 自ライブライ外のモデルの設定は行わないとき
                            csMdlPrmGen = m_csMdlFactorySet.CreateModelParameterGenerator(csMdlLibID, csMdlKnd, csElmInf.GetElmenetID());
                        }
                        if (csMdlPrmGen != null)
                        {
                            try
                            {
                                bLclRtn= csMdlPrmGen.CreateModelPropertyData(ref csMDGInfoIF, ref csPropertyComponentsNode, ref csPropertyXml);
                                if (bLclRtn == false)
                                {
                                    bRtn = false;
                                    //McMdlDtGenAckInfo csSubDt =
                                    //    new McMdlDtGenAckInfo(false, new HySString("プロパティ情報の生成に失敗しました　In " + csMdlPrmGen.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                                    McMdlDtGenAckInfo csSubDt =
                                        new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_INFO_MG_MAKING_START") + csMdlPrmGen.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                                    ((HySEventObject)csEvent).SetSubData(csSubDt);

                                    break;
                                }
                                bLclRtn= csMdlPrmGen.CreateInitialData(ref csMDGInfoIF, ref csInitialComponentsNode, ref csInitialXml);
                                if (bLclRtn == false)
                                {
                                    bRtn = false;
                                    //McMdlDtGenAckInfo csSubDt =
                                    //    new McMdlDtGenAckInfo(false, new HySString("初期化情報の生成に失敗しました　In　" + csMdlPrmGen.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                                    McMdlDtGenAckInfo csSubDt =
                                        new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_MAKE_PROPETYINFO") + csMdlPrmGen.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                                    ((HySEventObject)csEvent).SetSubData(csSubDt);

                                    break;
                                }
                            }
                            catch (Exception ex)
                            {
                                // ログ出力
                               // ver1.5 エラートレース日本語対応
                                HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo",
                                     Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + ":(" + csMdlPrmGen.ToString() + ")" + ex.Message);
                               // HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo",
                               //                         "Exception Catch ::(" + csMdlPrmGen.ToString() + ")" + ex.Message);
                                //McMdlDtGenAckInfo csSubDt =
                                //    new McMdlDtGenAckInfo(false, new HySString("異常終了：In　" + csMdlPrmGen.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                                McMdlDtGenAckInfo csSubDt =
                                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_END_IN") + csMdlPrmGen.ToString()), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                                ((HySEventObject)csEvent).SetSubData(csSubDt);
                                // 異常通知
                                bRtn = false;
                                break;
                            }
                        }
                        else
                        {
                            // Do Nothing
                        }
                    }
                    csElmentList.MoveCursorNext();
                }
                if (bRtn == true)
                {
                    csPrptyRootNode.AppendChild(csPropertyComponentsNode);
                    csInitialXml.AppendChild(csInitialComponentsNode);
                    csPropertyXml.Save();
                    csInitialXml.Save();
                }
            }
            catch (Exception ex)
            {
                // ログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo",
                      Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + ":" + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo",
               //                         "Exception Catch ::" + ex.Message);
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(false, new HySString("異常終了検出"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_DETECT_END")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);

                // 異常通知
                bRtn = false;
            }


            try
            {
                // プロジェクトファイル  .XML 生成
                HySXmlWriter csPrjctXml = new HySXmlWriter((csPath + new HySString("\\") + csPrjctFileName) );

                HySTime csStart = HySCalendar.CreateNowTime();
                HySTime csGoal = csStart + new HySTime(6,0,0);
                HySTime csDlt = new HySTime(60);
                csStructInfo.ProjectXML(ref csPrjctXml, csSCFileName, csStart, csGoal, csDlt);
                csPrjctXml.Save();

                //csModelNetworkGenerator.CreateModelNetworkData(
            }
            catch (Exception ex)
            {
                // ログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo", 
                    Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + ": " + ex.Message); //ex.StackTrace);
               // HySLog.LogOut(HySLog.ONLINE, "McModelGeneratorController::CreateSimulationInfo", "Exception Catch :: " + ex.Message); //ex.StackTrace);
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(false, new HySString("プロジェクトファイル生成時に異常が発生しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString(McMessage.GetString("MC_MSG_ERROR_MG_CREATE_PROJECTFILE")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);
                // 異常通知
                bRtn = false;
            }
            if (bRtn == true)
            {
                //McMdlDtGenAckInfo csSubDt =
                //    new McMdlDtGenAckInfo(true, new HySString("モデル生成終了しました"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(true, new HySString(McMessage.GetString("MC_MSG_INFO_MG_COMPLETE")), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)csEvent).SetSubData(csSubDt);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成中止</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = BreakCreation(ref csEvent)</para>
        /// </example>
        /// <param name="csEvent">送られたイベント（必要ならば使用する）</param>
        /// <returns>true  : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求された情報でシミュレーション内部を構築する
        /// </para>
        /// </remarks>
        public virtual Boolean BreakCreation(ref HySSysEvent csEvent)
        {
            m_bBreakFlg = true;
            if (m_csModelNetworkGenerator != null)
            {
                m_csModelNetworkGenerator.BreakCreation();
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務処理クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetBusiProcedure( csBusiProc )</para>
        /// </example>
        /// <param name="csBusiProc">業務処理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>HYMCO 固有</para>
        /// </remarks>
        public virtual void  SetBusiProcedure( McBusiProcedure csBusiProc )
        {
            m_csBusiProc = csBusiProc;
        }

        /// <summary><para>method outline:</para>
        /// <para>応答を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutAckEvent( csSubDt ) </para>
        /// </example>
        /// <param name="csSubDt">送る イベント付加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からを所有する業務処理クラスに応答イベント送信を依頼する</para>
        /// </remarks>
        virtual protected void PutAckEvent(McMdlDtGenAckInfo csSubDt)
        {
            HySEventObject csEvent = 
                new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_SIMULATION_COMMON);
            csEvent.SetSubEventNo(HySSimulatorDefine.SIMULATION_DATA_CREATE);

            csEvent.SetSubData(csSubDt);
            csEvent.SetToSimKind(m_csBusiProc.GetSimKind());
            m_csBusiProc.PutEvent(csEvent);
        }
        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からを所有する業務処理クラスにイベント送信を依頼する</para>
        /// </remarks>
        virtual protected void PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetTo(HySSysEvent.OBJID_VIEWER);
            m_csBusiProc.PutEvent(csEvent);
        }
    }
}
