﻿// <summary>ソースコード：ＨＹＭＣＯ ライブラリ分類定義データ設定処理クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreImpl.LibraryMng
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ分類定義データ設定処理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/01/22][新規作成]</para>
    /// </remarks>
    internal class McLibConfigDataHandler
    {
        /// <summary>区分ノード名称</summary>
        static private readonly String NODE_DIVISION = "Division";
        /// <summary>分類ノード名称</summary>
        static private readonly String NODE_CATEGORY = "Category";
        /// <summary>分類ノード名称</summary>
        static private readonly String NODE_LIBRARY = "Library";
        /// <summary>分類名ノード名称</summary>
        static private readonly String KEY_NAME = "Name";
        /// <summary>分類IDノード名称</summary>
        static private readonly String KEY_ID = "ID";
        /// <summary>ライブラリID属性名称</summary>
        static private readonly String KEY_LIBRARY_ID = "LibraryID";
        /// <summary>モデル種別名称</summary>
        static private readonly String KEY_MODEL_KIND = "ModelKind";
        ///// <summary>分類Iconノード名称</summary>
        //static private readonly String KEY_ICON = "Icon";

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ区分情報設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        /// McLibConfigDataHandler.SetDivisionNode(csXmlDocument, csLibCategoryData)
        /// </para>
        /// </example>
        /// <param name="csXmlDocument">XMLファイル読込み情報</param>
        /// <param name="csLibCategoryData">ライブラリ分類データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDivisionNode(XmlDocument csXmlDocument, McLibCategoryData csLibCategoryData)
        {
            HySString csTagName = null;
            HySString csKeyName = null;
            HySString csKeyId = null;

            // XML文書のルートノード取得
            XmlNode csRootXmlNode = csXmlDocument.DocumentElement;

            foreach (XmlNode csChildXmlNode in csRootXmlNode.ChildNodes)
            {
                //区分ノードか？
                if (csChildXmlNode.Name.Equals(NODE_DIVISION))
                {
                    // 属性「ID」を取得
                    csKeyId = new HySString(((XmlElement)csChildXmlNode).GetAttribute(KEY_ID));
                    //タグ要素名を取得
                    csTagName = new HySString(((XmlElement)csChildXmlNode).Name);
                    // 属性「name」を取得
                    csKeyName = new HySString(((XmlElement)csChildXmlNode).GetAttribute(KEY_NAME));

                    //区分ノードのデータを追加
                    csLibCategoryData.AddData(csKeyId, csTagName, csKeyName);
                    SetCategoryNode(csKeyId, csChildXmlNode, csLibCategoryData);
                }
            }

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ分類情報設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        /// McLibConfigDataHandler.SetCategoryNode( csKeyId,  csChildXmlNode,  csLibCategoryData)
        /// </para>
        /// </example>
        /// <param name="csKeyId">キーID</param>
        /// <param name="csChildXmlNode">ライブラリ分類Node</param>
        /// <param name="csLibCategoryData">ライブラリ分類データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCategoryNode(HySString csKeyId, XmlNode csChildXmlNode, McLibCategoryData csLibCategoryData)
        {
            List<McLibInfoNode> csChildNodeList = CreateCategoryChildNodeList(csChildXmlNode);
            //分類ノードのデータを追加
            csLibCategoryData.AddChildNodeList(csKeyId, csChildNodeList);

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>カテゴリノード子ノードリスト作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        /// List = McLibConfigDataHandler.CreateCategoryChildNodeList( csChildXmlNode )
        /// </para>
        /// </example>
        /// <param name="csChildXmlNode">ライブラリ分類Node</param>
        /// <returns>List&lt;McLibInfoNode&gt;ノードリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>カテゴリノードの子ノードリストを作成する</para>
        /// </remarks>
        public List<McLibInfoNode> CreateCategoryChildNodeList(XmlNode csChildXmlNode)
        {
            List<McLibInfoNode> csLibInfoNodeList = new List<McLibInfoNode>();
            
            foreach (XmlNode csXmlNode in csChildXmlNode.ChildNodes)
            {
                McLibInfoNode csLibInfoNode = null;
                //分類ノードか？
                if (csXmlNode.Name.Equals(NODE_CATEGORY))
                {
                    csLibInfoNode = new McLibInfoNode();
                    // 属性「ID」を取得
                    csLibInfoNode.ID = new HySString(((XmlElement)csXmlNode).GetAttribute(KEY_ID));
                    // 属性「name」を取得
                    csLibInfoNode.Name = new HySString(((XmlElement)csXmlNode).GetAttribute(KEY_NAME));
                    //ノード名称を所得
                    csLibInfoNode.Type = new HySString(((XmlElement)csXmlNode).Name);

                    csLibInfoNode.SetChildNodeList( CreateCategoryChildNodeList(csXmlNode) );

                    csLibInfoNodeList.Add(csLibInfoNode);
                }
                else if (csXmlNode.Name.Equals(NODE_LIBRARY))
                {
                    csLibInfoNode = new McLibInfoNode();
                    // 属性[LibraryID]を取得
                    // 属性[ModelKind]を取得
                    csLibInfoNode.SetAttribute(new HySString(KEY_LIBRARY_ID), new HySString(((XmlElement)csXmlNode).GetAttribute(KEY_LIBRARY_ID)));
                    csLibInfoNode.SetAttribute(new HySString(KEY_MODEL_KIND), new HySString(((XmlElement)csXmlNode).GetAttribute(KEY_MODEL_KIND)));
                    // ノードの名称を取得
                    csLibInfoNode.Type = new HySString(((XmlElement)csXmlNode).Name);

                    csLibInfoNodeList.Add(csLibInfoNode);
                }
                               
            }
            return csLibInfoNodeList;
        }
    }
}
