﻿// <summary>ソースコード：ＨＹＭＣＯ ライブラリ分類定義データ読込み管理ファクトリクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;


namespace CommonMP.HYMCO.CoreImpl.LibraryMng
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ分類定義データ読込み管理ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/01/22][新規作成]</para>
    /// </remarks>
    internal class McLibConfigDataReaderFactory
    {
        //定数定義
        /// <summary>ファイル種別：DICON</summary>
        static private readonly HySString DICON_FILETYPE = new HySString("DICON_FILETYPE");
        /// <summary>ファイル種別：XML</summary>
        static private readonly HySString XML_FILETYPE = new HySString("xml");
        /// <summary>ファイルパス</summary>
        //static private readonly HySString CONFIG_PATH = new HySString("\\conf\\");
        static private readonly HySString CONFIG_PATH = new HySString("\\conf\\" + HySEnvInf.GetCultureDirectory().ToString());
        /// <summary>エラーメッセージ</summary>
        static private readonly String MSG_ERROR_CONFIG_FILETYPE = "未知の形式です";

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ定義データリーダ処理生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLibConfigDataReader csReader = McLibConfigDataReaderFactory.CreateInstanse( csFileName )</para>
        /// </example>
        /// <param name="csFileName">ライブラリ定義データファイル名称</param>
        /// <returns>ライブラリ定義データリーダ処理</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static McLibConfigDataReader CreateInstanse(HySString csFileName)
        {
            HySString csDataPath = null;
            HySString csFileType = null;

            csDataPath = HySEnvInf.GetHomeDirectory() + CONFIG_PATH; ;

            // ファイル種別を設定（diconファイルを流用）
            csFileType = HySEnvInf.GetEnvInf(DICON_FILETYPE);

            if (csFileType.Equal(XML_FILETYPE) == true)
            {
                // ファイルタイプがXMLの場合
                return (McLibConfigDataReader)new McLibXmlFileReader(csDataPath, csFileName);
            }
            else
            {
                //ファイルが未知の形式の場合
                throw new NotSupportedException(MSG_ERROR_CONFIG_FILETYPE.ToString() + csFileType);
            }
        }
    }
}
