﻿// <summary>ソースコード：ＨＹＭＣＯ ライブラリ分類定義XMLファイル読込みクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreImpl.LibraryMng
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ分類定義XMLファイル読込みクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/01/22][新規作成]</para>
    /// </remarks>
    internal class McLibXmlFileReader : McLibConfigDataReader
    {
         /// <summary>定義ファイル名称</summary>
        private String m_csFileName;

        /// <summary>ファイルパス</summary>
        private String m_csDataPath;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLibXmlFileReader csReader = new McLibXmlFileReader( csDataPath, csFileName )</para>
        /// </example>
        /// <param name="csDataPath">ファイルパス</param>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>McLibXmlFileReader 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibXmlFileReader(HySString csDataPath, HySString csFileName)
        {
            m_csDataPath = csDataPath.ToString();
            m_csFileName = csFileName.ToString();
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ分類定義データ読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLibCategoryData csData = McLibXmlFileReader.ConfigDataLoad()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ分類定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McLibCategoryData LibConfigDataLoad()
        {
            try
            {
                //定義ファイルパス
                StringBuilder csSb = new StringBuilder();
                csSb.Append(m_csDataPath);
                csSb.Append(m_csFileName);
                McLibCategoryData csLibCategoryData = new McLibCategoryData();      //ライブラリ分類データ
                XmlDocument csXmlDocument = new XmlDocument();                      //XMLドキュメント

                //ファイルが存在するかどうかチェック
                if (File.Exists(csSb.ToString()) == false)
                {
                    csLibCategoryData = null;
                }
                else
                {
                    csXmlDocument.Load(csSb.ToString());                            //XMLドキュメント読み込み処理
                    McLibConfigDataHandler csHandler = new McLibConfigDataHandler();//定義データ処理クラス
                    csHandler.SetDivisionNode(csXmlDocument, csLibCategoryData);    //定義データを設定する
                }
                return csLibCategoryData;
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McLibXmlFileReader.LibConfigDataLoad", 
                    Properties.HymcoImplResources.STATEMENT_LIB_CLASSIFICATION_READ_NG + ex);
               // HySLog.LogOut(HySLog.ONLINE, "McLibXmlFileReader.LibConfigDataLoad", "ライブラリ分類定義ファイル読み込みエラー：" + ex);
                return null;
            }            
        }
    }
}
