﻿// <summary>ソースコード：ＨＹＭＣＯファイル出力用制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.CoreImpl.Data.FileIO;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreImpl.Model
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯファイル出力制御クラス（抽象クラス）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public abstract class McBasicFileOutCtl : McBasicIOCtlModelBase, McOutModelCtlIF
    {
        //// <summary>出力データ</summary>
        //protected McCalInfo m_csCalInfo = null;

        /// <summary>出力ファイル名称</summary>
        protected HySString m_csOutFileNameWithFullPath = new HySString("..\\temp\\Result.csv");//HySEnvInf.GetHomeDirectory() + new HySString("\\temp\\Result.csv");
        /// <summary>出力ファイルインスタンス</summary>
        protected HySFile m_csOutFile = null;
        /// <summary>出力ファイル形式（将来拡張用）</summary>
        protected HySDefine.FileType  m_csOutType = HySDefine.FileType.CSV_TYPE;

        /// <summary>出力切替SWITCH（==true:ファイル出力ON,==false:ファイル出力OFF）</summary>
        protected bool m_bFileOutFlg = true;

        /// <summary>タイムステップ</summary>
        protected double m_dTimeStep = 0.0;


        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;
            if (lOutputDataNum > 0)
            {
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), new HySObjectKind("McBasicFileOutCtl"),
                    Properties.HymcoImplResources.STATEMENT_HAVE_NO_SEND_PORT );
               // csErrorInf.AddCheckErrorData(this.m_csElement.GetID(), new HySObjectKind("McBasicFileOutCtl"), "McBasiclFileOutCtl must have no Send Port.");
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算状態復元のためのデータクラスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCmnElementOutData csElementOutData = CreateOutData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCmnElementOutData データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCmnElementOutData  CreateOutData()
        {
            return new McFileCtlOutData();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルにモデル内情報を全て書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileOUT(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>bool true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileOUT(HySDataRoot csData)
        {
            ((McFileCtlOutData)(csData)).SetFileOutData(m_csCalInfo);
            ((McFileCtlOutData)(csData)).SetFileName(m_csOutFileNameWithFullPath);
            ((McFileCtlOutData)(csData)).SetOutFile(m_csOutFile);
            ((McFileCtlOutData)(csData)).SetFileOutFlg(m_bFileOutFlg);
            ((McFileCtlOutData)(csData)).SetTimeStep(m_dTimeStep);

            //((McFileCtlOutData)(csData)).SetTimeData(McDefine.SIMULATION_TIME, m_csSimTime);
            //((McFileCtlOutData)(csData)).SetTimeData(McDefine.TARGET_TIME, m_csTgtTime);
            //((McFileCtlOutData)(csData)).SetTimeData(McDefine.DELTA_TIME, m_csDltTime);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルからモデル情報を全て読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileIN(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>bool true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileIN(HySDataRoot csData)
        {
            // 演算状態の復元
            McCalInfo csCalInfo = ((McFileCtlOutData)(csData)).GetFileOutData();
            if (m_csCalInfo != null)
            {
                m_csCalInfo.CopyInfo(csCalInfo);
            }
            m_csOutFileNameWithFullPath = ((McFileCtlOutData)(csData)).GetFileName();
            m_csOutFile = ((McFileCtlOutData)(csData)).GetOutFile();
            m_bFileOutFlg = ((McFileCtlOutData)(csData)).GetFileOutFlg();
            m_dTimeStep = ((McFileCtlOutData)(csData)).GetTimeStep();

            //m_csSimTime = (HySTime)((McFileCtlOutData)(csData)).GetTimeData(McDefine.SIMULATION_TIME);
            //m_csTgtTime = (HySTime)((McFileCtlOutData)(csData)).GetTimeData(McDefine.TARGET_TIME);
            //m_csDltTime = (HySTime)((McFileCtlOutData)(csData)).GetTimeData(McDefine.DELTA_TIME);
            
            // 復元後の整合性確保
            if (m_csCalInfo != null)
            {
                if (m_csCalInfo is HySVersionManagement)
                {
                    ((HySVersionManagement)m_csCalInfo).PostDeserialize();
                }
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションデータコンテナの内容を設定する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimDataContainerInfo( csDataContainer )</para>
        /// </example>
        /// <param name="csDataContainer">シミュレーションデータコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetSimDataContainer(HySSimulationDataContainer csDataContainer)
        {
            // 何もしない
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>現在状態の一時記憶（但し計算途中状態は除く）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Memorize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Memorize()とRemember()は対で使用する</para>
        /// </remarks>
        public virtual void Memorize()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>Memorize()した情報の復元</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Remember() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Memorize()とRemember()は対で使用する</para>
        /// </remarks>
        public virtual void Remember()
        {
        }
        */
    }
}
