﻿// <summary>ソースコード：モデルファクトリクラス集合体</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreImpl.Model
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス集合体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McModelFactorySet : HySFactorySet, McModelFactory
    {
        /// <summary>モデル情報リスト </summary>
        HySDataLinkedList m_csCalModelInforList = new HySDataLinkedList();
        /// <summary>モデル情報とDLL名称対応情報 </summary>
        HySDataHashTable m_csCalModelInfoLinkedDll = new HySDataHashTable();
        /// <summary>DLLに含まれるモデル情報 </summary>
        HySDataHashTable m_csDllIncludeCalModelInfo = new HySDataHashTable();
        /// <summary>DLL名称 </summary>
        HySString m_csDllName = new HySString();

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID CreateFactoryID()
        {
            return (HySID)McDefine.FACTORY_ID_MODEL_SET;
            //return new HySID("HYMCO", ".CoreImpl.Model.", "McModelFactorySet");
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelFactorySet csFactory = new McModelFactorySet()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelFactorySet()
        {
            this.SetFactoryID(this.GetFactoryID());
            g_McModelFactorySet = this;
        }

        /// <summary><para>method outline:</para>
        /// <para>エレメントクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElement = CreateElement(csLibraryID,csElementKind, csElementID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csElementKind">エレメント種別識別子</param>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>エレメントクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McElement CreateElement(HySID csLibraryID, HySObjectKind csElementKind, HySID csElementID)
        {
            McElement csRtnElement = null;

            //if (csElementKind.Equals(McModelLibraryDefine.ELEMENT_CONVERGENCE) == true)
            //{
            //    csRtnElement = new McCvrgElement(csElementID);
            //}
            //else
            //{
                csRtnElement = new McCalElement(csElementID);
            //}
           
            return csRtnElement;
        }
        /// <summary><para>method outline:</para>
        /// <para>グループエレメントクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElement = CreateGroupElement(csLibraryID,csElementKind, csElementID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csElementKind">エレメント種別識別子</param>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>エレメントクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McElement CreateGroupElement(HySID csLibraryID, HySObjectKind csElementKind, HySID csElementID)
        {
            McElement csRtnElement = null;
            csRtnElement = new McGrElement(csElementID);
            return csRtnElement;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalModel CreateCalModel(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McCalModel csRtnCalModel = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnCalModel = csModelFactory.CreateCalModel(csLibraryID, csModelKind, csModelID);
                        if (csRtnCalModel != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnCalModel;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot CreateModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            McPropertyInfoRoot csRtnInfoData = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnInfoData = csModelFactory.CreateModelPropertyInfo(csLibraryID, csModelKind);
                        if (csRtnInfoData != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnInfoData;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            McPropertyInfoRoot csRtnInfoData = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnInfoData = csModelFactory.CreateModelInitialInfo(csLibraryID, csModelKind);
                        if (csRtnInfoData != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csLibraryID, csCalInfoKind, csCalInfoID ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csCalInfoKind">データ種別識別子</param>
        /// <param name="csCalInfoID">データID（ダミー)</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalInfo CreateCalInfo(HySID csLibraryID, HySObjectKind csCalInfoKind, HySID csCalInfoID)
        {
            McCalInfo csRtnCalInfoData = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnCalInfoData = csModelFactory.CreateCalInfo(csLibraryID, csCalInfoKind, csCalInfoID);
                        if (csRtnCalInfoData != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTranInfo = CreateTransData(csLibraryID, csTransDataKind, csPropertyInfo, csTransDataID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <param name="csPropertyInfo">伝送データプロパティ表示／設定情報クラス</param>
        /// <param name="csTransDataID">伝送データID</param>
        /// <returns>データ伝送クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTranInfo CreateTransData(HySID csLibraryID, HySObjectKind csTransDataKind, McPropertyInfoRoot csPropertyInfo, HySID csTransDataID)
        {
            McTranInfo csRtnTransData = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnTransData = csModelFactory.CreateTransData(csLibraryID, csTransDataKind, csPropertyInfo, csTransDataID);
                        if (csRtnTransData != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnTransData;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateTranInfoPropertyInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>伝送データプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot CreateTranInfoPropertyInfo(HySID csLibraryID, HySObjectKind csTransDataKind)
        {
            McPropertyInfoRoot csRtnInfoData = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnInfoData = csModelFactory.CreateTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                        if (csRtnInfoData != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnInfoData;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ初期化設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateTranInfoInitialInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>伝送データプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot CreateTranInfoInitialInfo(HySID csLibraryID, HySObjectKind csTransDataKind)
        {
            McPropertyInfoRoot csRtnInfoData = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnInfoData = csModelFactory.CreateTranInfoInitialInfo(csLibraryID, csTransDataKind);
                        if (csRtnInfoData != null)
                        {
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnInfoData;
        }


        /// <summary><para>method outline:</para>
        /// <para>スクリーンファクトリクラス追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> AddMcFactory( csFactory ) </para>
        /// </example>
        /// <param name="csFactory">データ識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void AddFactory(HySFactory csFactory)
        {
            HySDataLinkedList csWorkList = null;
            //McReleaseLibData csReleaseData = null;
            McModelInfo csModelInfo = null;
            McPropertyInfoRoot csPropertyInf = null;
            HySID csLibraryID = null;
            HySObjectKind csElementKind = null;
            McModelFactory csModelFactory = csFactory as McModelFactory;
            if (csFactory != null)
            {
                //======= ファクトリクラスを追加するときに　ついでに、モデル情報等を収集してリンクリストに保持する
                // リリースノート情報リスト更新
                //csReleaseData = csModelFactory.GetReleaseNote() as McReleaseLibData;
                //if (csReleaseData != null)
                //{
                //    m_csReleaseNoteList.AddLast(csReleaseData);
                //}

                // モデル情報リスト更新
                csWorkList = csModelFactory.GetCalModelInfoList();
                // モデル情報とDLL名称の対応情報を作成
                this.MakeModelInfoLinkedDll(m_csDllName, csWorkList);
                if (csWorkList != null)
                {   // モデル情報リスト有り
                    long lDtNum = csWorkList.GetCount();   // データの数取得
                    csWorkList.SetCursorFirst();    // リストの先頭へカーソルを持っていく
                    for (long lLp = 0; lLp < lDtNum; lLp++)
                    {   // データ数繰り返す
                        csModelInfo = csWorkList.GetCursorData() as McModelInfo;    // モデル情報データ取得
                        if (csModelInfo != null)
                        {
                            // プロパティ情報を生成
                            csLibraryID = csModelInfo.GetLibraryID();
                            csElementKind = csModelInfo.GetModelKind();
                            csPropertyInf = csModelFactory.CreateModelPropertyInfo(csLibraryID,csElementKind);
                            if (csPropertyInf == null)
                            {
                                csPropertyInf = csModelFactory.CreateTranInfoPropertyInfo(csLibraryID, csElementKind);
                            }
                            if (csPropertyInf != null)
                            {
                                csModelInfo.SetPropertyInfo(csPropertyInf); // プロパティ情報を設定
                            }
                            else
                            {
                               // ver1.5 エラートレース日本語対応
                                HySLog.LogOut(HySLog.ONLINE, "McModelFactorySet", "AddFactory",
                                    Properties.HymcoImplResources.STATEMENT_NO_MODEL_INF + csLibraryID.ToString() + "," + csElementKind.ToString());
                               // HySLog.LogOut(HySLog.ONLINE, "McModelFactorySet", "AddFactory", "No ModelPropertyInfo In " + csLibraryID.ToString() + "," + csElementKind.ToString());
                            }

                            // 初期情報を生成
                            csPropertyInf = csModelFactory.CreateModelInitialInfo(csLibraryID, csElementKind);
                            if (csPropertyInf == null)
                            {
                                csPropertyInf = csModelFactory.CreateTranInfoInitialInfo(csLibraryID, csElementKind);
                            }
                            csModelInfo.SetInitialInfo(csPropertyInf);  // 初期情報を設定

                            m_csCalModelInforList.AddLast(csModelInfo);  // リストへ追加
                        }
                        csWorkList.MoveCursorNext();    // カーソル位置を次に
                    }
                }
                //==========
                // ファクトリクラスの追加
                base.AddFactory(csModelFactory);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報とDLL名称の対応情報作成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MakeModelInfoLinkedDll(csDllName, csWorkList)</para>
        /// </example>
        /// <param name="csDllName">DLL名称</param>
        /// <param name="csWorkList">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MakeModelInfoLinkedDll(HySString csDllName, HySDataLinkedList csWorkList)
        {
            McModelInfo csModelInfo = null;
            // Dllに対応するモデル情報リストを記憶
            m_csDllIncludeCalModelInfo.AddObject(csDllName, csWorkList);
            if (csWorkList != null)
            {   // モデル情報リスト有り
                long lDtNum = csWorkList.GetCount();   // データの数取得
                csWorkList.SetCursorFirst();    // リストの先頭へカーソルを持っていく
                for (long lLp = 0; lLp < lDtNum; lLp++)
                {   // データ数繰り返す
                    csModelInfo = csWorkList.GetCursorData() as McModelInfo;    // モデル情報データ取得
                    if (csModelInfo != null)
                    {
                        // モデル情報に対応するDll名称を記憶
                        m_csCalModelInfoLinkedDll.AddObject(new HySString(csModelInfo.GetModelKind().ToString()), csDllName);
                    }
                    csWorkList.MoveCursorNext();    // カーソル位置を次に
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>DLL名称設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetDllName(sDllName)</para>
        /// </example>
        /// <param name="sDllName">DLL名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDllName(string sDllName)
        {
            HySString csStr = new HySString(sDllName);
            m_csDllName = csStr;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報とDLL名称対応情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataHashTable csTable = GetCalModelInfoLinkedDll()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報とDLL名称対応情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataHashTable GetCalModelInfoLinkedDll()
        {
            return m_csCalModelInfoLinkedDll;
        }

        /// <summary><para>method outline:</para>
        /// <para>DLLに含まれるモデル情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataHashTable csTable = GetDllIncludeCalModelInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>DLLに含まれるモデル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataHashTable GetDllIncludeCalModelInfo()
        {
            return m_csDllIncludeCalModelInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelInfoList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報(McModelInfo)のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報をリスト形式で返却する</para>
        /// </remarks>
        public HySDataLinkedList GetCalModelInfoList()
        {
            return m_csCalModelInforList;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素モデル情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csModel = GetModelInfo( csLibraryID, csCalInfoKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csCalInfoKind">データ種別識別子</param>
        /// <returns>McModelInfo 要素モデル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelInfo GetModelInfo(HySID csLibraryID, HySObjectKind csCalInfoKind)
        {
            McModelInfo csRtn = null;
            McModelInfo csWork = null;
            long lMdlNum = m_csCalModelInforList.GetCount();
            m_csCalModelInforList.SetCursorFirst();
            for (long lLp = 0; lLp < lMdlNum; lLp++)
            {
                csWork = m_csCalModelInforList.GetCursorData() as McModelInfo;
                if (csLibraryID.Equals(csWork.GetLibraryID()) == true &&
                    csCalInfoKind.Equals(csWork.GetModelKind()) == true)
                {
                    csRtn = csWork;
                    break;
                }
                m_csCalModelInforList.MoveCursorNext();
            }
            return csRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ情報データの取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataRoot csLibData = GetReleaseNote()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>null</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetReleaseNote()
        {
            return null;
        }

        // ================= モデルデータ半自動作成ツール用メソッド ============================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelNetworkGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラス情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelNetworkGeneratorList()
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            HySDataLinkedList csLclList = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    // 要素モデルネットワーク作成クラスリストの取得
                    csLclList = csModelFactory.GetModelNetworkGeneratorList();
                    if (csLclList != null)
                    {   // 要素モデルネットワーク作成クラスの生成に成功
                        long lDtCnt = csLclList.GetCount();
                        csLclList.SetCursorFirst();
                        for (long lLclLp = 0; lLclLp < lDtCnt; lLclLp++)
                        {
                            csRtnList.AddLast(csLclList.GetCursorData());
                            csLclList.MoveCursorNext();
                        }
                    }
                }

                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnList;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelNetworkGenerator csMdlNetworkGen = CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelNetworkGenerator 演算要素モデルネットワーク生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelNetworkGenerator CreateModelNetworkGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McModelNetworkGenerator csRtnMdlNetGenerator = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {   // 指定ファクトリならば
                        // 要素モデルネットワーク作成クラスの取得
                        csRtnMdlNetGenerator = csModelFactory.CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID);
                        if (csRtnMdlNetGenerator != null)
                        {   // 要素モデルネットワーク作成クラスの生成に成功
                            csRtnMdlNetGenerator.SetID(csModelID);
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnMdlNetGenerator;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelParameterGenerator CreateModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McModelParameterGenerator csRtnModelPrmGenerator = null;

            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.EqualFactory(csLibraryID) == true)
                    {
                        csRtnModelPrmGenerator = csModelFactory.CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID);
                        if (csRtnModelPrmGenerator != null)
                        {
                            csRtnModelPrmGenerator.SetID(csModelID);
                            break;
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnModelPrmGenerator;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とするデータのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト(対象なければnull が返却される)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind)
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            HySDataLinkedList csLclRtnList=null;
            McModelFactory csModelFactory = null;
            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {   // ファクトリ数繰り返す
                csModelFactory = csFactoryNode.Value as McModelFactory;
                if (csModelFactory != null)
                {
                    if (csModelFactory.IsEssentialModelGenerationData() == true || 
                        csModelFactory.EqualFactory(csLibraryID) == true)
                    {   // 必須または、IDが一致すれば
                        csLclRtnList = csModelFactory.GetModelGeneratorNeedDataList(csLibraryID, csModelKind);
                        if (csLclRtnList != null)
                        {   // リターン側に移す
                            long lNnum = csLclRtnList.GetCount();
                            csLclRtnList.SetCursorFirst();
                            for (long lLp = 0; lLp < lNnum; lLp++)
                            {
                                //csRtnList.AddFirst(csLclRtnList.GetCursorData());
                                csRtnList.AddLast(csLclRtnList.GetCursorData());
                                csLclRtnList.MoveCursorNext();
                            }
                        }
                    }
                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnList;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とする必須のデータを提供するか？</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsEssentialModelGenerationData( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:必須、=false:モデルによっては不要</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>親クラスは必ずfalse</para>
        /// </remarks>
        public virtual bool IsEssentialModelGenerationData()
        { return false; }
        /// <summary>グローバル公開：モデルファクトリ－セット </summary>
        public static McModelFactorySet g_McModelFactorySet = null; 
    }
}
