﻿// <summary>ソースコード：ＨＹＭＣＯ画面表示用制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.CoreImpl.Data.FileIO;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreImpl.Model
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ画面出力制御クラス（抽象クラス）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public abstract class McScreenCtl : McBasicIOCtlModelBase, McOutModelCtlIF
    {
        /// <summary>表示データ</summary>
        protected HySDataRoot m_csDispData = null;

        /// <summary>シミュレーション制御クラス</summary>
        static protected HySSimulationController m_csSimuCtl;

        /// <summary>画面表示中フラグ</summary>
        protected bool m_bDispFlg = false;

        /// <summary>タイムステップ</summary>
        protected double m_dTimeStep = 0.0;

        /// <summary>描画周期</summary>
        protected long m_lDispCycle = 0;
        
        // ===== 画面更新イベント発行中　時間調整用変数群 ======
        /// <summary> イベント発行待ち状態 </summary>
        protected bool m_EventHoldingState = false;
        /// <summary> 画面表示要求数 </summary>
        protected ulong m_lDispEventNum = 0;
        /// <summary> 画面更新要求最低間隔（ミリ秒） </summary>
        protected int m_iDispTimeLag = 1000;
        /// <summary> 画面表示スレッド消去回数 </summary>
        protected ulong m_lDispEventTOutNum = 0;
        /// <summary> 画面表示スレッド消去回数最大値 </summary>
        protected ulong m_lDispEventTOutMax = 5;


        /// <summary><para>method outline:</para>
        /// <para>計算状態復元のためのデータクラスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCmnElementOutData csElementOutData = CreateOutData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCmnElementOutData CreateOutData()
        {
            return new McScreenCtlOutData();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルにモデル内情報を全て書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileOUT(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>bool true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileOUT(HySDataRoot csData)
        {
            ((McScreenCtlOutData)(csData)).SetDispData(m_csDispData);
            ((McScreenCtlOutData)(csData)).SetDispFlg(m_bDispFlg);
            ((McScreenCtlOutData)(csData)).SetTimeStep(m_dTimeStep);
            ((McScreenCtlOutData)(csData)).SetDispCycle(m_lDispCycle);
            ((McScreenCtlOutData)(csData)).SetEventHoldingState(m_EventHoldingState);
            ((McScreenCtlOutData)(csData)).SetDispEventNum(m_lDispEventNum);
            ((McScreenCtlOutData)(csData)).SetDispTimeLag(m_iDispTimeLag);
            ((McScreenCtlOutData)(csData)).SetDispEventTOutNum(m_lDispEventTOutNum);
            ((McScreenCtlOutData)(csData)).SetDispEventTOutMax(m_lDispEventTOutMax);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルからモデル情報を全て読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileIN(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>bool true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileIN(HySDataRoot csData)
        {
            // 計算未実行の場合、表示データは生成されない
            m_csDispData = ((McScreenCtlOutData)(csData)).GetDispData();
            m_bDispFlg = ((McScreenCtlOutData)(csData)).GetDispFlg();
            m_dTimeStep = ((McScreenCtlOutData)(csData)).GetTimeStep();
            m_lDispCycle = ((McScreenCtlOutData)(csData)).GetDispCycle();
            m_EventHoldingState = ((McScreenCtlOutData)(csData)).GetEventHoldingState();
            m_lDispEventNum = ((McScreenCtlOutData)(csData)).GetDispEventNum();
            m_iDispTimeLag = ((McScreenCtlOutData)(csData)).GetDispTimeLag();
            m_lDispEventTOutNum = ((McScreenCtlOutData)(csData)).GetDispEventTOutNum();
            m_lDispEventTOutMax = ((McScreenCtlOutData)(csData)).GetDispEventTOutMax();

            // 復元後の整合性確保
            if (m_csDispData != null)
            {
                if (m_csDispData is HySVersionManagement)
                {
                    ((HySVersionManagement)m_csDispData).PostDeserialize();
                }
                //m_csDispData.PostDeserialize();
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimulationController(csSimuCtl)</para>
        /// </example>
        /// <param name="csSimuCtl">シミュレーション制御</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void SetSimulationController(  HySSimulationController csSimuCtl)
        {
            m_csSimuCtl = csSimuCtl;
        }    
    }
}
