﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.CoreImpl.Model.McSystemModelFactory();
        }
    }
}

namespace CommonMP.HYMCO.CoreImpl.Model
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McSystemModelFactory : HySFactoryMono, McModelFactory
    {
        /// <summary>モデル情報リスト </summary>
        protected HySDataLinkedList m_csCalModelInforList = new HySDataLinkedList();

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID CreateFactoryID()
        {
            return McModelLibraryDefine.SYSTEM_MODEL_FACTORY;
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSystemModelFactory csFactory = new McSystemModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSystemModelFactory()
        {
            this.SetFactoryID(this.CreateFactoryID());
            McCellIDMngrFactory.SetCellIDManageData(new McModelCellCorrespondenceInf());
            McCellIDMngrFactory.SetCellIDManageData(new McCellIDMngData());
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalModel CreateCalModel(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McCalModel csCalModel = null;
            if (csModelKind == McModelLibraryDefine.HYM_MODEL_IDLE)
            {   // 何もしないモデル
                csCalModel = new McIdleModel();
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_DATA_MERGE)
            {   // データマージモデル
                csCalModel = new McDataMergeModel();
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            {   // 部分系制御
                csCalModel = new McSubSystemCtl();
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_CONVERGENCE_ITERATION)
            {   // 収束演算制御
                //csCalModel = new McCnvrgncIterationCtlBase();
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24)
            {   // 水理収束演算系演算制御モデルH24版
                csCalModel = new McHydraulicCnvrgncGrCtlBaseH24();
            }
            else if ( csModelKind == McModelLibraryDefine.HYM_MODEL_CALRESULT_DBA_OUT)
            {
                // 演算結果DBアクセス出力
                csCalModel = new McCalResultDBAccessOut();
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_LINES)
            {
                // 時系列任意入力計算結果モニターグラフ出力
                csCalModel = new McLineGraphScreen();
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO)
            {
                // 時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力
                csCalModel = new McLineGraphScreen();
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED)
            {
                // １次元配列縦断データ入力計算結果モニターグラフ出力
                csCalModel = new McLineGraphScreen();
            }
            else
            {
                // Do Nothing
            }

            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalInfo = CreateCalInfo( csLibraryID, csCalInfoKind, csCalInfoID ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csCalInfoKind">データ種別識別子</param>
        /// <param name="csCalInfoID">データID（ダミー)</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalInfo CreateCalInfo(HySID csLibraryID, HySObjectKind csCalInfoKind, HySID csCalInfoID)
        {
            McCalInfo csCalInfoData = null;
            if (csCalInfoKind == McModelLibraryDefine.HYM_MODEL_IDLE)
            {
                // Do Nothing
                //csCalInfoData = new McIdleModel();
            }
            else if (csCalInfoKind == McModelLibraryDefine.HYM_MODEL_DATA_MERGE)
            {   // データマージモデル
                // Do Nothing　McDataMergeModelCalInfo
                csCalInfoData = new McDataMergeModelCalInfo();
            }
            else if (csCalInfoKind == McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            {   // 部分系制御
                // Do Nothing
                //csCalInfoData = new McSubSystemCtl();
            }
            else if (csCalInfoKind == McModelLibraryDefine.HYM_MODEL_CONVERGENCE_ITERATION)
            {   // 収束演算制御
                // Do Nothing
                csCalInfoData = new McCnvrgncIterationInfoBase();
            }
            else if (csCalInfoKind == McModelLibraryDefine.HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24)
            {   // 水理収束演算系演算制御モデルH24版
                csCalInfoData = new McCnvrgncIterationInfoBase();
            }
            else if (csCalInfoKind == McModelLibraryDefine.HYM_MODEL_CALRESULT_DBA_OUT)
            {   // 演算結果DBアクセス出力
                // Do Nothing
            }
            else if (csCalInfoKind == McModelLibraryDefine.MODEL_SCREEN_OUT_LINES)
            {   // 時系列折れ線グラフ画面出力
                csCalInfoData = new McLineGraphScreenOutCalInfo();
            }
            else if (csCalInfoKind == McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO)
            {   // 時系列ハイエト／ハイドログラフ画面出力
                csCalInfoData = new McLineGraphScreenOutCalInfo();
            }
            else if (csCalInfoKind == McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED)
            {   // １次元配列縦断データグラフ画面出力
                csCalInfoData = new McLineGraphScreenOutCalInfo();
            }
            else
            {
                // Do Nothing
            }
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot CreateModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            McPropertyInfoRoot csRtnDt = null;
            if (csModelKind == McModelLibraryDefine.HYM_MODEL_IDLE)
            {
                // Do Nothing
                csRtnDt = new McModelPropertyInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_DATA_MERGE)
            {   // データマージモデル
                csRtnDt = this.CreateMergeModelPropertyInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            {  // 部分系制御
                //csRtnDt = new McGroupPropertyInfo(csLibraryID, csModelKind);
                McGroupPropertyInfo csPrptyInfo = new McGroupPropertyInfo(csLibraryID, csModelKind);
                //csPrptyInfo.SetStepTime(60.0);
                csRtnDt = csPrptyInfo;
            }
            //else if (csModelKind == McModelLibraryDefine.HYM_MODEL_CONVERGENCE_ITERATION) 
            //{
            //}
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24)
            {   // 水理収束演算系演算制御モデルH24版
                McGroupPropertyInfo csPrptyInfo = new McGroupPropertyInfo(csLibraryID, csModelKind);
                //McFigUnityPropertyInfo csPrptyInfo = new McFigUnityPropertyInfo(csLibraryID, csModelKind, new HySTime(60));
                csPrptyInfo.SetDataFusionTiming(McDefine.DataFusionTiming.SYNCHRONOUS);
                csPrptyInfo.SetLoopPermission(true);
                //csPrptyInfo.SetDisband(false);
                csPrptyInfo.SetStepTime(60.0d);
                csRtnDt = csPrptyInfo;
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_CALRESULT_DBA_OUT)
            {
                // 演算結果DBアクセス出力
                McModelPropertyInfo csPrptyInfo = new McModelPropertyInfo(csLibraryID, csModelKind);
                csPrptyInfo.RemoveStepTime();
                // 演算結果格納データサイズ情報
                csPrptyInfo.AddInfoType(McCalResultDBAccessOut.MODEL_DBACCESS_OUT_STOREDATA_SIZE_KEY,
                                        McCalResultDBAccessOut.MODEL_DBACCESS_OUT_STOREDATA_SIZE_NAME,
                                        McDefine.ValKind.LONG);
                csPrptyInfo.SetInfo(McCalResultDBAccessOut.MODEL_DBACCESS_OUT_STOREDATA_SIZE_KEY,
                                    McCalResultDBAccessOut.DEFAULT_STOREDATA_SIZE);
                // DB格納データ間引き間隔
                csPrptyInfo.AddInfoType(McCalResultDBAccessOut.MODEL_DBACCESS_OUT_THIN_OUT_SIZE_KEY,
                                        McCalResultDBAccessOut.MODEL_DBACCESS_OUT_THIN_OUT_SIZE_NAME,
                                        McDefine.ValKind.LONG);
                csPrptyInfo.SetInfo(McCalResultDBAccessOut.MODEL_DBACCESS_OUT_THIN_OUT_SIZE_KEY,
                                    McCalResultDBAccessOut.DEFAULT_THIN_OUT_SIZE);

                csRtnDt = csPrptyInfo;
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_LINES)
            {  // 時系列任意入力計算結果モニターグラフ出力の場合
                csRtnDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                // 演算結果出力刻み時間設定
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_TIME_STEP_KEY,
                                                           McLineGraphScreen.MODEL_TIME_STEP_VALUE);
                // 演算結果出力要否フラグ設定
                ((McCellModelPropertyInfo)csRtnDt).AddInfoType(McLineGraphScreen.MODEL_DISP_FLAG_KEY,
                                                               McLineGraphScreen.MODEL_DISP_FLAG_NAME,
                                                               McDefine.ValKind.BOOL);
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_DISP_FLAG_KEY,
                                                           McLineGraphScreen.MODEL_DISP_FLAG_VALUE);
                // 描画周期時間(ms)設定
                ((McCellModelPropertyInfo)csRtnDt).AddInfoType(McLineGraphScreen.MODEL_DISP_CYCLE_KEY,
                                                               McLineGraphScreen.MODEL_DISP_CYCLE_NAME,
                                                               McDefine.ValKind.LONG);
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_DISP_CYCLE_KEY,
                                                           McLineGraphScreen.MODEL_DISP_CYCLE_VALUE);
                {
                    // ポイント時系列任意入力受信パターンの設定
                    HySID csPatternName = HySMoniterScreen.LINE_GRAPH_SINGLE_CELL_ANY;
                    McTranInfoPattern csTrnPtn = ((McCellModelPropertyInfo)csRtnDt).CreateTranInforPattern(csPatternName,
                                                   McTranInfoDefine.SINGLE_CELL_SERIAL,
                                                   McLineGraphScreen.ANY_VALUE_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定－セルの配列（１次元：１個のみ）
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, McLineGraphScreen.ANY_VALUE_NAME,
                                                       HySDataKindDefine.ANY_VALUE,
                                                       McLineGraphScreen.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    ((McCellModelPropertyInfo)csRtnDt).AddReceivePattern(csTrnPtn);

                    // １次元配列時系列任意入力受信パターンの設定
                    csPatternName = HySMoniterScreen.LINE_GRAPH_D1_CELL_SERIAL;
                    csTrnPtn = ((McCellModelPropertyInfo)csRtnDt).CreateTranInforPattern(csPatternName,
                                                   McTranInfoDefine.D1_CELL_SERIAL,
                                                   McLineGraphScreen.ANY_VALUE_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定－セルの配列（１次元：１個のみ）
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, McLineGraphScreen.ANY_VALUE_NAME,
                                                       HySDataKindDefine.ANY_VALUE,
                                                       McLineGraphScreen.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    ((McCellModelPropertyInfo)csRtnDt).AddReceivePattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO)
            {  // 時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力の場合
                csRtnDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                // 演算結果出力刻み時間設定
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_TIME_STEP_KEY,
                                                           McLineGraphScreen.MODEL_TIME_STEP_VALUE);
                // 演算結果出力要否フラグ設定
                ((McCellModelPropertyInfo)csRtnDt).AddInfoType(McLineGraphScreen.MODEL_DISP_FLAG_KEY,
                                                               McLineGraphScreen.MODEL_DISP_FLAG_NAME,
                                                               McDefine.ValKind.BOOL);
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_DISP_FLAG_KEY,
                                                           McLineGraphScreen.MODEL_DISP_FLAG_VALUE);
                // 描画周期時間(ms)設定
                ((McCellModelPropertyInfo)csRtnDt).AddInfoType(McLineGraphScreen.MODEL_DISP_CYCLE_KEY,
                                                               McLineGraphScreen.MODEL_DISP_CYCLE_NAME,
                                                               McDefine.ValKind.LONG);
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_DISP_CYCLE_KEY,
                                                           McLineGraphScreen.MODEL_DISP_CYCLE_VALUE);
                {
                    // ポイント時系列雨量（ハイエト）入力受信パターンの設定
                    HySID csPatternName = HySMoniterScreen.HYETO_GRAPH_RAIN_SERIAL;
                    McTranInfoPattern csTrnPtn = ((McCellModelPropertyInfo)csRtnDt).CreateTranInforPattern(csPatternName,
                                                   McTranInfoDefine.SINGLE_CELL_SERIAL,
                                                   McLineGraphScreen.HYETO_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定－セルの配列（１次元：１個のみ）
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, McLineGraphScreen.SCALOR_RAIN_FALLE_NAME,
                                                       HySDataKindDefine.SCALOR_RAIN_FALL,
                                                       McLineGraphScreen.SCALOR_RAIN_FALLE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    ((McCellModelPropertyInfo)csRtnDt).AddReceivePattern(csTrnPtn);

                    // ポイント時系列任意入力受信パターンの設定
                    csPatternName = HySMoniterScreen.HYETO_GRAPH_SINGLE_CELL_SERIAL;
                    csTrnPtn = ((McCellModelPropertyInfo)csRtnDt).CreateTranInforPattern(csPatternName,
                                                   McTranInfoDefine.SINGLE_CELL_SERIAL,
                                                   McLineGraphScreen.ANY_VALUE_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定－セルの配列（１次元：１個のみ）
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, McLineGraphScreen.ANY_VALUE_NAME,
                                                       HySDataKindDefine.ANY_VALUE,
                                                       McLineGraphScreen.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    ((McCellModelPropertyInfo)csRtnDt).AddReceivePattern(csTrnPtn);

                    // １次元配列時系列任意入力受信パターンの設定
                    csPatternName = HySMoniterScreen.HYETO_GRAPH_D1_CELL_SERIAL;
                    csTrnPtn = ((McCellModelPropertyInfo)csRtnDt).CreateTranInforPattern(csPatternName,
                                                   McTranInfoDefine.D1_CELL_SERIAL,
                                                   McLineGraphScreen.ANY_VALUE_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定－セルの配列（１次元：１個のみ）
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, McLineGraphScreen.ANY_VALUE_NAME,
                                                       HySDataKindDefine.ANY_VALUE,
                                                       McLineGraphScreen.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    ((McCellModelPropertyInfo)csRtnDt).AddReceivePattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED)
            {  // １次元配列縦断データ入力計算結果モニターグラフ出力の場合
                csRtnDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                // 演算結果出力刻み時間設定
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_TIME_STEP_KEY,
                                                           McLineGraphScreen.MODEL_TIME_STEP_VALUE);
                // 演算結果出力要否フラグ設定
                ((McCellModelPropertyInfo)csRtnDt).AddInfoType(McLineGraphScreen.MODEL_DISP_FLAG_KEY,
                                                               McLineGraphScreen.MODEL_DISP_FLAG_NAME,
                                                               McDefine.ValKind.BOOL);
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_DISP_FLAG_KEY,
                                                           McLineGraphScreen.MODEL_DISP_FLAG_VALUE);
                // 描画周期時間(ms)設定
                ((McCellModelPropertyInfo)csRtnDt).AddInfoType(McLineGraphScreen.MODEL_DISP_CYCLE_KEY,
                                                               McLineGraphScreen.MODEL_DISP_CYCLE_NAME,
                                                               McDefine.ValKind.LONG);
                ((McCellModelPropertyInfo)csRtnDt).SetInfo(McLineGraphScreen.MODEL_DISP_CYCLE_KEY,
                                                           McLineGraphScreen.MODEL_DISP_CYCLE_VALUE);
                {
                    // １次配列時系列縦断データ入力受信パターンの設定
                    HySID csPatternName = HySMoniterScreen.RIVERBED_SHAPE_D1_CELL_SERIAL;
                    McTranInfoPattern csTrnPtn = ((McCellModelPropertyInfo)csRtnDt).CreateTranInforPattern(csPatternName,
                                                   McTranInfoDefine.D1_CELL_SERIAL,
                                                   McLineGraphScreen.RIVERBED_SHAPE_NAME) as McTranInfoPattern;
                    {
                        // セル内変数設定－セルの配列（１次元：１個のみ）
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, McLineGraphScreen.ANY_VALUE_NAME,
                                                       HySDataKindDefine.ANY_VALUE,
                                                       McLineGraphScreen.ANY_VALUE_KEY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    ((McCellModelPropertyInfo)csRtnDt).AddReceivePattern(csTrnPtn);
                }
            }
            else
            {
                // Do Nothing
            }
            return csRtnDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデル初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            McPropertyInfoRoot csRtnDt = null;
            if (csModelKind == McModelLibraryDefine.HYM_MODEL_IDLE)
            {
                // Do Nothing
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_DATA_MERGE)
            {   // データマージモデル
                csRtnDt = new McDataMergeInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_SUBSYSTEM)
            {  // 部分系制御
                //csRtnDt = new McGroupPropertyInfo(csLibraryID, csModelKind);
                csRtnDt = new McGroupInitialInfo(csLibraryID, csModelKind);
            }
            //else if (csModelKind == McModelLibraryDefine.HYM_MODEL_CONVERGENCE_ITERATION)
            //{
            //}
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24)
            {   // 水理収束演算系演算制御モデルH24版
                csRtnDt = new McGroupInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.HYM_MODEL_CALRESULT_DBA_OUT)
            {
                csRtnDt = new McModelInitialInfo(csLibraryID,csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_LINES)
            {  // 時系列任意入力計算結果モニターグラフ出力の場合
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO)
            {  // 時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力の場合
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED)
            {  // １次元配列縦断データ入力計算結果モニターグラフ出力の場合
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
                // Do Nothing
            }
            return csRtnDt;
        }


        /// <summary><para>method outline:</para>
        /// <para>伝送データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTranInfo = CreateTransData(csLibraryID, csTransDataKind, csPropertyInfo, csTransDataID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <param name="csPropertyInfo">伝送データプロパティ表示／設定情報クラス</param>
        /// <param name="csTransDataID">伝送データID</param>
        /// <returns>データ伝送クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo CreateTransData(HySID csLibraryID, HySObjectKind csTransDataKind, McPropertyInfoRoot csPropertyInfo, HySID csTransDataID)
        {
            McTranInfo csTransData = null;

            // ===========================
            // 伝送データ種別識別子関係（システムで準備しておくモデルのみ）
            // ===========================
            if (csTransDataKind == McTranInfoDefine.D1_CELL)
            {
                csTransData = new McD1CellArrayTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_CELL)
            {
                csTransData = new McD2CellArrayTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_CELL)
            {
                csTransData = new McD3CellArrayTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.SINGLE_CELL_SERIAL)
            {
                csTransData = new McTimeSeriesSingleCellTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_CELL_SERIAL)
            {
                csTransData = new McTimeSeriesD1CellArrayTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_CELL_SERIAL)
            {
                csTransData = new McTimeSeriesD2CellArrayTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_CELL_SERIAL)
            {
                csTransData = new McTimeSeriesD3CellArrayTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_GIS)
            {
                csTransData = new McGeoDim1TranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_GIS_MESH)
            {
                csTransData = new McGeoDim2MeshTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_GIS_MESH)
            {
                csTransData = new McGeoDim3MeshTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_GIS_SERIAL)
            {
                csTransData = new McTimeSeriesGeoD1TranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_GIS_MESH_SERIAL)
            {
                csTransData = new McTimeSeriesGeoD2MeshTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_GIS_MESH_SERIAL)
            {
                csTransData = new McTimeSeriesGeoD3MeshTranInfo(csPropertyInfo);
            }

            //else if (csTransDataKind == McTranInfoDefine.TRNINF_LINE_GRAPH)
            //{
            //    csTransData = new McLineGraphTranInfo(csPropertyInfo);
            //}
            else if (csTransDataKind == McTranInfoDefine.TRNINF_MULTI_SERIAL_PROTOTYPE)
            {
                csTransData = new McMultiSerialTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.TRNINF_1DIM_SERIAL_PROTOTYPE)
            {
                csTransData = new McTimeSeries1DTranInfo(csPropertyInfo);
            }
            else if (csTransDataKind == McTranInfoDefine.TRNINF_2DIM_SERIAL_PROTOTYPE)
            {
                csTransData = new McTimeSeries2DTranInfo(csPropertyInfo);
            }

            else if (csTransDataKind == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL 
                || csTransDataKind == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL
                || csTransDataKind == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL
                || csTransDataKind == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL )
            {
                McMutualTranInfoProperty csMutuaTrPrpty = csPropertyInfo as McMutualTranInfoProperty;
                if (csMutuaTrPrpty != null)
                {
                    McCellArrayTranInfoPropertyInfo csDownstreamPrpty;
                    McCellArrayTranInfoPropertyInfo csUpstreamPrpty;
                    (csDownstreamPrpty, csUpstreamPrpty) = csMutuaTrPrpty.GetTranInfoProperty();

                    McTimeSeriesMutualCellTranInfor csMtlTransData = new McTimeSeriesMutualCellTranInfor(csMutuaTrPrpty);
                    //csMtlTransData.SetTranInfoKind(csTransDataKind);


                    McTranInfo csDownstreamTranInfo = this.CreateTransData(csLibraryID, (HySObjectKind)(csDownstreamPrpty.GetModelKind()), csDownstreamPrpty, new HySID( csTransDataID.ToString() + "_Dwn"));
                    McTranInfo csUpstreamTranInfo = this.CreateTransData(csLibraryID, (HySObjectKind)(csUpstreamPrpty.GetModelKind()), csUpstreamPrpty, new HySID(csTransDataID.ToString() + "_Upp"));
                    csMtlTransData.SetTranInfo(csDownstreamTranInfo, csUpstreamTranInfo);

                    csTransData = csMtlTransData;
                }
            }

            else
            {
            }
            
            return csTransData;
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateTranInfoPropertyInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>伝送データプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfoRoot CreateTranInfoPropertyInfo(HySID csLibraryID, HySObjectKind csTransDataKind)
        {
            if (McModelLibraryDefine.SYSTEM_MODEL_FACTORY.Equals(csLibraryID) == false)
            {
                return null;
            }

            McPropertyInfoRoot csRtnDt = null;

            if (csTransDataKind == McTranInfoDefine.D1_CELL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4);// <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(64);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_CELL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32,32);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_CELL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32,16);
            }
            else if (csTransDataKind == McTranInfoDefine.SINGLE_CELL_SERIAL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetMaxRecordDataNum(96);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_CELL_SERIAL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4); //<-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(64);
                csPrptyDt.SetMaxRecordDataNum(96);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_CELL_SERIAL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32,32);
                csPrptyDt.SetMaxRecordDataNum(64);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_CELL_SERIAL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetDimInCell(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32,32,16);
                csPrptyDt.SetMaxRecordDataNum(32);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_GIS)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                //csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(64);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_GIS_MESH)
            {
                McGeoMeshTranInfoPropertyInfo csPrptyDt = new McGeoMeshTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                //csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_GIS_MESH)
            {
                McGeoMeshTranInfoPropertyInfo csPrptyDt = new McGeoMeshTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                //csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32,16);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_GIS_SERIAL)
            {
                McCellArrayTranInfoPropertyInfo csPrptyDt = new McCellArrayTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //csPrptyDt.SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                //csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(64);
                csPrptyDt.SetMaxRecordDataNum(64);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_GIS_MESH_SERIAL)
            {
                McGeoMeshTranInfoPropertyInfo csPrptyDt = new McGeoMeshTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                //csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32);
                csPrptyDt.SetMaxRecordDataNum(64);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_GIS_MESH_SERIAL)
            {
                McGeoMeshTranInfoPropertyInfo csPrptyDt = new McGeoMeshTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.SetKind(HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD);
                //csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32, 16);
                csPrptyDt.SetMaxRecordDataNum(64);
            }
            else if (csTransDataKind == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL)
            {
                McMutualTranInfoProperty csPrptyDt = new McMutualTranInfoProperty(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //////csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(1);
            }
            else if (csTransDataKind == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL)
            {
                McMutualTranInfoProperty csPrptyDt = new McMutualTranInfoProperty(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //////csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                 csPrptyDt.SetDim(64);
            }
            else if (csTransDataKind == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL)
            {
                McMutualTranInfoProperty csPrptyDt = new McMutualTranInfoProperty(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //////csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32);
            }
            else if (csTransDataKind == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL)
            {
                McMutualTranInfoProperty csPrptyDt = new McMutualTranInfoProperty(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                //////csPrptyDt.SetDimInMesh(4); <-- これを設定してはならない(送信側のパターンで決定される為)
                csPrptyDt.SetDim(32, 32, 16);
            }

            // ﾌﾟﾛﾄﾀｲﾌﾟリリースデータ
            else if (csTransDataKind == McTranInfoDefine.TRNINF_MULTI_SERIAL_PROTOTYPE)
            {
                //McModelPropertyInfo csPrptyDt = new McModelPropertyInfo(csLibraryID, csTransDataKind);
                McProtoTranInfoPropertyInfo csPrptyDt = new McProtoTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.AddInfoType(McMultiSerialTranInfo.DATA_SERIES_NUM, Properties.HymcoImplResources.MODEL_DATA_SERIES_NUM, McDefine.ValKind.LONG);   //"データの系列数"
                csPrptyDt.SetInfo(McMultiSerialTranInfo.DATA_SERIES_NUM, 4);
                csPrptyDt.AddInfoType(McMultiSerialTranInfo.MAX_DATA_NUM, Properties.HymcoImplResources.MODEL_MAX_DATA_NUM, McDefine.ValKind.LONG); //"データ保持最大数"
                csPrptyDt.SetInfo(McMultiSerialTranInfo.MAX_DATA_NUM, 32);
            }
                /*
            else if (csTransDataKind == McTranInfoDefine.TRNINF_LINE_GRAPH)
            {
                //McModelPropertyInfo csPrptyDt = new McModelPropertyInfo(csLibraryID, csTransDataKind);
                McProtoTranInfoPropertyInfo csPrptyDt = new McProtoTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt; 
                csPrptyDt.AddInfoType("GRAPH_KIND", "データ種別（時系列：１、それ以外：２）", McDefine.ValKind.LONG);
                csPrptyDt.SetInfo("GRAPH_KIND", (long)HySLineGraphDataPrototype.GRAPH_KIND.TIME_SERIES_DATA);
                csPrptyDt.AddInfoType("GRAPH_FORM_KIND", "フォーマット区分（折れ線：１、リスト表：２）", McDefine.ValKind.LONG);
                csPrptyDt.SetInfo("GRAPH_FORM_KIND", (long)HySLineGraphDataPrototype.GRAPH_FORM_KIND.GRAPH_LINE_DATA);
                csPrptyDt.AddInfoType("m_lSeriesNum", "データの系列数", McDefine.ValKind.LONG);
                csPrptyDt.SetInfo("m_lSeriesNum",1);
            }
                */
            else if (csTransDataKind == McTranInfoDefine.TRNINF_1DIM_SERIAL_PROTOTYPE)
            {
                //McModelPropertyInfo csPrptyDt = new McModelPropertyInfo(csLibraryID, csTransDataKind);
                McProtoTranInfoPropertyInfo csPrptyDt = new McProtoTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.AddInfoType(McTimeSeries1DTranInfo.DATA_DIMENTION_NUM, Properties.HymcoImplResources.MODEL_DATA_DIMENTION_NUM, McDefine.ValKind.LONG);    //"データ配列数"
                csPrptyDt.SetInfo(McTimeSeries1DTranInfo.DATA_DIMENTION_NUM, 64);
                csPrptyDt.AddInfoType(McTimeSeries1DTranInfo.MAX_DATA_NUM, Properties.HymcoImplResources.MODEL_MAX_DATA_NUM, McDefine.ValKind.LONG);    //"データ保持最大数"
                csPrptyDt.SetInfo(McTimeSeries1DTranInfo.MAX_DATA_NUM, 32);
            }
            else if (csTransDataKind == McTranInfoDefine.TRNINF_2DIM_SERIAL_PROTOTYPE)
            {
                //McModelPropertyInfo csPrptyDt = new McModelPropertyInfo(csLibraryID, csTransDataKind);
                McProtoTranInfoPropertyInfo csPrptyDt = new McProtoTranInfoPropertyInfo(csLibraryID, csTransDataKind);
                csRtnDt = csPrptyDt;
                csPrptyDt.AddInfoType(McTimeSeries2DTranInfo.DATA_ROW_NUM, Properties.HymcoImplResources.MODEL_DATA_ROW_NUM, McDefine.ValKind.LONG);    //"データ行数"
                csPrptyDt.SetInfo(McTimeSeries2DTranInfo.DATA_ROW_NUM, 3);
                csPrptyDt.AddInfoType(McTimeSeries2DTranInfo.DATA_COLUMN_NUM, Properties.HymcoImplResources.MODEL_DATA_COLUMN_NUM, McDefine.ValKind.LONG);  //"データ列数"
                csPrptyDt.SetInfo(McTimeSeries2DTranInfo.DATA_COLUMN_NUM, 64);
                csPrptyDt.AddInfoType(McTimeSeries2DTranInfo.MAX_DATA_NUM, Properties.HymcoImplResources.MODEL_MAX_DATA_NUM, McDefine.ValKind.LONG);    //"データ保持最大数"
                csPrptyDt.SetInfo(McTimeSeries2DTranInfo.MAX_DATA_NUM, 64);
            }
            else
            {
                // Do Nothing
            }
            return csRtnDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateTranInfoInitialInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>伝送データプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfoRoot CreateTranInfoInitialInfo(HySID csLibraryID, HySObjectKind csTransDataKind)
        {
            if (McModelLibraryDefine.SYSTEM_MODEL_FACTORY.Equals(csLibraryID) == false)
            {
                return null;
            }

            McPropertyInfo csRtnDt = null;

            if (csTransDataKind == McTranInfoDefine.D1_CELL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_CELL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_CELL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.SINGLE_CELL_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_CELL_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_CELL_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_CELL_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_GIS)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_GIS_MESH)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_GIS_MESH)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D1_GIS_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D2_GIS_MESH_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.D3_GIS_MESH_SERIAL)
            {
                 csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL 
                || csTransDataKind == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL
                || csTransDataKind == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL
                || csTransDataKind == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }

            // ﾌﾟﾛﾄﾀｲﾌﾟリリースデータ
            else if (csTransDataKind == McTranInfoDefine.TRNINF_MULTI_SERIAL_PROTOTYPE)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
                /*
            else if (csTransDataKind == McTranInfoDefine.TRNINF_LINE_GRAPH)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
                */
            else if (csTransDataKind == McTranInfoDefine.TRNINF_1DIM_SERIAL_PROTOTYPE)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else if (csTransDataKind == McTranInfoDefine.TRNINF_2DIM_SERIAL_PROTOTYPE)
            {
                csRtnDt = new McPropertyInfo(csLibraryID, csTransDataKind);
            }
            else
            {
                // Do Nothing
            }
            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ情報データの取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataRoot csLibData = GetReleaseNote();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ情報データ(McReleaseLibData)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetReleaseNote()
        {
            McReleaseLibData csRtn = new McReleaseLibData();
            //csRtn に情報設定
            return csRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo = null;

            // ===========================
            // モデルについて
            // ===========================

            //部分系演算制御モデル: SubSystemCtl
            csModelInfo = new McModelInfo(
                     (HySID)this.GetFactoryID(),
                     McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_CTL,
                     McModelLibraryDefine.HYM_MODEL_SUBSYSTEM,
                     McModelLibraryDefine.MODEL_NAME_SUBSYSTEM,
                     McDefine.MODEL_TYPE_GROUP);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_SUBSYSTEM);   //"部分系制御クラス"
            csModelInfo.SetVersionInf("Ver.1.0");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetLibraryDispMode(false);
            m_csCalModelInforList.AddLast(csModelInfo);

            //水理収束演算系演算制御H24版: McHydraulicCnvrgncCtlH24
            csModelInfo = new McModelInfo(
                     (HySID)this.GetFactoryID(),
                     McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_CTL,
                     McModelLibraryDefine.HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24,
                     McModelLibraryDefine.MODEL_NAME_HYDRAULIC_CONVERGENCE_CTL_H24,
                     McDefine.MODEL_TYPE_GROUP);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_HYDRAULIC_CONVERGENCE_CTL_H24);   //"水理収束演算制御クラス"
            csModelInfo.SetVersionInf("Ver.1.3");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("ConvergenceCtl");
            csModelInfo.SetLibraryDispMode(false);
            m_csCalModelInforList.AddLast(csModelInfo);

            // 何もしない演算モデル:IdleModel
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_ETC,
                    McModelLibraryDefine.HYM_MODEL_IDLE,
                    McModelLibraryDefine.MODEL_NAME_IDLE);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_IDLE);    //"処理を何もしない演算クラス　ダミー処理等に用いる"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultModel");
            m_csCalModelInforList.AddLast(csModelInfo);

            // データマージ要素演算モデル:SammationModel
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_ETC,
                    McModelLibraryDefine.HYM_MODEL_DATA_MERGE,
                    McModelLibraryDefine.MODEL_NAME_DATA_MERGE);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_JUNCTION);    //"複数のデータをマージする要素。物理的合流モデルではない"
            csModelInfo.SetVersionInf("Ver.1.0");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetLibraryDispMode(false);
            m_csCalModelInforList.AddLast(csModelInfo);

            // 演算結果DBアクセス出力要素:CalResultDBAccessOut
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_SPF_FILE,
                    McModelLibraryDefine.HYM_MODEL_CALRESULT_DBA_OUT,
                    McModelLibraryDefine.MODEL_NAME_CALRESULT_DBA_OUT);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_CALRESULT_DBA_OUT);   //"演算結果をDBに出力するためのモデル"
            csModelInfo.SetVersionInf("Ver.1.0");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultOutput");
            csModelInfo.SetLibraryDispMode(false);
            //csModelInfo.SetUserName("演算結果");
            m_csCalModelInforList.AddLast(csModelInfo);

            // 時系列任意入力計算結果モニターグラフ出力要素:McLineGraphScreenOut
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_SCREEN,
                    McModelLibraryDefine.MODEL_SCREEN_OUT_LINES,
                    McModelLibraryDefine.MODEL_NAME_SCREEN_OUT_LINES);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_SCREEN_OUT_LINES);    //"演算中に演算結果を折れ線グラフ画面でモニターするためのモデル"
            csModelInfo.SetVersionInf("Ver.1.0");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("GraphMonitor");
            csModelInfo.SetAttachedScreenKind(true);         // 付属画面有り設定
            m_csCalModelInforList.AddLast(csModelInfo);

            // 時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力要素:McHyetoHydroGraphScreenOut
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_SCREEN,
                    McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO,
                    McModelLibraryDefine.MODEL_NAME_SCREEN_OUT_HYETO_HYDRO);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_SCREEN_OUT_OUT_HYETO_HYDRO);  //"演算中に演算結果をハイエト／ハイドログラフ画面でモニターするためのモデル"
            csModelInfo.SetVersionInf("Ver.1.0");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("GraphMonitor");
            csModelInfo.SetAttachedScreenKind(true);         // 付属画面有り設定
            m_csCalModelInforList.AddLast(csModelInfo);

            // １次元配列縦断データ入力計算結果モニターグラフ出力要素:McReverbedGraphScreenOut
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_SCREEN,
                    McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED,
                    McModelLibraryDefine.MODEL_NAME_SCREEN_OUT_REVERBED);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_SCREEN_OUT_REVERBED); //"演算中に演算結果を縦断データグラフ画面でモニターするためのモデル"
            csModelInfo.SetVersionInf("Ver.1.0");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("GraphMonitor");
            csModelInfo.SetAttachedScreenKind(true);         // 付属画面有り設定
            m_csCalModelInforList.AddLast(csModelInfo);

            // ===========================
            // 伝送データについて
            // ===========================

            // １次元定常情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_CONST_FORM,
                McTranInfoDefine.D1_CELL,
                McTranInfoDefine.NAME_D1_CELL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D1_CELL); //"定常データ：多変数の１次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ２次元定常情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_CONST_FORM,
                McTranInfoDefine.D2_CELL,
                McTranInfoDefine.NAME_D2_CELL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D2_CELL); //"定常データ：多変数の２次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ３次元定常情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_CONST_FORM,
                McTranInfoDefine.D3_CELL,
                McTranInfoDefine.NAME_D3_CELL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D3_CELL); //"定常データ：多変数の３次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // １セルのみ時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_SERIAL_FORM,
                McTranInfoDefine.SINGLE_CELL_SERIAL,
                McTranInfoDefine.NAME_SINGLE_CELL_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_SINGLE_CELL_SERIAL);  //"時系列データ：多変数の０次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // １次元時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_SERIAL_FORM,
                McTranInfoDefine.D1_CELL_SERIAL,
                McTranInfoDefine.NAME_D1_CELL_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D1_CELL_SERIAL);  //"時系列データ：多変数の１次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ２次元時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_SERIAL_FORM,
                McTranInfoDefine.D2_CELL_SERIAL,
                McTranInfoDefine.NAME_D2_CELL_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D2_CELL_SERIAL);  //"時系列データ：多変数の２次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ３次元時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_STD_SERIAL_FORM,
                McTranInfoDefine.D3_CELL_SERIAL,
                McTranInfoDefine.NAME_D3_CELL_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D3_CELL_SERIAL);  //"時系列データ：多変数の３次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ＧＩＳ１次元情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_GIS_FORM,
                McTranInfoDefine.D1_GIS,
                McTranInfoDefine.NAME_D1_GIS);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D1_GIS);  //"定常データ：1次元ＧＩＳ情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            // 将来拡張用
            //m_csCalModelInforList.AddLast(csModelInfo);

            // ＧＩＳ２次元メッシュ定常情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_GIS_FORM,
                McTranInfoDefine.D2_GIS_MESH,
                McTranInfoDefine.NAME_D2_GIS_MESH);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D2_GIS_MESH); //"定常データ：ＧＩＳ２次元メッシュ情報（１メッシュ内は多変数）"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ＧＩＳ３次元メッシュ定常情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_GIS_FORM,
                McTranInfoDefine.D3_GIS_MESH,
                McTranInfoDefine.NAME_D3_GIS_MESH);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D3_GIS_MESH); //"定常データ：ＧＩＳ３次元メッシュ情報（１メッシュ内は多変数）"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ＧＩＳ１次元時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_GIS_FORM,
                McTranInfoDefine.D1_GIS_SERIAL,
                McTranInfoDefine.NAME_D1_GIS_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D1_GIS_SERIAL);   //"時系列データ：1次元ＧＩＳ情報"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            // 将来拡張用
            //m_csCalModelInforList.AddLast(csModelInfo);

            // ＧＩＳ２次元メッシュ時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_GIS_FORM,
                McTranInfoDefine.D2_GIS_MESH_SERIAL,
                McTranInfoDefine.NAME_D2_GIS_MESH_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D2_GIS_MESH_SERIAL);  //"時系列データ：ＧＩＳ２次元メッシュ情報（１メッシュ内は多変数）"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // ＧＩＳ３次元メッシュ時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_GIS_FORM,
                McTranInfoDefine.D3_GIS_MESH_SERIAL,
                McTranInfoDefine.NAME_D3_GIS_MESH_SERIAL);
            csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_D3_GIS_MESH_SERIAL);  //"時系列データ：ＧＩＳ３次元メッシュ情報（１メッシュ内は多変数）"
            csModelInfo.SetVersionInf("Ver.1.0 ");
            csModelInfo.SetCreatorInf("CommonMP");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            /*
            // 相互通信時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_MUTUAL_FORM,
                McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL,
                McTranInfoDefine.NAME_SINGLE_MUTUAL_SERIAL);
            csModelInfo.SetSummaryInf("相互通信データ");  //"時系列データ：相互多変数の1次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.20 ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);
            */
            // 相互通信時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_MUTUAL_FORM,
                McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL,
                McTranInfoDefine.NAME_D1_MUTUAL_SERIAL);
            csModelInfo.SetSummaryInf("相互通信データ");  //"時系列データ：相互多変数の1次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.20 ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);
            /*
            // 相互通信時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_MUTUAL_FORM,
                McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL,
                McTranInfoDefine.NAME_D2_MUTUAL_SERIAL);
            csModelInfo.SetSummaryInf("相互通信データ");  //"時系列データ：相互多変数の2次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.20 ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);

            // 相互通信時系列情報 要素間伝送データ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_TRAN_MUTUAL_FORM,
                McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL,
                McTranInfoDefine.NAME_D3_MUTUAL_SERIAL);
            csModelInfo.SetSummaryInf("相互通信データ");  //"時系列データ：相互多変数の3次元配列情報"
            csModelInfo.SetVersionInf("Ver.1.20 ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName("DefaultCnnct");
            m_csCalModelInforList.AddLast(csModelInfo);
            */
            // ---------------------------------
            // プロトタイプリリース              
            // ---------------------------------

            // 汎用時系列データ:McMultiSerialTranInfo
            csModelInfo = new McModelInfo(
                        (HySID)this.GetFactoryID(),
                        new HySObjectKind("TRAN_PROTO_FORM"),
                        McTranInfoDefine.TRNINF_MULTI_SERIAL_PROTOTYPE,
                        McTranInfoDefine.TRNINF_NAME_MULTI_SERIAL_PROTOTYPE);
                csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_TRNINF_MULTI_SERIAL_PROTOTYPE);   //"ポイント時系列伝送データ　（プロトタイプ版互換の為）使用を奨励せず"
                csModelInfo.SetVersionInf("Ver.0.1 " + Properties.HymcoImplResources.MODEL_PROTOTYPE_VERSION);  //"Ver.0.1 プロトタイプ版"
                csModelInfo.SetCreatorInf("CommonMP");
                csModelInfo.SetIconName("DefaultCnnct");
                csModelInfo.SetLibraryDispMode(false);
                m_csCalModelInforList.AddLast(csModelInfo);

                // 汎用時系列データ:McTimeSeriesD1CellArrayTranInfo
                csModelInfo = new McModelInfo(
                        (HySID)this.GetFactoryID(),
                        new HySObjectKind("TRAN_PROTO_FORM"),
                        McTranInfoDefine.TRNINF_1DIM_SERIAL_PROTOTYPE,
                        McTranInfoDefine.TRNINF_NAME_1DIM_SERIAL_PROTOTYPE);
                csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_TRNINF_1DIM_SERIAL_PROTOTYPE);    //"double型 １次元配列データを時系列化　（プロトタイプ版互換の為）使用を奨励せず"
                csModelInfo.SetVersionInf("Ver.0.1 " + Properties.HymcoImplResources.MODEL_PROTOTYPE_VERSION);  //"Ver.0.1 プロトタイプ版"
                csModelInfo.SetCreatorInf("CommonMP");
                csModelInfo.SetIconName("DefaultCnnct");
                csModelInfo.SetLibraryDispMode(false);
                m_csCalModelInforList.AddLast(csModelInfo);

                // 汎用時系列データ:McTimeSeriesD2CellArrayTranInfo
                csModelInfo = new McModelInfo(
                        (HySID)this.GetFactoryID(),
                        new HySObjectKind("TRAN_PROTO_FORM"),
                        McTranInfoDefine.TRNINF_2DIM_SERIAL_PROTOTYPE,
                        McTranInfoDefine.TRNINF_NAME_2DIM_SERIAL_PROTOTYPE);
                csModelInfo.SetSummaryInf(Properties.HymcoImplResources.MODEL_SUMMARY_TRNINF_2DIM_SERIAL_PROTOTYPE);    //"double型 ２次元配列データを時系列化　（プロトタイプ版互換の為）使用を奨励せず"
                csModelInfo.SetVersionInf("Ver.0.1 " + Properties.HymcoImplResources.MODEL_PROTOTYPE_VERSION);  //"Ver.0.1 プロトタイプ版"
                csModelInfo.SetCreatorInf("CommonMP");
                csModelInfo.SetIconName("DefaultCnnct");
                csModelInfo.SetLibraryDispMode(false);
                m_csCalModelInforList.AddLast(csModelInfo);

            return m_csCalModelInforList;
        }
        //
        // ================= モデルデータ半自動作成ツール用メソッド ============================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelNetworkGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラス情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelNetworkGeneratorList()
        {
            // 親クラス側では何もしない事
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelNetworkGenerator csMdlNetworkGen = CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelNetworkGenerator 演算要素モデルネットワーク生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelNetworkGenerator CreateModelNetworkGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // 親クラス側では何もしない事
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelParameterGenerator CreateModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // 親クラス側では何もしない事
            return null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とするデータのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind)
        {
            // Do Nothing
            return null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とする必須のデータを提供するか？</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsEssentialModelGenerationData( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:必須、=false:モデルによっては不要</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>親クラスは必ずfalse</para>
        /// </remarks>
        public virtual bool IsEssentialModelGenerationData()
        {
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>データマージモデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDataMergePropertyInfo csPropertyInf = CreateMergeModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDataMergePropertyInfo CreateMergeModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            // データマージモデル
            McDataMergePropertyInfo csRtnCellPrptyDt = new McDataMergePropertyInfo(csLibraryID, csModelKind);
            csRtnCellPrptyDt.SetStepTime((double)60); // δT設定 60秒

            // 送信パターンの設定
            {
                // 送信パターンその０
                McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_SINGLE_CELL_SERIAL,
                            McTranInfoDefine.SINGLE_CELL_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_SINGLE_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその１
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_D1_CELL_SERIAL,
                            McTranInfoDefine.D1_CELL_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_D1_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその２
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_D2_CELL_SERIAL,
                            McTranInfoDefine.D2_CELL_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_D2_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその３
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_D3_CELL_SERIAL,
                            McTranInfoDefine.D3_CELL_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_D3_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその４－１
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_GEOD1_CELL_SERIAL,
                            McTranInfoDefine.D1_GIS_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_GEOD1_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその４
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_GEOD2_CELL_SERIAL,
                            McTranInfoDefine.D2_GIS_MESH_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_GEOD2_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその５
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_GEOD3_CELL_SERIAL,
                            McTranInfoDefine.D3_GIS_MESH_SERIAL,
                            McDataMergePropertyInfo.OUT_NAME_GEOD3_CELL_SERIAL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 非時系列
                // 送信パターンその６
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_D1_CELL,
                            McTranInfoDefine.D1_CELL,
                            McDataMergePropertyInfo.OUT_NAME_D1_CELL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその７
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_D2_CELL,
                            McTranInfoDefine.D2_CELL,
                            McDataMergePropertyInfo.OUT_NAME_D2_CELL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその８
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_D3_CELL,
                            McTranInfoDefine.D3_CELL,
                            McDataMergePropertyInfo.OUT_NAME_D3_CELL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその９－１
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_GEOD1_CELL,
                            McTranInfoDefine.D1_GIS,
                            McDataMergePropertyInfo.OUT_NAME_GEOD1_CELL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその９
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_GEOD2_CELL,
                            McTranInfoDefine.D2_GIS_MESH,
                            McDataMergePropertyInfo.OUT_NAME_GEOD2_CELL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                // 送信パターンその１０
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                            McDataMergePropertyInfo.OUT_PTN_GEOD3_CELL,
                            McTranInfoDefine.D3_GIS_MESH,
                            McDataMergePropertyInfo.OUT_NAME_GEOD3_CELL) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(0); // セル内の情報は最初ゼロ
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);

                }
                csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            }
            return csRtnCellPrptyDt;
        }
        //
    }
}
