﻿// <summary>ソースコード：>ＨＹＭＣＯ演算ログメッセージクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYMCO.CoreImpl.Tool
{
    /// <summary><para>class outline:</para>
    /// <para>演算ログメッセージクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/21][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McLogMessageData : HySDataRoot, HySVersionManagement
    {
        /// <summary>クラス名称</summary>
        private HySString m_csClassName;
        /// <summary>メッセージ</summary>
        private HySString m_csMessage;
        /// <summary>スレッドＩＤ</summary>
        private HySString m_csThreaID;

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~McLogMessageData()
        {
            m_csClassName = null;
            m_csMessage = null;
            m_csThreaID = null;
            m_sDecodedVersion = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLogMessageData csLogMessageData = new McLogMessageData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McLogMessageData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLogMessageData()
        {
            m_csClassName = null;
            m_csMessage = null;
            m_csThreaID = null;
        }
               
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLogMessageData csLogMessageData = new McLogMessageData(csClassName, csMessage)</para>
        /// </example>
        /// <param name="csClassName">クラス名</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>McLogMessageData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLogMessageData(HySString csClassName, HySString csMessage)
        {
            m_csClassName = csClassName;
            m_csMessage = csMessage;
            m_csThreaID = new HySString(System.Threading.Thread.CurrentThread.ManagedThreadId.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>クラス名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csClassName = GetClassName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString　クラス名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetClassName()
        {
            return m_csClassName;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csMessage = GetMessage() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString　メッセージ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetMessage()
        {
            return m_csMessage;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csMessageID = GetMessageID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString　メッセージＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetMessageID()
        {
            return m_csThreaID;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        //
    }
}
