﻿// <summary>ソースコード：>ＨＹＭＣＯログクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.Interface.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Controller;

namespace CommonMP.HYMCO.CoreImpl.Tool
{
    /// <summary><para>class outline:</para>
    /// <para>モデルライブラリ情報管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.5.0][2014/11/01][新規作成]</para>
    /// </remarks>
    static public class McMdlLibInfoMng
    {
        /// <summary>DLL情報リスト</summary>
        static List<McModelDLLInfo> m_csModelDLLList = new List<McModelDLLInfo>();

        /// <summary>モデルファクトリセット</summary>
        static McModelFactorySet m_csModelFactorySet = null;

        //// <summary>ファクトリクラスリスト</summary>
        //static List<McModelFactory> m_csFactoryList = new List<McModelFactory>();

        // static McStructInfo m_csStructInfo = null;

        /// <summary><para>method outline:</para>
        /// <para>モデルファクトリクラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelFactorySet(csModelFactorySet)</para>
        /// </example>
        /// <param name="csModelFactorySet">モデルファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static public void SetModelFactorySet(McModelFactorySet csModelFactorySet)
        {
            m_csModelFactorySet = csModelFactorySet;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルファクトリクラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddModelDLLInfo(DLLName, csFactory)</para>
        /// </example>
        /// <param name="DLLName">DLL名称</param>
        /// <param name="csFactory">演算モデルファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static public void AddModelDLLInfo(String DLLName, HySFactory csFactory)
        {
            McModelDLLInfo csDLLInfo = new McModelDLLInfo();
            csDLLInfo.m_sDLLName = DLLName;
            csDLLInfo.m_sFactoryID = csFactory.GetFactoryID().ToString();
            csDLLInfo.m_sFactoryName = csFactory.ToString();
            // 名前空間は、Factory名称（"xxx.yyy.zzz.aaFactoryname")の最後からたどって最初に見つかった"." までを取り外した残り文字列を代入する。
            int index = csDLLInfo.m_sFactoryName.LastIndexOf('.');
            if (index != -1)
            {
                csDLLInfo.m_sNameSpace = csDLLInfo.m_sFactoryName.Substring(0, index);
            }
            else
            {
                csDLLInfo.m_sNameSpace = csDLLInfo.m_sFactoryName;
            }

            m_csModelDLLList.Add(csDLLInfo);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト内モデル一覧を作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateProjectModelList(csStructInf)</para>
        /// </example>
        /// <param name="csStructInf">モデル構造クラス</param>
        /// <returns>モデル一覧リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static public List<McProjectModelInfo> CreateProjectModelList(McStructInfo csStructInf)
        {
            List<McProjectModelInfo> csMdlList = new List<McProjectModelInfo>();

            // ワーク用ハッシュテーブル  ===>>>> 変更　McProjectModelInfoをハッシュで管理するように変更　　McCounterは無くす
            Hashtable csHashTbl = new Hashtable();

            // ハッシュテーブル内に使用されている要素モデルIDの一覧を生成する
            McMdlLibInfoMng.CountElement(ref csHashTbl, csStructInf);

            // ハッシュから要素モデルID一覧取得
            HySDataLinkedList csElmList = McMdlLibInfoMng.GetKeyList(csHashTbl);
            
            // いよいよ、モデルリストを作成する
            long lElmNum = csElmList.GetCount();
            for (long iLp = 0; iLp < lElmNum; iLp++)
            {
                // ①モデル種別を取得
                HySString sElmKind = (HySString)csElmList.GetData(iLp);

                // ②プロジェクト内で使用されているモデル情報を取得
                McProjectModelInfo csPrjMdlInf = null;
                csPrjMdlInf = (McProjectModelInfo)csHashTbl[sElmKind.ToString()];
                csMdlList.Add(csPrjMdlInf);  // リストに追加

                csPrjMdlInf.m_csModelKind = new HySObjectKind(sElmKind);  // モデル種別の設定

                // ③モデルを生成するDLL情報を取得
                McCalModel csCalModel=null;
                McModelFactoryBase csMdlFactory = null;
                long iFctryNum = m_csModelFactorySet.GetFactoryNum();
                for (long llp = 0; llp < iFctryNum; llp++)
                {
                    csMdlFactory = m_csModelFactorySet.GetFactory(llp) as McModelFactoryBase;
                    if (csMdlFactory != null)
                    {
                        try
                        {
                            csCalModel = csMdlFactory.CreateCalModel(csPrjMdlInf.m_csModelKind);
                        }
                        catch 
                        {
                            continue;
                        }

                        if (csCalModel != null)
                        {
                            break;
                        }
                    }
                }

                if (csCalModel != null)
                {   // ファクトリからモデルが取得できたならば
                    string sFactoryID = csMdlFactory.GetFactoryID().ToString();
                    McModelDLLInfo csDLLInf = McMdlLibInfoMng.GetModelDLLInfo(sFactoryID);
                    if (csDLLInf != null)
                    {
                        csPrjMdlInf.m_sDLLName = csDLLInf.m_sDLLName;
                        csPrjMdlInf.m_sFactoryID = csDLLInf.m_sFactoryID;
                        csPrjMdlInf.m_sNameSpace = csDLLInf.m_sNameSpace;
                    }

                    // ④ 要素モデルが必要とするファイルを取得する
                    McMdlLibInfoMng.SetUsedFileInfo(ref csPrjMdlInf, csMdlFactory, csStructInf);
                }
                else
                {
                    // モデルを生成するDLLが存在していない
                  //csPrjMdlInf.m_sDLLName = "本モデルを含むDLLが存在しません";
                    csPrjMdlInf.m_sDLLName = Properties.McMsgResources.MC_MSG_INFO_DLL_NAME;
                    csPrjMdlInf.m_sFactoryID = csPrjMdlInf.m_csMdlInf.GetLibraryID().ToString() + " ?";
                    // 名前空間は、csPrjMdlInf.m_csMdlInf.GetLibraryID().ToString() を最後から辿って、最初の"." までを削除する。
                    // 残った文字列　＋　" ?" を csPrjMdlInf.m_sNameSpace
                    int index = csPrjMdlInf.m_sFactoryID.LastIndexOf('.');
                    if (index != -1)
                    {
                        csPrjMdlInf.m_sNameSpace = csPrjMdlInf.m_sFactoryID.Substring(0, index) + " ?";
                    }
                    else
                    {
                        csPrjMdlInf.m_sNameSpace = csPrjMdlInf.m_sFactoryID;
                    }
                }

            }

            return csMdlList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル種別毎に、ハッシュテーブルに情報を追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CountElement(ref csHashTbl,  csElment) </para>
        /// </example>
        /// <param name="csHashTbl">ハッシュテーブル</param>
        /// <param name="csElment">プロジェクト情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static void CountElement(ref Hashtable csHashTbl, McStructElement csElment)
        {
            if (csElment is McStructGroupElement)
            {   // Gr要素
                long lElmNum = ((McStructGroupElement)csElment).GetElmCount();
                for (long iLp = 0; iLp < lElmNum; iLp++)
                {
                    McStructElement csInnerElment = ((McStructGroupElement)csElment).GetElement(iLp);
                    McMdlLibInfoMng.CountElement(ref csHashTbl, csInnerElment);
                }
            }
            else
            {  // 個別要素
               McModelInfo MdlInf = csElment.GetModelInfo();  // モデル情報取得
                string csElmMdlKind = MdlInf.GetModelKind().ToString();  // ハッシュテーブル用キー作成
                McProjectModelInfo csModelInfoInProject = (McProjectModelInfo)csHashTbl[csElmMdlKind];  // すでにハッシュテーブルに登録されているか？
                if (csModelInfoInProject == null)
                {   // 登録されていない
                    McProjectModelInfo csNewMdlInfo = new McProjectModelInfo();
                    csNewMdlInfo.m_lUsedNumber = 1;  // 最初の１個目

                    csNewMdlInfo.m_csMdlInf = MdlInf;
                    csNewMdlInfo.m_csModelKind = MdlInf.GetModelKind();  // モデル種別設定
                    csNewMdlInfo.m_sModelName = MdlInf.GetModelName().ToString();  // モデル名設定
                    if (MdlInf.GetCreatorInf() != "")
                    {
                        csNewMdlInfo.m_csCreator = MdlInf.GetCreatorInf().ToString();
                    }
                    if (MdlInf.GetSummaryInf() != "")
                    {
                        csNewMdlInfo.m_csSummary = MdlInf.GetSummaryInf().ToString();
                    }

                    // その他必要な情報は、csNewMdlInfo.m_csMdlInf から取得する。

                    csHashTbl[csElmMdlKind] = csNewMdlInfo; // ハッシュテーブルへ格納
                }
                else
                {  // 登録されている
                    csModelInfoInProject.m_lUsedNumber += 1;  // 使用数をカウントアップ
                }
            }
            return ;
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュ内に登録されているモデル一覧を生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  HySDataLinkedList csList = GetKeyList(csHashTbl) </para>
        /// </example>
        /// <param name="csHashTbl">ハッシュテーブル</param>
        /// <returns>HySDataLinkedList　モデル種別一覧</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static HySDataLinkedList GetKeyList(Hashtable csHashTbl)
        {
            HySDataLinkedList csKeyList = new HySDataLinkedList();
            foreach (string csName in csHashTbl.Keys)
            {  // ハッシュテーブル件数繰り返す
                csKeyList.AddLast(new HySString(csName));
            }
            return csKeyList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルDLL情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetModelDLLInfo(sFactoryID)</para>
        /// </example>
        /// <param name="sFactoryID">識別子</param>
        /// <returns>モデルDLL情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static McModelDLLInfo GetModelDLLInfo(string sFactoryID)
        {
            McModelDLLInfo csRtnDLLInfo = null;
            long lDLLCnt = McMdlLibInfoMng.m_csModelDLLList.Count;
            for (int lLp = 0; lLp < lDLLCnt; lLp++)
            {
                McModelDLLInfo csDllInf = McMdlLibInfoMng.m_csModelDLLList[lLp] as McModelDLLInfo;
                if ( sFactoryID.CompareTo(csDllInf.m_sFactoryID) == 0 )
                {   // 同じIDならば
                    csRtnDLLInfo = csDllInf;
                    break;
                }
            }

            return csRtnDLLInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルが必要とするファイルを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUsedFileInfo(csMdlFactory, csMdlFactory, csElment)</para>
        /// </example>
        /// <param name="csPrjMdlInf">モデル一覧リスト情報</param>
        /// <param name="csMdlFactory">モデルファクトリクラス</param>
        /// <param name="csElment">プロジェクト情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static void SetUsedFileInfo(
            ref McProjectModelInfo csPrjMdlInf,
            McModelFactoryBase csMdlFactory,
            McStructElement csElment)
        {
            McStructErrorInfo csErrorInfoImpl = new McStructErrorInfoImpl();

            if (csElment is McStructGroupElement)
            {   // Gr要素
                long lElmNum = ((McStructGroupElement)csElment).GetElmCount();
                for (long iLp = 0; iLp < lElmNum; iLp++)
                {
                    McStructElement csInnerElment = ((McStructGroupElement)csElment).GetElement(iLp);
                    McMdlLibInfoMng.SetUsedFileInfo(ref csPrjMdlInf, csMdlFactory, csInnerElment);
                }
            }
            else
            {  // 個別要素
                if (csElment.GetModelInfo().GetModelKind() == csPrjMdlInf.m_csModelKind)
                {
                    McBasicFileInCtl csFileInModel = csMdlFactory.CreateCalModel(csElment.GetModelInfo().GetModelKind()) as McBasicFileInCtl;
                    if (csFileInModel != null)
                    {   // ファイル読み込み要素ならば

                        // PT-005 入力要素モデルが使用するファイルの取得不具合修正
                      //McCmnElement csNewElement = (McCmnElement)(m_csModelFactorySet.CreateElement(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.ELEMENT_CALC, csPrjMdlInf.m_csMdlInf.GetElementID()));
                        McCmnElement csNewElement = (McCmnElement)(m_csModelFactorySet.CreateElement(McModelLibraryDefine.SYSTEM_MODEL_FACTORY, McModelLibraryDefine.ELEMENT_CALC, csElment.GetModelInfo().GetElementID()));

                        csNewElement.SetCalModel(csFileInModel);

                        // PT-005 入力要素モデルが使用するファイルの取得不具合修正
                      //McCalInfo csCalInfo = csMdlFactory.CreateCalInfo(csPrjMdlInf.m_csModelKind);
                        McCalInfo csCalInfo = csMdlFactory.CreateCalInfo(csElment.GetModelInfo().GetModelKind());

                        csFileInModel.SetCalInfo(csCalInfo);

                        // PT-005 入力要素モデルが使用するファイルの取得不具合修正
                      //csFileInModel.SetProperty(csPrjMdlInf.m_csMdlInf.GetPropertyInfo(), ref csErrorInfoImpl);  // ﾌﾟﾛﾊﾟﾃｨをセット
                        csFileInModel.SetProperty(csElment.GetModelInfo().GetPropertyInfo(), ref csErrorInfoImpl);  // ﾌﾟﾛﾊﾟﾃｨをセット

                        List<string> csFileList = csFileInModel.GetReadFiles();  // ファイルが読んでいるファイル情報取得
                        if (csFileList != null)
                        {   // モデルが読み込んでいるファイル情報があるならば
                            for (int ilp = 0; ilp < csFileList.Count; ilp++)
                            {
                                csPrjMdlInf.m_csReadFileList.Add(csFileList[ilp]);  // 必要なファイルをリストに追加
                            }
                        }
                    }  // end of if( csFileInModel != null) 
                } // end of if csElment.GetModelInfo().GetModelKind() == csPrjMdlInf.m_csModelKind)
            }
            return;
        }  // end of method SetUsedFileInfo()

    }  // end of class McMdlLibInfoMng

    /// <summary><para>class outline:</para>
    /// <para>モデルDLL情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.5.0][2014/11/01][新規作成]</para>
    /// </remarks>
    public class McModelDLLInfo : HySDataRoot, HySVersionManagement 
    {
        // 内蔵モデル名

        /// <summary>DLL名称</summary>
        public string m_sDLLName=null;

        /// <summary>名前空間</summary>
        public string m_sNameSpace = null;

        /// <summary>ファクトリ識別子</summary>
        public string m_sFactoryID = null;

        /// <summary>ファクトリ名称</summary>
        public string m_sFactoryName = null;

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>保存バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            // ﾒﾝﾊﾞｰ：McPropertyInfo内のシリアライズ対象外のインスタンスを設定する
            //if (m_csModelInfo != null)
            //{
            //    McPropertyInfo csMdlPrpty = m_csModelInfo.GetPropertyInfo() as McPropertyInfo;
            //    if (csMdlPrpty != null)
            //    {
            //        csMdlPrpty.SetStructElement(this);
            //    }
            //}

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();//復元後の整合性確保処理
        }
    }

    /// <summary><para>class outline:</para>
    /// <para>モデル一覧リスト情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.5.0][2014/11/01][新規作成]</para>
    /// </remarks>
    public class McProjectModelInfo : HySDataRoot, HySVersionManagement
    {
        /// <summary>モデル/伝送データの種別（必須）</summary>
        public HySObjectKind m_csModelKind = null;
        /// <summary>モデル名</summary>
        public string  m_sModelName;
        /// <summary>モデル区分：演算、入力、出力</summary> 
        public string m_sModelKind;
        /// <summary>名前空間名</summary>
        public string m_sNameSpace;
        /// <summary>ファクトリ識別子名</summary>
        public string m_sFactoryID;
        /// <summary>DLL名</summary>
        public string m_sDLLName;
        /// <summary>ﾌﾟﾛｼﾞｪｸﾄ内の使用個数</summary>
        public long m_lUsedNumber=1;
        /// <summary>使用ファイル名リスト</summary>
        public List<string> m_csReadFileList = new List<string>();


         /// <summary>モデル情報クラス</summary>
        public McModelInfo m_csMdlInf = null;

        // ↓ここから：　McModelInfo m_csMdlInf内に入っている情報
        /// <summary>モデル作成者</summary>
        public string m_csCreator = null;
        /// <summary>概要説明</summary>
        public string m_csSummary = null;
        // ↑　ここまで：　McModelInfo m_csMdlInf内に入っている情報

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>保存バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            // ﾒﾝﾊﾞｰ：McPropertyInfo内のシリアライズ対象外のインスタンスを設定する
            //if (m_csModelInfo != null)
            //{
            //    McPropertyInfo csMdlPrpty = m_csModelInfo.GetPropertyInfo() as McPropertyInfo;
            //    if (csMdlPrpty != null)
            //    {
            //        csMdlPrpty.SetStructElement(this);
            //    }
            //}

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();//復元後の整合性確保処理
        }
    }
}
