﻿// <summary>ソースコード：>ＨＹＭＣＯモデル演算ログクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;

namespace CommonMP.HYMCO.CoreImpl.Tool
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>演算ログデータクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McModelLogData : HySDataRoot, HySVersionManagement
    {
        /// <summary>演算ログデータリスト</summary>
        protected HySDataLinkedList m_csDataList;
        /// <summary>デバッグログデータ数の最大値</summary>
        protected long m_lLogCountMax;

        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelLogData csModelLogData = new McModelLogData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelLogData  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelLogData()
        {
            m_csDataList = new HySDataLinkedList();
            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>ログデータ取得数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void Init()
        {
            m_lLogCountMax = McDefine.HYM_DEBUGLOG_DISP_MAX;
            HySString csString = HySEnvInf.GetEnvInf(new HySString("HYMCO_DEBUGLOG_DISP_NUMBER"));
            if ((object)csString != null)
            {
                m_lLogCountMax = Convert.ToInt32(csString.ToString());
            }
            if (m_lLogCountMax > McDefine.HYM_DEBUGLOG_DISP_MAX)
            {
                m_lLogCountMax = McDefine.HYM_DEBUGLOG_DISP_MAX;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ログデータリストに追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddLogInfo(csMsgData) </para>
        /// </example>
        /// <param name="csMsgData">ログデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddLogInfo(McLogMessageData csMsgData)
        {
            if (m_csDataList.GetCount() >= m_lLogCountMax)
            {   // デバッグログデータ数が指定最大値異常になったら先頭を削除
                m_csDataList.RemoveFirstData();
            }
            // ログデータを最後に追加
            m_csDataList.AddLast(csMsgData);
        }

        /// <summary><para>method outline:</para>
        /// <para>ログデータリストの削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearLogDataList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearLogDataList()
        {
            try
            {
                m_csDataList.Clear();
                this.Init();
            }
            catch
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ログデータリストの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csLogDataList = GetLogDataList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList　ログデータリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetLogDataList()
        {
            return m_csDataList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ログデータリストの要素数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = GetLogDataListCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long　要素数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetLogDataListCount()
        {
            return m_csDataList.GetCount();
        }

        /// <summary><para>method outline:</para>
        /// <para>指定ログデータの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csLogData = GetLogData(lCount) </para>
        /// </example>
        /// <param name="lCount">指定番号</param>
        /// <returns>HySString　メッセージ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetLogData(long lCount)
        {
            McLogMessageData msg = (McLogMessageData)m_csDataList.GetData(lCount);
            if (msg != null)
            {
                return msg.GetMessage();
            }
            else
            {
                return new HySString((DateTime.Now).ToString() + "   ---- No Message ----");
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelLogData csModelLogData = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelLogData　 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelLogData Clone()
        {
            McModelLogData csRtn = new McModelLogData();
            csRtn.m_csDataList = m_csDataList;
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.0":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
