﻿// <summary>ソースコード：ＨＹＭＣＯプロパティスクリーンファクトリ集合体基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO用 スクリーンファクトリ集合体基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McPropertyScreenFactorySet : HySFactorySet, HySScreenFactory //McScreenFactoryBase
    {
        /// <summary> 業務種別識別子  </summary>
        protected HySKind m_csSimKind = McDefine.SIMULATOR_KIND;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyScreenFactorySet csFctry = new McPropertyScreenFactorySet()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyScreenFactorySet()
        {
            m_csDataID = (HySID)McDefine.FACTORY_ID_PROPERTY_SCREEN_SET;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            //m_csSimKind = csSimKindID;
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKind.Equals(csSimKindID);
        }


        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csElmID,csModelKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csElmID">モデル要素識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>プロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csElmID, HySKind csModelKind)
        {
            HySScreen csRtnScreen = null;
            McPropertyScreenFactoryBase csPrtpyScreenFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csPrtpyScreenFactory = csFactoryNode.Value as McPropertyScreenFactoryBase;
                if (csPrtpyScreenFactory != null)
                {
                    {
                        
                            //csRtnScreen = ((McPropertyScreenFactorySet)csScreenFactory).CreateScreen(csSimulatorKind, csElmID, csModelKind);
                            csRtnScreen = csPrtpyScreenFactory.CreatePropertyScreen(csModelKind);
                            if (csRtnScreen != null)
                            {
                                csRtnScreen.SetSimKind(csSimulatorKind);    // 種別識別子設定
                                csRtnScreen.SetID(csElmID);  // データ識別子設定
                                csRtnScreen.SetScreenKind(csModelKind);
                                break;
                            }
                    }

                }
                csFactoryNode = csFactoryNode.Next;
            }
            //if (csRtnScreen == null)
            //{   // モデルプロパティ設定画面が生成できなかった場合
            //    McModelPropertyInfo csPrptyInf = m_csModelFactorySet.CreateModelPropertyInfo(
            //}
            return csRtnScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen 
        ///            = CreatePropertyScreen( csSimulatorKind, csElmID, csLibID, csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csElmID">モデル要素識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>プロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McModelPropertyScreen CreatePropertyScreen(HySKind csSimulatorKind, HySIdentifier csElmID, HySIdentifier csLibID, HySKind csModelKind)
        {
            McModelPropertyScreen csRtnScreen = null;
            McPropertyScreenFactoryBase csPrtpyScreenFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csPrtpyScreenFactory = csFactoryNode.Value as McPropertyScreenFactoryBase;
                if (csPrtpyScreenFactory != null)
                {
                    if (csLibID.Equals(csPrtpyScreenFactory.GetFactoryID()) == true)
                    {   // ファクトリーＩＤが一致ならば

                        csRtnScreen = csPrtpyScreenFactory.CreatePropertyScreen(csModelKind);
                        if (csRtnScreen != null)
                        {
                            csRtnScreen.SetSimKind(csSimulatorKind);    // 種別識別子設定
                            csRtnScreen.SetID(csElmID);  // データ識別子設定
                            csRtnScreen.SetScreenKind(csModelKind);
                            break;
                        }
                    }

                }
                csFactoryNode = csFactoryNode.Next;
            }
            //if (csRtnScreen == null)
            //{   // モデルプロパティ設定画面が生成できなかった場合
            //    McModelPropertyInfo csPrptyInf = m_csModelFactorySet.CreateModelPropertyInfo(
            //}
            return csRtnScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGeneratorScreen csMdlNetworkGen 
        ///            = CreateModelDataGeneratorScreen( csSimulatorKind, csLibID, csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelDataGeneratorScreen 個別モデル用設定スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelDataGeneratorScreen CreateModelDataGeneratorScreen(HySKind csSimulatorKind, HySIdentifier csLibID, HySKind csModelKind)
        {
            McModelDataGeneratorScreen csRtnScreen = null;
            McPropertyScreenFactoryBase csPrtpyScreenFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csPrtpyScreenFactory = csFactoryNode.Value as McPropertyScreenFactoryBase;
                if (csPrtpyScreenFactory != null)
                {
                    if (csLibID.Equals(csPrtpyScreenFactory.GetFactoryID()) == true)
                    {   // ファクトリーＩＤが一致ならば

                        csRtnScreen = csPrtpyScreenFactory.CreateModelDataGeneratorScreen(csModelKind);
                        if (csRtnScreen != null)
                        {
                            csRtnScreen.SetSimKind(csSimulatorKind);    // 種別識別子設定
                            //csRtnScreen.SetID(csElmID);  // データ識別子設定
                            csRtnScreen.SetScreenKind(csModelKind);
                            break;
                        }
                    }

                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル固有のモデルジェネレータ用必要情報選択画面スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelGeneratorDataSelectScreen csMdlGen = CreateModelDataGeneratorSelectScreen(csSimulatorKind,csLibID,csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelGeneratorDataSelectScreen モデル固有のモデルジェネレータ用必要情報選択画面スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデルジェネレータが必要とする情報を選択する画面
        /// CommonMPシステムが提供する汎用画面では、機能不足の場合本メソッドをオーバーライドして固有の画面を作成する</para>
        /// </remarks>
        public virtual McModelGeneratorDataSelectScreen CreateModelDataGeneratorSelectScreen(HySKind csSimulatorKind, HySIdentifier csLibID, HySKind csModelKind)
        {
            McModelGeneratorDataSelectScreen csRtnScreen = null;
            McPropertyScreenFactoryBase csPrtpyScreenFactory = null;

            LinkedListNode<HySFactory> csFactoryNode = m_csFactoryList.First;
            for (long lLoop = 0; lLoop < m_csFactoryList.Count; lLoop++)
            {
                csPrtpyScreenFactory = csFactoryNode.Value as McPropertyScreenFactoryBase;
                if (csPrtpyScreenFactory != null)
                {
                    if (csLibID.Equals(csPrtpyScreenFactory.GetFactoryID()) == true)
                    {   // ファクトリーＩＤが一致ならば

                        csRtnScreen = csPrtpyScreenFactory.CreateModelDataGeneratorSelectScreen(csModelKind);
                        if (csRtnScreen != null)
                        {
                            csRtnScreen.SetSimKind(csSimulatorKind);    // 種別識別子設定
                            //csRtnScreen.SetID(csElmID);  // データ識別子設定
                            csRtnScreen.SetScreenKind(csModelKind);
                            break;
                        }
                    }

                }
                csFactoryNode = csFactoryNode.Next;
            }
            return csRtnScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリーリスト取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> LinkedList csFactoryList = GetScreenFactoryList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリーリスト取得</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報をリスト形式で返却する</para>
        /// </remarks>
        internal LinkedList<HySFactory> GetScreenFactoryList()
        {
            return m_csFactoryList;
        }
    }
}
