﻿using System;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.DBA;

namespace CommonMP.HYMCO.CoreOptions.McDBA.FileDBA
{
    /// <summary><para>class outline:</para>
    /// <para>ファイルプロジェクトDBAユーティリティクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>DBA、ライブラリ管理で共通的に使用する処理を記述する。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/08][新規作成]</para>
    /// </remarks>
    public class McFileProjectDataDBAUtility
    {
        /// <summary><para>method outline:</para>
        /// <para>DB保存メタデータからプロジェクト情報オブジェクトを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <code>McProjectInfData csProjectInf = ConvertKeyInfoToProjectInfData( csStockData )</code>
        /// </example>
        /// <param name="csStockData">DB保存データ（追加検索キーを参照）</param>
        /// <returns>プロジェクト情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>DB保存データに付属する追加検索キーから必要な情報を抽出し、
        /// プロジェクト情報オブジェクトを作成する。</para>
        /// </remarks>
        public static McProjectInfData ConvertKeyInfoToProjectInfData(HySStockData csStockData)
        {
            McProjectInfData csPrjInf = new McProjectInfData();
            csPrjInf.SetProjectID(csStockData.GetID());
            long lKeyNumber = 0;
            HySDataHashTable csKeyInfo = csStockData.GetKeyInfo(ref lKeyNumber);
            if (lKeyNumber > 0)
            {
                csPrjInf.SetProjectID((HySID)csKeyInfo.GetObject(McProjectMetaKeyDefines.PROJECT_ID));
                csPrjInf.SetDispProjectName((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.DISP_PROJECT_NAME));
                csPrjInf.SetDbName((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.DB_NAME));
                csPrjInf.SetFileName((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.FILE_NAME));
                csPrjInf.SetProjectName((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.PROJECT_NAME));
                csPrjInf.SetAdminName((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.MANAGER_NAME));
                csPrjInf.SetCreateDate((HySTime)csKeyInfo.GetObject(McProjectMetaKeyDefines.CREATE_DATE));
                csPrjInf.SetRegistDate((HySTime)csKeyInfo.GetObject(McProjectMetaKeyDefines.REGISTRATION_DATE));
                csPrjInf.SetUpdateDate((HySTime)csKeyInfo.GetObject(McProjectMetaKeyDefines.UPDATE_DATE));
                csPrjInf.SetStartSimuTime((HySTime)csKeyInfo.GetObject(McProjectMetaKeyDefines.START_SIM_TIME));
                csPrjInf.SetEndSimuTime((HySTime)csKeyInfo.GetObject(McProjectMetaKeyDefines.END_SIM_TIME));
                csPrjInf.SetSuspendTime((HySTime)csKeyInfo.GetObject(McProjectMetaKeyDefines.SUSPEND_TIME));
                csPrjInf.SetComment((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.COMMENT));
                csPrjInf.SetModelType((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_TYPE));
                csPrjInf.SetModelTarget((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_TARGET));
                csPrjInf.SetModelCalcType((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_CALC_TYPE));
                csPrjInf.SetModelSubject((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_SUBJECT));
                csPrjInf.SetModelSituation((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_SITUATION));
                {
                    HySLong csModelPeriodTypeValue = (HySLong)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_PERIOD_TYPE);
                    if (csModelPeriodTypeValue != null)
                    {
                        csPrjInf.SetModelPeriodType((McProjectInfData.ModelPeriodType)csModelPeriodTypeValue.m_lValue);
                    }
                }
                csPrjInf.SetModelPeriod((McRange)csKeyInfo.GetObject(McProjectMetaKeyDefines.MODEL_PERIOD));
                csPrjInf.SetThresholdCondition1((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.THRESHOLD_CONDITION1));
                csPrjInf.SetThresholdCondition2((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.THRESHOLD_CONDITION2));
                csPrjInf.SetThresholdCondition3((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.THRESHOLD_CONDITION3));
                csPrjInf.SetThresholdCondition4((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.THRESHOLD_CONDITION4));
                csPrjInf.SetThresholdCondition5((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.THRESHOLD_CONDITION5));
                csPrjInf.SetCondition1((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.CONDITION1));
                csPrjInf.SetCondition2((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.CONDITION2));
                csPrjInf.SetCondition3((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.CONDITION3));
                csPrjInf.SetCondition4((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.CONDITION4));
                csPrjInf.SetCondition5((HySString)csKeyInfo.GetObject(McProjectMetaKeyDefines.CONDITION5));
                //csPrjInf.SetKeyOne((HySString)csKeyInfo.GetObject(McProjectQueryFieldNames.KEY_ONE));
                //csPrjInf.SetKeyTwo((HySString)csKeyInfo.GetObject(McProjectQueryFieldNames.KEY_TWO));

            }
            return csPrjInf;
        }
    }
}
