﻿using System;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.CoreImpl.DBA;

namespace CommonMP.HYMCO.CoreOptions.McDBA.FileDBA
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクトデータのメタデータキー定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/22][新規作成]</para>
    /// </remarks>
    public class McProjectMetaKeyDefines
    {
        /// <summary>
        /// シミュレーターID
        /// </summary>
        public static readonly HySString PROJECT_ID = new HySString("__PROJECT_ID__");

        /// <summary>
        /// 表示プロジェクト名
        /// </summary>
        public static readonly HySString DISP_PROJECT_NAME = new HySString("__DISP_PROJECT_NAME__");

        /// <summary>
        /// データベース名
        /// </summary>
        public static readonly HySString DB_NAME = new HySString("__DB_NAME__");

        /// <summary>
        /// ファイルパス
        /// </summary>
        public static readonly HySString FILE_NAME = new HySString("__FILE_NAME__");

        /// <summary>
        /// プロジェクト名
        /// </summary>
        public static readonly HySString PROJECT_NAME = McProjectQueryFieldNames.PROJECT_NAME;

        /// <summary>
        /// 管理者名
        /// </summary>
        public static readonly HySString MANAGER_NAME = McProjectQueryFieldNames.MANAGER_NAME;

        /// <summary>
        /// 作成日
        /// </summary>
        public static readonly HySString CREATE_DATE = new HySString("__CREATE_DATE__");

        /// <summary>
        /// 登録日
        /// </summary>
        public static readonly HySString REGISTRATION_DATE = McProjectQueryFieldNames.REGISTRATION_DATE;

        /// <summary>
        /// 更新日
        /// </summary>
        public static readonly HySString UPDATE_DATE = McProjectQueryFieldNames.UPDATE_DATE;

        /// <summary>
        /// 計算開始時間
        /// </summary>
        public static readonly HySString START_SIM_TIME = new HySString("__START_SIM_TIME__");

        /// <summary>
        /// 計算終了時間
        /// </summary>
        public static readonly HySString END_SIM_TIME = new HySString("__END_SIM_TIME__");

        /// <summary>
        /// 中断時刻
        /// </summary>
        public static readonly HySString SUSPEND_TIME = new HySString("__SUSPEND_TIME__");

        /// <summary>
        /// プロジェクトコメント
        /// </summary>
        public static readonly HySString COMMENT = new HySString("__COMMENT__");

        /// <summary>
        /// 種別
        /// </summary>
        public static readonly HySString MODEL_TYPE = McProjectQueryFieldNames.MODEL_TYPE;

        /// <summary>
        /// 対象
        /// </summary>
        public static readonly HySString MODEL_TARGET = McProjectQueryFieldNames.MODEL_TARGET;

        /// <summary>
        /// モデル
        /// </summary>
        public static readonly HySString MODEL_CALC_TYPE = McProjectQueryFieldNames.MODEL_CALC_TYPE;

        /// <summary>
        /// 件名
        /// </summary>
        public static readonly HySString MODEL_SUBJECT = McProjectQueryFieldNames.MODEL_SUBJECT;

        /// <summary>
        /// ケース名
        /// </summary>
        public static readonly HySString MODEL_SITUATION = McProjectQueryFieldNames.MODEL_SITUATION;

        /// <summary>
        /// 期間種別
        /// </summary>
        public static readonly HySString MODEL_PERIOD_TYPE = McProjectQueryFieldNames.MODEL_PERIOD_TYPE;

        /// <summary>
        /// 期間
        /// </summary>
        public static readonly HySString MODEL_PERIOD = McProjectQueryFieldNames.MODEL_PERIOD;

        /// <summary>
        /// 境界条件１
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION1 = McProjectQueryFieldNames.THRESHOLD_CONDITION1;

        /// <summary>
        /// 境界条件２
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION2 = McProjectQueryFieldNames.THRESHOLD_CONDITION2;

        /// <summary>
        /// 境界条件３
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION3 = McProjectQueryFieldNames.THRESHOLD_CONDITION3;

        /// <summary>
        /// 境界条件４
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION4 = McProjectQueryFieldNames.THRESHOLD_CONDITION4;

        /// <summary>
        /// 境界条件５
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION5 = McProjectQueryFieldNames.THRESHOLD_CONDITION5;

        /// <summary>
        /// 条件１
        /// </summary>
        public static readonly HySString CONDITION1 = McProjectQueryFieldNames.CONDITION1;

        /// <summary>
        /// 条件２
        /// </summary>
        public static readonly HySString CONDITION2 = McProjectQueryFieldNames.CONDITION2;

        /// <summary>
        /// 条件３
        /// </summary>
        public static readonly HySString CONDITION3 = McProjectQueryFieldNames.CONDITION3;

        /// <summary>
        /// 条件４
        /// </summary>
        public static readonly HySString CONDITION4 = McProjectQueryFieldNames.CONDITION4;

        /// <summary>
        /// 条件５
        /// </summary>
        public static readonly HySString CONDITION5 = McProjectQueryFieldNames.CONDITION5;

    }
}
