﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.Interface.Viewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel
{
    /// <summary><para>class outline:</para>
    /// <para>接続パターン管理用データ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    //[Serializable]
    public class McConnectPatternPairInfo
    {
        /// <summary> パターンID </summary>
        public HySID m_PatternID = new HySID("");
        /// <summary>　接続の区分 =1:相互通信(受信側)、=2:相互通信（送信側）、=-3:受信のみ、 =-4:送信のみ </summary>
        //public McSndRcvTypeKbn m_Kbn = 0;
        /// <summary> 具体的接続の対：受信側インスタンス、送信側インスタンス、次元</summary>
        public List<(McReceiveCellDataIF, McSendCellDataIF,long, McSndRcvTypeKbn) > m_RcvSndPairList = new List<(McReceiveCellDataIF, McSendCellDataIF, long, McSndRcvTypeKbn)>();
    }


    /// <summary><para>class outline:</para>
    /// <para> 受信専用＿接続パターン管理用データ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    //[Serializable]
    public class McReceiveOnlyTranInfo
    {
        /// <summary> パターンID </summary>
        public HySID m_PatternID = new HySID("");
        /// <summary> 受信側インスタンス</summary>
        public McReceiveCellDataIF m_csRcvInf = null;
        /// <summary> 受信情報の次元 </summary>
        public long m_DimNum = 1;
    }

    /// <summary><para>class outline:</para>
    /// <para>送信専用＿接続パターン管理用データ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    //[Serializable]
    public class McSendOnlyTranInfo
    {
        /// <summary> パターンID </summary>
        public HySID m_PatternID = new HySID("");
        /// <summary> 送信側インスタンス</summary>
        public McSendCellDataIF m_csSndInf = null;
        /// <summary> 送信情報の次元 </summary>
        public long m_DimNum = 1;
    }

    /// <summary><para>class outline:</para>
    /// <para>送受信＿接続パターン管理用データ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    //[Serializable]
    public class McRdvSndTranInfoPair
    {
        /// <summary>　接続の区分 =1:相互通信(受信側)、=2:相互通信（送信側）、=-3:受信のみ、 =-4:送信のみ </summary>
        public McSndRcvTypeKbn m_Kbn = 0;
        /// <summary> パターンID </summary>
        public HySID m_PatternID = new HySID("");
        /// <summary> 具体的接続の対：受信側インスタンス</summary>
        public McReceiveCellDataIF m_csRcvInf = null;
        /// <summary> 具体的接続の対：送信側インスタンス</summary>
        public McSendCellDataIF m_csSndInf = null;
        /// <summary> 送受信情報の次元（送信と受信の次元は同じ） </summary>
        public long m_DimNum = 1;
    }


    /// <summary><para>class outline:</para>
    /// <para>送受信＿接続パターン管理用データ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    //[Serializable]
    public class McPatternRdvSndTranInfoPair
    {
        /// <summary>　接続の区分 =1:相互通信(受信側)、=2:相互通信（送信側）、=-3:受信のみ、 =-4:送信のみ </summary>
        public McSndRcvTypeKbn m_Kbn = 0;
        /// <summary> パターンID </summary>
        public HySID m_PatternID = new HySID("");
        /// <summary> 送受信情報の次元（送信と受信の次元は同じ） </summary>
        public long m_DimNum = 1;

        public long m_RcvInfNum = 0;
        /// <summary> 具体的接続の対：受信側インスタンス</summary>
        public McReceiveCellDataIF[] m_csRcvInfArry = null;
        /// <summary> 送信する場合の比を計算するための変数</summary>
        public double[][] m_dRcvRatioData = null;
        /// <summary> 具体的接続の対：送信側インスタンス</summary>
        public McSendCellDataIF[] m_csSndInfArry = null;
        /// <summary> 送信する比　０－１ </summary>
        public double[][] m_dSendRatioData = null;
    }

    public enum McSndRcvTypeKbn
    {
        /// <summary> 受信 </summary>
        Rcv = 1,
        /// <summary> 送信 </summary>
        Snd = 2,
        /// <summary> 送信 </summary>
        OnlyRcv = 3,
        /// <summary> 送信 </summary>
        OnlySnd = 4

    }

    
}
