﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Windows.Forms;
using System.IO;

using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace HymcoLibDelete
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ削除処理プロセス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/08][新規作成]</para>
    /// </remarks>
    public class HymcoLibDeleteProgram
    {
        /// <summary>監視フラグ</summary>
        private bool m_bFlg = false;

        /// <summary>ライブラリ削除確認画面タイトル</summary>
        //static private readonly string LIBDELETE_DLG_TITLE = Properties.Resources.LIBDELETE_DLG_TITLE;
        static private string LIBDELETE_DLG_TITLE = McMessage.GetString("MC_MSG_TITLE_LIBDELETE_DLG");
        /// <summary>ライブラリ削除確認メッセージ「正常終了」 </summary>
        static private string MSG_INFO_COMPLETE_DELETE_LIBRARY = McMessage.GetString("MC_MSG_INFO_COMPLETE_DELETE_LIBRARY");
        /// <summary>ライブラリ削除確認メッセージ「異常終了」 </summary>
        static private string MSG_WARNING_DELETE_LIBRARY = McMessage.GetString("MC_MSG_WARNING_DELETE_LIBRARY");
        /// <summary>ライブラリ削除確認メッセージ「異常終了（例外発生）」 </summary>
        static private string MSG_ERR_DELETE_LIBRARY = McMessage.GetString("MC_MSG_ERR_DELETE_LIBRARY");

        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.1.0][2010/12/08][新規作成]</para>
        /// </remarks>
        [STAThread]
        static void Main()
        {
            try
            {
                // 地域情報をTheadにセット
                System.Threading.Thread.CurrentThread.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;

                HymcoLibDeleteProgram csLibDeleteProgram = new HymcoLibDeleteProgram();

                // 初期設定
                csLibDeleteProgram.Initialize();

                // CommonMP終了の確認
                csLibDeleteProgram.WatchCommonMPExit();
                // ライブラリ削除処理
                csLibDeleteProgram.DeleteLibrary();
                // プロセス終了
            }
            catch
            {
                // Do nothing
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Initialize()
        {
            // 地域情報の設定が有効とならない時点で設定されるため、再設定する。
            // 通常はＯＳの言語で設定されるため、本設定は必要無くても問題ない。
            LIBDELETE_DLG_TITLE = McMessage.GetString("MC_MSG_TITLE_LIBDELETE_DLG");
            MSG_INFO_COMPLETE_DELETE_LIBRARY = McMessage.GetString("MC_MSG_INFO_COMPLETE_DELETE_LIBRARY");
            MSG_WARNING_DELETE_LIBRARY = McMessage.GetString("MC_MSG_WARNING_DELETE_LIBRARY");
            MSG_ERR_DELETE_LIBRARY = McMessage.GetString("MC_MSG_ERR_DELETE_LIBRARY");
        }

        /// <summary><para>method outline:</para>
        /// <para>CommonMP終了の監視処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>WatchCommonMPExit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void WatchCommonMPExit()
        {
            for (; ; )
            {
                if (System.Diagnostics.Process.GetProcessesByName("CommonMPMain").Length == 0)	
                {
                    m_bFlg = true;
                }
                if (m_bFlg == true)
                {
                    break;
                }
                System.Threading.Thread.Sleep(300); // 300 mSec
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ削除処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DeleteLibrary()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DeleteLibrary()
        {
            bool bChkFlg = false;
            HySString csReadInfo = new HySString("");
            HySEnvInf csEnvInf = new HySEnvInf(new HySString("CommonMP.cfg"));
            List<DirectoryInfo> csDirList = new List<DirectoryInfo>();
            Hashtable csDirInfo = new Hashtable();
            try
            {
                csEnvInf.Initialize();
                // 削除情報ファイルの存在確認
                HySString csHomeDir = HySEnvInf.GetHomeDirectory();
                HySString csTargetDir = csHomeDir + "\\temp\\LibDeleteInfo.txt";
                HySFile csFile = new HySFile(csTargetDir);
                bool bRtn = csFile.Exist();
                if (bRtn == true)
                {
                    //オープン
                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)
                    {
                        // ファイルが開けない
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary",
                            Properties.Resources.STATEMENT_FILE_OPEN_NG + csTargetDir );
                       // HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary", "ファイルオープン処理失敗:" + csTargetDir);
                        MessageBox.Show(MSG_ERR_DELETE_LIBRARY, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                    else
                    { 
                        // 削除対象ファイルの参照
                        while (csFile.ReadText(ref csReadInfo) != 0)
                        {
                            long lRtn = 0;
                            HySFile csDelFile = new HySFile(csReadInfo);
                            if (csDelFile.Exist() == true)
                            {
                                // 削除対象が存在する場合のみ削除処理を実施する
                                lRtn = csDelFile.Delete();
                                // アイコンとマニュアルの場合は、上位フォルダ情報を取得しておく
                                bool IcoResult = csReadInfo.ToString().EndsWith("ico");
                                bool PdfResult = csReadInfo.ToString().EndsWith("pdf");
                                if (IcoResult == true || PdfResult == true)
                                {
                                    DirectoryInfo csInfo = Directory.GetParent(csReadInfo.ToString());
                                    // 重複取得を避ける
                                    if (csDirInfo[csInfo.ToString()] == null)
                                    {
                                        csDirList.Add(csInfo);
                                        csDirInfo.Add(csInfo.ToString(), csInfo);
                                    }
                                }
                                if (lRtn == -1)
                                {
                                    // 削除異常時の処理 メッセージorログ?
                                   // ver1.5 エラートレース日本語対応
                                    HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary",
                                        Properties.Resources.STATEMENT_DELEPROC_NG );
                                   // HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary", "削除処理失敗");
                                    csDelFile.Close();
                                    bChkFlg = true;
                                }
                            }
                            else
                            {
                                // 削除対象が存在しない場合
                               // ver1.5 エラートレース日本語対応
                                HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary", 
                                    Properties.Resources.STATEMENT_DELTARGET_NO );
                               // HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary", "削除対象が見つかりません");
                                bChkFlg = true;
                            }
                        }
                        // クローズ
                        csFile.Close();
                        // アイコンとマニュアルの場合は上位フォルダの削除実施
                        for (int iLp = 0; iLp < csDirList.Count; iLp++)
                        {
                            DirectoryInfo csDelInfo = csDirList[iLp];
                            // 上位フォルダが標準ディレクトリであればフォルダは削除しない
                            bool IconDirChk = csDelInfo.FullName.EndsWith(@"\ModelIcon");
                            bool PdfDirChk = csDelInfo.FullName.EndsWith(@"\ModelManual");
                            if (IconDirChk == true || PdfDirChk == true)
                            {
                                continue;
                            }
                            // 万が一ディレクトリが空でない場合でも削除を行う
                            csDelInfo.Delete(true);
                        }
                        // 削除情報ファイル削除
                        csFile.Delete();
                        if (bChkFlg == true)
                        {
                            // 異常メッセージ表示
                            MessageBox.Show(MSG_WARNING_DELETE_LIBRARY, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                        else
                        {
                            // 完了メッセージ表示
                            MessageBox.Show(MSG_INFO_COMPLETE_DELETE_LIBRARY, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
                        }
                    }
                }
                else
                {
                    // 存在しない場合は何もしない(通常のCommonMP終了時等)
                }
            }
            catch (Exception ex)
            {
                // ログ出力/メッセージ表示
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary", 
                    Properties.Resources.STATEMENT_LIB_DEL_EXCEP + Environment.NewLine + ex.ToString());
               // HySLog.LogOut(HySLog.ONLINE, "HymcoLibDeleteProgram", "DeleteLibrary", "ライブラリ削除処理で例外発生:" + Environment.NewLine + ex.ToString());
                MessageBox.Show(MSG_ERR_DELETE_LIBRARY, LIBDELETE_DLG_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            HySEnvInf.Terminate();
            csEnvInf = null;
        }
    }
}
