﻿// <summary>ソースコード：ＨＹＭＣＯインポートされたＤＬＬ演算モデルＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Reflection;
using System.IO;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.CoreOptionl.HymcoModelDLLWrapper
{
    /// <summary><para>class outline:</para>
    /// <para>インポートされたＤＬＬ演算モデル制御クラス（抽象クラス）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2011/04/01][新規作成]</para>
    /// </remarks>
    public abstract class McModel32BitDLLImportImpl : McModelDLLImport
    {

        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _GET_MAX_PARADT_AREA();

        //  戻り値を short で受けている　Fortran側は　Integer であるが、 long で受けると良くない
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _PRESET(IntPtr iplLongNum, IntPtr iplLongDt, IntPtr iplDoubleNum, IntPtr ipdDoubleDt);
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="ipdTime"></param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _SET_DELTA_TIME(IntPtr ipdTime);
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //  戻り値を short で受けている　Fortran側は　Integer であるが、 long で受けると良くない
        public delegate short _GET_MAX_INPUT_DIMENSION();

//        public delegate void _GET_INPUTDATA_DIM(IntPtr ipDimNum, IntPtr iplDim1, IntPtr iplDim2, IntPtr iplDim3);
//        public delegate void _GET_GEO_INPUTDATA_DIM(IntPtr ipDimNum, IntPtr iplLonDim, IntPtr iplLatDim, IntPtr iplAltDim);
//        public delegate short _GET_INPUT_DATA_KIND_NUMBER();
//        public delegate short _PUTDATA(IntPtr ipdTime, IntPtr ipDtNum, IntPtr ipdData, IntPtr iplDataKindNo0);

        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="ipDtNum"></param>
        /// <param name="ipdData"></param>
        /// <param name="ipdTime"></param>
        /// <param name="ipsValidFlg"></param>
        /// <param name="iplPtnNo"></param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _PUTDATA(IntPtr ipDtNum, IntPtr ipdData, IntPtr ipdTime, IntPtr ipsValidFlg, IntPtr iplPtnNo);
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate double _WANTTIME();
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _GET_MAX_OUTPUT_DIMENSION();

//        public delegate void _GET_OUTPUTDATA_DIM(IntPtr iplDimNum, IntPtr iplDim1, IntPtr iplDim2, IntPtr iplDim3);
//        public delegate void _GET_GEO_OUTPUTDATA_DIM(IntPtr iplDimNum, IntPtr iplLonDim, IntPtr iplLatDim, IntPtr iplAltDim);
//        public delegate short _GET_OUTPUT_DATA_KIND_NUMBER();
//        public delegate short _GETDATA(IntPtr ipdTime, IntPtr iplDtNum, IntPtr ipdData, IntPtr iplDataKindNo0);

        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="iplDtNum"></param>
        /// <param name="ipdData"></param>
        /// <param name="ipdTime"></param>
        /// <param name="iplPtnNo"></param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _GETDATA(IntPtr iplDtNum , IntPtr ipdData, IntPtr ipdTime, IntPtr iplPtnNo );
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="iplLongNum"></param>
        /// <param name="iplLongDt"></param>
        /// <param name="iplDoubleNum"></param>
        /// <param name="ipdDoubleDt"></param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _INITIALIZE(IntPtr iplLongNum, IntPtr iplLongDt, IntPtr iplDoubleNum, IntPtr ipdDoubleDt);
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _ISCONVERGED();

        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _CALCULATE();
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _GAIN_SIMULATION_TIME();
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="ipdTime"></param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _SET_TARGET_TIME(IntPtr ipdTime);

        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _READY_CALUCLATION();
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _COMPLETE_CALCULATION();
        /// <summary><para>method outline:</para>
        /// <para>(delegate宣言)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> short </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public delegate short _SUSPEND_CALCULATION();


        /// <summary> ＤＬＬモデルパラメーター受信エリアの最大配列数を取得する</summary>
        public _GET_MAX_PARADT_AREA GetMaxParaDim = null;
        /// <summary>プロパティ情報設定処理</summary>
        public _PRESET SetProperty = null;
        /// <summary>δＴを設定する </summary>
        public _SET_DELTA_TIME SetDltTime = null;

        /// <summary>初期化処理</summary>
        public _INITIALIZE Initialize = null;
        /// <summary>収束判断 </summary>
        public _ISCONVERGED IsConverged = null;
        /// <summary> ＤＬＬモデルへ設定するデータのエリアの最大配列数を取得する</summary>
        public _GET_MAX_INPUT_DIMENSION GetMaxReceiveDataDim = null;
        /// <summary> ＤＬＬモデルが欲しいデータの時刻を取得する</summary>
        public _WANTTIME WantDataTime = null;
        /// <summary>DLL側へのデータ設定</summary>
        public _PUTDATA PutFMdlData = null;
        /// <summary>計算（１ステップ） </summary>
        public _CALCULATE Calculate = null;

        /// <summary> ＤＬＬモデルから取得するデータのエリアの最大配列数を取得する</summary>
        public _GET_MAX_OUTPUT_DIMENSION GetMaxSendDataDim = null;
        /// <summary>DLL側からのデータ取得 </summary>
        public _GETDATA GetFMdlData = null;
        /// <summary>時刻を進める </summary>
        public _GAIN_SIMULATION_TIME GainSimulationTime = null;
        /// <summary>目標時刻を設定する </summary>
        public _SET_TARGET_TIME SetTrgtTime = null;

        /// <summary>計算開始時に動作する処理</summary>
        public _READY_CALUCLATION ReadyCalculation = null;
        /// <summary>計算終了時に動作する処理</summary>
        public _COMPLETE_CALCULATION CompleteCalculation = null;
        /// <summary>計算中断時に動作する処理</summary>
        public _SUSPEND_CALCULATION SuspendCalculation = null;


        /// <summary><para>method outline:</para>
        /// <para>デストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>~McModel32BitDLLImportImpl( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        ~McModel32BitDLLImportImpl()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ＤＬＬのインポート</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ImportDLL(sDLLName)</para>
        /// </example>
        /// <param name="sDLLName">ＤＬＬファイル名</param>
        /// <returns>bool =true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract bool ImportDLL(string sDLLName);

        /// <summary><para>method outline:</para>
        /// <para>準備処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = Prepare()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool =true:正常 false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必要に応じて派生クラスでオーバーライドする。 (この場合 overrideを忘れないこと)</para>
        /// </remarks>
        public abstract bool Prepare();

        /// <summary><para>method outline:</para>
        /// <para>演算目標時刻を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTargetTime(dTgtTime)</para>
        /// </example>
        /// <param name="dTgtTime">目標時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必要に応じて派生クラスでオーバーライドする。 (この場合 overrideを忘れないこと)</para>
        /// </remarks>
        public abstract void SetTargetTime(double dTgtTime);
        /// <summary><para>method outline:</para>
        /// <para>演算刻み時間を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDeltaTime(dDltTime)</para>
        /// </example>
        /// <param name="dDltTime">演算刻み時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必要に応じて派生クラスでオーバーライドする。 (この場合 overrideを忘れないこと)</para>
        /// </remarks>
        public abstract void SetDeltaTime(double dDltTime);

        
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPropertyInf(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract bool SetPropertyInf(McCellModelPropertyIF csCellMdlPropertyInfo);
        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInitialInf(csInitialData)</para>
        /// </example>
        /// <param name="csTime">初期時刻</param>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract bool SetInitialInf(HySTime csTime, ref McPropertyInfoRoot csInitialData);

        // -------------------
        // 各種ツール群
        // -------------------

        /// <summary><para>method outline:</para>
        /// <para>Delegate fnctionPtr = GetDelegateForFunctionPointer(iModuleHandle, sFunctionName, tTp)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetDelegateForFunctionPointer(iFuncHandle,sFunctionName,tTp)</para>
        /// </example>
        /// <param name="iFuncHandle">ハンドル</param>
        /// <param name="sFunctionName">関数名</param>
        /// <param name="tTp">タイプ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static Delegate GetDelegateForFunctionPointer(IntPtr iModuleHandle, string sFunctionName, Type tTp)
        {
            Delegate dRtn = null;

            if (iModuleHandle != (IntPtr)0)
            {
                IntPtr iFuncHandle = HySNativeDLLImport.GetProcAddress(iModuleHandle, @sFunctionName);
                if (iFuncHandle == (IntPtr)0)
                {
                    dRtn = Marshal.GetDelegateForFunctionPointer(iFuncHandle, tTp);
                }
            }
            return dRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域確保</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IntPtr iPtr = HmAlloc(lSizeNum,tTp) </para>
        /// </example>
        /// <param name="lSizeNum">確保するデータ数（配列数）</param>
        /// <param name="tTp">確保する情報の型式</param>
        /// <returns>IntPtr 確保したアンマネージ領域ポインター</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static IntPtr HmAlloc(long lSizeNum, Type tTp)
        {
            IntPtr ipBuff = (IntPtr)0;
            ipBuff = Marshal.AllocHGlobal((int)lSizeNum * Marshal.SizeOf(tTp));
            return ipBuff;
        }

        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域開放</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IntPtr iPtr = HmFree(ipArea) </para>
        /// </example>
        /// <param name="ipArea">アンマネージ領域ポインター</param>
        /// <returns>IntPtr</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static IntPtr HmFree(IntPtr ipArea)
        {
            Marshal.FreeHGlobal(ipArea);
            return (IntPtr)0;
        }

        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域へ引数を渡す（short用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(sOrgDt, iplDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="sOrgDt">渡す情報格納場所配列</param>
        /// <param name="iplDestDt">アンマネージ領域ポインター</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmPutData(short[] sOrgDt, IntPtr iplDestDt, long lSizeNum)
        {
            Marshal.Copy(sOrgDt, 0, iplDestDt, (int)lSizeNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域へ引数を渡す（long用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(lOrgDt, iplDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="lOrgDt">渡す情報格納場所配列</param>
        /// <param name="iplDestDt">アンマネージ領域ポインター</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmPutData(long[] lOrgDt, IntPtr iplDestDt, long lSizeNum)
        {
            Marshal.Copy(lOrgDt, 0, iplDestDt, (int)lSizeNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域へ引数を渡す（int用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(lOrgDt, iplDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="lOrgDt">渡す情報格納場所配列</param>
        /// <param name="iplDestDt">アンマネージ領域ポインター</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmPutData(int[] lOrgDt, IntPtr iplDestDt, long lSizeNum)
        {
            Marshal.Copy(lOrgDt, 0, iplDestDt, (int)lSizeNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域へ引数を渡す（double用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(dOrgDt, iplDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="dOrgDt">渡す情報格納場所配列</param>
        /// <param name="iplDestDt">アンマネージ領域ポインター</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmPutData(double[] dOrgDt, IntPtr ipdDestDt, long lSizeNum)
        {
            Marshal.Copy(dOrgDt, 0, ipdDestDt, (int)lSizeNum);
        }

        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域から引数を取得する（short用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(iplOrgDt, sDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="iplOrgDt">アンマネージ領域ポインター</param>
        /// <param name="sDestDt">取得する情報格納場所配列</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmGetData(IntPtr iplOrgDt, short[] sDestDt, long lSizeNum)
        {
            Marshal.Copy(iplOrgDt, sDestDt, 0, (int)lSizeNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域から引数を取得する（long用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(iplOrgDt, lDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="iplOrgDt">アンマネージ領域ポインター</param>
        /// <param name="lDestDt">取得する情報格納場所配列</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmGetData(IntPtr iplOrgDt,long[] lDestDt,  long lSizeNum)
        {
            Marshal.Copy(iplOrgDt, lDestDt, 0, (int)lSizeNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域から引数を取得する（int用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(iplOrgDt, lDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="iplOrgDt">アンマネージ領域ポインター</param>
        /// <param name="lDestDt">取得する情報格納場所配列</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmGetData(IntPtr iplOrgDt, int[] lDestDt, long lSizeNum)
        {
            Marshal.Copy(iplOrgDt, lDestDt, 0, (int)lSizeNum);
        }
        /// <summary><para>method outline:</para>
        /// <para>アンマネージ領域から引数を取得する（double用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HmPutData(ipdOrgDt, dDestDt, lSizeNum) </para>
        /// </example>
        /// <param name="iplOrgDt">アンマネージ領域ポインター</param>
        /// <param name="dDestDt">取得する情報格納場所配列</param>
        /// <param name="lSizeNum">配列数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void HmGetData(IntPtr ipdOrgDt, double[] dDestDt, long lSizeNum)
        {
            Marshal.Copy(ipdOrgDt, dDestDt, 0, (int)lSizeNum);
        }
    }
}
