﻿// <summary>ソースコード：業務処理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Threading;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.BusiProc;


namespace CommonMP.HYMCO.CoreOption.McSTGSystemBase
{
    /// <summary><para>class outline:</para>
    /// <para>ＴＧＣ関連業務基底クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public abstract class McSTGSysBusiProcedureBase : McBusiProcedure
    {

        /// <summary>TGC情報</summary>
        protected McSTGSysManageData m_csSTGMngData = null;
        /// <summary>TGC系全体の状況</summary>
        protected McSTGSysCtlInfo m_csSTGStatus = new McSTGSysCtlInfo();

        /// <summary>タイマーテーブル</summary>
        protected HySDataHashTable m_csTimerTable = new HySDataHashTable();
        /// <summary>起動開始時の時刻</summary>
        protected HySTime m_csNowTime = HySCalendar.CreateNowTime();
        /// <summary>TGC計算開始/終了等制御用フラグ</summary>
        protected long m_csCmndSTGStartFlg = McSTGSysCtlInfo.DEFAULT_STATE;

        /// <summary>モデル編集中の動作管理 </summary>
        protected HySDataHashTable m_csMdlEditWorkMng = new HySDataHashTable();

        /// <summary>ファイルパス管理テーブル</summary>
        protected HySDataHashTable m_csSavedFilePathTbl = new HySDataHashTable();

        /// <summary>モデルの計算モード </summary>
        protected McSTGSysManageData.STGCalMode m_eSTGCalMode = McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL;

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean Initialize()
        {
            base.Initialize();
            this.WatchDogThreadStart();
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public Boolean Terminate()
        {
            base.Terminate();
            //Thread.Sleep(100);
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        override public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            try
            {
                HySEventObject csHySEvent = (HySEventObject)csEvent;
                long lEventNo = csHySEvent.GetEventNo();
                long lSubEventNo = csHySEvent.GetSubEventNo();
                HySKind csSimKind = csHySEvent.GetToSimKind();
                HySID csID = csHySEvent.GetSuppID();
                HySDataRoot csData = csHySEvent.GetData();
                HySDataRoot csSubData = csHySEvent.GetSubData();

                if (lEventNo == HySEventObject.NOTICE_MAINVIWER_RUN_COMPLETE)
                {   // メイン画面起動完了
                    // ライブラリ検索要求
                    bRtn = this.NoticeQueryLibraryReqest(csHySEvent);
                }
                else if (lEventNo == HySEventObject.NOTICE_DB_OK ||
                         lEventNo == HySEventObject.NOTICE_DB_NG)
                {
                    if (lSubEventNo == McDefine.QUERY_LIBRARY_LIST)
                    {
                        // TGC管理画面表示
                        //bRtn = this.NoticeQueryLibraryReqest(csHySEvent);  // ライブラリ検索要求
                        HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, McSTGSysDefine.EVNO_CREATE_STGSET_DATA);
                        csEventObject.SetToSimKind(m_csSimKindID);
                        HySString csSTGFileName = null;
                        csEventObject.SetData(csSTGFileName);
                        bRtn = this.STGCreateData(csEventObject);

                        // プロジェクト管理画面表示
                        //csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, new HySID(McDefine.PROJECTSCREEN_ID));
                        //csEventObject.SetToSimKind(m_csSimKindID);
                        //csEventObject.SetData(McDefine.HYM_PROJECTCTL_SCREEN);
                        //csEventObject.SetSubData(csSubData);
                        //this.PutEvent(csEventObject);
 
                        // ライブラリ管理画面表示
                        csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN ,new HySID(McDefine.LIBRARYSCREEN_ID));
                        csEventObject.SetToSimKind(m_csSimKindID);
                        csEventObject.SetData(McDefine.HYM_LIBRARYCTL_SCREEN);
                        csEventObject.SetSubData(csSubData);
                        this.PutEvent(csEventObject);

                        // 評価グラフ表示画面を表示
                        //csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN);
                        //csEventObject.SetToSimKind(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND);
                        //csEventObject.SetSuppID(new HySID(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN.ToString()));
                        //csEventObject.SetData(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN);
                        //this.PutEvent(csEventObject);

                        try
                        {
                            string sHistoryFolderPath = HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_HISTORY_FOLDER")).ToString();
                            HySFile csFile = new HySFile(sHistoryFolderPath);
                            csFile.AllFileDelleteInDirectory(new HySString("*.rpstdat"));
                            csFile.AllFileDelleteInDirectory(new HySString("*.rpsidat"));
                        }
                        catch
                        {
                            // Do Nothing
                        }
                        //CmndMakeNewSimulator(csHySEvent);
                        this.StartBusiProc(csHySEvent);
                        m_eSTGCalMode = m_csSTGMngData.GetSTGCalMode(); // 派生クラス側で設定したモードを控えておく
                    }
                }
                else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK)
                {   // スクリーン表示完了報告
                    //bRtn = this.NoticeScreenDisp(csHySEvent);
                }
                //else if (lEventNo == McSTGSysDefine.EVNO_CREATE_STGSET_DATA)
                //{   // TGCデータ作成ならば
                //    bRtn = this.CreateSTGData(csHySEvent);
                //}
                else if (lEventNo == McSTGSysDefine.EVNO_SET_STG_COMPLETE)
                {   // TGC設定完了ならば
                    //csHySEvent.SetTo(HySSysEvent.OBJID_BUSIPROCEDURE);
                    m_csCmndSTGStartFlg = McSTGSysCtlInfo.DEFAULT_STATE;
                    bRtn = this.STGCreateSimulator(csHySEvent);
                }
                //            else if (lEventNo == HySEventObject.CMND_NEW_SIMULATOR_CREATE)
                //{   // シミュレーター（演算単位系）新規作成指示（プロジェクト新規作成）
                //    //bRtn = this.CmndMakeNewSimulator(csHySEvent);
                //}
                else if (lEventNo == HySEventObject.CMND_NEW_SIMULATOR_CREATE)
                {   // モデル生成の時
                    McSTGSysCtlInfo csCtlInf = this.m_csSTGMngData.GetCtlInfo(csID);
                    if (csCtlInf != null)
                    {
                        if (csCtlInf.GetCalStatus() < McSTGSysCtlInfo.MODEL_EXIST_STATE)
                        {
                            base.EventCallback(csEvent);
                        }
                    }
                }
                else if (lEventNo == HySEventObject.NOTICE_SIMULATOR_CREATE_SUCCESS)
                {   // シミュレーター（演算単位系）新規作成完了報告ならば
                    bRtn = this.NoticeSimulatorCreation(csHySEvent);

                    base.EventCallback(csEvent);
                }
                else if (lEventNo == HySEventObject.NOTICE_SIMULATOR_CREATE_FAIL)
                {   // シミュレータ生成失敗報告
                    // 画面に通知
                    HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, McSTGSysDefine.EVNO_NOTICE_NG_STG_MODELCONSTRUCTION);
                    csEventObject.SetToSimKind(m_csSimKindID);
                    csEventObject.SetSuppID(csID);
                    this.PutEvent(csEventObject);
                    //this.RedrawCtlScreen(HySEventObject.NOTICE_SIMULATOR_CREATE_FAIL);
                    //this.EventCallback(csEvent);
                }
                //else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_RESTORE)
                //{   // シミュレーター復元完了報告
                //    bRtn = this.CmndModelConstruction(csHySEvent);
                //}
                //     親ｸﾗｽに任せる あるいは、独自処理を作成する
                //else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_RESTORE_NG)
                //{
                //    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                //    ((HySEventObject)csEvent).SetEventNo(HySEventObject.CMND_DISPLY_MESSAGE);
                //    if (((HySEventObject)csEvent).GetData() != null)
                //    {
                //        // 開く対象のシミュレータがすでに存在する場合
                //        ((HySEventObject)csEvent).SetSubEventNo(McDefine.HYM_PROJECT_OPEN_NG);
                //    }
                //    else
                //    {
                //        // 復元異常の場合
                //        ((HySEventObject)csEvent).SetSubEventNo(McDefine.HYMCO_FILE_OPEN);
                //    }
                //    bRtn = this.PutEvent(csEvent);
                //}
                else if (lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
                {   // モデルコンストラクション完了報告
                    bRtn = this.NoticeModelConstruction(csHySEvent);

                    // 親クラス処理も行う
                    base.EventCallback(csEvent);
                }
                else if (lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)
                {   // モデル構築失敗
                    // モデルコンストラクション完了報告
                    bRtn = this.NoticeModelConstruction(csHySEvent);

                    //親クラス処理も行う。
                    //base.EventCallback(csEvent);
                }
                else if (lEventNo == McSTGSysDefine.EVNO_CMND_STG_CAL_START)
                {   // TGC計算開始指示
                    bRtn = this.STGCalStart();
                }
                else if (lEventNo == McSTGSysDefine.EVNO_CMND_STG_CAL_STOP)
                {   // TGC計算終了指示
                    bRtn = this.STGCalStop();
                }
                else if (lEventNo == McSTGSysDefine.EVNO_CMND_STG_CAL_RESET)
                {   // TGC計算リセット指示
                    bRtn = this.STGCalReset();
                }
                else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION)
                {   // 計算初期化完了報告
                    bRtn = this.NoticeSTGCalInitialize(csHySEvent);
                }
                else if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)
                {   // シミュレーション計算開始報告
                    bRtn = this.NoticeSTGCalStart(csHySEvent);
                }
                else if (lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION)
                {   // 計算開始不能ならば
                    // 画面に通知
                    HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_CANNOT_START_SIMULATION);
                    csEventObject.SetToSimKind(m_csSimKindID);
                    csEventObject.SetSuppID(csID);
                    this.PutEvent(csEventObject);
                }
                else if (lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)
                {   // 計算完了ならば
                    bRtn = this.NoticeSTGCalCompletet(csHySEvent);
                }
                else if (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION)
                {   // 計算ストップならば
                    bRtn = this.NoticeSTGStopCalculation(csHySEvent);
                }
                # region プログレスバーによる進捗確認用
                else if (lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS)
                {   // 計算経過報告ならば
                    // 此処でプログレスバー用の各プロジェクトの計算進捗値を取得できる
                    // 使用する場合、派生クラスにて進捗状況要求イベントを送信する
                    bRtn = this.NoticeCalProgress(csHySEvent);
                }
                # endregion
                else if (lEventNo == McSTGSysDefine.EVNO_CMND_DISP_HELP)
                {   // ヘルプ表示
                    bRtn = this.DispSysHelp();
                }
                else if (lEventNo == HySEventObject.CMND_MODEL_CONSTRUCTION)
                {   // 単体：モデル生成指示
                    m_csMdlEditWorkMng.AddObject((HySString)csID.GetString(), csID);
                    m_csDataContainerTbl.AddObject((HySString)this.GetSimKind().GetString() + (HySString)csID.GetString(), m_csSTGMngData.GetDataContainer(csID));
                    this.CmndModelConstruction(csID);
                }
                else if (lEventNo == McSTGSysDefine.EVNO_OPEN_STG)
                {
                    // TGC開く
                    bRtn = this.LoadSTGData(csHySEvent);
                }
                else if (lEventNo == McSTGSysDefine.EVNO_NEW_SAVE_STG)
                {
                    // TGC別名保存
                    bRtn = this.NewSaveSTGData(csHySEvent);
                }
                else if (lEventNo == McSTGSysDefine.EVNO_SAVE_STG)
                {
                    // TGC上書保存
                    bRtn = this.SaveSTGData(csHySEvent);
                }
                else
                {
                    bRtn = base.EventCallback(csEvent);
                }
            }
            catch(Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.EventCallback", 
                    Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.EventCallback", "catch exception( " + ex.Message + ")");
                bRtn = false;
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC情報用データクラスの保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SaveSTGData( csHySEvent ) </para>
        /// </example>
        /// <param name="csHySEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool SaveSTGData(HySEventObject csHySEvent)
        {
            Boolean bRtn = true;
            HySString csProjectGrName = null;
            McSTGSysManageData csSTGMngData = csHySEvent.GetSubData() as McSTGSysManageData;
            if ((object)csSTGMngData != null)
            {   // TGC管理情報が設定されているならば、上書保存か別名保存判定
                HySDataLinkedList csKeyList = csSTGMngData.GetKeyList();
                if (csKeyList != null)
                {
                    long lDtNum = csKeyList.GetCount();
                    for (long lLp = 0; lLp < lDtNum; lLp++)
                    {
                        HySString csKey = csKeyList.GetData(lLp) as HySString;
                        HySID csID = new HySID(csKey);
                        McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csID);
                        if (csCtlInfo != null)
                        {
                            csCtlInfo.SetCalStatus(McSTGSysCtlInfo.BEFOR_CREATE);
                            csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.BEFOR_CREATE);
                            csProjectGrName = csCtlInfo.GetProjectGrName();
                            if (m_csSavedFilePathTbl[csProjectGrName] == null)
                            {
                                // 別名保存（ビューアへイベント送信）
                                csHySEvent.SetEventNo(McSTGSysDefine.EVNO_NEW_SAVE_STG);
                                csHySEvent.SetTo(HySSysEvent.OBJID_VIEWER);
                                bRtn = this.PutEvent(csHySEvent);
                                break;
                            }
                            else
                            {
                                HySString csFilePath = (HySString)m_csSavedFilePathTbl[csProjectGrName];
                                csHySEvent.SetData(csFilePath);
                                bRtn = this.NewSaveSTGData(csHySEvent);
                                break;
                            }
                        }
                    }
                }
                else
                {
                    // 立上げ直後の上書保存の場合は別名保存（ビューアへイベント送信）
                    csHySEvent.SetEventNo(McSTGSysDefine.EVNO_NEW_SAVE_STG);
                    csHySEvent.SetTo(HySSysEvent.OBJID_VIEWER);
                    bRtn = this.PutEvent(csHySEvent);
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC情報用データクラスの保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NewSaveSTGData( csHySEvent ) </para>
        /// </example>
        /// <param name="csHySEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool NewSaveSTGData(HySEventObject csHySEvent)
        {
            Boolean bRtn = true;
            HySString csSTGFileName = csHySEvent.GetData() as HySString;
            if ((object)csSTGFileName != null)
            {   // ファイル名が設定されているならば、そのファイルを保存
                HySFile csFile = new HySFile(csSTGFileName);
                try
                {
                    if (csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                    {
                        bool blRtn = csFile.DataWrite(m_csSTGMngData);
                        csFile.Close();
                        if (blRtn == true)
                        {
                            // ファイルパス管理テーブルに追加（上書保存or別名保存の判定用）
                            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
                            if (csKeyList != null)
                            {
                                long lDtNum = csKeyList.GetCount();
                                for (long lLp = 0; lLp < lDtNum; lLp++)
                                {
                                    HySString csKey = csKeyList.GetData(lLp) as HySString;
                                    HySID csID = new HySID(csKey);
                                    McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csID);
                                    if (csCtlInfo != null)
                                    {
                                        csCtlInfo.SetCalStatus(McSTGSysCtlInfo.BEFOR_CREATE);
                                        csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.BEFOR_CREATE);
                                        m_csSavedFilePathTbl.AddObject(csCtlInfo.GetProjectGrName(), csSTGFileName);
                                    }
                                }
                            }
                            // 一般グラフ設定保存に移る
                            // TGC保存ファイルと同じディレクトリを取得（グラフ設定ファイルをコピーするのに使う）
                            //System.IO.DirectoryInfo csInfo = System.IO.Directory.GetParent(csSTGFileName.ToString());
                            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.ARBITRARY_EVENT);
                            csEventObject.SetSubEventNo(HySEvGrphDefine.CMND_DISPINFO_SAVE);
                            csEventObject.SetToSimKind(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND);
                            csEventObject.SetSuppID(new HySID(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN.ToString()));
                            csEventObject.SetData(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN);
                            // TGC保存ファイルパスをそのままイベントに付加する（グラフ設定ファイルをユニークなファイル名称としてコピーするのに使う）
                            csEventObject.SetSubData(csSTGFileName);
                            this.PutEvent(csEventObject);
                            Thread.Sleep(100);  // 最低でも100m秒待つ
                        }
                        else
                        {
                            // TGC保存失敗
                        }
                    }
                }
                catch (Exception ex)
                {
                    // 例外発生
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.SaveSTGData",
                        Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
                   // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.SaveSTGData", "catch exception( " + ex.Message + ")");
                }
            }

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC情報用データクラスの読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LoadSTGData( csHySEvent ) </para>
        /// </example>
        /// <param name="csHySEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool LoadSTGData(HySEventObject csHySEvent)
        {
            Boolean bRtn = true;
            HySString csSTGFileName = csHySEvent.GetData() as HySString;
            if ((object)csSTGFileName != null)
            {   // ファイル名が設定されているならば、そのファイルを復元
                HySFile csFile = new HySFile(csSTGFileName);
                try
                {
                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                    {
                        McSTGSysManageData csData = (McSTGSysManageData)csFile.DataRead();
                        csFile.Close();
                        if (csData != null)
                        {
                            csData.SetSTGCalMode(m_eSTGCalMode);  // 派生クラス側で設定したモードをデータ内に設定する
                            // 復元した管理情報を設定
                            m_csSTGMngData = csData;
                            // 計算状態を初期化する
                            // 本保存復元処理では、計算中断状態を保存するものでない為
                            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
                            if (csKeyList != null)
                            {
                                long lDtNum = csKeyList.GetCount();
                                for (long lLp = 0; lLp < lDtNum; lLp++)
                                {
                                    HySString csKey = csKeyList.GetData(lLp) as HySString;
                                    HySID csID = new HySID(csKey);
                                    McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csID);
                                    if (csCtlInfo != null)
                                    {
                                        // 復元後、設定時にシミュレータが生成されるよう
                                        csCtlInfo.SetCalStatus(McSTGSysCtlInfo.BEFOR_CREATE);
                                        csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.BEFOR_CREATE);
                                        // ファイルパス管理テーブルに追加（上書保存or別名保存の判定用）
                                        m_csSavedFilePathTbl.AddObject(csCtlInfo.GetProjectGrName(), csSTGFileName);
                                    }
                                }
                            }
                            
                            // TGC制御画面へ通知
                            csHySEvent.SetEventNo(HySEventObject.CMND_DISP_SCREEN);
                            csHySEvent.SetSubEventNo(McSTGSysDefine.EVNO_NOTICE_OPEN_STG);
                            csHySEvent.SetSubData(m_csSTGMngData);
                            csHySEvent.SetTo(HySSysEvent.OBJID_VIEWER);
                            this.PutEvent(csHySEvent);
                            
                            // 一般グラフ画面への復元処理
                            // TGC保存ファイルのベース名称取得
                            string sSTGSaveFileName = System.IO.Path.GetFileNameWithoutExtension(csSTGFileName.ToString());
                            // TGC保存ファイルと同じディレクトリを取得（グラフ設定ファイルをコピーするのに使う）
                            System.IO.DirectoryInfo csInfo = System.IO.Directory.GetParent(csSTGFileName.ToString());
                            string sGraphSaveFile = csInfo.ToString() + "\\" + sSTGSaveFileName + "._GraphSaveInfo.obj";

                            // TGC保存ファイルと同じディレクトリを取得（グラフ設定ファイルをコピーするのに使う）
                            //System.IO.DirectoryInfo csInfo = System.IO.Directory.GetParent(csSTGFileName.ToString());
                            //string sGraphSaveFile = csInfo.ToString() + "\\._GraphSaveInfo.obj";
                            string sTargetPath = HySEnvInf.GetHomeDirectory().ToString() + "\\temp\\._GraphSaveInfo.obj";
                            // グラフ設定ファイルの存在を確認し、万が一無い場合でもTGC設定は復元する
                            if (System.IO.File.Exists(sGraphSaveFile) == true)
                            {
                                // 保存ディレクトリからtemp下へグラフ設定ファイルをコピー
                                System.IO.File.Copy(sGraphSaveFile, sTargetPath, true);

                                Thread.Sleep(333);
                                // 一般グラフ設定保存に移る
                                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.ARBITRARY_EVENT);
                                csEventObject.SetSubEventNo(HySEvGrphDefine.CMND_DISPINFO_RESTORE);
                                csEventObject.SetToSimKind(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND);
                                csEventObject.SetSuppID(new HySID(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN.ToString()));
                                csEventObject.SetData(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN);
                                this.PutEvent(csEventObject);
                            }

                        }
                        else
                        {
                            // TGC復元失敗
                        }
                    }
                }
                catch (Exception ex)
                {
                    // 例外発生
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.LoadSTGData", 
                        Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
                   // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.LoadSTGData", "catch exception( " + ex.Message + ")");
                }
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC情報用データクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = STGCreateData( csHySEvent ) </para>
        /// </example>
        /// <param name="csHySEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool STGCreateData(HySEventObject csHySEvent)
        {
            Boolean bRtn = true;

            HySString csSTGFileName = csHySEvent.GetData() as HySString;
            
            m_csSTGMngData = new McSTGSysManageData(this.GetSimKind(), new HySString(""));
            if ((object)csSTGFileName != null)
            {   // ファイル名が設定されているならば、そのファイルを読み出す
// ファイル名が設定されているならば、そのファイルを読み出す
            }
            csHySEvent.SetSubData(m_csSTGMngData);
            csHySEvent.SetTo(HySSysEvent.OBJID_VIEWER);
            this.PutEvent(csHySEvent);
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC情報用に従い関連するシミュレーターを生成する指示を出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = STGCreateSimulator( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool STGCreateSimulator(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
            long lDtNum = csKeyList.GetCount();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                HySString csKey = csKeyList.GetData(lLp) as HySString;
                HySID csID = new HySID(csKey);
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csID);
                if( csCtlInfo != null )
                {
                    if (csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.BEFOR_CREATE)
                    {   // シミュレーター生成前ならば
                        // シミュレーター生成
                        HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_NEW_SIMULATOR_CREATE);
                        csEventObject.SetToSimKind(this.GetSimKind());
                        csEventObject.SetSuppID(csID);
                        csEventObject.SetData(m_csSTGMngData.GetDataContainer(csID));

                        this.PutEvent(csEventObject);

                        m_csDataContainerTbl.AddObject((HySString)this.GetSimKind().GetString() + (HySString)csID.GetString(), m_csSTGMngData.GetDataContainer(csID));
                    }
                    else
                    {
                        if (m_csSTGMngData.GetSTGCalMode() ==  McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                        {   // 一斉計算方式ならば
                            // モデルコンストラクション指示
                            this.CmndModelConstruction(csID);
                        }
                        else
                        {   // 個別計算方式ならば
//＝＝＝＝＝＝＝＝＝＝＝＝＝＝
                            // 全てが生成完了状況ならば
                            // 計算ステータス変更
                            csCtlInfo.SetCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
                            csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
                            if (this.IsAllCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE) == true)
                            {
                                m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);  // 系全体が　モデル生成完了
                                // 画面に通知
                                this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_MODELCONSTRUCTION);
                            }
                            else
                            {
                                // 画面に通知
                                this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
                            }
                        }
                    }
                }
            }
            m_csCmndSTGStartFlg = McSTGSysCtlInfo.DEFAULT_STATE;

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC用シミュレーター生成完了報告時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSimulatorCreation( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeSimulatorCreation(HySEventObject csEventObj)
        {
            bool bRtn = true;
            
            // データコンテナ管理テーブルに追加
            HySSimulationDataContainer csDataCnt = (HySSimulationDataContainer)csEventObj.GetData();
            HySID csPrjID = (HySID)csDataCnt.GetID();
            this.AddToDataContainerTbl(csDataCnt);

            // フィードバックデータ設定
            McSTGSysFeedbackDataBase csFeedbakData = this.CreateFeedbackData();
            csDataCnt.SetData(McSTGSysDefine.DATA_KEY_FEEDBACK_DATA, csFeedbakData);
            // フィードバック情報を共通保管エリアに設定
            HySCommonInfoHash.SetCorrespondData(McSTGSysDefine.TABLE_KEY_FEEDBACK_DATA, csPrjID.ToString(), csFeedbakData);

            // ファイルパス管理テーブルに追加
            HySString csFilepath = (HySString)csEventObj.GetSubData();
            m_csFilePathTbl.AddObject((HySString)csPrjID.GetString(), csFilepath);

            // 計算ステータス変更
            McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
            if (csCtlInfo != null)
            {
                csCtlInfo.SetCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
                csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
            }

            // データコンテナ設定
            m_csSTGMngData.SetDataContainer(csPrjID, csDataCnt);

            if (m_csSTGMngData.GetSTGCalMode() ==  McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
            {   // 一斉計算方式ならば
                // モデルコンストラクション指示
                this.CmndModelConstruction(csPrjID);
            }
            else
            {   // 個別計算方式ならば
                // 全てが生成完了状況ならば
                if (this.IsAllCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE) == true)
                {
                    m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);  // 系全体が　モデル生成完了
                    // 画面に通知
                    this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_MODELCONSTRUCTION);
                }
                else
                {
                    // 画面に通知
                    this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算モデル構築完了報告を受け取った時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSimulatorCreation( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeModelConstruction(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySID csPrjID = csEventObj.GetSuppID();
            HySString csMsg = csEventObj.GetSubData() as HySString;

            // 計算ステータス変更
            McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
            if (csCtlInfo != null)
            {
                if (csEventObj.GetEventNo() == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
                {// モデル構築が正常完了の場合、ステータス設定
                    csCtlInfo.SetCalStatus(McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE);
                }
                if (m_csCmndSTGStartFlg != McSTGSysCtlInfo.CALCULATION_STATE)
                {
                    if (csEventObj.GetEventNo() == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
                    {// モデル構築が正常完了の場合、ステータス設定
                        csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE);
                    }
                }
            }
            if (m_csCmndSTGStartFlg == McSTGSysCtlInfo.CALCULATION_STATE)
            {   // 計算中ならば
                // 子クラスに通知
                HySSimulationDataContainer csCnt = m_csSTGMngData.GetDataContainer(csPrjID);
                McSimulationStatus csSimSta = (McSimulationStatus)csCnt.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                if (csEventObj.GetEventNo() == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
                {// コンテナのシミュレーション状態（モデル構築状態）を設定する
                    csSimSta.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.CONSTRUCTED);
                }
                else if (csEventObj.GetEventNo() == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)
                {// コンテナのシミュレーション状態（モデル構築状態）を設定する
                    csSimSta.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.NOT_CONSTRUCTED);
                }
                this.NoticeModelConstruction(csPrjID, csCnt);
            }
            else
            {   // 計算中ではない時
                base.EventCallback(csEventObj);
            }

            if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
            {   // 一斉計算方式ならば
                // 全てがモデルコンストラクション完了状況ならば
                if (this.IsAllCalStatus(McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE) == true)
                {
                    m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE);  // 系全体が　モデルコンストラクション完了

                    // 画面に通知
                    this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_MODELCONSTRUCTION);

                    m_csCmndSTGStartFlg = McSTGSysCtlInfo.INITIAL_STATE;
                }
                else
                {
                    //Do Nothing
                }
            }
            else
            {   // 個別計算方式ならば
                // 画面に通知
                this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
            }


            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算モデル計算開始指示時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = STGCalStart(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面からの指示</para>
        /// </remarks>
        virtual protected bool STGCalStart()
        {
            m_csCmndSTGStartFlg = McSTGSysCtlInfo.CALCULATION_STATE;

            if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Repeat)
            {   // 繰り返し計算ならば
                HySTime csSetTime = m_csSTGMngData.GetSTGCalStartTime();
                this.SetTimer(McSTGSysBusiProcedureBase.STGSysTimerID, csSetTime);
            }
            else
            {   // １回計算ならば
                HySTime csSetTime = m_csSTGMngData.GetCalStartTime();
                this.CmndCalPrjTimeOut( csSetTime);
            }
            // 画面に通知
            this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_START);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算モデル計算終了指示時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = STGCalStop(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面からの指示</para>
        /// </remarks>
        virtual protected bool STGCalStop()
        {
            m_csCmndSTGStartFlg = McSTGSysCtlInfo.STOP_STATE;
            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
            long lDtNum = csKeyList.GetCount();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                HySString csKey = csKeyList.GetData(lLp) as HySString;
                HySID csID = new HySID(csKey);

                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csID);
                if (csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.CALCULATION_STATE)
                {
                    this.CmndCalStop(csID);
                }
                else
                {
                    csCtlInfo.SetCalStatus(McSTGSysCtlInfo.STOP_STATE);
                    csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.STOP_STATE);
                }
            }
            this.ResetTimer(McSTGSysBusiProcedureBase.STGSysTimerID);

            // 全てがモデル計算完了状況ならば
            if (IsAllCalStatus(McSTGSysCtlInfo.STOP_STATE) == true)
            {   // 画面に通知
                this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_STOP);
            }

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算モデル初期化指示時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = STGCalReset(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面からの指示</para>
        /// </remarks>
        virtual protected bool STGCalReset()
        {
            if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
            {   // 一斉計算方式ならば
                m_csCmndSTGStartFlg = McSTGSysCtlInfo.INITIAL_STATE;

                HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
                long lDtNum = csKeyList.GetCount();
                for (long lLp = 0; lLp < lDtNum; lLp++)
                {
                    HySString csKey = csKeyList.GetData(lLp) as HySString;
                    HySID csID = new HySID(csKey);
                    this.CmndCalInitialize(csID);
                }
            }
            else
            {   // 個別計算方式ならば
                HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
                long lDtNum = csKeyList.GetCount();
                for (long lLp = 0; lLp < lDtNum; lLp++)
                {
                    HySString csKey = csKeyList.GetData(lLp) as HySString;
                    HySID csPrjID = new HySID(csKey);
                    McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                    if (csCtlInfo != null)
                    {
                        csCtlInfo.SetCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
                        csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
                    }
                }
                // 画面に通知
                this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
            }
            // 画面に通知
            this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_INITIALIZE);
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC計算モデル初期化完了報告を受け取った時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSTGCalInitialize( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeSTGCalInitialize(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySID csPrjID = csEventObj.GetSuppID();
            //HySString csMsg = csEventObj.GetSubData() as HySString;

            try
            {
                // 計算ステータス変更
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                if (csCtlInfo != null)
                {
                    csCtlInfo.SetCalStatus(McSTGSysCtlInfo.INITIAL_STATE);
                    csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.INITIAL_STATE);
                    csCtlInfo.SetCalProgress(0);
                }
                // 子クラスに通知
                HySSimulationDataContainer csCnt = m_csSTGMngData.GetDataContainer(csPrjID);
                McSTGSysFeedbackDataBase csFeedBackData = csCnt.GetData(McSTGSysDefine.DATA_KEY_FEEDBACK_DATA) as McSTGSysFeedbackDataBase;
                this.NoticeCalInitialize(csPrjID, csFeedBackData, csCnt);

                if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                {   // 一斉計算方式ならば
                    if (IsAllCalStatus(McSTGSysCtlInfo.INITIAL_STATE) == true)
                    {
                        m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.INITIAL_STATE);

                        if (m_csCmndSTGStartFlg == McSTGSysCtlInfo.INITIAL_STATE)
                        {
                            // 画面に通知
                            this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_INITIALIZE);
                        }
                        else if (m_csCmndSTGStartFlg == McSTGSysCtlInfo.CALCULATION_STATE)
                        {

                            if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                            {   // モデルが一斉に計算を行うモードならば
                                // 全てのプロジェクトに計算開始を指示
                                HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
                                long lDtNum = csKeyList.GetCount();
                                for (long lLp = 0; lLp < lDtNum; lLp++)
                                {
                                    HySString csKey = csKeyList.GetData(lLp) as HySString;
                                    HySID csID = new HySID(csKey);
                                    this.CmndCalStart(csID); // 計算開始指示
                                }
                            }
                            //else
                            //{   // モデルが個別に計算を行うモードならば
                            //    this.CalculationTimerOut();
                            //}

                            // 画面に通知
                            this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_START);
                        }
                    }
                }
                else
                {   // 個別計算方式ならば
                    // 画面に通知
                    this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
                }

            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalInitialize", 
                    Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalInitialize", "catch exception( " + ex.Message + ")");
                bRtn = false;
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算開始報告を受け取った時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSTGCalStart( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeSTGCalStart(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySID csPrjID = csEventObj.GetSuppID();

            try
            {
                HySString csMsg = csEventObj.GetSubData() as HySString;


                // 計算ステータス変更
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                if (csCtlInfo != null)
                {
                    csCtlInfo.SetCalStatus(McSTGSysCtlInfo.CALCULATION_STATE);
                    csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.CALCULATION_STATE);
                }
                // 子ｸﾗｽに通知
                HySSimulationDataContainer csCnt = m_csSTGMngData.GetDataContainer(csPrjID);
                bRtn = this.NoticeCalStart(csPrjID, csCnt);

                if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                {   // 一斉計算方式ならば
                    // 全てがモデル計算中状況ならば
                    if (IsAllCalStatus(McSTGSysCtlInfo.CALCULATION_STATE) == true)
                    {  // 系全体が　計算中
                        m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.CALCULATION_STATE);
                    }
                    // 画面更新に通知
                    this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
                }
                else
                {   // 個別計算方式ならば
                }

            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalStart", 
                    Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalStart", "catch exception( " + ex.Message + ")");
                bRtn = false;
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算完了報告を受け取った時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSTGCalCompletet( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeSTGCalCompletet(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySID csPrjID = csEventObj.GetSuppID();
            try
            {
                //HySString csMsg = csEventObj.GetSubData() as HySString;

                // 計算ステータス変更
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                if (csCtlInfo != null)
                {
                    csCtlInfo.SetCalStatus(McSTGSysCtlInfo.END_STATE);
                    csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.END_STATE);
                    csCtlInfo.SetCalProgress(100);
                }

                // 子ｸﾗｽに通知
                HySSimulationDataContainer csCnt = m_csSTGMngData.GetDataContainer(csPrjID);
                McSTGSysFeedbackDataBase csFeedBackData = csCnt.GetData(McSTGSysDefine.DATA_KEY_FEEDBACK_DATA) as McSTGSysFeedbackDataBase;
                try
                {
                    bRtn = this.NoticeCalComplete(csPrjID, csFeedBackData, csCnt);
                }
                catch(Exception ex)
                {
                    // 例外発生
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalCompletet", 
                        Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
                   // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalCompletet", "catch exception( " + ex.Message + ")");
                }

                if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                {   // 一斉計算方式ならば
                    // 全てがモデル計算完了状況ならば
                    if (IsAllCalStatus(McSTGSysCtlInfo.END_STATE) == true)
                    {
                        m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.END_STATE);  // 系全体が　計算完了

                        if (m_csCmndSTGStartFlg == McSTGSysCtlInfo.END_STATE)
                        {
                            // 画面に通知
                            this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_COMPLETE);
                        }
                        else
                        {
                            // 画面表示更新指示
                            this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_COMPLETE);
                            //Thread.Sleep(1500);  // 最低でも１.５秒待つ

                            // 全体計算終了通知
                            this.NoticeSTGCalComplete();
                        }
                        //Thread.Sleep(15000);  // 最低でも15秒待つ
                        //for (int i = 0; i < 15; i++) { Thread.Sleep(1000); }
                    }
                    else
                    {
                        this.RedrawCtlScreen(McSTGSysDefine.EVNO_REDRAW_STG_CTL_SCREEN);
                    }
                }
                else
                {   // 個別計算方式ならば
                }

            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalCompletet", 
                     Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGCalCompletet", "catch exception( " + ex.Message + ")");
                bRtn = false;
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>TGC計算中止報告を受け取った時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSTGStopCalculation( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeSTGStopCalculation(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySID csPrjID = csEventObj.GetSuppID();
            try
            {
                // 計算ステータス変更
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                if (csCtlInfo != null)
                {
                    csCtlInfo.SetCalStatus(McSTGSysCtlInfo.STOP_STATE);
                    csCtlInfo.SetCtlStatus(McSTGSysCtlInfo.STOP_STATE);
                }

                // 全てがモデル計算強制終了状況ならば
                if (IsAllCalStatus(McSTGSysCtlInfo.STOP_STATE) == true)
                {
                    m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.STOP_STATE);  // 系全体が　計算強制終了
                    if (m_csCmndSTGStartFlg == McSTGSysCtlInfo.STOP_STATE)
                    {
                        // 画面に通知
                        this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_STOP);
                    }
                }
            }
            catch(Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGStopCalculation", 
                    Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeSTGStopCalculation", "catch exception( " + ex.Message + ")");
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }
        # region プログレスバーによる進捗確認用
        /// <summary><para>method outline:</para>
        /// <para>TGC計算進捗報告を受け取った時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeCalProgress( csEventObj ) </para>
        /// </example>
        /// <param name="csEventObj">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレーターからの報告</para>
        /// </remarks>
        virtual protected bool NoticeCalProgress(HySEventObject csEventObj)
        {
            bool bRtn = true;
            HySID csPrjID = csEventObj.GetSuppID();
            try
            {
                // 計算ステータス変更
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                if (csCtlInfo != null)
                {
                    long lPrgress = csEventObj.GetSubEventNo();
                    csCtlInfo.SetCalProgress(lPrgress);
                }
            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeCalProgress", 
                    Properties.HymcoSTGResources.STATEMENT_CATCH_EXCEPTION + "( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase.NoticeCalProgress", "catch exception( " + ex.Message + ")");
                bRtn = false;
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトのモデル生成指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndModelConstruction( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">指定プロジェクトＩＤ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool CmndModelConstruction(HySID csPrjID)
        {
            HySSimulationDataContainer csDataCnt = m_csSTGMngData.GetDataContainer(csPrjID);
            // モデルコンストラクション指示
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_MODEL_CONSTRUCTION);
            csEventObject.SetToSimKind(this.GetSimKind());
            csEventObject.SetSuppID(csPrjID);
            csEventObject.SetData(csDataCnt);
            this.PutEvent(csEventObject);

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトの初期化指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndCalInitialize( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">指定プロジェクトＩＤ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool CmndCalInitialize(HySID csPrjID)
        {
            HySSimulationDataContainer csDtCnt = m_csSTGMngData.GetDataContainer(csPrjID);
            csDtCnt.SetStartTime(m_csSTGMngData.GetCalStartTime());
            csDtCnt.SetSimuTime(m_csSTGMngData.GetCalStartTime());
            csDtCnt.SetGoalTime(m_csSTGMngData.GetCalGoalTime());

            
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_INITIALIZE_SIMULATION);
            csEventObject.SetToSimKind(this.GetSimKind());
            csEventObject.SetSuppID(csPrjID);

            //★サーバー／クライアント化で追加
            HySSimulationDataContainer csDataCnt = m_csSTGMngData.GetDataContainer(csPrjID);
            csEventObject.SetData(csDataCnt);
            //★サーバー／クライアント化で追加


            return this.PutEvent(csEventObject);
        }
        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトの計算開始指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndCalStart( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">指定プロジェクトＩＤ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool CmndCalStart(HySID csPrjID)
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_START_SIMULATION);
            csEventObject.SetToSimKind(this.GetSimKind());
            csEventObject.SetSuppID(csPrjID);

            //★サーバー／クライアント化で追加
            HySSimulationDataContainer csDataCnt = m_csSTGMngData.GetDataContainer(csPrjID);
            csEventObject.SetData(csDataCnt);
            //★サーバー／クライアント化で追加

            return this.PutEvent(csEventObject);
        }
        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトの計算終了指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndCalStop( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">指定プロジェクトＩＤ</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool CmndCalStop(HySID csPrjID)
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_STOP_SIMULATION);
            csEventObject.SetToSimKind(this.GetSimKind());
            csEventObject.SetSuppID(csPrjID);
            return this.PutEvent(csEventObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC内の全プロジェクトが指定した状態に達したかを調べる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = IsAllCalStatus( lStatus ) </para>
        /// </example>
        /// <param name="lStatus">指定状態</param>
        /// <returns>true:=指定状態にある, false:=指定状態でない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected bool IsAllCalStatus(long lStatus)
        {
            bool bRtn = true;
            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
            long lDtNum = csKeyList.GetCount();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                HySString csKey = csKeyList.GetData(lLp) as HySString;
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(new HySID(csKey));
                if (csCtlInfo.GetCtlStatus() != lStatus)
                {
                    bRtn = false;
                    break;
                }
            }
            //Thread.Sleep(1);  // スレッドの隙間を空ける
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>次の計算開始を行って良いかを問い合わせる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EnableNextSTGCalculation() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=計算開始しても良い, false:=計算開始不能</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>前回の計算が未だ終了していない時には、計算開始不能となる</para>
        /// </remarks>
        virtual protected bool EnableNextSTGCalculation()
        {
            bool bRtn = true;
            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
            long lDtNum = csKeyList.GetCount();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                HySString csKey = csKeyList.GetData(lLp) as HySString;
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(new HySID(csKey));

                if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                {   // 一斉計算方式ならば
                    if (csCtlInfo.GetCalStatus() < McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE ||
                        csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.CALCULATION_STATE ||
                        csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.PAUSE_STATE)
                    {
                        bRtn=false;
                        break;
                    }
                }
                else
                {   // 個別計算方式ならば
                    if (csCtlInfo.GetCalStatus() < McSTGSysCtlInfo.MODEL_EXIST_STATE ||
                        csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.CALCULATION_STATE ||
                        csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.PAUSE_STATE)
                    {
                        bRtn = false;
                        break;
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定した計算開始時刻になった時に行う処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndCalPrjTimeOut(csSetTime) </para>
        /// </example>
        /// <param name="csSetTime">指定した時刻</param>
        /// <returns>true:=計算開始, false:=計算開始不能</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>前回の計算が未だ終了していない時には、計算開始不能となる</para>
        /// </remarks>
        virtual protected bool CmndCalPrjTimeOut(HySTime csSetTime)
        {
            bool bFlg = this.EnableNextSTGCalculation();
            if( bFlg == false )
            {   // 計算シーケンス開始不可
                this.CannotCalStart(csSetTime);
            }
            else
            {   // 計算シーケンス開始可能
                if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL)
                {   // 一斉計算方式ならば
                    // 初期化から行わせる
                    HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
                    long lDtNum = csKeyList.GetCount();
                    for (long lLp = 0; lLp < lDtNum; lLp++)
                    {
                        HySString csKey = csKeyList.GetData(lLp) as HySString;
                        HySID csID = new HySID(csKey);
                        this.CmndCalInitialize(csID);
                    }

                    // 初期化の後、次に計算すべき期間を更新(初期化後ならば、変更しても、個々のプロジェクトに影響を与えない)
                    m_csSTGMngData.SetSTGCalStartTime(m_csSTGMngData.GetSTGCalStartTime() + m_csSTGMngData.GetSTGCalIntervalTime());
                    m_csSTGMngData.SetCalStartTime(m_csSTGMngData.GetCalStartTime() + m_csSTGMngData.GetSTGCalIntervalTime());
                    m_csSTGMngData.SetCalGoalTime(m_csSTGMngData.GetCalGoalTime() + m_csSTGMngData.GetSTGCalIntervalTime());
                }
                else
                {   // 個別計算方式ならば
                    this.CalculationTimerOut();
                    // 次の計算開始時間を設定する
                    //m_csSTGMngData.SetSTGCalStartTime(m_csSTGMngData.GetSTGCalStartTime() + m_csSTGMngData.GetSTGCalIntervalTime());
                }
            }

            return bFlg;
        }

        // ======== 派生側で使用可能な便利メソッド関係 =========

        /// <summary><para>method outline:</para>
        /// <para>IDで指定されたプロジェクトの構造定義データを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McStructInfo bData = GetStructInfo( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <returns>McStructInfo 構造定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McStructInfo GetStructInfo(HySID csPrjID)
        {
            McStructInfo csRtn = null;
            HySSimulationDataContainer csCnt = m_csSTGMngData.GetDataContainer(csPrjID);
            if (csCnt != null)
            {
                csRtn = csCnt.GetData(McDefine.HYM_DATA_STRUCT_INFO) as McStructInfo;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定された要素のプロパティデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfo bData = GetStructInfo( csPrjID,csUserElmName ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <param name="csUserElmName">プロジェクト内で定義された要素モデル名称</param>
        /// <returns>McPropertyInfo プロパティデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McPropertyInfo GetPropertyInfo(HySID csPrjID, HySString csUserElmName)
        {
            McPropertyInfo csRtn = null;
            McStructInfo csStrInf = this.GetStructInfo(csPrjID);
            if (csStrInf != null)
            {
                csRtn = csStrInf.GetPropertyInfo(csUserElmName) as McPropertyInfo;
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定された要素のプロパティデータを設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyInfo( csPrjID,csUserElmName,csPrptyInfo ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <param name="csUserElmName">プロジェクト内で定義された要素モデル名称</param>
        /// <param name="csPrptyInfo">要素モデルのプロパティデータ
        /// 必ず　GetPropertyInfo() で取得されたインスタンスを設定する事</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void SetPropertyInfo(HySID csPrjID, HySString csUserElmName, McPropertyInfo csPrptyInfo)
        {
            // モデルコンストラクションが必要となる事を示す設定
            McSTGSysCtlInfo csSTGCtlInfo = this.m_csSTGMngData.GetCtlInfo(csPrjID);
            if (csSTGCtlInfo != null)
            {
                csSTGCtlInfo.SetCalStatus(McSTGSysCtlInfo.MODEL_EXIST_STATE);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトの全モデルの修正が完了したことを通知する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CommitModelPropertyInfoSet(csPrjID) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GetPropertyInfo(),SetPropertyInfo()を行った後で必ず本メソッドをコールすること</para>
        /// </remarks>
        virtual protected void CommitModelPropertyInfoSet(HySID csPrjID)
        {
            /*
            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
            long lDtNum = csKeyList.GetCount();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                HySString csKey = csKeyList.GetData(lLp) as HySString;
                HySID csID = new HySID(csKey);
                McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csID);
                if (csCtlInfo.GetCalStatus() == McSTGSysCtlInfo.MODEL_EXIST_STATE)
                {
                    // モデルコンストラクション
                    this.CmndModelConstruction(csID);
                }
            }
            */

            if (m_csSTGMngData.GetSTGCalMode() ==  McSTGSysManageData.STGCalMode.ASYNCHRONOUS_CAL)
            {   // モデルの計算モードが　個別制御の場合
                // Do nothing
            }
            else
            {   // モデルの計算モードが　一斉計算の場合
                this.CmndModelConstruction(csPrjID);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>指定された要素の初期化データを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McInitialInfo bData = GetInitialInfo( csPrjID,csUserElmName ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <param name="csUserElmName">プロジェクト内で定義された要素モデル名称</param>
        /// <returns>McInitialInfo 初期化データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McInitialInfo GetInitialInfo(HySID csPrjID, HySString csUserElmName)
        {
            McInitialInfo csRtn = null;
            McStructInfo csStrInf = this.GetStructInfo(csPrjID);
            try
            {
                csRtn = csStrInf.GetElementByUserName(csUserElmName).GetModelInfo().GetInitialInfo() as McInitialInfo;
            }
            catch 
            {
                // Do Nothing
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定された要素の初期化データを設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInitialInfo( csPrjID,csUserElmName,csInitInfo ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <param name="csUserElmName">プロジェクト内で定義された要素モデル名称</param>
        /// <param name="csInitInfo">要素モデルの初期化データ
        /// 必ず　GetInitialInfo() で取得されたインスタンスを設定する事</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void SetInitialInfo(HySID csPrjID, HySString csUserElmName, McInitialInfo csInitInfo)
        {
            // モデルコンストラクションが必要となる事を示す設定
            McSTGSysCtlInfo csSTGCtlInfo = this.m_csSTGMngData.GetCtlInfo(csPrjID);
            if (csSTGCtlInfo != null)
            {
                csSTGCtlInfo.SetCalStatus(McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>指定されたプロジェクトの計算開始時刻と終了時刻を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCalTimeInitialize( csPrjID,csStartTime,csGoalTime ) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクトID</param>
        /// <param name="csStartTime">計算開始時刻</param>
        /// <param name="csGoalTime">計算終了時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCalTimeInitialize(HySID csKeyID, HySTime csStartTime, HySTime csGoalTime)
        {
            HySSimulationDataContainer csDtCnt = m_csSTGMngData.GetDataContainer(csKeyID);
            if (csDtCnt != null)
            {
                csDtCnt.SetStartTime(csStartTime);
                csDtCnt.SetGoalTime(csGoalTime);
            }
        }
        
        /// <summary><para>method outline:</para>
        /// <para>TGC制御画面の表示制御</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RedrawCtlScreen( lEventNo ) </para>
        /// </example>
        /// <param name="lEventNo">イベント番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void RedrawCtlScreen(long lEventNo)
        {
            // TGC制御画面を表示更新
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, lEventNo);
            csEventObject.SetToSimKind(m_csSimKindID);
            csEventObject.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csEventObject.SetData(McSTGSysDefine.STG_CAL_CTL_SCREEN);
            csEventObject.SetSubData(m_csSTGMngData);
            this.PutEvent(csEventObject);
        }
        /// <summary><para>method outline:</para>
        /// <para>一般グラフ表示画面の再描画指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RedrawLineGraph(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>一般グラフ表示画面の「再描画」の押下と同じ</para>
        /// </remarks>
        virtual protected void RedrawLineGraph()
        {
            // 評価グラフ表示画面を表示
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_RENEW_SCREEN);
            csEventObject.SetToSimKind(HySEvGrphDefine.HYSDOTNETLINEGRAPH_BUSINESS_KIND);
            csEventObject.SetSuppID(new HySID(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN.ToString()));
            csEventObject.SetData(HySEvGrphDefine.HYSDOTNETLINEGRAPH_SCREEN);
            this.PutEvent(csEventObject);
        }
        /// <summary><para>method outline:</para>
        /// <para>ユーザーが作成した画面の表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RedrawSysScreen( csScreenKind,csScreenID,csDispData ) </para>
        /// </example>
        /// <param name="csScreenKind">画面の種別</param>
        /// <param name="csScreenID">画面のID</param>
        /// <param name="csDispData">表示データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void RedrawSysScreen(HySKind csScreenKind, HySID csScreenID, HySDataRoot csDispData)
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, McSTGSysDefine.EVNO_CMND_DISP_USER_SYS_SCREEN);
            csEventObject.SetToSimKind(this.GetSimKind());
            csEventObject.SetSuppID(csScreenID);
            csEventObject.SetData(csScreenKind);
            csEventObject.SetSubData(csDispData);
            this.PutEvent(csEventObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>定周期計算開始時刻の待ち設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> WaitCalculation(csSetTime,csWaitTime) </para>
        /// </example>
        /// <param name="csSetTime">設定していた時間</param>
        /// <param name="csWaitTime">追加待ち時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>定周期起動される計算開始の時刻を延長する際に用いる</para>
        /// </remarks>
        virtual protected void WaitCalculation(HySTime csSetTime, HySTime csWaitTime)
        {
            this.SetTimer(McSTGSysBusiProcedureBase.STGSysTimerID, (csSetTime+csWaitTime));
            //this.SetTimer(McSTGSysBusiProcedureBase.STGSysWaitTimerID, csWaitTime);  // タイマー再設定
        }

        /// <summary><para>method outline:</para>
        /// <para>指定されたプロジェクトのフィードバック情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSTGSysFeedbackDataBase bData = GetFeedbackData( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <returns>McSTGSysFeedbackDataBase フィードバック情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected McSTGSysFeedbackDataBase GetFeedbackData(HySID csPrjID)
        {
            McSTGSysFeedbackDataBase csFeedBackData = null;
            HySSimulationDataContainer csCnt = m_csSTGMngData.GetDataContainer(csPrjID);
            if( csCnt != null )
            {
                csFeedBackData = csCnt.GetData(McSTGSysDefine.DATA_KEY_FEEDBACK_DATA) as McSTGSysFeedbackDataBase;
            }
            return csFeedBackData;
        }

        /// <summary><para>method outline:</para>
        /// <para>プログラム上から、計算状況を、TGC計算完了状態にする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSTGCalCompleteState(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>m_eSTGCalMode = STGCalMode.ASYNCHRONOUS_CALの時有効</para>
        /// </remarks>
        virtual protected void SetSTGCalCompleteState()
        {
            if (m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.ASYNCHRONOUS_CAL)
            {   // 個別計算方式ならば

                // 次に計算すべき期間を更新
                m_csSTGMngData.SetSTGCalStartTime(m_csSTGMngData.GetSTGCalStartTime() + m_csSTGMngData.GetSTGCalIntervalTime());
                m_csSTGMngData.SetCalStartTime(m_csSTGMngData.GetCalStartTime() + m_csSTGMngData.GetSTGCalIntervalTime());
                m_csSTGMngData.SetCalGoalTime(m_csSTGMngData.GetCalGoalTime() + m_csSTGMngData.GetSTGCalIntervalTime());

                m_csSTGStatus.SetCalStatus(McSTGSysCtlInfo.END_STATE);  // 系全体が　計算完了完了

                // 画面表示更新指示
                this.RedrawCtlScreen(McSTGSysDefine.EVNO_NOTICE_STG_CAL_COMPLETE);

                // 全体計算終了通知
                this.NoticeSTGCalComplete();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>マニュアル表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowManual(csFileNameWithPath) </para>
        /// </example>
        /// <param name="csFileNameWithPath">ファイル名（パス付き）</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ShowManual(HySString csFileNameWithPath)
        {
            bool bRtn = false;
                       
            HySFile csFile = new HySFile(csFileNameWithPath);
            if (csFile.Exist() == true)
            {   // ファイルが存在すれば
                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, McSTGSysDefine.EVNO_CMND_SHOW_MANUAL);
                csEventObject.SetToSimKind(this.GetSimKind());
                csEventObject.SetSubData(csFileNameWithPath);
                bRtn = this.PutEvent(csEventObject);
            }
            else
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase", "ShowManual", 
                    csFileNameWithPath.ToString()+ Properties.HymcoSTGResources.STATEMENT_NOT_EXIST );
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysBusiProcedureBase", "ShowManual", csFileNameWithPath.ToString() + " not exist");
            }
            return bRtn;
        }

        // ＝＝＝＝＝　タイマー関係処理　＝＝＝＝＝＝＝
        /// <summary><para>method outline:</para>
        /// <para>タイマー設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTimer(csKeyID,csOutTime) </para>
        /// </example>
        /// <param name="csKeyID">タイマーID</param>
        /// <param name="csOutTime">設定時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定時刻になるとTimeOut() メソッドがコールされる</para>
        /// </remarks>
        virtual protected void SetTimer(HySID csKeyID, HySTime csOutTime)
        {
            m_csTimerTable.AddObject((HySString)csKeyID.GetString(), csOutTime);
        }
        /// <summary><para>method outline:</para>
        /// <para>タイマー解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ResetTimer(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">タイマーID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void ResetTimer(HySID csKeyID)
        {
            m_csTimerTable.DeleteData((HySString)csKeyID.GetString());
        }

        /// <summary><para>method outline:</para>
        /// <para>タイマー見張り処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> WatchDogTimer( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void WatchDogTimer()
        {
            HySCalendar.SetNow(ref m_csNowTime); // 現在時刻取得
            HySTime csSetTime = null;

            HySDataLinkedList csKeyList = this.m_csTimerTable.GetKeyList();
            if (csKeyList != null)
            {
                long lDtNum = csKeyList.GetCount();
                for (long lLp = 0; lLp < lDtNum; lLp++)
                {
                    HySString csKey = csKeyList.GetData(lLp) as HySString;
                    csSetTime = m_csTimerTable[csKey] as HySTime;
                    if (csSetTime != null)
                    {
                        if (m_csNowTime.After(csSetTime) == true)
                        {
                            HySID csID = new HySID(csKey);
                            m_csTimerTable.DeleteData(csKey);
                            this.WatchDogTimerOut(csID, csSetTime);
                        }
                    }
                }
            }

        }
        /// <summary><para>method outline:</para>
        /// <para>スレッド起動（別スレッドで this.WatchDogThreadStart()が動作を開始する）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ThreadStart() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void WatchDogThreadStart()
        {
            ThreadStart ThSt = new ThreadStart(this.WatchDogThreadRun);
            Thread t = new Thread(ThSt);
            t.Start();

        }
        /// <summary><para>method outline:</para>
        /// <para>スレッド処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> スレッド起動時に呼ばれる </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void WatchDogThreadRun()
        {
            for (; ; )
            {
                if (base.m_bWorkFlg == false)
                {
                    break;
                }
                this.WatchDogTimer();
                Thread.Sleep(777);
            }
            return;
        }
        /// <summary><para>method outline:</para>
        /// <para>タイムアウト検出時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> WatchDogTimerOut(csKeyID,csSetTime) </para>
        /// </example>
        /// <param name="csKeyID">タイマーID</param>
        /// <param name="csSetTime">設定時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>タイムアウトを検出した時にコールされる</para>
        /// </remarks>
        protected virtual void WatchDogTimerOut(HySID csKeyID, HySTime csSetTime)
        {
            if (McSTGSysBusiProcedureBase.STGSysTimerID.Equals(csKeyID) == true)
            {
                if (this.CmndCalPrjTimeOut(csSetTime) == true)
                {
                    if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Repeat)
                    {   // 繰り返し計算ならば
                        csSetTime = csSetTime + m_csSTGMngData.GetSTGCalIntervalTime();
                        this.SetTimer(McSTGSysBusiProcedureBase.STGSysTimerID, csSetTime);  // タイマー再設定
                    }
                }
            }
            else
            {
                this.TimeOut(csKeyID, csSetTime);
            }
        }

        // ======== 派生側で実装すべきメソッド関係 =========

        /// <summary><para>method outline:</para>
        /// <para>システム固有のフィードバック情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSTGSysFeedbackDataBase csFeedbackData = CreateFeedbackData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McSTGSysFeedbackDataBase CreateFeedbackData()
        {
            return new McSTGSysFeedbackDataBase();
        }

        /// <summary><para>method outline:</para>
        /// <para>システム起動直後の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = StartBusiProc(csHySEvent) </para>
        /// </example>
        /// <param name="csHySEvent">送られたイベント</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool StartBusiProc(HySEventObject csHySEvent);

        /// <summary><para>method outline:</para>
        /// <para>TGC計算指定時刻になったが、今だ計算続行中等により計算開始出来ない事を通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CannotCalStart(csSetTime) </para>
        /// </example>
        /// <param name="csSetTime">TGC計算に設定されていた時刻</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool CannotCalStart(HySTime csSetTime);
        /// <summary><para>method outline:</para>
        /// <para>TGC計算指定時刻になったことを通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalculationTimerOut( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// this.m_eSTGCalMode == STGCalMode.ASYNCHRONOUS_CAL　の時
        /// コールされる
        /// （this.m_eSTGCalMode == STGCalMode.SYNCHRONOUS_CAL　の時はコールされない）
        /// </para>
        /// </remarks>
        abstract protected void CalculationTimerOut();

        /// <summary><para>method outline:</para>
        /// <para>モデル構築通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeModelConstruction(csPrjID,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">構築されたプロジェクトＩＤ</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool NoticeModelConstruction(HySID csPrjID, HySSimulationDataContainer csDtCnt);
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化完了通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeCalInitialize(csPrjID,csFeedBackData,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">初期化されたプロジェクトＩＤ</param>
        /// <param name="csFeedBackData">プロジェクトが保持するフィードバック情報</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool NoticeCalInitialize(HySID csPrjID, McSTGSysFeedbackDataBase csFeedBackData, HySSimulationDataContainer csDtCnt);
        /// <summary><para>method outline:</para>
        /// <para>計算開始通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeCalStart(csPrjID,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">計算開始したプロジェクトＩＤ</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>特別な処理がなければオーバーライドメソッドをコーディングする必要なし</para>
        /// </remarks>
        virtual protected bool NoticeCalStart(HySID csPrjID, HySSimulationDataContainer csDtCnt)
        { return true; }
        /// <summary><para>method outline:</para>
        /// <para> 計算完了通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeCalComplete(csPrjID,csFeedBackData,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">計算が完了したプロジェクトＩＤ</param>
        /// <param name="csFeedBackData">プロジェクトが保持するフィードバック情報</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool NoticeCalComplete(HySID csPrjID, McSTGSysFeedbackDataBase csFeedBackData, HySSimulationDataContainer csDtCnt);

        /// <summary><para>method outline:</para>
        /// <para> TGCを構成する全プロジェクトの計算完了通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSTGCalComplete( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool NoticeSTGCalComplete();

        /// <summary><para>method outline:</para>
        /// <para>SetTimer()で設定した時刻のタイムアウト検出通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = TimeOut(csKeyID,csSetTime) </para>
        /// </example>
        /// <param name="csKeyID">SetTimer() で　指定したタイマーＩＤ</param>
        /// <param name="csSetTime">SetTimer() で指定した時刻</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 特別な処理がなければオーバーライドメソッドをコーディングする必要なし。
        /// 精度：　PC内のシステム時刻に対して 約＋－１秒
        /// </para>
        /// </remarks>
        virtual protected bool TimeOut(HySID csKeyID, HySTime csSetTime)
        { return true; }

        /// <summary><para>method outline:</para>
        /// <para>システム固有ヘルプ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DispSysHelp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract protected bool DispSysHelp();

        // ------------------------------------------------
        //  常数
        // ------------------------------------------------
        /// <summary>TGC計算呼び出しタイマーID </summary>
        readonly static HySID STGSysTimerID = new HySID("__STGSysTimerID__");


    }
}
