﻿// <summary>ソースコード：業務ファクトリクラスベース</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.BusiProc;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGC業務ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public abstract class McSTGSysBusiProcedureFactoryBase : McBusiProcedureFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSTGSysBusiProcedureFactoryBase csFactory = new McSTGSysBusiProcedureFactoryBase()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSTGSysBusiProcedureFactoryBase()
        {
            HySCommonInfoHash.CreateTable(McSTGSysDefine.TABLE_KEY_FEEDBACK_DATA);
        }

        /// <summary><para>method outline:</para>
        /// <para>業務クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure csBusiProc = CreateBusiProcedure( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySBusiProcedure CreateBusiProcedure()
        {
            return this.CreateSTGBusiProcedure();
        }
        /// <summary><para>method outline:</para>
        /// <para>業務クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure csBusiProc = CreateSTGBusiProcedure( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public HySBusiProcedure CreateSTGBusiProcedure();
    }
}
