﻿// <summary>ソースコード：クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Model;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGCを構成する各プロジェクト情報管理データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McSTGSysCtlInfo : HySDataRoot
    {
        /// <summary>計算制御状態</summary>
        internal long m_lCtlStatus = McSTGSysCtlInfo.BEFOR_CREATE;
        /// <summary>計算状態(ｼﾐｭﾚｰｼｮﾝ状態)</summary>
        protected long m_lCalStatus = McSTGSysCtlInfo.BEFOR_CREATE;
        /// <summary>ｼﾐｭﾚｰｼｮﾝ進捗状況(%)</summary>
        protected long m_lProgress = 0;

        /// <summary>プロジェクトグループ名称</summary>
        protected HySString m_csPrjctGroupName=null;
        /// <summary>プロジェクトファイル名称</summary>
        protected HySString m_csPrjctFileName=null;


        /// <summary>プロジェクト保存ファイル名称</summary>
        protected HySString m_csSavePrjctFileName = null;



        //-- 各種セッター --//
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名称設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetProjectGroupName(csGrName)</para>
        /// </example>
        /// <param name="csGrName">プロジェクトグループ名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetProjectGroupName(HySString csGrName)
        { m_csPrjctGroupName = csGrName; }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイル名称設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetProjectFileName(csFileName)</para>
        /// </example>
        /// <param name="csFileName">プロジェクトファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetProjectFileName(HySString csFileName)
        { m_csPrjctFileName = csFileName; }

        /// <summary><para>method outline:</para>
        /// <para>計算制御状態設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCtlStatus(lStatus)</para>
        /// </example>
        /// <param name="lStatus">計算制御状態</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetCtlStatus(long lStatus)
        { m_lCtlStatus = lStatus; }

        /// <summary><para>method outline:</para>
        /// <para>計算状態設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCalStatus(lStatus)</para>
        /// </example>
        /// <param name="lStatus">計算状態(ｼﾐｭﾚｰｼｮﾝ状態)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCalStatus(long lStatus)
        { m_lCalStatus = lStatus; }

        /// <summary><para>method outline:</para>
        /// <para>ｼﾐｭﾚｰｼｮﾝ進捗状況設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCalProgress(lProgress)</para>
        /// </example>
        /// <param name="lProgress">ｼﾐｭﾚｰｼｮﾝ進捗状況(%)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCalProgress(long lProgress)
        { m_lProgress = lProgress; }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト保存ファイル名称設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetProjectSaveFileName(csFileName)</para>
        /// </example>
        /// <param name="csFileName">プロジェクト保存ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetProjectSaveFileName(HySString csFileName)
        { m_csSavePrjctFileName = csFileName; }


        //-- 各種ゲッター --//
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetProjectGrName()</para>
        /// </example>
        /// <returns>プロジェクトグループ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectGrName()
        {
            return m_csPrjctGroupName;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイル名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetProjectFileName()</para>
        /// </example>
        /// <returns>プロジェクトファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectFileName()
        {
            //HySString csDtHome = HySEnvInf.GetDataHomeDirectory();
            //HySString csRtnFileName = csDtHome + new HySString("\\") + m_csPrjctGroupName + new HySString("\\") + m_csPrjctFileName;
            return m_csPrjctFileName;
        }

        /// <summary><para>method outline:</para>
        /// <para>パス付プロジェクトファイル名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetProjectFileNameWithPath()</para>
        /// </example>
        /// <returns>パス付プロジェクトファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectFileNameWithPath()
        {
            HySString csDtHome = HySEnvInf.GetDataHomeDirectory();
            HySString csRtnFileName = csDtHome + new HySString("\\") + m_csPrjctGroupName + new HySString("\\") + m_csPrjctFileName;
            return csRtnFileName;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算制御状態取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCtlStatus()</para>
        /// </example>
        /// <returns>計算制御状態</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal long GetCtlStatus()
        { return m_lCtlStatus; }

        /// <summary><para>method outline:</para>
        /// <para>計算状態取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCalStatus()</para>
        /// </example>
        /// <returns>計算状態(ｼﾐｭﾚｰｼｮﾝ状態)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCalStatus()
        { return m_lCalStatus; }

        /// <summary><para>method outline:</para>
        /// <para>ｼﾐｭﾚｰｼｮﾝ進捗状況取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCalProgress()</para>
        /// </example>
        /// <returns>ｼﾐｭﾚｰｼｮﾝ進捗状況(%)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCalProgress()
        { return m_lProgress; }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト保存ファイル名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetProjectSaveFileName()</para>
        /// </example>
        /// <returns>プロジェクト保存ファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectSaveFileName()
        {
            //HySString csDtHome = HySEnvInf.GetDataHomeDirectory();
            //HySString csRtnFileName = csDtHome + new HySString("\\") + m_csPrjctGroupName + new HySString("\\STG\\") + m_csSavePrjctFileName;
            return m_csSavePrjctFileName;
        }


        // ------------------------------------------------
        //  常数
        // ------------------------------------------------
        /// <summary>最初の値</summary>
        public readonly static long BEFOR_CREATE = -999;
        /// <summary>デフォルト</summary>
        public readonly static long DEFAULT_STATE = -2;
        /// <summary>モデル生成完了状態</summary>
        public readonly static long MODEL_EXIST_STATE = -1;
        /// <summary>モデル生成完了状態</summary>
        public readonly static long MODEL_CONSTRUCTION_STATE = 0;
        /// <summary>初期化完了状態</summary>
        public readonly static long INITIAL_STATE = 1;
        /// <summary>計算中状態</summary>
        public readonly static long CALCULATION_STATE = 2;
        /// <summary>中断状態</summary>
        public readonly static long PAUSE_STATE = 3;
        /// <summary>再開段階状態</summary>
        public readonly static long RESTART_STATE = 4;
        /// <summary>強制終了状態</summary>
        public readonly static long STOP_STATE = 5;
        /// <summary>計算完了状態</summary>
        public readonly static long END_STATE = 6;
    }
}
