﻿// <summary>ソースコード：クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGC情報管理データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McSTGSysManageData : HySDataContainer, HySVersionManagement
    {
        /// <summary>計算制御情報テーブル</summary>
        protected HySDataHashTable m_csInfoTable = new HySDataHashTable();

        /// <summary>TGC計算開始時刻</summary>
        protected HySTime m_csSTGCalStartTime = HySCalendar.CreateNowTime();
        /// <summary>TGC計算起動間隔</summary>
        protected HySTime m_csSTGCalIntervalTime = new HySTime(0, 10, 0);

        /// <summary>シミュレーションの初期時刻</summary>
        protected HySTime m_csStartTime = HySCalendar.CreateNowTime() - new HySTime(6, 0, 0);
        /// <summary>シミュレーションの目標時刻</summary>
        protected HySTime m_csGoalTime = HySCalendar.CreateNowTime() + new HySTime(6, 0, 0);
        /// <summary>シミュレーションの計算期間</summary>
        protected HySTime m_csCalPeriod = new HySTime(6+6, 0, 0);
        /// <summary>繰り返し計算有無</summary>
        protected STGCalType m_eSTGCalType = STGCalType.Repeat;
        /// <summary>モデルの計算モード </summary>
        protected STGCalMode m_eSTGCalMode = STGCalMode.SYNCHRONOUS_CAL;
        /// <summary>CSVファイル名称情報</summary>
        protected List<string> m_csFileNameList = new List<string>();

        /// <summary>計算方式</summary>
        public enum STGCalType
        {
            /// <summary>１回のみ</summary>
            Once = -1,
            /// <summary>繰り返し</summary>
            Repeat
        }

        /// <summary>モデルの計算モード </summary>
        public enum STGCalMode
        {
            /// <summary>モデルが一斉に計算を行う場合 </summary>
            SYNCHRONOUS_CAL = 0,
            /// <summary>モデルが個別に計算を行う場合 </summary>
            ASYNCHRONOUS_CAL
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataContainer csDataContainer = new HySDataContainer(csSimulatorKind, csSTGName)</para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csSTGName">TGC名称</param>
        /// <returns>HySDataContainer  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSTGSysManageData(HySKind csSimulatorKind, HySString csSTGName)
            : base(csSimulatorKind, new HySID(csSTGName))
        {
            //バージョン情報設定
            SetNowVersion();
            m_csDataID = new HySID("TaskGroup");
        }

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para></para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        ~McSTGSysManageData()
        {
            if (m_csInfoTable != null)
            {
                m_csInfoTable.ClearAllObject();
            }
            m_csInfoTable = null;
        }

        // 各種Ｇｅｔｔｅｒ，Ｓｅｔｔｅｒ
        /// <summary><para>method outline:</para>
        /// <para>CSVファイル名称設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCSVFileName(csNameList)</para>
        /// </example>
        /// <param name="csNameList">CSVファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCSVFileName(List<string> csNameList)
        {
            m_csFileNameList = csNameList;
        }

        /// <summary><para>method outline:</para>
        /// <para>CSVファイル名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCSVFileName()</para>
        /// </example>
        /// <returns>CSVファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual List<string> GetCSVFileName()
        {
            return m_csFileNameList;
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC名称設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetSTGName(csName)</para>
        /// </example>
        /// <param name="csName">TGC名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSTGName(HySString csName)
        {
            m_csDataID = new HySID(csName);
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetSTGName()</para>
        /// </example>
        /// <returns>TGC名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetSTGName()
        {
            return (HySString)m_csDataID.GetString();
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC計算開始時刻設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetSTGCalStartTime(csTim)</para>
        /// </example>
        /// <param name="csTim">TGC計算開始時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSTGCalStartTime(HySTime csTim)
        { m_csSTGCalStartTime = csTim; }

        /// <summary><para>method outline:</para>
        /// <para>TGC計算開始時刻取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetSTGCalStartTime()</para>
        /// </example>
        /// <returns>TGC計算開始時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetSTGCalStartTime()
        { return m_csSTGCalStartTime; }

        /// <summary><para>method outline:</para>
        /// <para>TGC計算起動間隔設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetSTGCalIntervalTime(csTim)</para>
        /// </example>
        /// <param name="csTim">TGC計算起動間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSTGCalIntervalTime(HySTime csTim)
        { m_csSTGCalIntervalTime = csTim; }

        /// <summary><para>method outline:</para>
        /// <para>TGC計算起動間隔取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetSTGCalIntervalTime()</para>
        /// </example>
        /// <returns>TGC計算起動間隔</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetSTGCalIntervalTime()
        { return m_csSTGCalIntervalTime; }

        /// <summary><para>method outline:</para>
        /// <para>繰り返し計算有無の設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetSTGCalType(eCalType)</para>
        /// </example>
        /// <param name="eCalType">繰り返し計算有無</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSTGCalType(STGCalType eCalType)
        { m_eSTGCalType = eCalType; }

        /// <summary><para>method outline:</para>
        /// <para>繰り返し計算有無の取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetSTGCalType()</para>
        /// </example>
        /// <returns>繰り返し計算有無</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual STGCalType GetSTGCalType()
        { return m_eSTGCalType; }

        /// <summary><para>method outline:</para>
        /// <para>モデルの計算モード設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetSTGCalMode(eSTGCalMode)</para>
        /// </example>
        /// <param name="eSTGCalMode">モデルの計算モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetSTGCalMode(STGCalMode eSTGCalMode)
        { m_eSTGCalMode = eSTGCalMode; }

        /// <summary><para>method outline:</para>
        /// <para>モデルの計算モード取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetSTGCalMode()</para>
        /// </example>
        /// <returns>モデルの計算モード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual STGCalMode GetSTGCalMode()
        { return m_eSTGCalMode; }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの初期時刻設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCalStartTime(csTim)</para>
        /// </example>
        /// <param name="csTim">シミュレーションの初期時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCalStartTime(HySTime csTim)
        { m_csStartTime = csTim; }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの初期時刻取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCalStartTime()</para>
        /// </example>
        /// <returns>シミュレーションの初期時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetCalStartTime()
        { return m_csStartTime; }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの計算期間設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCalPeriod(csTime)</para>
        /// </example>
        /// <param name="csTime">シミュレーションの計算期間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCalPeriod(HySTime csTime)
        { m_csCalPeriod.SetTime(csTime); }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの計算期間取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCalPeriod()</para>
        /// </example>
        /// <returns>シミュレーションの計算期間</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetCalPeriod()
        { return m_csCalPeriod; }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの目標時刻設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCalGoalTime(csTim)</para>
        /// </example>
        /// <param name="csTim">シミュレーションの目標時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCalGoalTime(HySTime csTim)
        { m_csGoalTime = csTim; }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションの目標時刻取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetCalGoalTime()</para>
        /// </example>
        /// <returns>シミュレーションの目標時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetCalGoalTime()
        { return m_csGoalTime; }

        /// <summary><para>method outline:</para>
        /// <para>初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>new された直後の状態にする</para>
        /// </remarks>
        public virtual void Clear()
        {
            this.DeleteAllData();
            m_csSTGCalStartTime = HySCalendar.CreateNowTime();
            m_csSTGCalIntervalTime = new HySTime(0, 10, 0);
            m_csStartTime = HySCalendar.CreateNowTime() - new HySTime(6, 0, 0);
            m_csGoalTime = HySCalendar.CreateNowTime() + new HySTime(6, 0, 0);
            m_csCalPeriod = new HySTime(6 + 6, 0, 0);
            m_eSTGCalType = STGCalType.Repeat;
            m_eSTGCalMode = STGCalMode.SYNCHRONOUS_CAL;
            m_csFileNameList = new List<string>();
            this.SetSTGName(new HySString(""));
        }

        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトのプロジェクト管理情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataCtlInfo(csKeyID,csDtContainer,csCtlInfo) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <param name="csCtlInfo">プロジェクト管理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataCtlInfo(HySID csKeyID, McSTGSysCtlInfo csCtlInfo)
        {
            HySString csStringID = csKeyID.GetString() as HySString;

            // ０．プロジェクトファイルの名称を先に設定しておく
            csCtlInfo.SetProjectSaveFileName(new HySString(csKeyID.ToString()) + csCtlInfo.GetProjectFileName());
            
            // １．プロジェクト管理情報を管理下に置く
            m_csInfoTable.SetObject(csStringID, csCtlInfo);


            // ２．プロジェクトコンテナをファイルから読み出して、設定する。
            HySString csOpenFileName = csCtlInfo.GetProjectFileNameWithPath();
            HySFile csPrjFile = new HySFile(csOpenFileName);
            try
            {
                csPrjFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                HySSimulationDataContainer csContainer = csPrjFile.DataRead() as HySSimulationDataContainer;
                csPrjFile.Close();
                if (csContainer != null)
                {   // 管理すべきデータコンテナが見つかったなら
                    HySID csNewID = csKeyID;
                    McStructInfo csStructInfo = csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO) as McStructInfo;
                    McProjectInfData csProjectInfData = csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO) as McProjectInfData;

                    // コンテナ内の情報のＩＤを変更する
                    csStructInfo.SetID(csNewID);  // ID の変更
                    csContainer.SetID(csNewID);  // ID の変更
                    csProjectInfData.SetProjectID(csNewID);  // ID の変更

                    // プロジェクト情報を別ファイルとしてセーブし直す
                    HySString csSaveFileName = this.GetSavePrjctFileNameWithPath(csKeyID);
                    HySFile csSaveFile = new HySFile(csSaveFileName);
                    if (csSaveFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
                    {   // 
                        csSaveFile.DataWrite(csContainer);
                        csSaveFile.Close();
                    }

                    // コンテナを管理下に置く
                    this.SetDataContainer(csNewID,csContainer);
                }
            }
            catch (Exception ex)
            {
                // Do Nothing
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトのデータコンテナを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataContainer(csKeyID,csDtContainer,csCtlInfo) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <param name="csDtContainer">データコンテナ</param>
        /// <param name="csCtlInfo">プロジェクト管理情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataContainer(HySID csKeyID, HySSimulationDataContainer csDtContainer, McSTGSysCtlInfo csCtlInfo)
        {
            HySString csStringID = csKeyID.GetString() as HySString;
            m_csDataTable.SetObject(csStringID, csDtContainer);
            m_csInfoTable.SetObject(csStringID, csCtlInfo);
        }
        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトのデータコンテナを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataContainer(csKeyID,csDtContainer) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <param name="csDtContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataContainer(HySID csKeyID, HySSimulationDataContainer csDtContainer)
        {
            HySString csStringID = csKeyID.GetString() as HySString;
            m_csDataTable.SetObject(csStringID, csDtContainer);
        }

        /// <summary><para>method outline:</para>
        /// <para>指定プロジェクトを管理状態から外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteData(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DeleteData(HySID csKeyID)
        {
            HySString csStringID = csKeyID.GetString() as HySString;
            m_csDataTable.DeleteData((HySString)csStringID);
            m_csInfoTable.DeleteData((HySString)csStringID);
        }

        /// <summary><para>method outline:</para>
        /// <para>全データ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteAllData() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void DeleteAllData()
        {
            m_csDataTable.ClearAllObject();
            m_csInfoTable.ClearAllObject();
        }

        /// <summary><para>method outline:</para>
        /// <para>指定ＩＤのデータコンテナ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulationDataContainer csCnt = GetDataContainer(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <returns>HySSimulationDataContainer</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySSimulationDataContainer GetDataContainer(HySID csKeyID)
        {
            HySSimulationDataContainer csRtn = null;
            HySString csStringID = csKeyID.GetString() as HySString;
            csRtn = m_csDataTable.GetObject(csStringID) as HySSimulationDataContainer;
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定ＩＤのプロジェクト管理情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSTGSysCtlInfo csCtlInf = GetCtlInfo(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <returns>McSTGSysCtlInfo</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McSTGSysCtlInfo GetCtlInfo(HySID csKeyID)
        {
            McSTGSysCtlInfo csRtn = null;
            HySString csStringID = csKeyID.GetString() as HySString;
            csRtn = m_csInfoTable.GetObject(csStringID) as McSTGSysCtlInfo;
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>管理されているプロジェクト識別子リストの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csList = GetKeyList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 識別子をリストで返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetKeyList()
        {
            return m_csInfoTable.GetKeyList();
        }

        /// <summary><para>method outline:</para>
        /// <para>指定ＩＤのプロジェクト情報保存ファイルの名称をフルパスで返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csFileName = GetSavePrjctFileNameWithPath(csKeyID) </para>
        /// </example>
        /// <param name="csKeyID">プロジェクト識別ＩＤ</param>
        /// <returns>HySString</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetSavePrjctFileNameWithPath(HySID csKeyID)
        {
            HySString csRtnStr = new HySString("");
            McSTGSysCtlInfo csCtlInf = this.GetCtlInfo(csKeyID);
            if (csCtlInf != null)
            {
                HySString csDtHome = HySEnvInf.GetDataHomeDirectory();
                csRtnStr = csDtHome + new HySString("\\") +
                    csCtlInf.GetProjectGrName() + new HySString("\\STG\\") +
                    this.GetSTGName() + new HySString("\\") +
                    csCtlInf.GetProjectSaveFileName();
            }
            return csRtnStr;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
