﻿// <summary>ソースコード：常数定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGC関連ＤＬＬ内で使用する共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class McSTGSysDefine
    {

        // フィードバック情報取得プロジェクトグループ名称キー
        /// <summary> ﾌｨｰﾄﾞﾊﾞｯｸ情報取得キー </summary>
        public static readonly string TABLE_KEY_FEEDBACK_DATA = "McSTGFeedbackTable";

        //---------------------------------
        // コンテナ内データ取得キー
        //---------------------------------
        /// <summary> ﾌｨｰﾄﾞﾊﾞｯｸ情報取得キー </summary>
        public static readonly HySString DATA_KEY_FEEDBACK_DATA = new HySString("McSTGFeedbackData");

        //---------------------------------
        // イベント番号
        //---------------------------------
        //// <summary> TGC新規作成 </summary>
        //public static readonly long EVNO_NEW_STG = -10001;
        /// <summary> TGCオープン </summary>
        public static readonly long EVNO_OPEN_STG = -10002;
        /// <summary> TGC上書き保存 </summary>
        public static readonly long EVNO_SAVE_STG = -10003;
        /// <summary> TGC別名保存 </summary>
        public static readonly long EVNO_NEW_SAVE_STG = -10004;
        /// <summary> TGCオープン完了報告 </summary>
        public static readonly long EVNO_NOTICE_OPEN_STG = -10005;

        /// <summary> TGC設定データ </summary>
        public static readonly long EVNO_CREATE_STGSET_DATA = -10101;
        /// <summary> TGC設定完了 </summary>
        public static readonly long EVNO_SET_STG_COMPLETE = -10102;
        /// <summary> TGCモデル生成完了報告 </summary>
        public static readonly long EVNO_NOTICE_STG_MODELCONSTRUCTION = -10103;
        /// <summary> TGCモデル初期化報告 </summary>
        public static readonly long EVNO_NOTICE_STG_INITIALIZE = -10104;
        /// <summary> TGCモデル計算開始報告 </summary>
        public static readonly long EVNO_NOTICE_STG_CAL_START = -10105;
        /// <summary> TGCモデル計算終了報告 </summary>
        public static readonly long EVNO_NOTICE_STG_CAL_STOP = -10106;
        /// <summary> TGCモデル計算完了報告 </summary>
        public static readonly long EVNO_NOTICE_STG_CAL_COMPLETE = -10107;
        /// <summary> TGC設定画面再描画 </summary>
        public static readonly long EVNO_REDRAW_STG_CTL_SCREEN = -10108;
        /// <summary> TGCモデル生成完了異常報告 </summary>
        public static readonly long EVNO_NOTICE_NG_STG_MODELCONSTRUCTION = -10109;

        /// <summary> TGC計算開始指示 </summary>
        public static readonly long EVNO_CMND_STG_CAL_START = -10111;
        /// <summary> TGC計算終了指示 </summary>
        public static readonly long EVNO_CMND_STG_CAL_STOP = -10112;
        /// <summary> TGC計算リセット指示 </summary>
        public static readonly long EVNO_CMND_STG_CAL_RESET = -10113;

        /// <summary> SYSTEMヘルプ表示 </summary>
        public static readonly long EVNO_CMND_DISP_HELP = -10201;
        /// <summary> SYSTEM マニュアル表示 </summary>
        public static readonly long EVNO_CMND_SHOW_MANUAL = -10202;

        /// <summary>ユーザー定義システム画面表示指示</summary>
        public static readonly long EVNO_CMND_DISP_USER_SYS_SCREEN = -10210;

        // =======================
        // 画面識別子関係
        // =======================
        /// <summary>TGC計算制御画面識別子</summary>
        static public readonly HySID STG_CAL_CTL_SCREEN_ID = new HySID("STGCalCtlScreen");

        /// <summary>TGC計算制御画面種別</summary>
        static public readonly HySObjectKind STG_CAL_CTL_SCREEN = new HySObjectKind("Hymco.Screen.STGCalCtl");

    }
}
