﻿// <summary>ソースコード：画面フォームクラス</summary>
// <remarks>

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.IO;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemViewBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGC計算制御画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public partial class McSTGCalCtlForm : HySDotNetForm //Form
    {
        /// <summary>TGC計算制御画面</summary>
        protected McSTGCalCtlScreen m_csSTGCalCtlScreen=null;

        /// <summary>現在のTGC表示頁(0～3)</summary>
        protected int m_iSTGPage = 0;

        /// <summary>TGC情報管理データ</summary>
        protected McSTGSysManageData m_csSTGMngData=null;

        /// <summary>表示自動更新</summary>
        protected bool bAutoRefleshFlg = false;

        /// <summary>CSVファイル名称入力フラグ</summary>
        protected bool m_bCsvFileNameInputFlg = false;

        /// <summary>設定済みプロジェクトGr名称</summary>
        protected HySString m_csPrjGrName = new HySString("");

        /// <summary>プロジェクト識別子1</summary>
        protected HySID m_csPrj01 = new HySID("Prj01");

        /// <summary>プロジェクト識別子2</summary>
        protected HySID m_csPrj02 = new HySID("Prj01");

        /// <summary>プロジェクト識別子3</summary>
        protected HySID m_csPrj03 = new HySID("Prj02");

        /// <summary>プロジェクト識別子4</summary>
        protected HySID m_csPrj04 = new HySID("Prj03");

        /// <summary>プロジェクト識別子5</summary>
        protected HySID m_csPrj05 = new HySID("Prj04");

        /// <summary>タブロックフラグ</summary>
        protected bool m_bTabLockFlg = false;

        /// <summary>色管理テーブル</summary>
        protected Hashtable m_csTextBoxColorTbl = null;

        /// <summary>メッセージボックスタイトル『CSVファイル生成』</summary>
        private static readonly string MSGBOX_TITLE = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_TITLE_MAKECSV;
        /// <summary>メッセージボックスタイトル『TaskGroup制御機能』</summary>
        private static readonly string MSGBOX_TITLE2 = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_TITLE_TASKGROUP;
        /// <summary>「処理中にエラーが発生しました。詳細はログファイルを参照ください。」</summary>
        private static readonly string MSG_ERROR_MAKECSV = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_MAKECSV;
        /// <summary>「ファイル名には次の文字は使えません。」</summary>
        private static readonly string MSG_ERROR_NOT_USE_CHAR = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_NOT_USE_CHAR;
        /// <summary>「ファイル名を入力してください。」</summary>
        private static readonly string MSG_ERROR_FILENAME = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_FILENAME;
        /// <summary>「未入力の項目があります。」</summary>
        private static readonly string MSG_ERROR_NON_INPUT = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_NON_INPUT;
        /// <summary>「使用できない文字列が含まれています。」</summary>
        private static readonly string MSG_ERROR_NOT_USE_TEXT = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_NOT_USE_TEXT;
        /// <summary>「計算期間設定が正しくありません。」</summary>
        private static readonly string MSG_ERROR_CAL_TERM = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_CAL_TERM;
        /// <summary>「開始予定時刻設定が正しくありません。」</summary>
        private static readonly string MSG_ERROR_CAL_TIME = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_CAL_TIME;
        /// <summary>「追加済みプロジェクトはTaskGroup制御画面上からクリアされます。」</summary>
        private static readonly string MSG_INFO_ADD_PROJECT = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_INFO_ADD_PROJECT;


        # region プログレスバーによる進捗確認用
        ///// <summary>計算進捗要求用タイマーインスタンス</summary>
        //protected System.Threading.Timer m_csThreadTimerInstance = null;

        ///// <summary>非同期動作追跡クラス</summary>
        //AsyncOperation m_csAO = null;

        ///// <summary>タイマーメソッドデリゲート</summary>
        //System.Threading.SendOrPostCallback m_d_PostCallback = null;
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト識別子生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MakePrjID()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void MakePrjID()
        {
            if (m_iSTGPage == 0) { m_csPrj01 = new HySID("Prj01"); m_csPrj02 = new HySID("Prj02"); m_csPrj03 = new HySID("Prj03"); m_csPrj04 = new HySID("Prj04"); m_csPrj05 = new HySID("Prj05"); }
            else if (m_iSTGPage == 1) { m_csPrj01 = new HySID("Prj06"); m_csPrj02 = new HySID("Prj07"); m_csPrj03 = new HySID("Prj08"); m_csPrj04 = new HySID("Prj09"); m_csPrj05 = new HySID("Prj10"); }
            else if (m_iSTGPage == 2) { m_csPrj01 = new HySID("Prj11"); m_csPrj02 = new HySID("Prj12"); m_csPrj03 = new HySID("Prj13"); m_csPrj04 = new HySID("Prj14"); m_csPrj05 = new HySID("Prj15"); }
            else { m_csPrj01 = new HySID("Prj16"); m_csPrj02 = new HySID("Prj17"); m_csPrj03 = new HySID("Prj18"); m_csPrj04 = new HySID("Prj19"); m_csPrj05 = new HySID("Prj20"); }

            PrevButtonE.Enabled = true; PrevButtonD.Enabled = true; NextButtonE.Enabled = true; NextButtonD.Enabled = true;
            if (m_iSTGPage == 0) { PrevButtonE.Enabled = false; PrevButtonD.Enabled = false; }
            else if (m_iSTGPage == 3) { NextButtonE.Enabled = false; NextButtonD.Enabled = false; }

            PrjID1_E.Text = m_csPrj01.ToString(); PrjID1_D.Text = m_csPrj01.ToString();
            PrjID2_E.Text = m_csPrj02.ToString(); PrjID2_D.Text = m_csPrj02.ToString();
            PrjID3_E.Text = m_csPrj03.ToString(); PrjID3_D.Text = m_csPrj03.ToString();
            PrjID4_E.Text = m_csPrj04.ToString(); PrjID4_D.Text = m_csPrj04.ToString();
            PrjID5_E.Text = m_csPrj05.ToString(); PrjID5_D.Text = m_csPrj05.ToString();
        }

        /// <summary><para>method outline:</para>
        /// <para>計算期間の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCalcTerm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void SetCalcTerm()
        {
            if (SimuCycleRadioBtnE.Checked == true)
            {   // 周期起動ならば
                m_csSTGMngData.SetSTGCalType(McSTGSysManageData.STGCalType.Repeat);

                double dInterval = (double)Int32.Parse(CalCycleTextBoxE.Text) * 60.0;
                m_csSTGMngData.SetSTGCalIntervalTime(new HySTime(dInterval));

                long lYear = 0; long lMonth = 0; long lDay = 0; long lHour = 0; long lMin = 0; long lSec = 0;
                HySCalendar.GetNowTime(ref lYear, ref lMonth, ref lDay, ref lHour, ref lMin, ref lSec);
                HourTextBox.Text = lHour.ToString();
                MinTextBox.Text = lMin.ToString();
                lHour = Int32.Parse(HourTextBox.Text);
                lMin = Int32.Parse(MinTextBox.Text);

                HySTime csSTGStartTime = HySCalendar.CreateTime(lYear, lMonth, lDay, lHour, lMin, 0);
                m_csSTGMngData.SetSTGCalStartTime(csSTGStartTime);

                long lStart = Int32.Parse(CalStartPeriodTextBoxE.Text) * 60;
                long lEnd = Int32.Parse(CalGoalPeriodTextBoxE.Text) * 60;
                m_csSTGMngData.SetCalPeriod(new HySTime(lStart + lEnd));

                m_csSTGMngData.SetCalStartTime(csSTGStartTime - new HySTime(lStart));
                m_csSTGMngData.SetCalGoalTime(csSTGStartTime + new HySTime(lEnd));
            }
            else
            {   // 期間限定一回計算の場合
                m_csSTGMngData.SetSTGCalType(McSTGSysManageData.STGCalType.Once);

                DateTime csStim = SimuDayStartTimeD.Value;
                m_csSTGMngData.SetCalStartTime(HySCalendar.Exchange(csStim));
                DateTime csEtim = SimuDayEndTimeD.Value;
                m_csSTGMngData.SetCalGoalTime(HySCalendar.Exchange(csEtim));
                m_csSTGMngData.SetCalPeriod(m_csSTGMngData.GetCalGoalTime() - m_csSTGMngData.GetCalStartTime());
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McSTGCalCtlForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSTGCalCtlForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McSTGCalCtlForm()
        {
            InitializeComponent();
        }
              
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSTGCalCtlForm csDotNetForm = new McSTGCalCtlForm(csScreen)</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McSTGCalCtlForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSTGCalCtlForm(HySScreen csScreen)
        {
            InitializeComponent();
            # region プログレスバーによる進捗確認用
            //// 計算進捗要求用タイマー
            //System.Threading.TimerCallback timerDelegate = new System.Threading.TimerCallback(ReportOrderTimer_Tick);
            //// 更新間隔（初期値）
            //// タイマーインスタンス生成（まだ開始しない）
            //m_csThreadTimerInstance = new System.Threading.Timer(timerDelegate, null, System.Threading.Timeout.Infinite, 1000);
            //m_csAO = AsyncOperationManager.CreateOperation(this);
            //m_d_PostCallback = new System.Threading.SendOrPostCallback(ReportOrderTimer_Work);
            # endregion
            // 背景色の初期設定
            m_csTextBoxColorTbl = new Hashtable();
            m_csTextBoxColorTbl["Prj01"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj02"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj03"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj04"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj05"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj06"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj07"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj08"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj09"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj10"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj11"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj12"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj13"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj14"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj15"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj16"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj17"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj18"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj19"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj20"] = SystemColors.Control;
            m_csSTGCalCtlScreen = csScreen as McSTGCalCtlScreen;
            base.SetScreen(csScreen);
        }

        /// <summary>閉じるボタンを無効化 </summary>
        protected override System.Windows.Forms.CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;

                // ClassStyle に CS_NOCLOSE ビットを立てる
                CreateParams cp = base.CreateParams;
                cp.ClassStyle = cp.ClassStyle | CS_NOCLOSE;

                return cp;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC情報管理データの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSTGMngData(csSTGMngData)</para>
        /// </example>
        /// <param name="csSTGMngData">TGC情報管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSTGMngData(McSTGSysManageData csSTGMngData)
        {
            m_csSTGMngData = csSTGMngData;

            STGNameTextBoxE.Text = m_csSTGMngData.GetSTGName().ToString();
            STGNameTextBoxD.Text = m_csSTGMngData.GetSTGName().ToString();
            # region コメント
            /*
            this.MakePrjID();

            ProjectNameTextBox1_E.Text = ""; ProjectNameTextBox1_D.Text = ""; //PrjStatus1D.Text = "";
            ProjectNameTextBox2_E.Text = ""; ProjectNameTextBox2_D.Text = ""; //PrjStatus2D.Text = "";
            ProjectNameTextBox3_E.Text = ""; ProjectNameTextBox3_D.Text = ""; //PrjStatus3D.Text = "";
            ProjectNameTextBox4_E.Text = ""; ProjectNameTextBox4_D.Text = ""; //PrjStatus4D.Text = "";
            ProjectNameTextBox5_E.Text = ""; ProjectNameTextBox5_D.Text = ""; //PrjStatus5D.Text = "";

            HySDataLinkedList csList = m_csSTGMngData.GetKeyList();
            HySString csKeyStr = null;
            HySID csKeyID = null;
            McSTGSysCtlInfo csCtlInf = null;
            if (csList != null)
            {
                long lNum = csList.GetCount();
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csKeyStr = csList.GetData(lLp) as HySString;
                    csKeyID = new HySID(csKeyStr);
                    csCtlInf = m_csSTGMngData.GetCtlInfo(csKeyID);
                    if (csKeyID.Equals(m_csPrj01) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox1_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox1_D.Text = ProjectNameTextBox1_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj02) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox2_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox2_D.Text = ProjectNameTextBox2_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj03) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox3_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox3_D.Text = ProjectNameTextBox3_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj04) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox4_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox4_D.Text = ProjectNameTextBox4_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj05) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox5_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox5_D.Text = ProjectNameTextBox5_E.Text;
                    }
                    else
                    {
                        // Do Nothing
                    }
                }
                ProjectNameTextBox1_E.ForeColor = Color.Black; ProjectNameTextBox1_D.ForeColor = Color.Black;
                ProjectNameTextBox2_E.ForeColor = Color.Black; ProjectNameTextBox2_D.ForeColor = Color.Black;
                ProjectNameTextBox3_E.ForeColor = Color.Black; ProjectNameTextBox3_D.ForeColor = Color.Black;
                ProjectNameTextBox4_E.ForeColor = Color.Black; ProjectNameTextBox4_D.ForeColor = Color.Black;
                ProjectNameTextBox5_E.ForeColor = Color.Black; ProjectNameTextBox5_D.ForeColor = Color.Black;

            }
            */
            # endregion
            this.DispPrjArea();
            // 計算時間の調整
            if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Repeat)
            {
                HySTime csSTGStartTime = m_csSTGMngData.GetSTGCalStartTime();
                HySTime csCalStartTime = m_csSTGMngData.GetCalStartTime();
                HySTime csCalGoalTime = m_csSTGMngData.GetCalGoalTime();

                long lStart = (long)((csSTGStartTime.GetTime() - csCalStartTime.GetTime() + 0.1) / 60.0);
                long lEnd = (long)((csCalGoalTime.GetTime() - csSTGStartTime.GetTime() + 0.1) / 60.0);


                long lYear = 0; long lMonth = 0; long lDay = 0; long lHour = 0; long lMin = 0; long lSec = 0;
                HySCalendar.GetNowTime(ref lYear, ref lMonth, ref lDay, ref lHour, ref lMin, ref lSec);
                csSTGStartTime = HySCalendar.CreateTime(lYear, lMonth, lDay, lHour, lMin, 0);

                m_csSTGMngData.SetCalStartTime(csSTGStartTime - new HySTime(lStart*60));
                m_csSTGMngData.SetCalGoalTime(csSTGStartTime + new HySTime(lEnd*60));

                //HySString csStartTime = HySCalendar.GetString( m_csSTGMngData.GetCalStartTime(), HySCalendar.FORMAT.lSW_MONTH);
                long lInterval = (long)(m_csSTGMngData.GetSTGCalIntervalTime().GetTime() / 60.0);
                CalCycleTextBoxE.Text = lInterval.ToString();
                CalCycleTextBoxD.Text = CalCycleTextBoxE.Text;

                //long lPeriod = (long)((m_csSTGMngData.GetSTGCalStartTime().GetTime() - m_csSTGMngData.GetCalStartTime().GetTime()+0.1) / 60.0);
                //CalStartPeriodTextBoxE.Text = lPeriod.ToString();
                CalStartPeriodTextBoxE.Text = lStart.ToString();
                CalStartPeriodTextBoxD.Text = CalStartPeriodTextBoxE.Text;

                //lPeriod = (long)((m_csSTGMngData.GetCalGoalTime().GetTime() - m_csSTGMngData.GetSTGCalStartTime().GetTime()+0.1) / 60.0);
                //CalGoalPeriodTextBoxE.Text = lPeriod.ToString();
                CalGoalPeriodTextBoxE.Text = lEnd.ToString();
                CalGoalPeriodTextBoxD.Text = CalGoalPeriodTextBoxE.Text;

                SimuDayStartTimeE.Value = HySCalendar.Exchange(m_csSTGMngData.GetCalStartTime());
                SimuDayEndTimeE.Value = HySCalendar.Exchange(m_csSTGMngData.GetCalGoalTime());
                // チェックとチェックイベント処理
                this.SimuCycleRadioBtnE.Checked = true;
                //this.SimuCycleRadioBtnE_CheckedChanged(null, null);

            }
            else
            {
                HySTime csCalStartTime = m_csSTGMngData.GetCalStartTime();
                HySTime csCalGoalTime = m_csSTGMngData.GetCalGoalTime();

                SimuDayStartTimeE.Value = HySCalendar.Exchange(csCalStartTime);
                SimuDayEndTimeE.Value = HySCalendar.Exchange(csCalGoalTime);

                SimuDayStartTimeD.Value = SimuDayStartTimeE.Value;
                SimuDayEndTimeD.Value = SimuDayEndTimeE.Value;
                // チェックとチェックイベント処理
                this.SimuFromToRadioBtnE.Checked = true;
                //this.SimuFromToRadioBtnE_CheckedChanged(null,null);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト設定部表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DispPrjArea()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DispPrjArea()
        {
            this.MakePrjID();

            ProjectNameTextBox1_E.Text = ""; ProjectNameTextBox1_D.Text = ""; PrjStatus1D.Text = "";
            ProjectNameTextBox2_E.Text = ""; ProjectNameTextBox2_D.Text = ""; PrjStatus2D.Text = "";
            ProjectNameTextBox3_E.Text = ""; ProjectNameTextBox3_D.Text = ""; PrjStatus3D.Text = "";
            ProjectNameTextBox4_E.Text = ""; ProjectNameTextBox4_D.Text = ""; PrjStatus4D.Text = "";
            ProjectNameTextBox5_E.Text = ""; ProjectNameTextBox5_D.Text = ""; PrjStatus5D.Text = "";
            if (this.m_csSTGMngData.GetKeyList() == null)
            {
                ProjectGroupBoxE.Text = ""; ProjectGroupBoxD.Text = "";
                CsvOutputPathTextBox.Text = "";
            }

            HySDataLinkedList csList = m_csSTGMngData.GetKeyList();
            HySString csKeyStr = null;
            HySID csKeyID = null;
            McSTGSysCtlInfo csCtlInf = null;
            if (csList != null)
            {
                long lNum = csList.GetCount();
                for (long lLp = 0; lLp < lNum; lLp++)
                {
                    csKeyStr = csList.GetData(lLp) as HySString;
                    csKeyID = new HySID(csKeyStr);
                    csCtlInf = m_csSTGMngData.GetCtlInfo(csKeyID);
                    // 設定済みプロジェクトGr名称を設定
                    m_csPrjGrName =  csCtlInf.GetProjectGrName();
                    if (csKeyID.Equals(m_csPrj01) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox1_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox1_D.Text = ProjectNameTextBox1_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj02) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox2_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox2_D.Text = ProjectNameTextBox2_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj03) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox3_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox3_D.Text = ProjectNameTextBox3_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj04) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox4_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox4_D.Text = ProjectNameTextBox4_E.Text;
                    }
                    else if (csKeyID.Equals(m_csPrj05) == true)
                    {
                        ProjectGroupBoxE.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectGroupBoxD.Text = csCtlInf.GetProjectGrName().ToString();
                        ProjectNameTextBox5_E.Text = csCtlInf.GetProjectFileName().ToString();
                        ProjectNameTextBox5_D.Text = ProjectNameTextBox5_E.Text;
                    }
                    else
                    {
                        // Do Nothing
                    }
                }
            }
            this.DispReflesh();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名称表示色設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPrjNameColorSet()</para>
        /// </example>
        /// <param name="csID">プロジェクト識別子</param>
        /// <param name="ColorNo">カラー定義enum</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetPrjNameColorSet(HySID csID, McSTGCalCtlScreen.ColorNo ColorNo)
        {
            string csIDStrng = csID.ToString();
            Color  csDrawColor = Color.Black;
            if (ColorNo == McSTGCalCtlScreen.ColorNo.RED)
            {
                csDrawColor = Color.Red;
            }
            else if (ColorNo == McSTGCalCtlScreen.ColorNo.CONTROL)
            {
                csDrawColor = SystemColors.Control;
            }
            // 色管理テーブルの更新
            m_csTextBoxColorTbl[csIDStrng] = csDrawColor;
        }

        /// <summary><para>method outline:</para>
        /// <para>設定完了指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CloseButton_Click()</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void STGSetButton_Click(object sender, EventArgs e)
        {
            // 入力チェック
            if (this.CheckInputData() == false)
            {
                return;
            }

            SetCalcTerm();

            if (SimuCycleRadioBtnE.Checked == true)
            {   // 周期起動ならば
                /*
                m_csSTGMngData.SetSTGCalType(McSTGSysManageData.STGCalType.Repeat);

                double dInterval = (double)Int32.Parse(CalCycleTextBoxE.Text) * 60.0;
                m_csSTGMngData.SetSTGCalIntervalTime(new HySTime(dInterval));

                double dPeriod = ((double)Int32.Parse(CalStartPeriodTextBoxE.Text) + (double)Int32.Parse(CalGoalPeriodTextBoxE.Text)) * 60.0;
                m_csSTGMngData.SetCalPeriod(new HySTime(dPeriod));
                */
                long lYear = 0; long lMonth = 0; long lDay = 0; long lHour = 0; long lMin = 0; long lSec = 0;
                HySCalendar.GetNowTime(ref lYear, ref lMonth, ref lDay, ref lHour, ref lMin, ref lSec);
                DayTextBox.Text = lYear.ToString() + "/" + lMonth.ToString() + "/" + lDay.ToString();
                HourTextBox.Text = lHour.ToString();
                MinTextBox.Text = lMin.ToString();

                CalCycleTextBoxD.Text = CalCycleTextBoxE.Text;
                CalStartPeriodTextBoxD.Text = CalStartPeriodTextBoxE.Text;
                CalGoalPeriodTextBoxD.Text = CalGoalPeriodTextBoxE.Text;
            }
            else
            {   // 期間起動ならば
                //m_csSTGMngData.SetSTGCalType(McSTGSysManageData.STGCalType.Once);

                DayTextBox.Text = "";
                HourTextBox.Text = "";
                MinTextBox.Text = "";
                CalCycleTextBoxD.Text = "";
                CalStartPeriodTextBoxD.Text = "";
                CalGoalPeriodTextBoxD.Text = "";
            }

            m_csSTGCalCtlScreen.CompleteSTGSet();

            // ここで、カーソルを砂時計にする
            this.Cursor = Cursors.WaitCursor;
            // 一瞬、カーソルを砂時計にして、設定されている事を　オペレーターに認識させる
            System.Threading.Thread.Sleep(300);
            // ここで、カーソルを元に戻す。
            this.Cursor = Cursors.Default;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CalStartButton_Click()</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalStartButton_Click(object sender, EventArgs e)
        {
            // 入力チェック
            if (this.CheckInputData() == false)
            {
                return;
            }

            if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Repeat)
            {   // 繰り返し計算の場合
                long lYear = 0; long lMonth = 0; long lDay = 0; long lHour = 0; long lMin = 0; long lSec = 0;
                HySCalendar.GetNowTime(ref lYear, ref lMonth, ref lDay, ref lHour, ref lMin, ref lSec);
                lHour = Int32.Parse(HourTextBox.Text);
                lMin = Int32.Parse(MinTextBox.Text);

                //HySTime csStartTime = HySCalendar.CreateNowTime();
                HySTime csSTGStartTime = HySCalendar.CreateTime(lYear, lMonth, lDay, lHour, lMin,0);
                if (csSTGStartTime.Before(HySCalendar.CreateNowTime() - m_csSTGMngData.GetSTGCalIntervalTime()) == true)
                {
                    HourTextBox.ForeColor = Color.Red;
                    MinTextBox.ForeColor = Color.Red;
                }
                else
                {
                    HourTextBox.ForeColor = Color.Black;
                    MinTextBox.ForeColor = Color.Black;

                    double dInterval = (double)Int32.Parse(CalCycleTextBoxE.Text) * 60.0;
                    m_csSTGMngData.SetSTGCalIntervalTime(new HySTime(dInterval));

                    m_csSTGMngData.SetSTGCalStartTime(csSTGStartTime);

                    long lStart = Int32.Parse(CalStartPeriodTextBoxD.Text) * 60;
                    long lEnd = Int32.Parse(CalGoalPeriodTextBoxD.Text) * 60;
                    m_csSTGMngData.SetCalPeriod(new HySTime(lStart + lEnd));

                    m_csSTGMngData.SetCalStartTime(csSTGStartTime - new HySTime(lStart));
                    m_csSTGMngData.SetCalGoalTime(csSTGStartTime + new HySTime(lEnd));

                    m_csSTGCalCtlScreen.STGCalStart();

                    CalStartButton.Enabled = false;
                    CalStopButton.Enabled = true;
                    CalResetButton.Enabled = false;
                    HourTextBox.ReadOnly = true;
                    MinTextBox.ReadOnly = true;
                    # region タブ制御により個別のマスク制御は不要
                    //STGSetButton.Enabled = false;
                    //MakeFileButton.Enabled = false;
                    # endregion
                    // 計算開始後は他のタブ選択を許さない
                    m_bTabLockFlg = true;
                }
            }
            else
            {   // 期間限定一回計算の場合

                DateTime csStim = SimuDayStartTimeE.Value;
                m_csSTGMngData.SetCalStartTime(HySCalendar.Exchange(csStim));
                DateTime csEtim = SimuDayEndTimeE.Value;
                m_csSTGMngData.SetCalGoalTime(HySCalendar.Exchange(csEtim));
                m_csSTGMngData.SetCalPeriod(m_csSTGMngData.GetCalGoalTime() - m_csSTGMngData.GetCalStartTime());

                m_csSTGMngData.SetSTGCalStartTime(HySCalendar.CreateNowTime());

                m_csSTGCalCtlScreen.STGCalStart();

                CalStartButton.Enabled = false;
                CalStopButton.Enabled = true;
                CalResetButton.Enabled = false;
                HourTextBox.ReadOnly = true;
                MinTextBox.ReadOnly = true;
                # region タブ制御により個別のマスク制御は不要
                //STGSetButton.Enabled = false;
                //MakeFileButton.Enabled = false;
                # endregion
                // 計算開始後は他のタブ選択を許さない
                m_bTabLockFlg = true;
            }
            # region タブ制御により個別のマスク制御は不要
            //PrjEdtButton1.Enabled = false;
            //PrjEdtButton2.Enabled = false;
            //PrjEdtButton3.Enabled = false;
            //PrjEdtButton4.Enabled = false;
            //PrjEdtButton5.Enabled = false;
            //PrjDelButton1.Enabled = false;
            //PrjDelButton2.Enabled = false;
            //PrjDelButton3.Enabled = false;
            //PrjDelButton4.Enabled = false;
            //PrjDelButton5.Enabled = false;
            //Prj01Button.Enabled = false;
            //Prj02Button.Enabled = false;
            //Prj03Button.Enabled = false;
            //Prj04Button.Enabled = false;
            //Prj05Button.Enabled = false;
            //STGClearButton.Enabled = false;
            //OpenSTGButton.Enabled = false;
            //SaveSTGButton.Enabled = false;
            //SaveAsSTGButton.Enabled = false;
            # endregion
            # region プログレスバーによる進捗確認用
            //// 計算進捗要求用タイマースタート
            //m_csThreadTimerInstance.Change(0, 500);
            # endregion
        }
        /// <summary><para>method outline:</para>
        /// <para>計算終了指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CalStopButton_Click()</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalStopButton_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.STGCalStop();


            //CalStartButton.Enabled = false;
            CalStopButton.Enabled = false;
            //CalResetButton.Enabled = true;
            HourTextBox.ReadOnly = false;
            MinTextBox.ReadOnly = false;

            ForceStopTimer.Enabled = true;

            CalStartTimeLabel.Text = Properties.HymcoSTGSystemViewBaseResource.LABEL_SCHEDULED_STARTING_TIME;//"計算開始予定時刻";
            # region プログレスバーによる進捗確認用
            //// 計算進捗要求用タイマー停止
            //m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            # endregion

        }
        /// <summary><para>method outline:</para>
        /// <para>計算リセット指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CalResetButton_Click()</para>
        /// </example>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalResetButton_Click(object sender, EventArgs e)
        {
            long lYear = 0; long lMonth = 0; long lDay = 0; long lHour = 0; long lMin = 0; long lSec = 0;
            HySCalendar.GetNowTime(ref lYear, ref lMonth, ref lDay, ref lHour, ref lMin, ref lSec);
            //lHour = Int32.Parse(HourTextBox.Text);
            //lMin = Int32.Parse(MinTextBox.Text);
            HySTime csStartTime = HySCalendar.CreateTime(lYear, lMonth, lDay, lHour, lMin, 0);
            m_csSTGMngData.SetSTGCalStartTime(csStartTime);
            //m_csSTGMngData.SetCalStartTime(csStartTime);
            //m_csSTGMngData.SetCalGoalTime(m_csSTGMngData.GetCalStartTime() + m_csSTGMngData.GetCalPeriod());

            DayTextBox.Text = lYear.ToString() + "/" + lMonth.ToString() + "/" + lDay.ToString();
            HourTextBox.Text = lHour.ToString(); HourTextBox.ForeColor = Color.Black;
            MinTextBox.Text = lMin.ToString(); MinTextBox.ForeColor = Color.Black;

            m_csSTGCalCtlScreen.STGCalReset();

            // 計算リセット後は他のタブ選択を許可
            m_bTabLockFlg = false;
            # region タブ制御により個別のマスク制御は不要
            //PrjEdtButton1.Enabled = true;
            //PrjEdtButton2.Enabled = true;
            //PrjEdtButton3.Enabled = true;
            //PrjEdtButton4.Enabled = true;
            //PrjEdtButton5.Enabled = true;
            //PrjDelButton1.Enabled = true;
            //PrjDelButton2.Enabled = true;
            //PrjDelButton3.Enabled = true;
            //PrjDelButton4.Enabled = true;
            //PrjDelButton5.Enabled = true;
            //Prj01Button.Enabled = true;
            //Prj02Button.Enabled = true;
            //Prj03Button.Enabled = true;
            //Prj04Button.Enabled = true;
            //Prj05Button.Enabled = true;

            //STGClearButton.Enabled = true;
            //OpenSTGButton.Enabled = true;
            //SaveSTGButton.Enabled = true;
            //SaveAsSTGButton.Enabled = true;

            //STGSetButton.Enabled = true;
            //MakeFileButton.Enabled = true;
            # endregion
            CalStartButton.Enabled = true;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面表示リセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DispReset()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算開始後のモデル構築失敗等エラー発生時に行う</para>
        /// </remarks>
        public void DispReset()
        {
            if (m_csSTGMngData.GetSTGCalMode() ==  McSTGSysManageData.STGCalMode.ASYNCHRONOUS_CAL)
            {
                CalStartButton.Enabled = true;
                CalStopButton.Enabled = false;
                CalResetButton.Enabled = true;
                HourTextBox.ReadOnly = false;
                MinTextBox.ReadOnly = false;
                CalStartTimeLabel.Text = Properties.HymcoSTGSystemViewBaseResource.LABEL_SCHEDULED_STARTING_TIME;//"計算開始予定時刻";
                // タブ選択を許可
                m_bTabLockFlg = false;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DispReflesh()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>        
        public void DispReflesh()
        {
            // 此処に画面再描画処理を入れる
            this.MakePrjID();

            string sDispStr = "";

            // 色の更新
            ProjectNameTextBox1_E.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj01.ToString()];
            ProjectNameTextBox1_D.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj01.ToString()];
            ProjectNameTextBox2_E.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj02.ToString()];
            ProjectNameTextBox2_D.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj02.ToString()];
            ProjectNameTextBox3_E.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj03.ToString()];
            ProjectNameTextBox3_D.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj03.ToString()];
            ProjectNameTextBox4_E.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj04.ToString()];
            ProjectNameTextBox4_D.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj04.ToString()];
            ProjectNameTextBox5_E.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj05.ToString()];
            ProjectNameTextBox5_D.BackColor = (Color)m_csTextBoxColorTbl[m_csPrj05.ToString()];

            HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
            if (csKeyList == null) { return; }

            long lDtNum = csKeyList.GetCount();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                HySString csKey = csKeyList.GetData(lLp) as HySString;
                HySID csID = new HySID(csKey);
                McSTGSysCtlInfo csCtlInf = m_csSTGMngData.GetCtlInfo(csID);
                long lSts = csCtlInf.GetCalStatus();
                if (lSts < McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE) { sDispStr = ""; }
//                else if (lSts == McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE) { sDispStr = "調整完了"; }
                else if (lSts == McSTGSysCtlInfo.MODEL_CONSTRUCTION_STATE) { sDispStr = Properties.HymcoSTGSystemViewBaseResource.STATE_ADJUSTMENT_COMPLETION; }
//                else if (lSts == McSTGSysCtlInfo.INITIAL_STATE) { sDispStr = "初期化"; }
                else if (lSts == McSTGSysCtlInfo.INITIAL_STATE) { sDispStr = Properties.HymcoSTGSystemViewBaseResource.STATE_INITIALIZATION; }
//                else if (lSts == McSTGSysCtlInfo.CALCULATION_STATE) { sDispStr = "計算中"; }
                else if (lSts == McSTGSysCtlInfo.CALCULATION_STATE) { sDispStr = Properties.HymcoSTGSystemViewBaseResource.STATE_DURING_THE_CALCULATION; }
//                else if (lSts == McSTGSysCtlInfo.END_STATE) { sDispStr = "計算完了"; }
                else if (lSts == McSTGSysCtlInfo.END_STATE) { sDispStr = Properties.HymcoSTGSystemViewBaseResource.STATE_CALCULATION_COMPLETION; }
//                else if (lSts == McSTGSysCtlInfo.STOP_STATE) { sDispStr = "計算終了"; }
                else if (lSts == McSTGSysCtlInfo.STOP_STATE) { sDispStr = Properties.HymcoSTGSystemViewBaseResource.STATE_CALCULATION_END; }

                if (csID.Equals(m_csPrj01) == true)
                {
                    PrjStatus1D.Text = sDispStr;
                    if (sDispStr == Properties.HymcoSTGSystemViewBaseResource.STATE_DURING_THE_CALCULATION)
                    {
                        PrjStatus1D.BackColor = Color.LightGreen;
                    }
                    else
                    {
                        PrjStatus1D.BackColor = SystemColors.Control;
                    }
                }
                else if (csID.Equals(m_csPrj02) == true)
                {
                    PrjStatus2D.Text = sDispStr;
                    if (sDispStr == Properties.HymcoSTGSystemViewBaseResource.STATE_DURING_THE_CALCULATION)
                    {
                        PrjStatus2D.BackColor = Color.LightGreen;
                    }
                    else
                    {
                        PrjStatus2D.BackColor = SystemColors.Control;
                    }
                }
                else if (csID.Equals(m_csPrj03) == true)
                {
                    PrjStatus3D.Text = sDispStr;
                    if (sDispStr == Properties.HymcoSTGSystemViewBaseResource.STATE_DURING_THE_CALCULATION)
                    {
                        PrjStatus3D.BackColor = Color.LightGreen;
                    }
                    else
                    {
                        PrjStatus3D.BackColor = SystemColors.Control;
                    }
                }
                else if (csID.Equals(m_csPrj04) == true)
                {
                    PrjStatus4D.Text = sDispStr;
                    if (sDispStr == Properties.HymcoSTGSystemViewBaseResource.STATE_DURING_THE_CALCULATION)
                    {
                        PrjStatus4D.BackColor = Color.LightGreen;
                    }
                    else
                    {
                        PrjStatus4D.BackColor = SystemColors.Control;
                    }
                }
                else if (csID.Equals(m_csPrj05) == true)
                {
                    PrjStatus5D.Text = sDispStr;
                    if (sDispStr == Properties.HymcoSTGSystemViewBaseResource.STATE_DURING_THE_CALCULATION)
                    {
                        PrjStatus5D.BackColor = Color.LightGreen;
                    }
                    else
                    {
                        PrjStatus5D.BackColor = SystemColors.Control;
                    }
                }
                else
                {
                    // Do Nothing
                }
                //**/
                //HySTime csCalSTGStarTime = m_csSTGMngData.GetCalStartTime();
                HySTime csCalSTGStarTime = m_csSTGMngData.GetSTGCalStartTime();
                long lYear = 0; long lMonth = 0; long lDay = 0; long lHour = 0; long lMin = 0; long lSec = 0;
                HySCalendar.GetTime(csCalSTGStarTime, ref lYear, ref lMonth, ref lDay, ref lHour, ref lMin, ref lSec);
                DayTextBox.Text = lYear.ToString() + "/" + lMonth.ToString() + "/" + lDay.ToString();
                HourTextBox.Text = lHour.ToString();
                MinTextBox.Text = lMin.ToString();
                //**/
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>タイマー起動切り替え</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>RefleshTimerOnOff(bFlg)</para>
        /// </example>
        /// <param name="bFlg"></param>
        /// <returns>bool :true 有効, false 無効</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RefleshTimerOnOff(bool bFlg)
        {
            bAutoRefleshFlg = bFlg;
            RedrawTimer.Enabled = bFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>自動再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AutoReflesh()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AutoReflesh()
        {
            DispReflesh();
            RedrawTimer.Enabled = bAutoRefleshFlg;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>TGC読み込み完了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSTGOpen()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGOpen()
        {
            CalStartButton.Enabled = false;
            CalStopButton.Enabled = false;
            CalResetButton.Enabled = false;
            HourTextBox.ReadOnly = false;
            MinTextBox.ReadOnly = false;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル構築完了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CompleteSTGModelConstruction()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void CompleteSTGModelConstruction()
        {
            CalStartButton.Enabled = true;
            CalStopButton.Enabled = false;
            CalResetButton.Enabled = true;
            m_csTextBoxColorTbl["Prj01"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj02"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj03"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj04"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj05"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj06"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj07"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj08"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj09"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj10"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj11"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj12"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj13"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj14"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj15"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj16"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj17"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj18"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj19"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj20"] = SystemColors.Control;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化完了通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSTGCalInitialize()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalInitialize()
        {
            CalStartButton.Enabled = true;
            CalStopButton.Enabled = false;
            //CalResetButton.Enabled = false;
            HourTextBox.ReadOnly = false;
            MinTextBox.ReadOnly = false;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSTGCalStart()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalStart()
        {
            CalStartButton.Enabled = false;
            CalStopButton.Enabled = true;
            CalResetButton.Enabled = false;
            HourTextBox.ReadOnly = true;
            MinTextBox.ReadOnly = true;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算停止通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSTGCalStop()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalStop()
        {
            CalStartButton.Enabled = false;
            CalStopButton.Enabled = false;
            CalResetButton.Enabled = true;
            HourTextBox.ReadOnly = false;
            MinTextBox.ReadOnly = false;

        }

        /// <summary><para>method outline:</para>
        /// <para>計算完了通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSTGCalComplete()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalComplete()
        {
            if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Once)
            {   // 1回計算の時
                CalStartButton.Enabled = false;
                CalStopButton.Enabled = false;
                CalResetButton.Enabled = true;
                HourTextBox.ReadOnly = false;
                MinTextBox.ReadOnly = false;
                # region タブ制御により個別のマスク制御は不要
                //PrjEdtButton1.Enabled = true;
                //PrjEdtButton2.Enabled = true;
                //PrjEdtButton3.Enabled = true;
                //PrjEdtButton4.Enabled = true;
                //PrjEdtButton5.Enabled = true;
                //PrjDelButton1.Enabled = true;
                //PrjDelButton2.Enabled = true;
                //PrjDelButton3.Enabled = true;
                //PrjDelButton4.Enabled = true;
                //PrjDelButton5.Enabled = true;
                //Prj01Button.Enabled = true;
                //Prj02Button.Enabled = true;
                //Prj03Button.Enabled = true;
                //Prj04Button.Enabled = true;
                //Prj05Button.Enabled = true;

                //STGClearButton.Enabled = true;
                //OpenSTGButton.Enabled = true;
                //SaveSTGButton.Enabled = true;
                //SaveAsSTGButton.Enabled = true;
                # endregion
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト編集ボタン1クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjEdtButton1_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjEdtButton1_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjEdit(new HySID(PrjID1_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト編集ボタン2クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjEdtButton2_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjEdtButton2_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjEdit(new HySID(PrjID2_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト編集ボタン3クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjEdtButton3_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjEdtButton3_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjEdit(new HySID(PrjID3_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト編集ボタン4クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjEdtButton4_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjEdtButton4_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjEdit(new HySID(PrjID4_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト編集ボタン5クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjEdtButton5_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjEdtButton5_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjEdit(new HySID(PrjID5_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト消去ボタン1クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjDelButton1_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjDelButton1_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjDel(new HySID(PrjID1_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト消去ボタン2クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjDelButton2_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjDelButton2_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjDel(new HySID(PrjID2_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト消去ボタン3クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjDelButton3_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjDelButton3_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjDel(new HySID(PrjID3_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト消去ボタン4クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjDelButton4_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjDelButton4_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjDel(new HySID(PrjID4_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト消去ボタン5クリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrjDelButton5_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrjDelButton5_Click(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.PrjDel(new HySID(PrjID5_E.Text));
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>計算間隔設定テキストボックス値変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalCycleTextBoxE_DockChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalCycleTextBoxE_DockChanged(object sender, EventArgs e)
        {
            CalCycleTextBoxD.Text = CalCycleTextBoxE.Text;
            CalStartPeriodTextBoxD.Text = CalStartPeriodTextBoxE.Text;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>計算期間 前設定テキストボックス値変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalPeriodTextBoxE_DockChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalStartPeriodTextBoxE_DockChanged(object sender, EventArgs e)
        {
            CalCycleTextBoxD.Text = CalCycleTextBoxE.Text;
            CalStartPeriodTextBoxD.Text = CalStartPeriodTextBoxE.Text;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>計算開始予定時刻 時間設定テキストボックス値変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HourTextBox_TextChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HourTextBox_TextChanged(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>計算開始予定時刻 分設定テキストボックス値変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MinTextBox_TextChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MinTextBox_TextChanged(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト別名保存</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>NewSaveSTGProject(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NewSaveSTGProject(object sender, EventArgs e)
        {
            this.SetCalcTerm();
            // TGC名称の保存
            m_csSTGMngData.SetSTGName(new HySString(STGNameTextBoxE.Text));
            // CSVファイル名称の保存
            List<string> csFileNameList = new List<string>();
            csFileNameList.Add(CsvNameTextBox01.Text);
            csFileNameList.Add(CsvNameTextBox02.Text);
            csFileNameList.Add(CsvNameTextBox03.Text);
            csFileNameList.Add(CsvNameTextBox04.Text);
            csFileNameList.Add(CsvNameTextBox05.Text);
            csFileNameList.Add(CsvNameTextBox06.Text);
            csFileNameList.Add(CsvNameTextBox07.Text);
            csFileNameList.Add(CsvNameTextBox08.Text);
            csFileNameList.Add(CsvNameTextBox09.Text);
            csFileNameList.Add(CsvNameTextBox10.Text);
            csFileNameList.Add(CsvNameTextBox11.Text);
            csFileNameList.Add(CsvNameTextBox12.Text);
            csFileNameList.Add(CsvNameTextBox13.Text);
            csFileNameList.Add(CsvNameTextBox14.Text);
            csFileNameList.Add(CsvNameTextBox15.Text);
            csFileNameList.Add(CsvNameTextBox16.Text);
            m_csSTGMngData.SetCSVFileName(csFileNameList);
            m_csSTGCalCtlScreen.NewSaveSTGProject();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト上書保存</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SaveSTGProject(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveSTGProject(object sender, EventArgs e)
        {
            this.SetCalcTerm();
            // TGC名称の保存
            m_csSTGMngData.SetSTGName(new HySString(STGNameTextBoxE.Text));
            // CSVファイル名称の保存
            List<string> csFileNameList = new List<string>();
            csFileNameList.Add(CsvNameTextBox01.Text);
            csFileNameList.Add(CsvNameTextBox02.Text);
            csFileNameList.Add(CsvNameTextBox03.Text);
            csFileNameList.Add(CsvNameTextBox04.Text);
            csFileNameList.Add(CsvNameTextBox05.Text);
            csFileNameList.Add(CsvNameTextBox06.Text);
            csFileNameList.Add(CsvNameTextBox07.Text);
            csFileNameList.Add(CsvNameTextBox08.Text);
            csFileNameList.Add(CsvNameTextBox09.Text);
            csFileNameList.Add(CsvNameTextBox10.Text);
            csFileNameList.Add(CsvNameTextBox11.Text);
            csFileNameList.Add(CsvNameTextBox12.Text);
            csFileNameList.Add(CsvNameTextBox13.Text);
            csFileNameList.Add(CsvNameTextBox14.Text);
            csFileNameList.Add(CsvNameTextBox15.Text);
            csFileNameList.Add(CsvNameTextBox16.Text);
            m_csSTGMngData.SetCSVFileName(csFileNameList);
            m_csSTGCalCtlScreen.SaveSTGProject();
            // ここで、カーソルを砂時計にする
            this.Cursor = Cursors.WaitCursor;
            // 一瞬、カーソルを砂時計にして、セーブされている事を　オペレーターに認識させる
            System.Threading.Thread.Sleep(300); 
            // ここで、カーソルを元に戻す。
            this.Cursor = Cursors.Default;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト読込み</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LoadSTGProject(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LoadSTGProject(object sender, EventArgs e)
        {
            m_csSTGCalCtlScreen.LoadSTGProject();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TGCクリアボタンクリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>STGClearButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void STGClearButton_Click(object sender, EventArgs e)
        {
            m_iSTGPage = 0;
            m_csSTGMngData.Clear();  // m_csSTGMngData をクリアする
            
            SetSTGMngData(this.m_csSTGMngData);
            STGNameTextBoxE.Text = "";
            STGNameTextBoxD.Text = "";
            ProjectGroupBoxE.Text = "";
            ProjectGroupBoxD.Text = "";
            m_csTextBoxColorTbl["Prj01"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj02"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj03"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj04"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj05"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj06"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj07"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj08"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj09"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj10"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj11"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj12"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj13"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj14"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj15"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj16"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj17"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj18"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj19"] = SystemColors.Control;
            m_csTextBoxColorTbl["Prj20"] = SystemColors.Control;
            this.DispReflesh();
            this.Refresh();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddProject(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AddProject(object sender, EventArgs e)
        {
            McDotNetProjectFileDialog csOpenFileDlg = new McDotNetProjectFileDialog(HySEnvInf.GetDataHomeDirectory());
            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {
                this.MakePrjID();

                McSTGSysManageData csMngData =  m_csSTGCalCtlScreen.GetSTGSysMngData();
                HySString csPrjGrName = csOpenFileDlg.GetProjectGroupName();
                if (m_csPrjGrName != "" && csPrjGrName != m_csPrjGrName)
                {
                    DialogResult result = MessageBox.Show(MSG_INFO_ADD_PROJECT, MSGBOX_TITLE2, MessageBoxButtons.YesNo, MessageBoxIcon.Information,MessageBoxDefaultButton.Button2);
                    if (result == DialogResult.No)
                    {
                        return;
                    }
                    else
                    {
                        this.ResetData();
                    }
                }
                m_csPrjGrName = csPrjGrName;
                HySString csPrjName = csOpenFileDlg.GetProjectName();
                HySString csPrjFullName = null;
                if (csPrjName.ToString().EndsWith(".cmprj") == false)
                {
                     csPrjFullName = csPrjName + new HySString(".cmprj");
                }
                else
                {
                    csPrjFullName = csPrjName;
                }
                //HySString csSTGName = new HySString("STG") + csPrjGrName;
                HySID csPrjID = null;
                if (((Button)sender).Name == "Prj01Button")
                {
                    csPrjID = m_csPrj01;
                }
                else if (((Button)sender).Name == "Prj02Button")
                {
                    csPrjID = m_csPrj02;
                }
                else if (((Button)sender).Name == "Prj03Button")
                {
                    csPrjID = m_csPrj03;
                }
                else if (((Button)sender).Name == "Prj04Button")
                {
                    csPrjID = m_csPrj04;
                }
                else if (((Button)sender).Name == "Prj05Button")
                {
                    csPrjID = m_csPrj05;
                }
                McSTGSysCtlInfo csCtlInfo = new McSTGSysCtlInfo();
                csCtlInfo.SetProjectGroupName(csPrjGrName);
                csCtlInfo.SetProjectFileName(csPrjFullName);
                //csMngData.SetSTGName(csSTGName);  <-- 不要
                csMngData.SetDataCtlInfo(csPrjID, csCtlInfo);

                //this.SetSTGMngData(csMngData);

                this.DispPrjArea();
                
                // 一般グラフ表示用ファイル出力先設定
                HySString csOutPath = HySEnvInf.GetDataHomeDirectory() + new HySString("\\") + m_csPrjGrName + new HySString("\\OutputData");
                this.CsvOutputPathTextBox.Text = csOutPath.ToString();
                // 右端表示(長いフルパスでもファイル名が認識できるよう)
                this.CsvOutputPathTextBox.SelectAll();
                int idx = this.CsvOutputPathTextBox.SelectionLength;
                this.CsvOutputPathTextBox.SelectionStart = idx;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクト設定初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ResetData()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void ResetData()
        {
            McSTGSysManageData csMngData = m_csSTGCalCtlScreen.GetSTGSysMngData();
            csMngData.Clear();
            STGNameTextBoxE.Text = "";
            STGNameTextBoxD.Text = "";
            ProjectGroupBoxE.Text = "";
            ProjectGroupBoxD.Text = "";
            ProjectNameTextBox1_E.Text = "";
            ProjectNameTextBox1_D.Text = "";
            ProjectNameTextBox2_E.Text = "";
            ProjectNameTextBox2_D.Text = "";
            ProjectNameTextBox3_E.Text = "";
            ProjectNameTextBox3_D.Text = "";
            ProjectNameTextBox4_E.Text = "";
            ProjectNameTextBox4_D.Text = "";
            ProjectNameTextBox5_E.Text = "";
            ProjectNameTextBox5_D.Text = "";
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>CSV出力先表示ボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CsvOutputPathTextBoxChangedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CsvOutputPathTextBoxChangedEvent(object sender, EventArgs e)
        {
            if (CsvOutputPathTextBox.Text != string.Empty && m_bCsvFileNameInputFlg == true)
            {
                MakeFileButton.Enabled = true;
            }
            else
            {
                MakeFileButton.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>CSVファイル名称指定ボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CsvNameTextBoxChangedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CsvNameTextBoxChangedEvent(object sender, EventArgs e)
        {
            if (((TextBox)sender).Text != string.Empty)
            {
                m_bCsvFileNameInputFlg = true;
                if (CsvOutputPathTextBox.Text != string.Empty)
                {
                    MakeFileButton.Enabled = true;
                }
            }
            else if(CsvNameTextBox01.Text == string.Empty && CsvNameTextBox02.Text == string.Empty && CsvNameTextBox03.Text == string.Empty &&
                CsvNameTextBox04.Text == string.Empty && CsvNameTextBox05.Text == string.Empty && CsvNameTextBox06.Text == string.Empty &&
                CsvNameTextBox07.Text == string.Empty && CsvNameTextBox08.Text == string.Empty && CsvNameTextBox09.Text == string.Empty &&
                CsvNameTextBox10.Text == string.Empty && CsvNameTextBox11.Text == string.Empty && CsvNameTextBox12.Text == string.Empty &&
                CsvNameTextBox13.Text == string.Empty && CsvNameTextBox14.Text == string.Empty && CsvNameTextBox15.Text == string.Empty &&
                CsvNameTextBox16.Text == string.Empty)
            {
                m_bCsvFileNameInputFlg = false;
                MakeFileButton.Enabled = false;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>CSVファイル生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MakeCsvFile(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MakeCsvFile(object sender, EventArgs e)
        {
            try
            {
                HySCSVFileDim1Data csD1CSVData = new HySCSVFileDim1Data();
                csD1CSVData.SetDimention(1);

                List<string> csFileNameList = new List<string>();
                // リストに追加
                csFileNameList.Add(CsvNameTextBox01.Text);
                csFileNameList.Add(CsvNameTextBox02.Text);
                csFileNameList.Add(CsvNameTextBox03.Text);
                csFileNameList.Add(CsvNameTextBox04.Text);
                csFileNameList.Add(CsvNameTextBox05.Text);
                csFileNameList.Add(CsvNameTextBox06.Text);
                csFileNameList.Add(CsvNameTextBox07.Text);
                csFileNameList.Add(CsvNameTextBox08.Text);
                csFileNameList.Add(CsvNameTextBox09.Text);
                csFileNameList.Add(CsvNameTextBox10.Text);
                csFileNameList.Add(CsvNameTextBox11.Text);
                csFileNameList.Add(CsvNameTextBox12.Text);
                csFileNameList.Add(CsvNameTextBox13.Text);
                csFileNameList.Add(CsvNameTextBox14.Text);
                csFileNameList.Add(CsvNameTextBox15.Text);
                csFileNameList.Add(CsvNameTextBox16.Text);
                // 入力チェック
                bool bRtn = this.CheckFileName(csFileNameList);
                if (bRtn == false)
                {
                    // 異常あればファイル出力しない
                    return;
                }
                // ファイル出力処理
                int icount = csFileNameList.Count;
                for (int iLp = 0; iLp < icount; iLp++)
                {
                    string sFileName = csFileNameList[iLp];
                    if (sFileName == string.Empty)
                    {
                        continue;
                    }
                    string sPath = CsvOutputPathTextBox.Text + "\\" + sFileName + ".csv";
                    HySFile csFile = new HySFile(sPath);
                    csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    csD1CSVData.HeadInfWrite(csFile);
                    csFile.Close();
                }
                // ここで、カーソルを砂時計にする
                this.Cursor = Cursors.WaitCursor;
                // 一瞬、カーソルを砂時計にして、生成されている事を　オペレーターに認識させる
                System.Threading.Thread.Sleep(300);
                // ここで、カーソルを元に戻す。
                this.Cursor = Cursors.Default;
            }
            catch (Exception ex)
            {
                // 例外発生
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGCalCtlForm.MakeCsvFile",
                    Properties.HymcoSTGSystemViewBaseResource.STATEMENT_CATCH_EXCEPTION +"( " + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McSTGCalCtlForm.MakeCsvFile", "catch exception( " + ex.Message + ")");
                // メッセージ表示
                MessageBox.Show(MSG_ERROR_MAKECSV, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        /// <summary>
        /// <para>method outline</para>
        /// <para>CSVファイル生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MakeCsvFile()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void MakeCsvFile()
        {
            this.MakeCsvFile(null, null);
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>CSVファイル名称読込み</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReadCSVFileName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void ReadCSVFileName()
        {
            // 事前の表示クリア
            CsvNameTextBox01.Text = string.Empty;
            CsvNameTextBox02.Text = string.Empty;
            CsvNameTextBox03.Text = string.Empty;
            CsvNameTextBox04.Text = string.Empty;
            CsvNameTextBox05.Text = string.Empty;
            CsvNameTextBox06.Text = string.Empty;
            CsvNameTextBox07.Text = string.Empty;
            CsvNameTextBox08.Text = string.Empty;
            CsvNameTextBox09.Text = string.Empty;
            CsvNameTextBox10.Text = string.Empty;
            CsvNameTextBox11.Text = string.Empty;
            CsvNameTextBox12.Text = string.Empty;
            CsvNameTextBox13.Text = string.Empty;
            CsvNameTextBox14.Text = string.Empty;
            CsvNameTextBox15.Text = string.Empty;
            CsvNameTextBox16.Text = string.Empty;
            // CSVファイル名称の復元
            List<string> csFileNameList = m_csSTGMngData.GetCSVFileName();
            string sFileName = "";
            if (csFileNameList != null)
            {
                for (int iLp = 0; iLp < csFileNameList.Count; iLp++)
                {
                    sFileName = csFileNameList[iLp];
                    if (CsvNameTextBox01.Text == string.Empty)
                    {
                        CsvNameTextBox01.Text = sFileName;
                    }
                    else if (CsvNameTextBox02.Text == string.Empty)
                    {
                        CsvNameTextBox02.Text = sFileName;
                    }
                    else if (CsvNameTextBox03.Text == string.Empty)
                    {
                        CsvNameTextBox03.Text = sFileName;
                    }
                    else if (CsvNameTextBox04.Text == string.Empty)
                    {
                        CsvNameTextBox04.Text = sFileName;
                    }
                    else if (CsvNameTextBox05.Text == string.Empty)
                    {
                        CsvNameTextBox05.Text = sFileName;
                    }
                    else if (CsvNameTextBox06.Text == string.Empty)
                    {
                        CsvNameTextBox06.Text = sFileName;
                    }
                    else if (CsvNameTextBox07.Text == string.Empty)
                    {
                        CsvNameTextBox07.Text = sFileName;
                    }
                    else if (CsvNameTextBox08.Text == string.Empty)
                    {
                        CsvNameTextBox08.Text = sFileName;
                    }
                    else if (CsvNameTextBox09.Text == string.Empty)
                    {
                        CsvNameTextBox09.Text = sFileName;
                    }
                    else if (CsvNameTextBox10.Text == string.Empty)
                    {
                        CsvNameTextBox10.Text = sFileName;
                    }
                    else if (CsvNameTextBox11.Text == string.Empty)
                    {
                        CsvNameTextBox11.Text = sFileName;
                    }
                    else if (CsvNameTextBox12.Text == string.Empty)
                    {
                        CsvNameTextBox12.Text = sFileName;
                    }
                    else if (CsvNameTextBox13.Text == string.Empty)
                    {
                        CsvNameTextBox13.Text = sFileName;
                    }
                    else if (CsvNameTextBox14.Text == string.Empty)
                    {
                        CsvNameTextBox14.Text = sFileName;
                    }
                    else if (CsvNameTextBox15.Text == string.Empty)
                    {
                        CsvNameTextBox15.Text = sFileName;
                    }
                    else if (CsvNameTextBox16.Text == string.Empty)
                    {
                        CsvNameTextBox16.Text = sFileName;
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>CSVファイル名称のチェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckFileName(csFileNameList)</para>
        /// </example>
        /// <param name="csFileNameList">入力されたファイル名称のリスト情報</param>
        /// <returns>bool:true 問題なし false 問題あり</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckFileName(List<string> csFileNameList)
        {
            bool bRtn = true;
            int icount = csFileNameList.Count;
            for (int iLp = 0; iLp < icount; iLp++)
            {
                string sChkStr = csFileNameList[iLp];
                string sErrCharacter = @"\/:,;*?""<>|";
                if (sChkStr.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
                {
                    MessageBox.Show(MSG_ERROR_NOT_USE_CHAR + @"\/:,;*?""<>|", MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    bRtn = false;
                }
                else if (sChkStr.StartsWith(".") == true)
                {
                    MessageBox.Show(MSG_ERROR_FILENAME, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    bRtn = false;
                }
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>入力情報のチェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CheckInputData()</para>
        /// </example>
        /// <returns>bool:true 問題なし false 問題あり</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckInputData()
        {
            bool bRtn = true;
            // 現在アクティブなタブを確認して、チェック対象を選択
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (SimuCycleRadioBtnE.Checked == true)
                {
                    // 周期起動
                    if (CalCycleTextBoxE.Text == string.Empty || CalStartPeriodTextBoxE.Text == string.Empty || CalGoalPeriodTextBoxE.Text == string.Empty)
                    {
                        // 未入力の場合
                        bRtn = false;
                        MessageBox.Show(MSG_ERROR_NON_INPUT, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                    else
                    {
                        // 入力値の妥当性確認
                        string sChkStr = "1234567890";
                        // 半角英数字 以外不可
                        if (CheckInputKind(CalCycleTextBoxE.Text, sChkStr, false) == true || CheckInputKind(CalStartPeriodTextBoxE.Text, sChkStr, false) || CheckInputKind(CalGoalPeriodTextBoxE.Text, sChkStr, false))
                        {
                            bRtn = false;
                            MessageBox.Show(MSG_ERROR_NOT_USE_TEXT, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        }
                        else
                        {
                            // 周期0は除外
                            long CycleMin = long.Parse(CalCycleTextBoxE.Text);
                            if (CycleMin == 0)
                            {
                                bRtn = false;
                                CalCycleTextBoxE.ForeColor = Color.Red;
                            }
                            else
                            {
                                CalCycleTextBoxE.ForeColor = Color.Black;
                            }
                        }
                    }
                }
                else if (SimuFromToRadioBtnE.Checked == true)
                {
                    // 計算期間設定
                    HySTime csStartTime = null;
                    HySTime csEndTime = null;
                    // 期間の取得(開始) 
                    csStartTime = HySCalendar.Exchange(SimuDayStartTimeE.Value);
                    // 期間の取得(終了) 
                    csEndTime = HySCalendar.Exchange(SimuDayEndTimeE.Value);
                    if (csEndTime.After(csStartTime) == false)
                    {
                        bRtn = false;
                        MessageBox.Show(MSG_ERROR_CAL_TERM, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算タブ
                if (HourTextBox.Text == string.Empty || MinTextBox.Text == string.Empty)
                {
                    // 未入力の場合
                    bRtn = false;
                    MessageBox.Show(MSG_ERROR_NON_INPUT, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }
                else
                {
                    // 入力値の妥当性確認
                    string sChkStr = "1234567890";
                    // 半角英数字 以外不可
                    if (CheckInputKind(HourTextBox.Text, sChkStr, false) == true || CheckInputKind(MinTextBox.Text, sChkStr, false))
                    {
                        bRtn = false;
                        MessageBox.Show(MSG_ERROR_NOT_USE_TEXT, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    }
                    else
                    {
                        long Hour = long.Parse(HourTextBox.Text);
                        long Min = long.Parse(MinTextBox.Text);
                        if (Hour < 0 || Hour > 23)
                        {
                            bRtn = false;
                            MessageBox.Show(MSG_ERROR_CAL_TIME, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        }
                        if (Min < 0 || Min > 59)
                        {
                            bRtn = false;
                            MessageBox.Show(MSG_ERROR_CAL_TIME, MSGBOX_TITLE2, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                        }
                    }
                }
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>文字種別チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = CheckInputKind(string sText, string sChkStr, bool bFlg)</para>
        /// </example>
        /// <param name="sText">チェック対象文字</param>
        /// <param name="sChkStr">含まれているかチェックしたい文字</param>
        /// <param name="bFlg">true:チェックしたい文字が含まれているか  false:チェックしたい文字以外が含まれているか</param>
        /// <returns>true：含む false: 含まない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool CheckInputKind(string sText, string sChkStr, bool bFlg)
        {
            bool bRtn = false;
            if (bFlg)
            {
                // チェックしたい文字が含まれているか
                bRtn = (sText.IndexOfAny(sChkStr.ToCharArray()) >= 0);
            }
            else
            {
                // チェックしたい文字以外が含まれているか
                char[] cBuff = sText.ToCharArray();
                char[] cErrChar = sChkStr.ToCharArray();
                for (int i = 0; i < cBuff.Length; i++)
                {
                    bool bChkFlg = false;
                    for (int y = 0; y < cErrChar.Length; y++)
                    {
                        if (cBuff[i] == cErrChar[y])
                        {
                            bChkFlg = true;
                            break;
                        }
                    }
                    if (!bChkFlg)
                    {
                        bRtn = true;
                    }
                }
            }

            return bRtn;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl選択処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>STGTabControl_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void STGTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (m_bTabLockFlg == true)
            {// ロックフラグオンの場合、TGC計算タブ以外を無効とする。
                if (STGTabControl.SelectedTab == STGEditTabPage)
                {
                    STGTabControl.SelectedTab = STGCalCtlTabPage;
                }
                else if (STGTabControl.SelectedTab == GraphOutRegTabPage)
                {
                    STGTabControl.SelectedTab = STGCalCtlTabPage;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeUndoEvent()
        {
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (this.ActiveControl.Name == "CalCycleTextBoxE")
                {
                    if (CalCycleTextBoxE.CanUndo == true)
                    {
                        CalCycleTextBoxE.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CalStartPeriodTextBoxE")
                {
                    if (CalStartPeriodTextBoxE.CanUndo == true)
                    {
                        CalStartPeriodTextBoxE.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CalGoalPeriodTextBoxE")
                {
                    if (CalGoalPeriodTextBoxE.CanUndo == true)
                    {
                        CalGoalPeriodTextBoxE.Undo();
                    }
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算
                if (this.ActiveControl.Name == "HourTextBox")
                {
                    if (HourTextBox.CanUndo == true)
                    {
                        HourTextBox.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "MinTextBox")
                {
                    if (MinTextBox.CanUndo == true)
                    {
                        MinTextBox.Undo();
                    }
                }
            }
            else if (STGTabControl.SelectedIndex == 2)
            {
                // 一般グラフ表示用ファイル準備
                if (this.ActiveControl.Name == "CsvNameTextBox01")
                {
                    if (CsvNameTextBox01.CanUndo == true)
                    {
                        CsvNameTextBox01.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox02")
                {
                    if (CsvNameTextBox02.CanUndo == true)
                    {
                        CsvNameTextBox02.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox03")
                {
                    if (CsvNameTextBox03.CanUndo == true)
                    {
                        CsvNameTextBox03.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox04")
                {
                    if (CsvNameTextBox04.CanUndo == true)
                    {
                        CsvNameTextBox04.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox05")
                {
                    if (CsvNameTextBox05.CanUndo == true)
                    {
                        CsvNameTextBox05.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox06")
                {
                    if (CsvNameTextBox06.CanUndo == true)
                    {
                        CsvNameTextBox06.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox07")
                {
                    if (CsvNameTextBox07.CanUndo == true)
                    {
                        CsvNameTextBox07.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox08")
                {
                    if (CsvNameTextBox08.CanUndo == true)
                    {
                        CsvNameTextBox08.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox09")
                {
                    if (CsvNameTextBox09.CanUndo == true)
                    {
                        CsvNameTextBox09.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox10")
                {
                    if (CsvNameTextBox10.CanUndo == true)
                    {
                        CsvNameTextBox10.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox11")
                {
                    if (CsvNameTextBox11.CanUndo == true)
                    {
                        CsvNameTextBox11.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox12")
                {
                    if (CsvNameTextBox12.CanUndo == true)
                    {
                        CsvNameTextBox12.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox13")
                {
                    if (CsvNameTextBox13.CanUndo == true)
                    {
                        CsvNameTextBox13.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox14")
                {
                    if (CsvNameTextBox14.CanUndo == true)
                    {
                        CsvNameTextBox14.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox15")
                {
                    if (CsvNameTextBox15.CanUndo == true)
                    {
                        CsvNameTextBox15.Undo();
                    }
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox16")
                {
                    if (CsvNameTextBox16.CanUndo == true)
                    {
                        CsvNameTextBox16.Undo();
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeRedoEvent()
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent()
        {
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (this.ActiveControl.Name == "CalCycleTextBoxE")
                {
                    CalCycleTextBoxE.Cut();
                }
                else if (this.ActiveControl.Name == "CalStartPeriodTextBoxE")
                {
                    CalStartPeriodTextBoxE.Cut();
                }
                else if (this.ActiveControl.Name == "CalGoalPeriodTextBoxE")
                {
                    CalGoalPeriodTextBoxE.Cut();
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算
                if (this.ActiveControl.Name == "HourTextBox")
                {
                    HourTextBox.Cut();
                }
                else if (this.ActiveControl.Name == "MinTextBox")
                {
                    MinTextBox.Cut();
                }
            }
            else if (STGTabControl.SelectedIndex == 2)
            {
                // 一般グラフ表示用ファイル準備
                if (this.ActiveControl.Name == "CsvNameTextBox01")
                {
                    CsvNameTextBox01.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox02")
                {
                    CsvNameTextBox02.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox03")
                {
                    CsvNameTextBox03.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox04")
                {
                    CsvNameTextBox04.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox05")
                {
                    CsvNameTextBox05.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox06")
                {
                    CsvNameTextBox06.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox07")
                {
                    CsvNameTextBox07.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox08")
                {
                    CsvNameTextBox08.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox09")
                {
                    CsvNameTextBox09.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox10")
                {
                    CsvNameTextBox10.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox11")
                {
                    CsvNameTextBox11.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox12")
                {
                    CsvNameTextBox12.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox13")
                {
                    CsvNameTextBox13.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox14")
                {
                    CsvNameTextBox14.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox15")
                {
                    CsvNameTextBox15.Cut();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox16")
                {
                    CsvNameTextBox16.Cut();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent()
        {
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (this.ActiveControl.Name == "CalCycleTextBoxE")
                {
                    CalCycleTextBoxE.Copy();
                }
                else if (this.ActiveControl.Name == "CalStartPeriodTextBoxE")
                {
                    CalStartPeriodTextBoxE.Copy();
                }
                else if (this.ActiveControl.Name == "CalGoalPeriodTextBoxE")
                {
                    CalGoalPeriodTextBoxE.Copy();
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算
                if (this.ActiveControl.Name == "HourTextBox")
                {
                    HourTextBox.Copy();
                }
                else if (this.ActiveControl.Name == "MinTextBox")
                {
                    MinTextBox.Copy();
                }
            }
            else if (STGTabControl.SelectedIndex == 2)
            {
                // 一般グラフ表示用ファイル準備
                if (this.ActiveControl.Name == "CsvNameTextBox01")
                {
                    CsvNameTextBox01.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox02")
                {
                    CsvNameTextBox02.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox03")
                {
                    CsvNameTextBox03.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox04")
                {
                    CsvNameTextBox04.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox05")
                {
                    CsvNameTextBox05.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox06")
                {
                    CsvNameTextBox06.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox07")
                {
                    CsvNameTextBox07.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox08")
                {
                    CsvNameTextBox08.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox09")
                {
                    CsvNameTextBox09.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox10")
                {
                    CsvNameTextBox10.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox11")
                {
                    CsvNameTextBox11.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox12")
                {
                    CsvNameTextBox12.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox13")
                {
                    CsvNameTextBox13.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox14")
                {
                    CsvNameTextBox14.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox15")
                {
                    CsvNameTextBox15.Copy();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox16")
                {
                    CsvNameTextBox16.Copy();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent()
        {
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (this.ActiveControl.Name == "CalCycleTextBoxE")
                {
                    CalCycleTextBoxE.Paste();
                }
                else if (this.ActiveControl.Name == "CalStartPeriodTextBoxE")
                {
                    CalStartPeriodTextBoxE.Paste();
                }
                else if (this.ActiveControl.Name == "CalGoalPeriodTextBoxE")
                {
                    CalGoalPeriodTextBoxE.Paste();
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算
                if (this.ActiveControl.Name == "HourTextBox")
                {
                    HourTextBox.Paste();
                }
                else if (this.ActiveControl.Name == "MinTextBox")
                {
                    MinTextBox.Paste();
                }
            }
            else if (STGTabControl.SelectedIndex == 2)
            {
                // 一般グラフ表示用ファイル準備
                if (this.ActiveControl.Name == "CsvNameTextBox01")
                {
                    CsvNameTextBox01.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox02")
                {
                    CsvNameTextBox02.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox03")
                {
                    CsvNameTextBox03.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox04")
                {
                    CsvNameTextBox04.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox05")
                {
                    CsvNameTextBox05.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox06")
                {
                    CsvNameTextBox06.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox07")
                {
                    CsvNameTextBox07.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox08")
                {
                    CsvNameTextBox08.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox09")
                {
                    CsvNameTextBox09.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox10")
                {
                    CsvNameTextBox10.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox11")
                {
                    CsvNameTextBox11.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox12")
                {
                    CsvNameTextBox12.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox13")
                {
                    CsvNameTextBox13.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox14")
                {
                    CsvNameTextBox14.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox15")
                {
                    CsvNameTextBox15.Paste();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox16")
                {
                    CsvNameTextBox16.Paste();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent()
        {
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (this.ActiveControl.Name == "CalCycleTextBoxE")
                {
                    if (CalCycleTextBoxE.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CalCycleTextBoxE.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CalCycleTextBoxE.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CalStartPeriodTextBoxE")
                {
                    if (CalStartPeriodTextBoxE.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CalStartPeriodTextBoxE.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CalStartPeriodTextBoxE.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CalGoalPeriodTextBoxE")
                {
                    if (CalGoalPeriodTextBoxE.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CalGoalPeriodTextBoxE.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CalGoalPeriodTextBoxE.SelectedText = string.Empty;
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算
                if (this.ActiveControl.Name == "HourTextBox")
                {
                    if (HourTextBox.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        HourTextBox.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    HourTextBox.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "MinTextBox")
                {
                    if (MinTextBox.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        MinTextBox.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    MinTextBox.SelectedText = string.Empty;
                }
            }
            else if (STGTabControl.SelectedIndex == 2)
            {
                // 一般グラフ表示用ファイル準備
                if (this.ActiveControl.Name == "CsvNameTextBox01")
                {
                    if (CsvNameTextBox01.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox01.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox01.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox02")
                {
                    if (CsvNameTextBox02.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox02.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox02.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox03")
                {
                    if (CsvNameTextBox03.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox03.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox03.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox04")
                {
                    if (CsvNameTextBox04.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox04.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox04.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox05")
                {
                    if (CsvNameTextBox05.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox05.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox05.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox06")
                {
                    if (CsvNameTextBox06.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox06.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox06.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox07")
                {
                    if (CsvNameTextBox07.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox07.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox07.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox08")
                {
                    if (CsvNameTextBox08.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox08.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox08.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox09")
                {
                    if (CsvNameTextBox09.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox09.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox09.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox10")
                {
                    if (CsvNameTextBox10.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox10.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox10.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox11")
                {
                    if (CsvNameTextBox11.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox11.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox11.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox12")
                {
                    if (CsvNameTextBox12.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox12.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox12.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox13")
                {
                    if (CsvNameTextBox13.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox13.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox13.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox14")
                {
                    if (CsvNameTextBox14.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox14.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox14.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox15")
                {
                    if (CsvNameTextBox15.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox15.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox15.SelectedText = string.Empty;
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox16")
                {
                    if (CsvNameTextBox16.SelectionLength == 0)
                    {
                        // カーソル直後の1文字削除処理
                        CsvNameTextBox16.SelectionLength = 1;
                    }
                    // 選択済文字列の削除処理
                    CsvNameTextBox16.SelectedText = string.Empty;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent()
        {
            if (STGTabControl.SelectedIndex == 0)
            {
                // TGC作成・編集タブ
                if (this.ActiveControl.Name == "CalCycleTextBoxE")
                {
                    CalCycleTextBoxE.SelectAll();
                }
                else if (this.ActiveControl.Name == "CalStartPeriodTextBoxE")
                {
                    CalStartPeriodTextBoxE.SelectAll();
                }
                else if (this.ActiveControl.Name == "CalGoalPeriodTextBoxE")
                {
                    CalGoalPeriodTextBoxE.SelectAll();
                }
            }
            else if (STGTabControl.SelectedIndex == 1)
            {
                // TGC計算
                if (this.ActiveControl.Name == "HourTextBox")
                {
                    HourTextBox.SelectAll();
                }
                else if (this.ActiveControl.Name == "MinTextBox")
                {
                    MinTextBox.SelectAll();
                }
            }
            else if (STGTabControl.SelectedIndex == 2)
            {
                // 一般グラフ表示用ファイル準備
                if (this.ActiveControl.Name == "CsvNameTextBox01")
                {
                    CsvNameTextBox01.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox02")
                {
                    CsvNameTextBox02.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox03")
                {
                    CsvNameTextBox03.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox04")
                {
                    CsvNameTextBox04.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox05")
                {
                    CsvNameTextBox05.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox06")
                {
                    CsvNameTextBox06.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox07")
                {
                    CsvNameTextBox07.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox08")
                {
                    CsvNameTextBox08.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox09")
                {
                    CsvNameTextBox09.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox10")
                {
                    CsvNameTextBox10.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox11")
                {
                    CsvNameTextBox11.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox12")
                {
                    CsvNameTextBox12.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox13")
                {
                    CsvNameTextBox13.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox14")
                {
                    CsvNameTextBox14.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox15")
                {
                    CsvNameTextBox15.SelectAll();
                }
                else if (this.ActiveControl.Name == "CsvNameTextBox16")
                {
                    CsvNameTextBox16.SelectAll();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McSTGCalCtlForm_Activated( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McSTGCalCtlForm_Activated(object sender, EventArgs e)
        {
            base.HySDotNetForm_Activated(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McSTGCalCtlForm_Deactivate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McSTGCalCtlForm_Deactivate(object sender, EventArgs e)
        {
            base.HySDotNetForm_Deactivate(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間設定ラジオボタンチェックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimuFromToRadioBtnE_CheckedChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuFromToRadioBtnE_CheckedChanged(object sender, EventArgs e)
        {
            m_csSTGMngData.SetSTGCalType(McSTGSysManageData.STGCalType.Once);
            //SimuCycleRadioBtnE.Checked = false;
            //SimuCycleRadioBtnD.Checked = false;
            //SimuFromToRadioBtnE.Checked = true;
            SimuFromToRadioBtnD.Checked = true;

            SimuDayStartTimeE.Enabled = true;
            SimuDayEndTimeE.Enabled = true;
            //SimuDayStartTimeD.Enabled = true;
            //SimuDayEndTimeD.Enabled = true;

            SimuDayStartTimeD.Value = SimuDayStartTimeE.Value;
            SimuDayEndTimeD.Value = SimuDayEndTimeE.Value; 

            CalCycleTextBoxE.Enabled = false;
            CalStartPeriodTextBoxE.Enabled = false;
            CalGoalPeriodTextBoxE.Enabled = false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>周期起動設定ラジオボタンチェックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimuCycleRadioBtnE_CheckedChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuCycleRadioBtnE_CheckedChanged(object sender, EventArgs e)
        {
            m_csSTGMngData.SetSTGCalType(McSTGSysManageData.STGCalType.Repeat);
            //SimuFromToRadioBtnE.Checked = false;
            //SimuFromToRadioBtnD.Checked = false;
            //SimuCycleRadioBtnE.Checked = true;
            SimuCycleRadioBtnD.Checked = true;

            SimuDayStartTimeE.Enabled = false;
            SimuDayEndTimeE.Enabled = false;
            SimuDayStartTimeD.Enabled = false;
            SimuDayEndTimeD.Enabled = false;

            CalCycleTextBoxE.Enabled = true;
            CalStartPeriodTextBoxE.Enabled = true;
            CalGoalPeriodTextBoxE.Enabled = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間 前設定テキストボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalStartPeriodTextBoxE_TextChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalStartPeriodTextBoxE_TextChanged(object sender, EventArgs e)
        {
            CalStartPeriodTextBoxD.Text = CalStartPeriodTextBoxE.Text;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間 後設定テキストボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalGoalPeriodTextBoxE_TextChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalGoalPeriodTextBoxE_TextChanged(object sender, EventArgs e)
        {
            CalGoalPeriodTextBoxD.Text = CalGoalPeriodTextBoxE.Text;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算間隔設定テキストボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CalCycleTextBoxE_TextChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CalCycleTextBoxE_TextChanged(object sender, EventArgs e)
        {
            CalCycleTextBoxD.Text =  CalCycleTextBoxE.Text;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>TGC名称設定テキストボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>STGNameTextBoxE_TextChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void STGNameTextBoxE_TextChanged(object sender, EventArgs e)
        {
            STGNameTextBoxD.Text = STGNameTextBoxE.Text;
            m_csSTGMngData.SetSTGName(new HySString(STGNameTextBoxE.Text));
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>前貢ボタンクリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PrevButtonE_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PrevButtonE_Click(object sender, EventArgs e)
        {
            m_iSTGPage -= 1;
            this.DispPrjArea();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>後貢ボタンクリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>NextButtonE_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NextButtonE_Click(object sender, EventArgs e)
        {
            m_iSTGPage += 1;
            this.DispPrjArea();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間開始値変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimuDayStartTimeE_ValueChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuDayStartTimeE_ValueChanged(object sender, EventArgs e)
        {
            //DateTime csStim = SimuDayStartTimeE.Value;
            //m_csSTGMngData.SetCalStartTime(HySCalendar.Exchange(csStim));

            SimuDayStartTimeD.Value = SimuDayStartTimeE.Value;
            //SimuDayEndTimeD.Value = SimuDayEndTimeE.Value; 
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間終了値変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimuDayEndTimeE_ValueChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuDayEndTimeE_ValueChanged(object sender, EventArgs e)
        {
            //DateTime csEtim = SimuDayEndTimeE.Value;
            //m_csSTGMngData.SetCalGoalTime(HySCalendar.Exchange(csEtim));

            //SimuDayStartTimeD.Value = SimuDayStartTimeE.Value;
            SimuDayEndTimeD.Value = SimuDayEndTimeE.Value; 
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間開始値変更イベント2</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimuDayStartTimeD_ValueChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuDayStartTimeD_ValueChanged(object sender, EventArgs e)
        {
            //DateTime csStim = SimuDayStartTimeD.Value;
            //m_csSTGMngData.SetCalStartTime(HySCalendar.Exchange(csStim));

            SimuDayStartTimeE.Value = SimuDayStartTimeD.Value;
            //SimuDayEndTimeE.Value = SimuDayEndTimeD.Value; 
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算期間終了値変更イベント2</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SimuDayEndTimeD_ValueChanged( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SimuDayEndTimeD_ValueChanged(object sender, EventArgs e)
        {
            //DateTime csEtim = SimuDayEndTimeD.Value;
            //m_csSTGMngData.SetCalGoalTime(HySCalendar.Exchange(csEtim));

            //SimuDayStartTimeE.Value = SimuDayStartTimeD.Value;
            SimuDayEndTimeE.Value = SimuDayEndTimeD.Value; 
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ヘルプボタンクリックイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Help_Button_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            //HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("TGC_OPERATION_MANUAL_FILENAME"));
            //Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
            m_csSTGCalCtlScreen.DispHelp();
        }

        # region プログレスバーによる進捗確認用
        ///// <summary><para>method outline:</para>
        ///// <para>スレッドタイマー処理</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ReportOrderTimer_Tick( obj ) </para>
        ///// </example>
        ///// <param name="obj"></param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //private void ReportOrderTimer_Tick(object obj)
        //{
        //    // 別スレッドから呼ばれる
        //    try
        //    {
        //        m_csAO.Post(m_d_PostCallback, null);
        //    }
        //    catch
        //    {
        //        // Formオブジェクトが破棄された後にスレッドタイマー処理（別スレッド）
        //        // からのコールによる例外発生を吸収する(フラグ処理は極力使用しない)
        //    }
        //}
        ///// <summary><para>method outline:</para>
        ///// <para>タイマーからコールされる処理</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> ReportOrderTimer_Work( obj ) </para>
        ///// </example>
        ///// <param name="obj"></param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //private void ReportOrderTimer_Work(object obj)
        //{
        //    // Mainスレッドと同じ
        //    HySDataLinkedList csKeyList = this.m_csSTGMngData.GetKeyList();
        //    if (csKeyList != null)
        //    {
        //        long lDtNum = csKeyList.GetCount();
        //        for (long lLp = 0; lLp < lDtNum; lLp++)
        //        {
        //            HySString csKey = csKeyList.GetData(lLp) as HySString;
        //            HySID csID = new HySID(csKey);
        //            m_csSTGCalCtlScreen.SimulationReportOrder(csID);
        //        }
        //    }
        //}
        # endregion

        /// <summary>
        /// <para>method outline:</para>
        /// <para>再描画タイマーコール処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>RedrawTimer_Tick( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RedrawTimer_Tick(object sender, EventArgs e)
        {
            AutoReflesh();
            HySTime csDltT = m_csSTGMngData.GetSTGCalStartTime() - HySCalendar.CreateNowTime();
            long lDltT = (long)(csDltT.GetTime());
            if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Repeat)
            {   // 繰り返し計算の時
                //CalStartTimeLabel.Text = "計算開始予定時刻 (" + lDltT.ToString() + ")";
                CalStartTimeLabel.Text = Properties.HymcoSTGSystemViewBaseResource.LABEL_SCHEDULED_STARTING_TIME + " (" + lDltT.ToString() + ")";
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>強制終了タイマーコール処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ForceStopTimer_Tick( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ForceStopTimer_Tick(object sender, EventArgs e)
        {
            ForceStopTimer.Enabled = false;
            if (CalResetButton.Enabled == false)
            {
                NoticeSTGCalStop();
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>プロジェクトGr名称ボックス変更イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ProjectGroupBoxETextBoxChangedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectGroupBoxETextBoxChangedEvent(object sender, EventArgs e)
        {
            // 設定ボタンのマスク制御
            if (((TextBox)sender).Text != string.Empty)
            {
                STGSetButton.Enabled = true;
                // 一般グラフ表示用ファイル出力先設定
                HySString csOutPath = HySEnvInf.GetDataHomeDirectory() + new HySString("\\") + ProjectGroupBoxE.Text + new HySString("\\OutputData");
                this.CsvOutputPathTextBox.Text = csOutPath.ToString();
                // 右端表示(長いフルパスでもファイル名が認識できるよう)
                this.CsvOutputPathTextBox.SelectAll();
                int idx = this.CsvOutputPathTextBox.SelectionLength;
                this.CsvOutputPathTextBox.SelectionStart = idx;
            }
            else
            {
                STGSetButton.Enabled = false;
                // 計算制御ボタンのマスク制御
                CalStartButton.Enabled = false;
                CalStopButton.Enabled = false;
                CalResetButton.Enabled = false;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面通知捕捉処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="m">Windowsメッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void WndProc(ref Message m)
        {
            const int WM_SYSCOMMAND = 0x0112;
            const int SC_MINIMIZE = 0xF020;
            const int SC_MAXIMIZE = 0xF030;
            // 最小化を検出し、最小化前の配置情報を保存しておく
            if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MINIMIZE)
            {
                // 配置情報を保存
                Properties.Settings.Default.STGLocation = this.Location;
            }
            else if (m.Msg == WM_SYSCOMMAND && m.WParam.ToInt32() == SC_MAXIMIZE)
            {
                // Do Nothing
            }
            base.WndProc(ref m);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面クローズ時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.McDotNetLibraryCtlForm_FormClosing);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McSTGCalCtlForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.WindowState == FormWindowState.Normal)
            {// 通常表示状態の場合(最小化状態の場合は、WndProc()にて保存済)
                // 配置情報を保存
                Properties.Settings.Default.STGLocation = this.Location;
            }
            // 外部ファイルに保存
            Properties.Settings.Default.Save();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ロード時イベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Load += new System.EventHandler(this.McDotNetLibraryCtlForm_Load);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McSTGCalCtlForm_Load(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.STGLocation.X != -1 && Properties.Settings.Default.STGLocation.Y != -1)
            {
                // 保存情報をもとに配置情報を復元
                // 但し、初回はデフォルト値で表示させないようにする
                this.Location = Properties.Settings.Default.STGLocation;
            }
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>Formが閉じた後に発生するイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>FormClosedEvent(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FormClosedEvent(object sender, FormClosedEventArgs e)
        {
            # region プログレスバーによる進捗確認用
            //// タイマの停止
            //m_csThreadTimerInstance.Change(System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite);
            //// 非同期操作の終了
            //m_csAO.OperationCompleted();
            //// タイマの破棄
            //m_csThreadTimerInstance.Dispose();
            # endregion
        }
    }
}
