﻿// <summary>ソースコード：画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.CoreOption.McSTGSystemViewBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGC計算制御画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class McSTGCalCtlScreen : HySDotNetScreen
    {
        /// <summary>TGC制御情報表示Form</summary>
        protected McSTGCalCtlForm m_csSTGCalCtlForm;

        /// <summary>TGC管理情報</summary>
        protected McSTGSysManageData m_csSTGMngData;

        /// <summary>「CommonMP」</summary>
        private static readonly string TITLE_CMP = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_TITLE_CMP;
        /// <summary>「プロジェクト識別子」</summary>
        private static readonly string MSG_PROJECT_ID = Properties.HymcoSTGSystemViewBaseResource.PROJECT_ID;
        /// <summary>「モデル構築に失敗しました。」</summary>
        private static readonly string MSG_ERROR_MODEL_CONST = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_MODEL_CONST;
        /// <summary>「モデル生成に失敗しました。」</summary>
        private static readonly string MSG_ERROR_MODEL_CREATE = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_MODEL_CREATE;
        /// <summary>「計算開始に失敗しました。」</summary>
        private static readonly string MSG_ERROR_CAL_START = Properties.HymcoSTGSystemViewBaseResource.MESSAGE_ERROR_CAL_START;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSTGCalCtlScreen csScreen = new McSTGCalCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSTGCalCtlScreen()
        {
        }   
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSTGCalCtlScreen csScreen = new McSTGCalCtlScreen(csDotNetViewr)</para>
        /// </example>
        /// <param name="csDotNetViewr">メインビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSTGCalCtlScreen(HySViewer csDotNetViewr) : base(csDotNetViewr)
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> なし </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリークを防ぐため</para>
        /// </remarks>
        ~McSTGCalCtlScreen()
        {
        }
        
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Initialize()
        {
            m_csSTGCalCtlForm = new McSTGCalCtlForm(this);
            base.SetViewForm(m_csSTGCalCtlForm);
            m_csSTGCalCtlForm.StartPosition = FormStartPosition.Manual;
            m_csSTGCalCtlForm.SetDesktopLocation(5, 5);
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Terminate()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetViewer(csViewer)</para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            m_csSTGCalCtlForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
        }
        /// <summary><para>method outline:</para>
        /// <para>画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void ShowScreen()
        {
            m_csSTGCalCtlForm.Show();
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void CloseScreen()
        {
            m_csSTGCalCtlForm.Close();
            ((HySDotNetViewerJob)m_csVJob).DeleteScreen(this);
        }
        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitiateScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void InitiateScreen()
        {
        }
        
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            long lSubEventNo = csHySEvent.GetSubEventNo();
            HySKind csSimKind = csHySEvent.GetToSimKind();
            HySID csID = csHySEvent.GetSuppID();
            if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {
                m_csSTGMngData = csHySEvent.GetSubData() as McSTGSysManageData;
                if (m_csSTGMngData != null)
                {
                    m_csSTGCalCtlForm.SetSTGMngData(m_csSTGMngData);
                }
                if (lSubEventNo == McSTGSysDefine.EVNO_NOTICE_OPEN_STG)
                {
                    m_csSTGCalCtlForm.ReadCSVFileName();
                    m_csSTGCalCtlForm.MakeCsvFile();
                    m_csSTGCalCtlForm.NoticeSTGOpen();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        override public Boolean EventCallback(HySSysEvent csEvent)
        {

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC設定完了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CompleteSTGSet( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void CompleteSTGSet()
        {
            /*
            HySEventObject csNoticeEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, McSTGSysDefine.EVNO_SET_STG_COMPLETE);
            csNoticeEvent.SetToSimKind(this.GetSimKind());
            csNoticeEvent.SetSuppID(McSTGSysDefine.STG_CAL_CTL_SCREEN_ID);
            csNoticeEvent.SetSubData(this.m_csSTGMngData);

            m_csVJob.EventCallback(csNoticeEvent);
            */


            ((McSTGSysDotNetViewerJobBase)m_csVJob).CompleteSTGSet(m_csSTGMngData);
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル異常</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGModelNG(csPrjID, lEventNo) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクト識別子</param>
        /// <param name="lEventNo">イベント番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void STGModelNG(HySID csPrjID, long lEventNo)
        {
            // 表示色変更
            m_csSTGCalCtlForm.SetPrjNameColorSet(csPrjID, ColorNo.RED);
            // 再描画
            m_csSTGCalCtlForm.DispPrjArea();
            if (lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)
            {
                MessageBox.Show(MSG_ERROR_MODEL_CONST + Environment.NewLine + MSG_PROJECT_ID + csPrjID.ToString(), TITLE_CMP, MessageBoxButtons.OK, MessageBoxIcon.Error);
                // タイマー停止
                m_csSTGCalCtlForm.RefleshTimerOnOff(false);
                // 画面表示リセット指示
                m_csSTGCalCtlForm.DispReset();
            }
            else if (lEventNo == McSTGSysDefine.EVNO_NOTICE_NG_STG_MODELCONSTRUCTION)
            {
                MessageBox.Show(MSG_ERROR_MODEL_CREATE + Environment.NewLine + MSG_PROJECT_ID + csPrjID.ToString(), TITLE_CMP, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>モデル構築完了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CompleteSTGModelConstruction( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void CompleteSTGModelConstruction()
        {
            m_csSTGCalCtlForm.CompleteSTGModelConstruction();
            this.DispReflesh();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化完了通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeSTGCalInitialize( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalInitialize()
        {
            m_csSTGCalCtlForm.NoticeSTGCalInitialize();
            this.DispReflesh();
            this.DispReflesh();
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始失敗通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeSTGCalStartNG( csPrjID ) </para>
        /// </example>
        /// <param name="csPrjID">プロジェクト識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalStartNG(HySID csPrjID)
        {
            // 表示色変更
            m_csSTGCalCtlForm.SetPrjNameColorSet(csPrjID, ColorNo.RED);
            // 再描画
            m_csSTGCalCtlForm.DispPrjArea();
            MessageBox.Show(MSG_ERROR_CAL_START + Environment.NewLine + MSG_PROJECT_ID + csPrjID.ToString(), TITLE_CMP, MessageBoxButtons.OK, MessageBoxIcon.Error);
            // タイマー停止
            m_csSTGCalCtlForm.RefleshTimerOnOff(false);
            // 画面表示リセット指示
            m_csSTGCalCtlForm.DispReset();
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeSTGCalStart( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalStart()
        {
            m_csSTGCalCtlForm.NoticeSTGCalStart();
            this.DispReflesh();
            //m_csSTGCalCtlForm.RefleshTimerOnOff(true);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算停止通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeSTGCalStop( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalStop()
        {
            m_csSTGCalCtlForm.NoticeSTGCalStop();
            this.DispReflesh();
            //m_csSTGCalCtlForm.RefleshTimerOnOff(false);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算完了通知処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeSTGCalComplete( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NoticeSTGCalComplete()
        {
            m_csSTGCalCtlForm.NoticeSTGCalComplete();
            this.DispReflesh();
            if (m_csSTGMngData.GetSTGCalType() == McSTGSysManageData.STGCalType.Once)
            {
                m_csSTGCalCtlForm.RefleshTimerOnOff(false);
            }
        }
        # region プログレスバーによる進捗確認用
        ///// <summary><para>method outline:</para>
        ///// <para>計算進捗状況要求指示</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>this.SimulationReportOrder();</para>
        ///// </example>
        ///// <param name="csPrjID">プロジェクト識別子</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //virtual public void SimulationReportOrder(HySID csPrjID)
        //{
        //    // 計算進捗状況要求イベント生成 
        //    HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_REPORT_SIMU_PROGRESS);
        //    csEvent.SetSuppID(csPrjID);
        //    csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
        //    if (false == this.PutEvent(csEvent))
        //    {
        //        HySLog.LogOut(HySLog.ONLINE, "McSTGCalCtlScreen", "SimulationReportOrder", "PutEvent CMND_REPORT_SIMU_PROGRESS is failed.");
        //    }
        //}
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>計算開始処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGCalStart( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void STGCalStart()
        {
            m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_STG_CAL_START, true);
            this.DispReflesh();
            m_csSTGCalCtlForm.RefleshTimerOnOff(true);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算停止処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGCalStop( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void STGCalStop()
        {
            m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_STG_CAL_STOP, true);
            this.DispReflesh();
            m_csSTGCalCtlForm.RefleshTimerOnOff(false);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算リセット処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> STGCalReset( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void STGCalReset()
        {
            m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_STG_CAL_RESET, true);
            this.DispReflesh();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト別名保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NewSaveSTGProject( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void NewSaveSTGProject()
        {
            m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_NEW_SAVE_STG, true);
            //this.DispReflesh();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト上書保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveSTGProject( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SaveSTGProject()
        {
            m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_SAVE_STG, true);
            //this.DispReflesh();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト開く処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LoadSTGProject( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void LoadSTGProject()
        {
            m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_OPEN_STG, true);
        }

        /// <summary><para>method outline:</para>
        /// <para>再描画処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DispReflesh( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void DispReflesh()
        {
            m_csSTGCalCtlForm.DispReflesh();
            m_csSTGCalCtlForm.Refresh();
        }

        /// <summary><para>method outline:</para>
        /// <para>TGC情報管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetSTGSysMngData( ) </para>
        /// </example>
        /// <returns>STG情報管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McSTGSysManageData GetSTGSysMngData()
        { return m_csSTGMngData; }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト編集処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrjEdit( csPrjID　) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void PrjEdit(HySID csPrjID)
        {
            //McSTGSysCtlInfo csCtlInf = m_csSTGMngData.GetCtlInfo(csPrjID);
            HySSimulationDataContainer csContainer = m_csSTGMngData.GetDataContainer(csPrjID);
            if (csContainer == null)
            {   // 既に登録してなければ（新規）　＜－－ここの判断は重要（モデル側と画面側のコンテナインスタンスの不一致を防ぐため）
                HySString csSaveFileName = m_csSTGMngData.GetSavePrjctFileNameWithPath(csPrjID);
                HySFile csSaveFile = new HySFile(csSaveFileName);
                try
                {
                    csSaveFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    csContainer = csSaveFile.DataRead() as HySSimulationDataContainer;
                    csSaveFile.Close();
                }
                catch { }
            }
            if (csContainer != null)
            {

                m_csSTGMngData.SetDataContainer(csPrjID, csContainer);  // <-- ｲﾝｽﾀﾝｽの一致化
                //McSTGSysCtlInfo csCtlInfo = m_csSTGMngData.GetCtlInfo(csPrjID);
                //csCtlInfo.SetDataContainer(csContainer);// <-- ｲﾝｽﾀﾝｽの一致化

                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_NEW_SIMULATOR_CREATE);
                csEventObj.SetToSimKind(McDefine.SIMULATOR_KIND);
                csEventObj.SetSuppID(csPrjID);
                csEventObj.SetData(csContainer);
                this.PutEvent(csEventObj);

                csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN);
                csEventObj.SetSuppID(csPrjID);
                csEventObj.SetToSimKind(this.GetSimKind());
                csEventObj.SetData(McDefine.HYM_MODELCTL_SCREEN);

                this.GetViewerJob().EventCallback(csEventObj);


                csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.ARBITRARY_EVENT, McDefine.HYM_DATACONTAINER_SEND);
                csEventObj.SetSuppID(csPrjID);
                csEventObj.SetToSimKind(this.GetSimKind());
                csEventObj.SetData(csContainer);
                this.GetViewerJob().EventCallback(csEventObj);

            }

            //lEventNo == HySEventObject.CMND_DISP_SCREEN
            //HySObjectKind = McDefine.HYM_MODELCTL_SCREEN;


        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト削除処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrjDel( csPrjID　) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void PrjDel(HySID csPrjID)
        {
            //DialogResult result = MessageBox.Show("プロジェクトをリストから消去しますか？", "消去確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            DialogResult result = MessageBox.Show(Properties.HymcoSTGSystemViewBaseResource.MESSAGE_INFO_DEL_PROJECT, Properties.HymcoSTGSystemViewBaseResource.MESSAGE_TITLE_DEL, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            if (result == DialogResult.Yes)
            {
                this.m_csSTGMngData.DeleteData(csPrjID);
                // 色を標準に戻す
                m_csSTGCalCtlForm.SetPrjNameColorSet(csPrjID, ColorNo.CONTROL);
                // 再描画
                m_csSTGCalCtlForm.DispPrjArea();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ヘルプ表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DispHelp( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual internal void DispHelp()
        {
            //m_csVJob.MenuCallBack(McSTGSysDefine.EVNO_CMND_DISP_HELP, true);
            HySString csHelpFile = HySEnvInf.GetEnvInf(new HySString("TGC_OPERATION_MANUAL_FILENAME"));
            Help.ShowHelp(new Control(), HySEnvInf.GetHomeDirectory().ToString() + "\\help\\" + HySEnvInf.GetCultureDirectory().ToString() + csHelpFile.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeUndoEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticeUndoEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeRedoEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticeRedoEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticeCutEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticeCopyEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticePasteEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticeDeleteEvent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent()
        {
            // Formに対して通知する
            if (m_csSTGCalCtlForm != null)
            {
                m_csSTGCalCtlForm.NoticeAllSelectEvent();
            }
        }

        /// <summary>表示色</summary>
        internal enum ColorNo
        {
            BLACK = 0,
            RED = 1,
            CONTROL = 2
        }
    }
}
