﻿// <summary>ソースコード：スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;


namespace CommonMP.HYMCO.CoreOption.McSTGSystemViewBase
{
    /// <summary><para>class outline:</para>
    /// <para>TGCシステム内で使用する画面の基底クラス（Screen側）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public abstract class McSTGSysScreenBase : HySDotNetAddInBaseScreen
    {
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            HySDataRoot csDispData = ((HySEventObject)csEvent).GetSubData();
            this.SetDispData(csDispData);
        }
        /// <summary><para>method outline:</para>
        /// <para>イベント情報通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面から他のオブジェクトへイベントを送る場合に使用する</para>
        /// </remarks>
        virtual public void PutEvent(HySEventObject csEvent)
        {
            if (m_csVJob is McSTGSysDotNetViewerJobBase)
            {
                ((McSTGSysDotNetViewerJobBase)m_csVJob).PutEvent(csEvent);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            try
            {
                if (m_csHysFormObj is McSTGSysFormBase)
                {
                    ((McSTGSysFormBase)m_csHysFormObj).Close();
                }
                if (m_csVJob is McSTGSysDotNetViewerJobBase)
                {
                    //((McSTGSysDotNetViewerJobBase)m_csVJob).DeleteScreen(this);
                    ((McSTGSysDotNetViewerJobBase)m_csVJob).DeleteUserScreen(this);
                }
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McSTGSysScreenBase", "CloseScreen",
                    Properties.HymcoSTGSystemViewBaseResource.STATEMENT_CATCH_EXCEPTION + ex.Message);
               // HySLog.LogOut(HySLog.ONLINE, "McSTGSysScreenBase", "CloseScreen", "Catch Exception " + ex.Message);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>表示用データクラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispData( csDispData ) </para>
        /// </example>
        /// <param name="csDispData">表示用データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生側でオーバーライドの事</para>
        /// </remarks>
        abstract protected void SetDispData(HySDataRoot csDispData);

    }
}
